/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.logic.volume.SnapshotMap;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class SnapshotManager {
    HashMap snapshotMaps = new HashMap();

    public void addSnapshot(VolumeNode source, SnapshotVolume snapshot, VSwitch vSwitch) {
        SnapshotMap map = (SnapshotMap)this.snapshotMaps.get(vSwitch);
        if (map == null) {
            SnapshotMap newMap = new SnapshotMap();
            this.snapshotMaps.put(vSwitch, newMap);
            map = newMap;
        }
        map.addSnapshot(source, snapshot);
    }

    public Vector getSnapshotsForSourceVolume(VolumeNode sourceVolume, VSwitch vSwitch) {
        SnapshotMap map = (SnapshotMap)this.snapshotMaps.get(vSwitch);
        if (map == null) {
            return null;
        }
        return map.getSnapshotsForSourceVolume(sourceVolume);
    }

    public Vector getSnapshotsForSourceVolume(VolumeNode sourceVolume) {
        Vector retVal = null;
        Iterator itr = this.snapshotMaps.keySet().iterator();
        while (itr.hasNext()) {
            SnapshotMap map = (SnapshotMap)this.snapshotMaps.get(itr.next());
            Vector snaps = map.getSnapshotsForSourceVolume(sourceVolume);
            if (snaps == null) continue;
            Iterator snapItr = snaps.iterator();
            while (snapItr.hasNext()) {
                Object snap = snapItr.next();
                if (retVal == null) {
                    retVal = new Vector();
                }
                if (retVal.contains(snap)) continue;
                retVal.add(snap);
            }
        }
        return retVal;
    }

    public boolean isSourceOfSnapshot(VolumeNode sourceVolume, VSwitch vSwitch) {
        SnapshotMap map = (SnapshotMap)this.snapshotMaps.get(vSwitch);
        if (map == null) {
            return false;
        }
        return map.isSourceOfSnapshot(sourceVolume);
    }

    public boolean isSourceOfSnapshot(VolumeNode sourceVolume) {
        boolean retVal = false;
        Iterator itr = this.snapshotMaps.keySet().iterator();
        while (itr.hasNext()) {
            SnapshotMap map = (SnapshotMap)this.snapshotMaps.get(itr.next());
            retVal = retVal || map.isSourceOfSnapshot(sourceVolume);
        }
        return retVal;
    }

    public void removeAll() {
        this.snapshotMaps.clear();
    }

    public void removeAll(VSwitch vSwitch) {
        SnapshotMap map = (SnapshotMap)this.snapshotMaps.get(vSwitch);
        if (map != null) {
            map.removeAll();
        }
    }

    public void removeSnapshot(SnapshotVolume snapshotVolume, VSwitch vSwitch) throws RemoteException {
        SnapshotMap map = (SnapshotMap)this.snapshotMaps.get(vSwitch);
        if (map != null) {
            map.removeSnapshot(snapshotVolume);
        }
    }

    public void removeSnapshot(SnapshotVolume snapshotVolume) throws RemoteException {
        Iterator itr = this.snapshotMaps.keySet().iterator();
        while (itr.hasNext()) {
            SnapshotMap map = (SnapshotMap)this.snapshotMaps.get(itr.next());
            map.removeSnapshot(snapshotVolume);
        }
    }

    public void removeSnapshotBySource(SnapshotVolume snapshotVolume, VolumeNode source, VSwitch vSwitch) {
        SnapshotMap map = (SnapshotMap)this.snapshotMaps.get(vSwitch);
        if (map != null) {
            map.removeSnapshotBySource(snapshotVolume, source);
        }
    }

    public void removeSnapshotBySource(SnapshotVolume snapshotVolume, VolumeNode source) {
        Iterator itr = this.snapshotMaps.keySet().iterator();
        while (itr.hasNext()) {
            SnapshotMap map = (SnapshotMap)this.snapshotMaps.get(itr.next());
            map.removeSnapshotBySource(snapshotVolume, source);
        }
    }

    public VolumeNode getSourceOfSnapshot(SnapshotVolume snap) {
        SnapshotMap map;
        VolumeNode source = null;
        Iterator itr = this.snapshotMaps.keySet().iterator();
        while (itr.hasNext() && (source = (map = (SnapshotMap)this.snapshotMaps.get(itr.next())).getSourceOfSnapshot(snap)) == null) {
        }
        return source;
    }

    public VolumeNode getSourceOfSnapshot(SnapshotVolume snap, VSwitch vSwitch) {
        SnapshotMap map = (SnapshotMap)this.snapshotMaps.get(vSwitch);
        if (map != null) {
            return map.getSourceOfSnapshot(snap);
        }
        return null;
    }
}

