/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.volume.MirrorVolumeAlarmGenerator;
import com.sanrad.nms.server.exception.CopyAlreadyExistException;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.MirrorVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.volume.validators.AddMirrorValidator;
import com.sanrad.nms.server.logic.volume.validators.ExpandVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.MirrorVolumeSyncValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class MirrorVolumeImpl
extends VirtualVolumeImpl
implements MirrorVolume {
    private boolean performAutoSyncOnNewChild = false;

    public MirrorVolumeImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.MIRROR_VOLUME);
    }

    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        Vector vSwitchToSync = this.cluster.getOtherVSwitches(this.getVSwitches());
        Vector childrenForSync = this.getChildrenListForClusterSync((VSwitch)vSwitchToSync.get(0));
        MirrorVolumeSyncValidator validator = new MirrorVolumeSyncValidator(this.cluster, this.getAlias(), childrenForSync, storage.getVolumeMgr(), vSwitchToSync);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        storage.createMirrorVolume(this.getAlias(), childrenForSync, vSwitchToSync, this.getConnectedVSwitches()[0], this.getCommKeyClassId());
        return 2;
    }

    public boolean isMirrorMirroring(VSwitch vSwitch) throws RemoteException {
        Vector nonFuncChildre = this.getNonFunctionalChildren(vSwitch);
        return this.getChildren(vSwitch).size() - nonFuncChildre.size() > 1;
    }

    public AlarmGenerator getAlarmGenerator() {
        return MirrorVolumeAlarmGenerator.getInstance();
    }

    public VolumeNodeImpl getSyncSource(VSwitch vSwitch) throws RemoteException {
        Enumeration e = this.getChildren().elements();
        while (e.hasMoreElements()) {
            VolumeNodeImpl child = (VolumeNodeImpl)e.nextElement();
            if (child.isNeedSync(vSwitch) || child.isNonFunctional(vSwitch)) continue;
            return child;
        }
        return null;
    }

    public VolumeNodeImpl getSyncSource(VSwitch vSwitch, VolumeNodeImpl childToSync) throws RemoteException {
        CopyOperationManagerImpl copyOperationsManger = (CopyOperationManagerImpl)((ClusterImpl)this.getCluster()).getCopyOperManager();
        Enumeration e = this.getChildren().elements();
        while (e.hasMoreElements()) {
            VolumeNodeImpl child = (VolumeNodeImpl)e.nextElement();
            if (child.isNeedSync(vSwitch) || child.isNonFunctional(vSwitch) || child.equals(childToSync) || copyOperationsManger.isExistedAsDstInOtherActivrCopyOperation(child.getCommKeyClassId())) continue;
            return child;
        }
        return null;
    }

    private VolumeNodeImpl getSyncDestination() throws RemoteException {
        CopyOperationManagerImpl copyOperationsManger = (CopyOperationManagerImpl)((ClusterImpl)this.getCluster()).getCopyOperManager();
        Enumeration e = this.getChildren().elements();
        while (e.hasMoreElements()) {
            VolumeNodeImpl child = (VolumeNodeImpl)e.nextElement();
            if (!child.isNeedSync() || child.isNonFunctional() || copyOperationsManger.isExistedAsDstInOtherActivrCopyOperation(child.getCommKeyClassId()) || copyOperationsManger.isExistedAsSrcInOtherActivrCopyOperation(child.getCommKeyClassId())) continue;
            return child;
        }
        return null;
    }

    public void mirrorSync() throws RemoteException, IllegalValueException {
        try {
            VolumeNodeImpl syncDst = this.getSyncDestination();
            if (syncDst == null) {
                throw new IllegalValueException("Could not find the destination volume for the mirror sync operation for " + this.getClassId() + " " + this);
            }
            this.mirrorSync(this, syncDst);
        }
        catch (CopyAlreadyExistException copyAlreadyExistException) {
            // empty catch block
        }
    }

    public void breakMirror(CommKeyClassId[] children) throws RemoteException, IllegalValueException {
        this.removeChildren(children);
    }

    public void addMirror(CommKeyClassId newChild, String mirrVolAlias, boolean autoSync) throws RemoteException, IllegalValueException {
        this.performAutoSyncOnNewChild = autoSync;
        this.addChild((VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(newChild), VolumeOperationType.VOL_OPER_ADD_MIRROR, null, null);
    }

    public void setAutoSync(boolean autoSync) {
        this.performAutoSyncOnNewChild = autoSync;
    }

    public boolean getAutoSync() {
        return this.performAutoSyncOnNewChild;
    }

    public boolean setChildren(VSwitch vSwitch, Vector oldChildrenVector) throws RemoteException {
        CommKeyClassId[] newChildrenList = (CommKeyClassId[])this.getSrArrayValueOf(vSwitch, ParameterCode.VOLUME_CHILDREN, false);
        boolean set = super.setChildren(vSwitch, null);
        Vector<VolumeNodeImpl> newChildrenVector = new Vector<VolumeNodeImpl>();
        for (int i = 0; i < newChildrenList.length; ++i) {
            VolumeNodeImpl child = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(newChildrenList[i]);
            newChildrenVector.add(child);
            if (oldChildrenVector.contains(child) || !this.performAutoSyncOnNewChild || this.isExposed() && (!this.isExposed() || !vSwitch.equals(this.getExposedOnVSwitch()))) continue;
            try {
                this.mirrorSync(this, child);
                this.performAutoSyncOnNewChild = false;
                continue;
            }
            catch (IllegalValueException ive) {
                if (!this.isExposed()) continue;
                logger.warning("Failed to Sync new Mirror Child " + ive.getMessage());
                continue;
            }
            catch (CopyAlreadyExistException caee) {
                // empty catch block
            }
        }
        return set;
    }

    public void addChild(VolumeNodeImpl newChild, VolumeOperationType oper, CommKeyClassId[] vSwitchesToSet, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        AddMirrorValidator validator = new AddMirrorValidator(this.cluster, (VolumeNodeImpl)this, this.getAlias(), (Object)this.getChildren(), storage.getVolumeMgr(), newChild);
        CommKeyClassId[] vSToSet = validator.forWhichVswitchIsValidData(vSwitchesToSet);
        if (vSToSet == null || vSToSet.length == 0) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        super.addChild(newChild, oper, vSToSet, operationInvoker);
    }

    public void removeChildren(CommKeyClassId[] childrenToRemove) throws RemoteException, IllegalValueException {
        super.removeChildren(childrenToRemove, VolumeOperationType.VOL_OPER_BREAK_MIRROR);
    }

    protected VolumeStateConstant getMyTypeSpecialStateAfterAddChild() {
        return VolumeStateConstant.VOLUME_STATE_NEED_SYNC;
    }

    public void expand() throws RemoteException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        ExpandVolumeValidator validator = new ExpandVolumeValidator(this.cluster, this, this.getAlias(), (Object)this.getChildren(), storage.getVolumeMgr());
        CommKeyClassId[] vSwitchToSet = validator.forWhichVswitchIsValidData();
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchToSet));
        DataMgr.getInstance().operate(element, VolumeOperationType.VOL_OPER_EXPAND);
    }
}

