/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.volume.JournalAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.validators.JournalVolumeSyncValidator;
import com.sanrad.nms.server.logic.volume.validators.JournalVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.JournalVolumeActivityConstants;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class JournalVolumeImpl
extends VirtualVolumeImpl
implements JournalVolume {
    private ArrayList m_connectedPairs = new ArrayList();

    public JournalVolumeImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.JOURNAL_VOLUME);
        this.addParameterCode(ParameterCode.JOURNAL_VOLUME_DATE_AND_TIME);
        this.addParameterCode(ParameterCode.JOURNAL_VOLUME_ACTIVITY);
        this.addParameterCode(ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH);
        this.addParameterCode(ParameterCode.JOURNAL_VOLUME_PRECENT_UTILIZATION);
        this.addParameterCode(ParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID);
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String result = super.isValid(parameterList);
        if (result == null) {
            SrString alias = (SrString)parameterList.get(ClientParameterCode.VOLUME_ALIAS);
            Integer threshold = (Integer)parameterList.get(ClientParameterCode.JOURNAL_VOLUME_PRECENT_THRESH);
            CommKeyClassId activeOnVswitchId = (CommKeyClassId)parameterList.get(ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID);
            VSwitch activeOnVswitch = null;
            Vector otherVSwitches = null;
            if (activeOnVswitchId != null) {
                activeOnVswitch = (VSwitch)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(activeOnVswitchId);
                Vector<VSwitch> activeOnVswitchVec = new Vector<VSwitch>();
                activeOnVswitchVec.add(activeOnVswitch);
                otherVSwitches = ((ClusterImpl)this.getCluster()).getOtherVSwitches(activeOnVswitchVec);
            }
            JournalVolumeValidator validator = new JournalVolumeValidator(this.cluster, alias == null ? null : (String)alias.value(), threshold, null, activeOnVswitchId != null, activeOnVswitch, otherVSwitches != null ? (VSwitch)otherVSwitches.elementAt(0) : null, ((StorageImpl)this.getCluster().getStorage()).getVolumeMgr());
            result = validator.isValid(parameterList);
        }
        return result;
    }

    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        Vector currentExistedOnVSwitches = this.getVSwitches();
        Vector otherVSwitches = this.cluster.getOtherVSwitches(currentExistedOnVSwitches);
        VSwitch alreadyExistedOnVswitch = (VSwitch)currentExistedOnVSwitches.elementAt(0);
        JournalVolumeSyncValidator validator = new JournalVolumeSyncValidator(this.cluster, this.getAlias(), this.getChildren(), this.getPercentageThreshold(), storage.getVolumeMgr(), otherVSwitches);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        JournalVolumeActivityConstants journalActivityOnExistedVSwitch = this.getActivityState(alreadyExistedOnVswitch);
        if (journalActivityOnExistedVSwitch.equals(JournalVolumeActivityConstants.ACTIVE)) {
            storage.createJournalVolume(this.getAlias(), this.getPercentageThreshold(), this.getChildren(), null, (VSwitch)otherVSwitches.elementAt(0), false);
        } else if (journalActivityOnExistedVSwitch.equals(JournalVolumeActivityConstants.INACTIVE)) {
            storage.createJournalVolume(this.getAlias(), this.getPercentageThreshold(), this.getChildren(), (VSwitch)otherVSwitches.elementAt(0), null, false);
        }
        return 2;
    }

    protected String canBeDeleted() throws RemoteException {
        if (this.isConnectedToPairs()) {
            return "You cannot delete the journal volume " + this.getAlias() + " because it has pairs connected to it.";
        }
        return null;
    }

    public AlarmGenerator getAlarmGenerator() {
        return JournalAlarmGenerator.getInstance();
    }

    public boolean isOutOfSync(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, VolumeStateConstant.VOLUME_STATE_OUT_OF_SYNC);
    }

    public boolean isFull(VSwitch vSwitch) throws RemoteException {
        Integer load = this.getPercentageUtilization(vSwitch);
        return this.isOutOfSync(vSwitch) && load == 100;
    }

    public boolean isOverUsed(VSwitch vSwitch) throws RemoteException {
        Integer load = this.getPercentageUtilization(vSwitch);
        Integer thresh = this.getPercentageThreshold(vSwitch);
        return load >= thresh;
    }

    public Long getDateAndTime() throws RemoteException {
        return this.getDateAndTime(null);
    }

    public Long getDateAndTime(VSwitch vSwitch) throws RemoteException {
        Long dateAndTime = (Long)this.getValueOf(vSwitch, ParameterCode.JOURNAL_VOLUME_DATE_AND_TIME, vSwitch == null);
        return dateAndTime;
    }

    public Integer getPercentageUtilization() throws RemoteException {
        return this.getPercentageUtilization(null);
    }

    public Integer getPercentageUtilization(VSwitch vSwitch) throws RemoteException {
        Integer precentage = (Integer)this.getValueOf(vSwitch, ParameterCode.JOURNAL_VOLUME_PRECENT_UTILIZATION, vSwitch == null);
        return precentage;
    }

    public Integer getPercentageThreshold() throws RemoteException {
        return this.getPercentageThreshold(null);
    }

    public Integer getPercentageThreshold(VSwitch vSwitch) throws RemoteException {
        Integer precentage = (Integer)this.getValueOf(vSwitch, ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, vSwitch == null);
        return precentage;
    }

    public JournalVolumeActivityConstants getActivityState(CommKeyClassId vswitchCommKeyClassId) throws RemoteException {
        VSwitch vswitch = (VSwitch)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vswitchCommKeyClassId);
        JournalVolumeActivityConstants activity = this.getActivityState(vswitch);
        return activity;
    }

    public JournalVolumeActivityConstants getActivityState(VSwitch vswitch) throws RemoteException {
        return (JournalVolumeActivityConstants)this.getSrValueOf(vswitch, ParameterCode.JOURNAL_VOLUME_ACTIVITY, false);
    }

    public VSwitch getActiveOnVSwitch() throws RemoteException {
        VSwitch[] clusterVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < clusterVswitches.length; ++index) {
            VSwitch vswitch = clusterVswitches[index];
            JournalVolumeActivityConstants activeState = this.getActivityState(vswitch);
            if (!JournalVolumeActivityConstants.ACTIVE.equals(activeState) && !JournalVolumeActivityConstants.SWITCHED.equals(activeState)) continue;
            return vswitch;
        }
        return null;
    }

    public boolean isInternal(VSwitch vSwitch) throws RemoteException {
        return false;
    }

    public VSwitch getInactiveOnVSwitch() throws RemoteException {
        VSwitch[] clusterVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < clusterVswitches.length; ++index) {
            VSwitch vswitch = clusterVswitches[index];
            JournalVolumeActivityConstants activeState = this.getActivityState(vswitch.getCommKeyClassId());
            if (!activeState.equals(JournalVolumeActivityConstants.INACTIVE)) continue;
            return vswitch;
        }
        return null;
    }

    public void addConnectedPair(Object pair) throws RemoteException {
        this.m_connectedPairs.add(pair);
        this.updateJournalAlarms();
    }

    public void removeConnectedPair(Object pair) throws RemoteException {
        this.m_connectedPairs.remove(pair);
        this.updateJournalAlarms();
    }

    public Object[] getConnectedPairs() {
        return this.m_connectedPairs.toArray();
    }

    public void clearConnectedPairs() throws RemoteException {
        this.m_connectedPairs.clear();
        this.updateJournalAlarms();
    }

    public boolean isConnectedToPairs() {
        return this.m_connectedPairs.size() > 0;
    }

    private void updateJournalAlarms() throws RemoteException {
        if (this.getCluster().isInDeletionProcess()) {
            return;
        }
        VSwitch[] connectedVSwitches = this.getConnectedVSwitches();
        for (int num = 0; num < connectedVSwitches.length; ++num) {
            VSwitch connectedVSwitch = connectedVSwitches[num];
            if (connectedVSwitch.isInDeletionProcess()) continue;
            AlarmMgrImpl.getInstance().generateAlarms((ClusterImpl)this.getCluster(), 18, this, connectedVSwitch);
        }
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap params = super.getClientParameterList();
        VSwitch vSwitch = this.getActiveOnVSwitch();
        params.put(ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID, vSwitch);
        return params;
    }

    public void refreshPercentUtilization() throws RemoteException {
        this.refreshFields(new ParameterCode[]{ParameterCode.JOURNAL_VOLUME_PRECENT_UTILIZATION});
    }

    public VSwitch getDominentVswitch() throws RemoteException {
        return this.getActiveOnVSwitch();
    }
}

