/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.volume.CubeVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.ConcatinationVolumeImpl;
import com.sanrad.nms.server.logic.volume.CubeVolume;
import com.sanrad.nms.server.logic.volume.CubeVolumeSyncValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.Vector;

public class CubeVolumeImpl
extends ConcatinationVolumeImpl
implements CubeVolume {
    public CubeVolumeImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.CUBE_VOLUME);
    }

    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        Vector vSwitchToSync = this.cluster.getOtherVSwitches(this.getVSwitches());
        Vector childrenForSync = this.getChildrenListForClusterSync((VSwitch)vSwitchToSync.get(0));
        CubeVolumeSyncValidator validator = new CubeVolumeSyncValidator(this.cluster, this.getAlias(), childrenForSync, storage.getVolumeMgr(), vSwitchToSync);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        storage.createCubeVolume(this.getAlias(), childrenForSync, vSwitchToSync, this.getConnectedVSwitches()[0], this.getCommKeyClassId());
        return 2;
    }

    public AlarmGenerator getAlarmGenerator() {
        return CubeVolumeAlarmGenerator.getInstance();
    }
}

