/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.volume.ConcatenationVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.ConcatinationVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.ConcatinationVolumeSyncValidator;
import com.sanrad.nms.server.logic.volume.validators.ExpandVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.ResizeVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ConcatinationVolumeImpl
extends VirtualVolumeImpl
implements ConcatinationVolume {
    protected boolean isExpandable = false;
    protected boolean isRetractable = false;

    public ConcatinationVolumeImpl(ClusterImpl cluster) throws RemoteException {
        this(cluster, ClassID.CONCAT_VOLUME);
    }

    protected ConcatinationVolumeImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId);
    }

    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        Vector vSwitchToSync = this.cluster.getOtherVSwitches(this.getVSwitches());
        Vector childrenForSync = this.getChildrenListForClusterSync((VSwitch)vSwitchToSync.get(0));
        ConcatinationVolumeSyncValidator validator = new ConcatinationVolumeSyncValidator(this.cluster, this.getAlias(), childrenForSync, storage.getVolumeMgr(), vSwitchToSync);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        storage.createConcatinationVolume(this.getAlias(), childrenForSync, vSwitchToSync, this.getConnectedVSwitches()[0], this.getCommKeyClassId());
        return 2;
    }

    public AlarmGenerator getAlarmGenerator() {
        return ConcatenationVolumeAlarmGenerator.getInstance();
    }

    public void resize(CommKeyClassId newChild, String alias) throws RemoteException, IllegalValueException {
        this.addChild((VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(newChild), VolumeOperationType.VOL_OPER_RESIZE, null, null);
    }

    public void expand() throws RemoteException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        ExpandVolumeValidator validator = new ExpandVolumeValidator(this.cluster, this, this.getAlias(), (Object)this.getChildren(), storage.getVolumeMgr());
        CommKeyClassId[] vSwitchToSet = validator.forWhichVswitchIsValidData();
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchToSet));
        DataMgr.getInstance().operate(element, VolumeOperationType.VOL_OPER_EXPAND);
    }

    public void retract() throws RemoteException, IllegalValueException {
        CommKeyClassId[] childrenToRetract = this.getRetractableChildren();
        this.removeChildren(childrenToRetract);
    }

    public boolean isExpandable(VSwitch vs) throws RemoteException {
        return this.isInState(vs, VolumeStateConstant.VOLUME_STATE_EXPANDABLE);
    }

    public boolean calcExpandable() {
        try {
            if (this.isIllegal() || this.isInconsistent()) {
                return false;
            }
            boolean expandable = false;
            VSwitch[] connectedVswitch = this.getConnectedVSwitches();
            for (int i = 0; i < connectedVswitch.length; ++i) {
                if (!this.isExpandable(connectedVswitch[i])) continue;
                expandable = true;
                CommKeyClassId[] oneVSwitchChildren = (CommKeyClassId[])this.getSrArrayValueOf(connectedVswitch[i], ParameterCode.VOLUME_CHILDREN);
                for (int j = 0; j < oneVSwitchChildren.length; ++j) {
                    VolumeNodeImpl child = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(oneVSwitchChildren[j]);
                    if (child == null || !child.isInState(connectedVswitch[i], VolumeStateConstant.VOLUME_STATE_NONFUNCTIONAL)) continue;
                    return false;
                }
            }
            return expandable;
        }
        catch (RemoteException re) {
            logger.error(re);
            return false;
        }
    }

    public boolean calcRetractable() {
        try {
            if (this.isIllegal()) {
                return false;
            }
            boolean inExpandableState = false;
            VSwitch[] vSwitches = this.getConnectedVSwitches();
            for (int i = 0; i < vSwitches.length; ++i) {
                if (!this.isInState(vSwitches[i], VolumeStateConstant.VOLUME_STATE_EXPANDABLE)) continue;
                inExpandableState = true;
                break;
            }
            if (!inExpandableState) {
                return false;
            }
            try {
                CommKeyClassId[] retractable = this.getRetractableChildren();
                return retractable.length > 0;
            }
            catch (IllegalValueException ive) {
                logger.warning(ive.getMessage());
                return false;
            }
        }
        catch (RemoteException re) {
            logger.error(re);
            return false;
        }
    }

    public boolean isExpandable() throws RemoteException {
        return this.isExpandable;
    }

    public boolean isRetractable() throws RemoteException {
        return this.isRetractable;
    }

    public CommKeyClassId[] getRetractableChildren() throws RemoteException, IllegalValueException {
        Vector<CommKeyClassId> retractableChildren = new Vector<CommKeyClassId>();
        HashMap childrenListByVSwitch = this.getChildrenCommKeyClassIdListByVSwitch();
        CommKeyClassId[] existInAll = (CommKeyClassId[])childrenListByVSwitch.get(BELONG_TO_ALL_VSWITCHES);
        for (int i = 0; i < existInAll.length; ++i) {
            VolumeNodeImpl child = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(existInAll[i]);
            VSwitch[] childVSwitch = this.getConnectedVSwitches();
            boolean childRetractable = child.isRetractable(childVSwitch[0]);
            for (int j = 1; j < childVSwitch.length; ++j) {
                if (childRetractable == child.isRetractable(childVSwitch[j])) continue;
                StringBuffer errMsg = new StringBuffer("Child ");
                errMsg.append(child.getClassId());
                errMsg.append(" ");
                errMsg.append(child);
                errMsg.append(" is not retractable on ");
                errMsg.append(ClassID.VSWITCH);
                errMsg.append(" ");
                errMsg.append(childVSwitch[j]);
                throw new IllegalValueException(errMsg.toString());
            }
            if (!childRetractable) continue;
            retractableChildren.add(existInAll[i]);
        }
        Iterator keys = childrenListByVSwitch.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (key.equals(BELONG_TO_ALL_VSWITCHES)) continue;
            VSwitch vSwitch = (VSwitch)key;
            CommKeyClassId[] childrenList = (CommKeyClassId[])childrenListByVSwitch.get(vSwitch);
            for (int i = 0; i < childrenList.length; ++i) {
                VolumeNodeImpl child = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(childrenList[i]);
                if (!child.isRetractable(vSwitch)) {
                    StringBuffer errMsg = new StringBuffer("Child ");
                    errMsg.append(child.getClassId());
                    errMsg.append(" ");
                    errMsg.append(child);
                    errMsg.append(" is not retractable on ");
                    errMsg.append(ClassID.VSWITCH);
                    errMsg.append(" ");
                    errMsg.append(vSwitch);
                    throw new IllegalValueException(errMsg.toString());
                }
                retractableChildren.add(childrenList[i]);
            }
        }
        CommKeyClassId[] retVal = new CommKeyClassId[retractableChildren.size()];
        retractableChildren.toArray(retVal);
        return retVal;
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        if (this.getCluster().isDiscoverCompleted() && (parameterList.containsKey(ParameterCode.VOLUME_CHILDREN) || parameterList.containsKey(ParameterCode.VOLUME_STATE))) {
            this.updateExpandAndRetractStatus();
        }
        return changedValues;
    }

    public void updateExpandAndRetractStatus() {
        boolean isExpand;
        boolean isRetract = this.calcRetractable();
        HashMap<ParameterCode, SrBoolean> changedValues = new HashMap<ParameterCode, SrBoolean>();
        if (isRetract != this.isRetractable) {
            this.isRetractable = isRetract;
            changedValues.put(ParameterCode.VOLUME_RETRACTABLE, new SrBoolean(this.isRetractable));
        }
        if ((isExpand = this.calcExpandable()) != this.isExpandable) {
            this.isExpandable = isExpand;
            changedValues.put(ParameterCode.VOLUME_EXPANDABLE, new SrBoolean(this.isExpandable));
        }
        if (changedValues.size() > 0) {
            try {
                ElementEventImpl elementEvent = new ElementEventImpl(this, this);
                elementEvent.setParameterList(changedValues);
                EventServiceImpl.getInstance().fireElementChanged(elementEvent);
            }
            catch (RemoteException re) {
                LogMgr.getServerLog().debug("Failed to update Client with the new state of Concatenation volume", re);
            }
            this.reReadVolumeCapacity();
        }
    }

    public void childVolumeStateWasChanged() {
        this.updateExpandAndRetractStatus();
        this.reReadVolumeCapacity();
    }

    public void addChild(VolumeNodeImpl newChild, VolumeOperationType oper, CommKeyClassId[] vSwitchesToSet, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        ResizeVolumeValidator validator = new ResizeVolumeValidator(this.cluster, (VolumeNodeImpl)this, this.getAlias(), (Object)this.getChildren(), storage.getVolumeMgr(), newChild);
        CommKeyClassId[] vSToSet = validator.forWhichVswitchIsValidData(vSwitchesToSet);
        if (vSToSet == null || vSToSet.length == 0) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        super.addChild(newChild, oper, vSToSet, operationInvoker);
    }

    public void removeChildren(CommKeyClassId[] childrenToRetract) throws RemoteException, IllegalValueException {
        super.removeChildren(childrenToRetract, VolumeOperationType.VOL_OPER_RETRACT);
    }

    protected VolumeStateConstant getMyTypeSpecialStateAfterAddChild() {
        return VolumeStateConstant.VOLUME_STATE_RETRACTABLE;
    }
}

