/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.validation;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.DrAlarmMgrImpl;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.dr.DRActivate;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.validation.AlarmValidationKey;
import com.sanrad.nms.server.logic.validation.ValidatorKey;
import com.sanrad.nms.server.logic.validation.dr.DRAbortInitialSyncValidator;
import com.sanrad.nms.server.logic.validation.dr.DRAbortReplicateValidator;
import com.sanrad.nms.server.logic.validation.dr.DRDeleteCGValidator;
import com.sanrad.nms.server.logic.validation.dr.DRDeletePairValidator;
import com.sanrad.nms.server.logic.validation.dr.DRDisasterGroupValidation;
import com.sanrad.nms.server.logic.validation.dr.DREndInitialSyncValidator;
import com.sanrad.nms.server.logic.validation.dr.DRFallBackValidator;
import com.sanrad.nms.server.logic.validation.dr.DRGeneralValidation;
import com.sanrad.nms.server.logic.validation.dr.DRISyncTypeValidation;
import com.sanrad.nms.server.logic.validation.dr.DRPlanedFailOverValidator;
import com.sanrad.nms.server.logic.validation.dr.DRStartInitialSyncValidator;
import com.sanrad.nms.server.logic.validation.dr.DRStartReplicateValidator;
import com.sanrad.nms.server.logic.validation.dr.DRValidationKey;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DRStateConstant;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class Validator {
    private static ValidatorTable m_table;
    protected static Log logger;
    private static Validator theInstance;

    private Validator() {
        m_table = new ValidatorTable();
    }

    public static Validator getInstance() {
        return theInstance;
    }

    public void isValidAccordingToAlarm(GeneralLogicObjectImpl drObj, ParameterList state) throws RemoteException, IllegalValueException {
        Class<?> objClass = drObj.getClass();
        ValidatorKey key = null;
        key = state != null ? new DRValidationKey(objClass, state) : new ValidatorKey(objClass);
        HashMap validator = (HashMap)m_table.get(key);
        if (validator == null) {
            return;
        }
        Object[] alarms = new AlarmType[validator.keySet().toArray().length];
        alarms = validator.keySet().toArray();
        Object[] alarmValues = new Boolean[validator.values().toArray().length];
        alarmValues = validator.values().toArray();
        for (int i = 0; i < alarms.length; ++i) {
            AlarmType alarm = (AlarmType)alarms[i];
            Boolean alarmValue = (Boolean)alarmValues[i];
            if (this.validAlarm(drObj, alarm, alarmValue)) continue;
            String shouldBe = "";
            if (alarmValue.booleanValue()) {
                shouldBe = ", required state";
            }
            if (state == null || drObj == null) {
                throw new IllegalValueException("Cannot delete the item" + shouldBe + ": " + alarm);
            }
            if (drObj instanceof DRActivate && DRActivateConstant.ABORT_REPLICATE.equals(state.getParameter(0).getValue())) {
                if (((DRLogicObjectImpl)drObj).getInactiveElement() != null && !((DRLogicObjectImpl)drObj).getInactiveElement().isParameterEqual(new MasterParameter(MasterParameterCode.DR_REPLICATION_STATE.getParameterCode(drObj), DRReplicationStateConstant.INACTIVE), ((DRLogicObjectImpl)drObj).getInactiveElement().getActiveVswitch())) {
                    ((DRLogicObjectImpl)drObj).getInactiveElement().changeElementForActiveVswitch(new MasterParameter(((DRLogicObjectImpl)drObj).getInactiveElement().getActivateParameterCode(), DRActivateConstant.ABORT_REPLICATE));
                    logger.warning(DRActivateConstant.ABORT_REPLICATE + " active state is not the same in local and remote");
                    throw new UnsupportedOperationException();
                }
                if (((DRLogicObjectImpl)drObj).getActiveElement() != null && !((DRLogicObjectImpl)drObj).getActiveElement().isParameterEqual(new MasterParameter(MasterParameterCode.DR_REPLICATION_STATE.getParameterCode(drObj), DRReplicationStateConstant.INACTIVE), ((DRLogicObjectImpl)drObj).getActiveElement().getActiveVswitch())) {
                    ((DRLogicObjectImpl)drObj).getActiveElement().changeElementForActiveVswitch(new MasterParameter(((DRLogicObjectImpl)drObj).getActiveElement().getActivateParameterCode(), DRActivateConstant.ABORT_REPLICATE));
                    throw new UnsupportedOperationException();
                }
            }
            throw new IllegalValueException("Cannot perform this action on " + drObj + ": " + alarm);
        }
    }

    private boolean validAlarm(GeneralLogicObjectImpl drObj, AlarmType alarm, Boolean alarmValue) throws RemoteException {
        Vector vecAlarm = new Vector();
        vecAlarm = !(drObj instanceof DRLogicObject) ? AlarmMgrImpl.getInstance().getAlarms(drObj) : DrAlarmMgrImpl.getInstance().getAlarms(drObj);
        if (vecAlarm != null) {
            for (int i = 0; i < vecAlarm.size(); ++i) {
                Alarm check = (Alarm)vecAlarm.get(i);
                if (!check.getType().equals(alarm) || check.getVSwitch() != null && !check.getVSwitch().isConnected()) continue;
                return alarmValue;
            }
        }
        return alarmValue == false;
    }

    public Boolean validAccordingToParameter(GeneralLogicObjectImpl source, AlarmType alarm, VSwitch vswitch) throws RemoteException {
        AlarmValidationKey key = new AlarmValidationKey(source.getClass(), alarm);
        Object obj = m_table.get(key);
        if (obj == null || !(obj instanceof ParameterList)) {
            return null;
        }
        ParameterList params = (ParameterList)obj;
        if (source instanceof DRLogicObjectImpl) {
            if (((DRLogicObjectImpl)source).getLocalElement() != null && ((DRLogicObjectImpl)source).getLocalElement().getActiveVswitch() != null && (((DRLogicObjectImpl)source).getLocalElement().getActiveVswitch().equals(vswitch) || ((DRLogicObjectImpl)source).getLocalElement().getInactiveVSwitch().equals(vswitch))) {
                source = ((DRLogicObjectImpl)source).getLocalElement();
            }
            if (source instanceof DRLogicObjectImpl) {
                source = ((DRLogicObjectImpl)source).getRemoteElement();
            }
        }
        for (int i = 0; i < params.getLength(); ++i) {
            if (source.isParameterEqual(params.getParameter(i), vswitch)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean validAccordingToBitSet(GeneralLogicObjectImpl source, AlarmType alarm) throws RemoteException {
        return !source.isStateOn(alarm);
    }

    public Boolean validAccordingToVswitchesConsistency(GeneralLogicObjectImpl source, AlarmType alarm) throws RemoteException {
        AlarmValidationKey key = new AlarmValidationKey(source.getClass(), alarm);
        if (key != null && (ParameterCodes)m_table.get(key) != null) {
            if (((ParameterCodes)m_table.get(key)).checkConsistencyBetweenVSwitches(source)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    static {
        logger = LogMgr.getServerLog();
        theInstance = new Validator();
    }

    public class ValidatorTable
    extends Hashtable {
        public ValidatorTable() {
            this.put(DRValidationKey.START_REPLICATE_DR_CG, DRStartReplicateValidator.START_REPLICATE_VALIDATOR);
            this.put(DRValidationKey.START_REPLICATE_DR_PAIR, DRGeneralValidation.GENERAL_VALIDATION);
            this.put(DRValidationKey.ABORT_REPLICATE_DR_CG, DRAbortReplicateValidator.ABORT_REPLICATE_VALIDATOR);
            this.put(DRValidationKey.ABORT_REPLICATE_DR_PAIR, DRAbortReplicateValidator.ABORT_REPLICATE_VALIDATOR);
            this.put(DRValidationKey.FORCE_REPLICATE_DR_CG, DRGeneralValidation.GENERAL_VALIDATION);
            this.put(DRValidationKey.FORCE_REPLICATE_DR_PAIR, DRGeneralValidation.GENERAL_VALIDATION);
            this.put(DRValidationKey.SWITCH_DR_CG, DRGeneralValidation.GENERAL_VALIDATION);
            this.put(DRValidationKey.SWITCH_DR_PAIR, DRGeneralValidation.GENERAL_VALIDATION);
            this.put(DRValidationKey.PLANNED_FAIL_OVER_DR_CG, DRPlanedFailOverValidator.PLANED_FAIL_OVER_VALIDATOR);
            this.put(DRValidationKey.PLANNED_FAIL_OVER_DR_PAIR, DRPlanedFailOverValidator.PLANED_FAIL_OVER_VALIDATOR);
            this.put(DRValidationKey.FALL_BACK_DR_CG, DRFallBackValidator.FALL_BACK_VALIDATOR);
            this.put(DRValidationKey.FALL_BACK_DR_PAIR, DRFallBackValidator.FALL_BACK_VALIDATOR);
            this.put(DRValidationKey.DISASTER_CG, DRDisasterGroupValidation.DISASTER_VALIDATOR);
            this.put(DRValidationKey.ABORT_INITIAL_SYNC_DR_PAIR, DRAbortInitialSyncValidator.ABORT_INITIAL_SYNC_VALIDATOR);
            this.put(DRValidationKey.END_INITIAL_SYNC_DR_PAIR, DREndInitialSyncValidator.END_INITIAL_SYNC_VALIDATOR);
            this.put(DRValidationKey.START_INITIAL_SYNC_DR_PAIR, DRStartInitialSyncValidator.START_INITIAL_SYNC_VALIDATOR);
            this.put(DRValidationKey.NONE_INITIAL_SYNC_DR_PAIR, DRISyncTypeValidation.ISYNC_TYPE_VALIDATOR);
            this.put(DRValidationKey.OFFLINE_INITIAL_SYNC_DR_PAIR, DRISyncTypeValidation.ISYNC_TYPE_VALIDATOR);
            this.put(DRValidationKey.ONLINE_INITIAL_SYNC_DR_PAIR, DRISyncTypeValidation.ISYNC_TYPE_VALIDATOR);
            this.put(ValidatorKey.DELETE_PAIR, DRDeletePairValidator.DELETE_PAIR_VALIDATOR);
            this.put(ValidatorKey.DELETE_CG, DRDeleteCGValidator.DELETE_CG_VALIDATOR);
            this.put(AlarmValidationKey.INVERT_ROLE, MasterParameterCode.DR_ROLE);
            this.put(AlarmValidationKey.REPL_INACTIVE, new ParameterList(MasterParameterCode.DR_REPLICATION_STATE, DRReplicationStateConstant.INACTIVE));
            this.put(AlarmValidationKey.REPL_MERGE, new ParameterList(MasterParameterCode.DR_REPLICATION_STATE, DRReplicationStateConstant.MERGING));
            this.put(AlarmValidationKey.REPL_TRANSFER, new ParameterList(MasterParameterCode.DR_REPLICATION_STATE, DRReplicationStateConstant.TRANSFERRING));
            this.put(AlarmValidationKey.ILLEGAL_PAIR_CG, Boolean.TRUE);
            this.put(AlarmValidationKey.INCONS_REPLICATION, MasterParameterCode.DR_REPLICATION_STATE);
            this.put(AlarmValidationKey.INIT_SYNC_IN_PROGRESS, new ParameterList(MasterParameterCode.DR_INITIAL_SYNC_STATE, DRInitialSyncStateConstant.IN_PROGRESS));
            this.put(AlarmValidationKey.NEED_SYNC, new ParameterList(MasterParameterCode.DR_INITIAL_SYNC_STATE, DRInitialSyncStateConstant.NEED_SYNC));
            this.put(AlarmValidationKey.CG_DR_UNKNOWN, new ParameterList(MasterParameterCode.DR_MODE, DRModeConstant.UNKNOWN));
            this.put(AlarmValidationKey.SWITCH, new ParameterList(MasterParameterCode.DR_MODE, DRModeConstant.SWITCHED));
            this.put(AlarmValidationKey.PAIR_STATE_ERROR, new ParameterList(ParameterCode.DR_PAIR_STATE, DRStateConstant.ERROR));
            this.put(AlarmValidationKey.IILEGAL_VOL_PAIR, Boolean.TRUE);
            this.put(AlarmValidationKey.INVERTED_PAIR, Boolean.TRUE);
            this.put(AlarmValidationKey.UNEQUIVELENT_PAIR, Boolean.TRUE);
        }
    }
}

