/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.nms.server.logic.AliasObjectValidator;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public abstract class TargetValidator
extends AliasObjectValidator {
    private String name;
    private String vSwitchExposedOn;
    private ClusterImpl cluster;

    public TargetValidator(ClusterImpl cluster, String name, String alias, String vSwitchExposedOn) {
        super(alias);
        this.cluster = cluster;
        this.name = name;
        this.vSwitchExposedOn = vSwitchExposedOn;
    }

    public static String getDefaultAlias() {
        return "$tar$" + System.currentTimeMillis();
    }

    public boolean isValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        if (this.cluster.getTargetListMgr().isAliasExist(this.alias)) {
            this.setErrorMsg(ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(this.alias));
            return false;
        }
        if (this.cluster.getRemoteTargetListMgr().isNameExist(this.alias)) {
            this.setErrorMsg(ErrorMessage.ALIAS_ALREADY_IN_USE_BY_REMOTE_TARGET.getMessage(this.alias));
            return false;
        }
        ArrayList vswitchGroups = SystemRootImpl.getInstance().getAllVSwitchGroups();
        int i = vswitchGroups.size();
        while (i-- > 0) {
            ClusterImpl sysCluster;
            Object vsGroup = vswitchGroups.get(i);
            if (!(vsGroup instanceof ClusterImpl) || !(sysCluster = (ClusterImpl)vsGroup).getTargetListMgr().isNameExist(this.name)) continue;
            this.setErrorMsg(ErrorMessage.NAME_ALREADY_IN_USE.getMessage(new String[]{this.name, sysCluster.toString()}));
            return false;
        }
        if (this.name.length() > 223) {
            this.setErrorMsg(ErrorMessage.TARGET_WWWI_TOO_LONG.getMessage(Integer.toString(223)));
            return false;
        }
        Vector vswitches = this.cluster.getVSwitches();
        boolean isExists = false;
        Iterator i2 = vswitches.iterator();
        while (i2.hasNext()) {
            VSwitchImpl vs = (VSwitchImpl)i2.next();
            if (!vs.getName().equals(this.vSwitchExposedOn)) continue;
            isExists = true;
            break;
        }
        if (!isExists) {
            if (this.vSwitchExposedOn == null || this.vSwitchExposedOn.length() == 0) {
                this.setErrorMsg(ErrorMessage.VSWITCH_EMPTY_VALUE.getMessage());
            } else {
                this.setErrorMsg(ErrorMessage.VSWITCH_DOESNOT_EXIST.getMessage(this.vSwitchExposedOn));
            }
            return false;
        }
        return true;
    }
}

