/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.identity.CHAPCredentialsImpl;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeTreeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class TargetList {
    private Vector list = new Vector();
    private static Log logger = LogMgr.getServerLog();

    public void addTarget(Target target) {
        this.list.addElement(target);
    }

    public void removeAll() {
        this.list.removeAllElements();
    }

    public VolumeNode removeLU(LU lu) throws RemoteException {
        TargetImpl target = (TargetImpl)lu.getParentTarget();
        return target.removeLU(lu);
    }

    public Vector getTargetsExposedOnVSwitch(String vSwitchName) throws RemoteException {
        Vector<Target> targets = new Vector<Target>();
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            if (!target.getExposedOnVSwitch().equals(vSwitchName)) continue;
            targets.addElement(target);
        }
        return targets;
    }

    public Vector getTargetsExposedOnVSwitch(VSwitch vSwitch, String vSwitchName) throws RemoteException {
        Vector<ISCSITargetImpl> targets = new Vector<ISCSITargetImpl>();
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            ISCSITargetImpl target = (ISCSITargetImpl)e.nextElement();
            String exposedOnVSwitch = target.getExposedOnVSwitch(vSwitch);
            if (exposedOnVSwitch == null || !exposedOnVSwitch.equals(vSwitchName)) continue;
            targets.addElement(target);
        }
        return targets;
    }

    public Vector getTargetsNotExposedOnVSwitch(String vSwitchName) throws RemoteException {
        Vector<Target> targets = new Vector<Target>();
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            if (target.getExposedOnVSwitch().equals(vSwitchName)) continue;
            targets.addElement(target);
        }
        return targets;
    }

    public boolean removeTarget(Target target) {
        return this.list.remove(target);
    }

    public Vector getAll() {
        return this.list;
    }

    public Target getTargetByAlias(String alias) throws RemoteException {
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            if (!target.getAlias().equals(alias)) continue;
            return target;
        }
        return null;
    }

    public Target getTargetByName(String name) throws RemoteException {
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            if (!target.getName().equals(name)) continue;
            return target;
        }
        return null;
    }

    public Target getTargetByChapCredential(CHAPCredentialsImpl chap) throws RemoteException {
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            if (!((Target)chap.getISCSIDevice()).equals(target)) continue;
            return target;
        }
        return null;
    }

    public int size() {
        return this.list.size();
    }

    public void addLU(LU lu) throws RemoteException {
        TargetImpl target = (TargetImpl)lu.getParentTarget();
        target.addLU(lu);
    }

    public Vector getVolumeTrees() throws RemoteException {
        Vector<VolumeTreeImpl> volumeTrees = new Vector<VolumeTreeImpl>();
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            Vector luList = target.getLUs();
            Enumeration iter = luList.elements();
            while (iter.hasMoreElements()) {
                LU lu = (LU)iter.nextElement();
                VolumeNode volume = lu.getVolumeChild();
                VolumeTreeImpl tree = new VolumeTreeImpl(volume);
                volumeTrees.addElement(tree);
            }
        }
        return volumeTrees;
    }

    public boolean isAliasExist(String alias) throws RemoteException {
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            if (!target.getAlias().equals(alias)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameExist(String name) throws RemoteException {
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            if (!target.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isVolumeAliasExist(String alias) throws RemoteException {
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            Vector luList = target.getLUs();
            Enumeration iter = luList.elements();
            while (iter.hasMoreElements()) {
                LU lu = (LU)iter.nextElement();
                VolumeNode volume = lu.getVolumeChild();
                if (!(volume instanceof VolumeImpl) || !((VolumeImpl)volume).isAliasExist(alias)) continue;
                return true;
            }
        }
        return false;
    }

    public void readExposedOn() throws RemoteException {
        if (this.list.size() > 0) {
            ConfigElementDataList cedl = new ConfigElementDataList();
            Enumeration e = this.list.elements();
            while (e.hasMoreElements()) {
                Target target = (Target)e.nextElement();
                ConfigElementData element = new ConfigElementData(target.getCommKeys(), target.getClassId());
                element.addParameter(new Parameter(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON));
                cedl.addElement(element);
            }
            DataMgr.getInstance().readElement(cedl);
        }
    }

    public BigInteger getAccessibleSpace() throws RemoteException {
        BigInteger accessibleSpace = BigInteger.ZERO;
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            TargetImpl target = (TargetImpl)e.nextElement();
            accessibleSpace = accessibleSpace.add(target.getAccessibleSpace());
        }
        return accessibleSpace;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        int retVal = 0;
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            TargetImpl target = (TargetImpl)e.nextElement();
            try {
                int targetRetVal = target.synchronize();
                if (targetRetVal <= retVal) continue;
                retVal = targetRetVal;
            }
            catch (IllegalValueException ive) {
                errMsg.append("\n");
                errMsg.append(ive.getMessage());
                errOccured = true;
                logger.warning(ive.getMessage() + " when trying to synchronize " + target.getClassId() + " " + target);
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return retVal;
    }

    public int getTotalVolumeCount() throws RemoteException {
        int totalVolumeCount = 0;
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            TargetImpl target = (TargetImpl)e.nextElement();
            totalVolumeCount += target.getTotalVolumeCount();
        }
        return totalVolumeCount;
    }

    public Vector getTargetsOfVolume(VolumeNode volume) throws RemoteException {
        Vector<Target> targets = new Vector<Target>();
        Enumeration e = this.getAll().elements();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            Vector lus = target.getLUs();
            Enumeration iter = lus.elements();
            while (iter.hasMoreElements()) {
                LU lu = (LU)iter.nextElement();
                VolumeNode volumeChild = lu.getVolumeChild();
                if (!volume.equals(volumeChild)) continue;
                targets.addElement(target);
            }
        }
        return targets;
    }

    public HashMap getTargetsWithSameVolume() throws RemoteException {
        HashMap<VolumeNode, Vector> targets = new HashMap<VolumeNode, Vector>();
        Enumeration e = this.getAll().elements();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            Vector lus = target.getLUs();
            Vector targetParents = null;
            Enumeration iter = lus.elements();
            while (iter.hasMoreElements()) {
                LU lu = (LU)iter.nextElement();
                VolumeNode volume = lu.getVolumeChild();
                targetParents = this.getTargetsOfVolume(volume);
                targetParents.removeElement(target);
                if (targetParents.isEmpty()) continue;
                Vector currentTargetParents = (Vector)targets.get(volume);
                if (currentTargetParents != null) {
                    currentTargetParents.addAll(targetParents);
                    continue;
                }
                targets.put(volume, targetParents);
            }
        }
        return targets;
    }

    public Vector getAllVolumeRoots() throws RemoteException {
        Vector roots = null;
        Enumeration e = this.list.elements();
        while (e.hasMoreElements()) {
            TargetImpl target = (TargetImpl)e.nextElement();
            Vector volumes = target.getAllVolumeRoots();
            if (volumes == null) continue;
            if (roots == null) {
                roots = new Vector();
            }
            roots.addAll(volumes);
        }
        return roots;
    }
}

