/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.VirtualizationHierarchyObject;
import com.sanrad.nms.server.logic.acl.Acl;
import com.sanrad.nms.server.logic.acl.AclEntry;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.acl.PolicyManagerImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.scsi.SCSIDeviceImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetValidator;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import com.sanrad.nms.server.util.types.constants.SCSITargetDeviceStatusConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class TargetImpl
extends SCSIDeviceImpl
implements Target,
VirtualizationHierarchyObject {
    protected Vector luList = new Vector();
    private String name = null;

    protected TargetImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId);
        this.addParameterCode(ParameterCode.SCSI_TARGET_STATUS);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        if (parameterList.containsKey(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON) && parameterList.get(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON) == null) {
            StringBuffer msg = new StringBuffer();
            msg.append(this.getClassId());
            msg.append(" ");
            msg.append(this.toString());
            msg.append(" - Exposed On value set to NULL");
            LogMgr.getServerLog().warning(msg.toString());
            throw new IllegalValueException(msg.toString());
        }
        this.name = this.getName();
        this.toStringValue = this.getAlias();
        return changedValues;
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.SCSI_TARGET_PORT, this.getPorts());
        return parameterList;
    }

    public String getName() throws RemoteException {
        return this.getName(null);
    }

    public abstract String getName(VSwitch var1) throws RemoteException;

    public String getExposedOnVSwitch() throws RemoteException {
        return this.getExposedOnVSwitch(null);
    }

    public String getExposedOnVSwitch(VSwitch vSwitch) throws RemoteException {
        String exposedOn = (String)this.getValueOf(vSwitch, ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON, vSwitch == null);
        return exposedOn;
    }

    public VSwitch getExposedOnVSwitchObject() throws RemoteException {
        return this.getExposedOnVSwitchObject(null);
    }

    public VSwitch getExposedOnVSwitchObject(VSwitch vSwitch) throws RemoteException {
        String vswitchName = this.getExposedOnVSwitch(vSwitch);
        VSwitch vswitchExposedOn = ((ClusterImpl)this.getCluster()).getVSwitchByName(vswitchName);
        return vswitchExposedOn;
    }

    public String getAlias() throws RemoteException {
        return this.getAlias(null);
    }

    public abstract String getAlias(VSwitch var1) throws RemoteException;

    public SCSITargetDeviceStatusConstant getStatus() throws RemoteException {
        return this.getStatus(null);
    }

    public SCSITargetDeviceStatusConstant getStatus(VSwitch vSwitch) throws RemoteException {
        return (SCSITargetDeviceStatusConstant)this.getSrValueOf(vSwitch, ParameterCode.SCSI_TARGET_STATUS, vSwitch == null);
    }

    public boolean isExposedOnDifferentVSwitches() throws RemoteException {
        String[] names;
        if (this.isRedundant() && (names = this.getExposedOnVSwitches()).length > 0) {
            String name = names[0];
            for (int i = 1; i < names.length; ++i) {
                if (names[i].equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getExposedOnVSwitches() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        String[] names = new String[vSwitches.length];
        for (int i = 0; i < vSwitches.length; ++i) {
            names[i] = this.getExposedOnVSwitch(vSwitches[i]);
        }
        return names;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof TargetImpl) {
            return ((TargetImpl)obj).name.equals(this.name);
        }
        return false;
    }

    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().info("syncDataWasChanged called  " + this.toString());
        if (!this.isSynchronizePending()) {
            return;
        }
        try {
            if (this.isNeedToSynchronize()) {
                this.synchronizeMe();
                return;
            }
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            this.errorInSynchronizing();
            return;
        }
        this.doneSynchronizing();
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().debug("Start Sync of target " + this.getAlias());
        if (this.isSynchronizePending()) {
            logger.debug("Already synchronizing " + this.getClassId() + " " + this.toString());
            return 1;
        }
        int retVal = 0;
        try {
            retVal = super.synchronize();
            LogMgr.getServerLog().debug("Sync of target " + this.getAlias() + " After Super completion status " + retVal);
            if (retVal != 3) {
                retVal = this.synchronizeLUs();
                switch (retVal) {
                    case 3: {
                        this.setSynchronizePending(false);
                        break;
                    }
                    case 1: {
                        retVal = 2;
                    }
                }
            }
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            this.setSynchronizePending(false);
            throw ive;
        }
        return retVal;
    }

    private int synchronizeLUs() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().debug("Start Sync LUS of target " + this.getAlias());
        int retVal = 0;
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        Enumeration e = this.getLUs().elements();
        while (e.hasMoreElements()) {
            try {
                LUImpl lu = (LUImpl)e.nextElement();
                int luRetVal = lu.synchronize();
                LogMgr.getServerLog().debug("Sync of target " + this.getAlias() + " Lu " + lu.toString() + " status " + luRetVal);
                if (luRetVal <= retVal) continue;
                retVal = luRetVal;
            }
            catch (IllegalValueException ive) {
                logger.warning(ive.getMessage());
                errMsg.append(" \n");
                errMsg.append(ive.getMessage());
                errOccured = true;
            }
        }
        if (errOccured) {
            this.setSynchronizePending(false);
            throw new IllegalValueException(errMsg.toString());
        }
        return retVal;
    }

    public void addLU(LU lu) throws RemoteException {
        this.luList.addElement(lu);
    }

    public VolumeNode removeLU(LU lu) throws RemoteException {
        VolumeNode volume = lu.getVolumeChild();
        this.luList.remove(lu);
        return volume;
    }

    public Vector getLUs() throws RemoteException {
        return this.luList;
    }

    protected String canBeDeleted() throws RemoteException {
        if (!this.isEmpty()) {
            return ErrorMessage.CANNOT_DELETE_TARGET_WITH_LU.getMessage(this.getAlias());
        }
        return null;
    }

    public boolean isLUNumberExist(int lun) throws RemoteException {
        return this.isLUNumberExist(null, lun);
    }

    public boolean isLUNumberExist(VSwitch vSwitch, int lun) throws RemoteException {
        Enumeration e = this.getLUs().elements();
        while (e.hasMoreElements()) {
            LU lu = (LU)e.nextElement();
            Integer luNumber = lu.getLUN(vSwitch);
            if (luNumber == null || luNumber != lun) continue;
            return true;
        }
        return false;
    }

    public int getLUCount() throws RemoteException {
        return this.getLUs().size();
    }

    public int getLUCount(VSwitch vSwitch) throws RemoteException {
        Vector lus = this.getLUs();
        int luCount = 0;
        Enumeration e = lus.elements();
        while (e.hasMoreElements()) {
            LUImpl lu = (LUImpl)e.nextElement();
            if (!lu.isKnownByVSwitch(vSwitch)) continue;
            ++luCount;
        }
        return luCount;
    }

    public int getLUCount(int lun) throws RemoteException {
        Vector lus = this.getLUs(lun);
        if (lus == null) {
            return 0;
        }
        return lus.size();
    }

    public int getLUCount(VSwitch vSwitch, int lun) throws RemoteException {
        Vector lus = this.getLUs(lun);
        int luCount = 0;
        Enumeration e = lus.elements();
        while (e.hasMoreElements()) {
            LUImpl lu = (LUImpl)e.nextElement();
            if (!lu.isKnownByVSwitch(vSwitch)) continue;
            ++luCount;
        }
        return luCount;
    }

    public LU getLU(int lun) throws RemoteException {
        Enumeration e = this.getLUs().elements();
        while (e.hasMoreElements()) {
            LU lu = (LU)e.nextElement();
            if (lu.getLUN() != lun) continue;
            return lu;
        }
        return null;
    }

    public boolean isEmpty() throws RemoteException {
        return this.luList.isEmpty();
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String exposedOn;
        String name;
        String alias = (String)parameterList.get(ClientParameterCode.TARGET_ALIAS);
        if (alias != null) {
            String errorMsg = this.isAliasValid(alias);
            if (errorMsg != null) {
                return errorMsg;
            }
            if (alias.equals("")) {
                alias = TargetValidator.getDefaultAlias();
            }
            if (this.cluster.getTargetListMgr().isAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            parameterList.put(ClientParameterCode.TARGET_ALIAS, new SrString(alias));
        }
        if ((name = (String)parameterList.get(ClientParameterCode.TARGET_NAME)) != null) {
            if (this.getLUCount() > 0) {
                return this.getClassId() + " " + this.getAlias() + " has LUs. You cannot change its name";
            }
            if (name.length() > 223) {
                return this.getClassId() + " " + this.getAlias() + ". WWWWI is limited to " + 223 + "characters";
            }
            if (this.cluster.getTargetListMgr().isNameExist(name)) {
                return ErrorMessage.NAME_ALREADY_IN_USE.getMessage(name);
            }
            parameterList.put(ClientParameterCode.TARGET_NAME, new SrString(name));
        }
        if ((exposedOn = (String)parameterList.get(ClientParameterCode.TARGET_EXPOSED_ON)) != null) {
            VSwitch vSwitch = ((ClusterImpl)this.getCluster()).getVSwitchUnderTakeover();
            VSwitchImpl otherVswitch = (VSwitchImpl)this.getOtherVSwitchFromCluster(vSwitch);
            if (vSwitch != null && vSwitch.getName().equals(exposedOn) && !otherVswitch.isDeletionPending()) {
                return "You cannot change the parameter " + ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON + " to " + exposedOn + ".  That " + ClassID.VSWITCH + " was taken over";
            }
            Iterator iter = this.getLUs().iterator();
            while (iter.hasNext()) {
                LU lu = (LU)iter.next();
                VolumeNodeImpl volume = (VolumeNodeImpl)lu.getVolumeChild();
                if (DRRootImpl.getInstance().getPairUseingVolume(volume) != null) {
                    return "You cannot change the parameter " + ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON + " to " + exposedOn + ".  That " + volume + " is part of pair ";
                }
                VSwitch volumeVSwitch = volume.isInvolvedInActiveCopyDownHirarchy();
                if (volumeVSwitch == null) continue;
                return volume.getClassId() + " " + volume + " is part of copy operation on " + ClassID.VSWITCH + " " + volumeVSwitch + ". You cannot change the exposed on " + ClassID.VSWITCH + " until the operation is done/aborted";
            }
            parameterList.put(ClientParameterCode.TARGET_EXPOSED_ON, new SrString(exposedOn));
        }
        return null;
    }

    public void clear() throws RemoteException {
        this.luList = new Vector();
        super.clear();
    }

    public BigInteger getAccessibleSpace() throws RemoteException {
        BigInteger accessibleSpace = BigInteger.ZERO;
        Enumeration e = this.luList.elements();
        while (e.hasMoreElements()) {
            LUImpl lu = (LUImpl)e.nextElement();
            BigInteger luAccessibleSpace = lu.getAccessibleSpace();
            if (luAccessibleSpace == null) continue;
            accessibleSpace = accessibleSpace.add(luAccessibleSpace);
        }
        return accessibleSpace;
    }

    public int getTotalVolumeCount() throws RemoteException {
        int totalVolumeCount = 0;
        Enumeration e = this.luList.elements();
        while (e.hasMoreElements()) {
            LUImpl lu = (LUImpl)e.nextElement();
            totalVolumeCount += lu.getTotalVolumeCount();
        }
        return totalVolumeCount;
    }

    public boolean isTheorTarget(VSwitch vSwitch) throws RemoteException {
        return this.luList.isEmpty();
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    private Vector getLUs(int lun) throws RemoteException {
        Vector<LU> luVec = null;
        Enumeration e = this.luList.elements();
        while (e.hasMoreElements()) {
            LU lu = (LU)e.nextElement();
            if (lu.getLUN() != lun) continue;
            if (luVec == null) {
                luVec = new Vector<LU>();
            }
            luVec.addElement(lu);
        }
        return luVec;
    }

    public LU isLUVolumeChildConsistence(LU lu) throws RemoteException {
        Enumeration e = this.luList.elements();
        while (e.hasMoreElements()) {
            LU otherLu = (LU)e.nextElement();
            if (!otherLu.getLUN().equals(lu.getLUN()) || otherLu.equals(lu)) continue;
            return otherLu;
        }
        return null;
    }

    public LU isLUNConsistence(LU lu) throws RemoteException {
        Enumeration e = this.luList.elements();
        while (e.hasMoreElements()) {
            LU otherLu = (LU)e.nextElement();
            if (!otherLu.getVolumeChild().equals(lu.getVolumeChild()) || otherLu.equals(lu)) continue;
            return otherLu;
        }
        return null;
    }

    public Vector getAllVolumeRoots() throws RemoteException {
        Vector<VolumeNode> roots = null;
        Enumeration e = this.luList.elements();
        while (e.hasMoreElements()) {
            LU lu = (LU)e.nextElement();
            if (roots == null) {
                roots = new Vector<VolumeNode>();
            }
            roots.addElement(lu.getVolumeChild());
        }
        return roots;
    }

    public Acl getAclForTarget() throws RemoteException {
        PolicyManagerImpl policyMgr = (PolicyManagerImpl)this.getCluster().getPolicyManager();
        Hashtable aclMap = policyMgr.getAllAcl();
        return (Acl)aclMap.get(this);
    }

    public boolean isExposedOnDeadVswitch() {
        try {
            String exposedOn = this.getExposedOnVSwitch();
            VSwitch[] vSwitches = this.getConnectedVSwitches();
            for (int i = 0; i < vSwitches.length; ++i) {
                if (!exposedOn.equals(vSwitches[i].getName())) continue;
                return !vSwitches[i].isConnected();
            }
            return false;
        }
        catch (RemoteException re) {
            logger.error(re);
            return true;
        }
    }

    public boolean isLegitimateForVolumeOperation() {
        try {
            return !this.isExposedOnDeadVswitch() && !this.isExposedOnDifferentVSwitches();
        }
        catch (RemoteException re) {
            logger.error(re);
            return false;
        }
    }

    public HashMap checkConsistencyBetweenVSwitches() throws RemoteException {
        Object[] inconsistencyVals;
        HashMap<ParameterCode, Object[]> map = super.checkConsistencyBetweenVSwitches();
        AclImpl acl = (AclImpl)this.getAclForTarget();
        if (acl != null && (inconsistencyVals = acl.isDefaultAccessInconsistent()) != null) {
            if (map == null) {
                map = new HashMap<ParameterCode, Object[]>();
            }
            map.put(ParameterCode.ACL_ENTRY_ACCESS, inconsistencyVals);
        }
        return map;
    }

    public Vector getAllSnapshotVolumeSources() throws RemoteException {
        Vector<VolumeNode> allSources = new Vector<VolumeNode>();
        Enumeration e = this.getLUs().elements();
        while (e.hasMoreElements()) {
            LU lu = (LU)e.nextElement();
            VolumeNodeImpl volumeChild = (VolumeNodeImpl)lu.getVolumeChild();
            if (volumeChild.isSnapshotSource()) {
                allSources.addElement(volumeChild);
                continue;
            }
            if (!volumeChild.getClassId().equals(ClassID.SNAPSHOT_VOLUME)) continue;
            allSources.addElement(((SnapshotVolumeImpl)volumeChild).getSourceVolume());
        }
        return allSources;
    }

    public Vector getAllSnapshotVolumeSources(VSwitch vSwitch) throws RemoteException {
        Vector<VolumeNode> allSources = new Vector<VolumeNode>();
        Enumeration e = this.getLUs().elements();
        while (e.hasMoreElements()) {
            LU lu = (LU)e.nextElement();
            VolumeNodeImpl volumeChild = (VolumeNodeImpl)lu.getVolumeChild();
            if (volumeChild.isSnapshotSource(vSwitch)) {
                allSources.addElement(volumeChild);
                continue;
            }
            if (!volumeChild.getClassId().equals(ClassID.SNAPSHOT_VOLUME)) continue;
            allSources.addElement(((SnapshotVolumeImpl)volumeChild).getSourceVolume());
        }
        return allSources;
    }

    public Identity knowIdentity(IdentityPurposeConstant identityPurpose, ArrayList existedRemoteInitiatorNames) throws RemoteException {
        AclImpl acl = (AclImpl)this.getAclForTarget();
        Vector aclEntries = acl.getEntries();
        for (int index = 0; index < aclEntries.size(); ++index) {
            AclEntry aclEntry = (AclEntry)aclEntries.elementAt(index);
            Identity aclEntryIdentity = aclEntry.getIdentity();
            if (!aclEntryIdentity.getPurpose().equals(identityPurpose) || !((IdentityImpl)aclEntryIdentity).areNamesEqual(existedRemoteInitiatorNames)) continue;
            return aclEntryIdentity;
        }
        return null;
    }

    public Identity getIdentityOfInitiatorNames(IdentityPurposeConstant identityPurpose, ArrayList remoteInitiatorNames) throws RemoteException {
        AclImpl acl = (AclImpl)this.getAclForTarget();
        Vector aclEntries = acl.getEntries();
        for (int index = 0; index < aclEntries.size(); ++index) {
            AclEntry aclEntry = (AclEntry)aclEntries.elementAt(index);
            Identity aclEntryIdentity = aclEntry.getIdentity();
            if (!aclEntryIdentity.getPurpose().equals(identityPurpose) || ((IdentityImpl)aclEntryIdentity).isNameExist((String)remoteInitiatorNames.get(0)) == null) continue;
            return aclEntryIdentity;
        }
        return null;
    }
}

