/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.statistics.StatisticsImpl;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.SCSITargetPort;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.SCSIPortRoleConstant;
import com.sanrad.nms.server.util.types.constants.SCSITransportType;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class SCSITargetPortImpl
extends StatisticsImpl
implements SCSITargetPort {
    private static List s_parameterCodeList;
    private static HashMap s_parametersToCalculateMap;

    public SCSITargetPortImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.SCSI_TARGET_PORT, s_parameterCodeList, s_parametersToCalculateMap);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.getName();
        return changedValues;
    }

    private ISCSITargetImpl getTargetImpl() throws RemoteException {
        for (int i = 0; i < this.getConnectedVSwitchCounter(); ++i) {
            CommKeyClassId scsiTargetCommKeyClassId;
            VSwitch vswitch = this.getConnectedVSwitches()[i];
            if (vswitch == null || (scsiTargetCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vswitch, ParameterCode.ISCSI_TARGET_ID)) == null) continue;
            CommKeyClassId iscsiTargetCommKeyClassId = ((ClusterImpl)this.getCluster()).getISCSIId(scsiTargetCommKeyClassId);
            ISCSITargetImpl targetImpl = (ISCSITargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(iscsiTargetCommKeyClassId);
            if (targetImpl == null) continue;
            return targetImpl;
        }
        return null;
    }

    public VSwitch getDominentVswitch() throws RemoteException {
        VSwitch targetVS;
        ISCSITargetImpl target = this.getTargetImpl();
        if (target != null && this.isKnownByVSwitch(targetVS = target.getActiveVswitch())) {
            return targetVS;
        }
        return super.getDominentVswitch();
    }

    protected PollingGroupType getGroupType() {
        return PollingGroupType.SCSI_TARGET_PORT_STATISTICS_GROUP_TYPE;
    }

    public SCSIPortRoleConstant getRole() throws RemoteException {
        return (SCSIPortRoleConstant)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_PORT_ROLE);
    }

    public SCSITransportType getTransportType() throws RemoteException {
        return (SCSITransportType)this.getSrValueOf(ParameterCode.SCSI_PORT_TRANSPORT_TYPE);
    }

    public String getName() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_TARGET_PORT_NAME);
    }

    public BigInteger getReadMB() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_TARGET_PORT_READ_MB);
    }

    public BigInteger getWrittenMB() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_TARGET_PORT_WRITTEN_MB);
    }

    public BigInteger getInCommands() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_TARGET_PORT_IN_COMMANDS);
    }

    public ISCSITarget getTarget() throws RemoteException {
        return this.getTargetImpl();
    }

    static {
        s_parametersToCalculateMap = new HashMap();
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.ISCSI_TARGET_ID);
        parameterCodes.addElement(ParameterCode.SCSI_PORT_ROLE);
        parameterCodes.addElement(ParameterCode.SCSI_PORT_TRANSPORT_TYPE);
        parameterCodes.addElement(ParameterCode.SCSI_TARGET_PORT_NAME);
        parameterCodes.addElement(ParameterCode.SCSI_TARGET_PORT_IN_COMMANDS);
        parameterCodes.addElement(ParameterCode.SCSI_TARGET_PORT_READ_MB);
        parameterCodes.addElement(ParameterCode.SCSI_TARGET_PORT_WRITTEN_MB);
        s_parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
        s_parametersToCalculateMap.put(ParameterCode.SCSI_TARGET_PORT_IN_COMMANDS, ClientParameterCode.SCSI_TARGET_PORT_IN_COMMANDS_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.SCSI_TARGET_PORT_READ_MB, ClientParameterCode.SCSI_TARGET_PORT_READ_MB_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.SCSI_TARGET_PORT_WRITTEN_MB, ClientParameterCode.SCSI_TARGET_PORT_WRITTEN_MB_PER_SEC);
    }
}

