/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.target.ISCSITargetAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SitesSynchronizeable;
import com.sanrad.nms.server.logic.acl.Acl;
import com.sanrad.nms.server.logic.acl.AclEntry;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.Credentials;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatistics;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatisticsImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.ISCSITargetLoginFailureTypeConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ISCSITargetImpl
extends TargetImpl
implements ISCSITarget,
SitesSynchronizeable {
    private ArrayList m_sessions = new ArrayList();
    private ArrayList m_remoteInitiators = new ArrayList();
    private Credentials m_credentials;

    public ISCSITargetImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.ISCSI_TARGET);
        this.addParameterCode(ParameterCode.ISCSI_TARGET_NAME);
        this.addParameterCode(ParameterCode.ISCSI_TARGET_ALIAS);
        this.addParameterCode(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON);
        this.addParameterCode(ParameterCode.SCSI_TARGET_PORT_ID);
        this.addParameterCode(ParameterCode.ISCSI_REMOTE_INITIATOR_ID);
        this.addParameterCode(ParameterCode.ISCSI_REMOTE_INITIATOR_STATISTICS_ID);
        this.addParameterCode(ParameterCode.ISCSI_SESSION_ID);
        this.addParameterCode(ParameterCode.ISCSI_SESSION_STATISTICS_ID);
        this.addParameterCode(ParameterCode.SCSI_DEVICE_ID);
        this.addParameterCode(ParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE);
        this.addParameterCode(ParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME);
        this.addParameterCode(ParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE);
        this.addParameterCode(ParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME);
        this.addParameterCode(ParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP);
    }

    public void changeElement(HashMap parameterList) throws RemoteException, IllegalValueException {
        Object userName = parameterList.get(ClientParameterCode.TARGET_USER_NAME);
        Object password = parameterList.get(ClientParameterCode.TARGET_PASSWORD);
        if (userName != null || password != null) {
            HashMap map = new HashMap();
            if (userName != null) {
                map.put(ClientParameterCode.CHAP_CREDENTIALS_USER_NAME, userName);
            }
            if (password != null) {
                map.put(ClientParameterCode.CHAP_CREDENTIALS_PASSWORD, password);
            }
            if (this.getCredentials() != null) {
                this.getCredentials().changeElement(map);
            } else {
                logger.warning("Credentials of " + this.getClassId() + " " + this + " at cluster " + this.getCluster() + " is null - change cannot be made");
            }
        }
        super.changeElement(parameterList);
    }

    public void clear() throws RemoteException {
        this.m_sessions.clear();
        this.m_remoteInitiators.clear();
        this.setCredentials(null);
        super.clear();
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.ISCSI_TARGET_REMOTE_INITIATORS, this.getISCSIRemoteInitiators());
        parameterList.put(ClientParameterCode.TARGET_SESSIONS, this.getISCSISessions());
        parameterList.put(ClientParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE, this.getNumberOfLoginFailure());
        parameterList.put(ClientParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME, this.getLastLoginFailureTime());
        parameterList.put(ClientParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE, this.getLastLoginFailureType());
        parameterList.put(ClientParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME, this.getLastLoginFailureInitiatorName());
        parameterList.put(ClientParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP, this.getLastLoginFailureInitiatorIP());
        return parameterList;
    }

    public String getPassword() {
        return "";
    }

    public VSwitch getDominentVswitch() throws RemoteException {
        for (int i = 0; i < this.getConnectedVSwitchCounter(); ++i) {
            if (this.getConnectedVSwitches()[i] == null || !this.getConnectedVSwitches()[i].getName().equals(this.getExposedOnVSwitch(this.getConnectedVSwitches()[i]))) continue;
            return this.getConnectedVSwitches()[i];
        }
        return super.getDominentVswitch();
    }

    private VSwitch getVSwitchToCheck() throws RemoteException {
        VSwitch vswitchUnderTakeOver;
        VSwitch vswitchToCheck = null;
        String vswitchNameExposedOn = this.getExposedOnVSwitch();
        VSwitch vswitchExposedOn = ((ClusterImpl)this.getCluster()).getVSwitchByName(vswitchNameExposedOn);
        vswitchToCheck = ((ClusterImpl)this.getCluster()).isSingleVSwitchMode() ? vswitchExposedOn : ((vswitchUnderTakeOver = ((ClusterImpl)this.getCluster()).getVSwitchUnderTakeover()) == null ? vswitchExposedOn : vswitchUnderTakeOver);
        return vswitchToCheck;
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.ISCSI_TARGET_ALIAS, vSwitch == null);
    }

    public String getName(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.ISCSI_TARGET_NAME, vSwitch == null);
    }

    public BigInteger getNumberOfLoginFailure() throws RemoteException {
        VSwitch vswitchToCheck = this.getVSwitchToCheck();
        BigInteger num = (BigInteger)this.getValueOf(vswitchToCheck, ParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE, false);
        if (num == null && !((ClusterImpl)this.getCluster()).isSingleVSwitchMode()) {
            VSwitch otherVswitch = ((ClusterImpl)this.getCluster()).getOtherVSwitch(vswitchToCheck);
            num = (BigInteger)this.getValueOf(otherVswitch, ParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE, false);
        }
        if (num == null) {
            num = new BigInteger("0", 10);
        }
        return num;
    }

    public Long getLastLoginFailureTime() throws RemoteException {
        VSwitch vswitchToCheck = this.getVSwitchToCheck();
        Long time = (Long)this.getValueOf(vswitchToCheck, ParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME);
        if (time == null && !((ClusterImpl)this.getCluster()).isSingleVSwitchMode()) {
            VSwitch otherVswitch = ((ClusterImpl)this.getCluster()).getOtherVSwitch(vswitchToCheck);
            time = (Long)this.getValueOf(otherVswitch, ParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME, false);
        }
        if (time == null) {
            time = new Long(0L);
        }
        return time;
    }

    public ISCSITargetLoginFailureTypeConstant getLastLoginFailureType() throws RemoteException {
        VSwitch vswitchToCheck = this.getVSwitchToCheck();
        ISCSITargetLoginFailureTypeConstant type = (ISCSITargetLoginFailureTypeConstant)this.getSrValueOf(vswitchToCheck, ParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE, false);
        if (type == null && !((ClusterImpl)this.getCluster()).isSingleVSwitchMode()) {
            VSwitch otherVswitch = ((ClusterImpl)this.getCluster()).getOtherVSwitch(vswitchToCheck);
            type = (ISCSITargetLoginFailureTypeConstant)this.getSrValueOf(otherVswitch, ParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE, false);
        }
        return type;
    }

    public String getLastLoginFailureInitiatorName() throws RemoteException {
        VSwitch vswitchToCheck = this.getVSwitchToCheck();
        String name = (String)this.getValueOf(vswitchToCheck, ParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME, false);
        if (name == null && !((ClusterImpl)this.getCluster()).isSingleVSwitchMode()) {
            VSwitch otherVswitch = ((ClusterImpl)this.getCluster()).getOtherVSwitch(vswitchToCheck);
            name = (String)this.getValueOf(otherVswitch, ParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME, false);
        }
        return name;
    }

    public String getLastLoginFailureInitiatorIP() throws RemoteException {
        VSwitch vswitchToCheck = this.getVSwitchToCheck();
        String ip = this.getDisplayStringOf(vswitchToCheck, ParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP);
        if (ip == null && !((ClusterImpl)this.getCluster()).isSingleVSwitchMode()) {
            VSwitch otherVswitch = ((ClusterImpl)this.getCluster()).getOtherVSwitch(vswitchToCheck);
            ip = this.getDisplayStringOf(otherVswitch, ParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP);
        }
        return ip;
    }

    public String getUserName() throws RemoteException {
        return this.m_credentials == null ? null : this.m_credentials.getUserName();
    }

    public void setCredentials(Credentials credentials) {
        this.m_credentials = credentials;
    }

    public Credentials getCredentials() {
        return this.m_credentials;
    }

    public AlarmGenerator getAlarmGenerator() {
        return ISCSITargetAlarmGenerator.getInstance();
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (this.canBeSynchronized() != null) {
            return 2;
        }
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        Acl acl = this.getAclForTarget();
        if (acl != null && !this.isInSynchronizingMode()) {
            AclEntry firstEntry = ((AclImpl)acl).getFirstEntry();
            storage.createISCSITarget(this.getName(), this.getAlias(), firstEntry.getPermission(), this.getExposedOnVSwitch(), this.cluster.getOtherVSwitches(this.getVSwitches()));
            this.setSynchronizingMode(true);
            return 2;
        }
        return 3;
    }

    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        if (!this.isNeedToSynchronize()) {
            ((AclImpl)this.getAclForTarget()).synchronizeMe();
            Vector lus = this.getLUs();
            int numOfLuns = lus.size();
            for (int i = 0; i < numOfLuns; ++i) {
                LUImpl currLu = (LUImpl)lus.get(i);
                currLu.synchronizeMe();
            }
        }
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String result = super.isValid(parameterList);
        if (result == null) {
            String password;
            String userName = (String)parameterList.get(ClientParameterCode.TARGET_USER_NAME);
            if (userName != null) {
                parameterList.put(ClientParameterCode.TARGET_USER_NAME, new SrString(userName));
            }
            if ((password = (String)parameterList.get(ClientParameterCode.TARGET_PASSWORD)) != null) {
                parameterList.put(ClientParameterCode.TARGET_PASSWORD, new SrString(password));
            }
        }
        return result;
    }

    public String getTargetDeviceKey() {
        String targetDeviceKey = "";
        try {
            CommKey[] commKeys = this.getCommKeys();
            String targetkey = commKeys[0].getKey();
            targetDeviceKey = targetkey.substring(targetkey.indexOf(".") + 1);
        }
        catch (RemoteException re) {
            LogMgr.getServerLog().info("Cannot parse target device commkey.");
        }
        return targetDeviceKey;
    }

    public ISCSIRemoteInitiator[] getISCSIRemoteInitiators() throws RemoteException {
        ISCSIRemoteInitiator[] array = new ISCSIRemoteInitiator[this.m_remoteInitiators.size()];
        return this.m_remoteInitiators.toArray(array);
    }

    public void addRemoteInitiator(ISCSIRemoteInitiator remoteInitiator) {
        this.m_remoteInitiators.add(remoteInitiator);
    }

    public boolean initiatorKnownByTarget(ISCSIRemoteInitiatorImpl initiatorImpl) {
        for (int index = 0; index < this.m_remoteInitiators.size(); ++index) {
            if (!initiatorImpl.equals((ISCSIRemoteInitiatorImpl)this.m_remoteInitiators.get(index))) continue;
            return true;
        }
        return false;
    }

    private CommKeyClassId[] getSessionsKeys(ParameterCode code) throws RemoteException {
        CommKeyClassId[] initiatorsKeys = (CommKeyClassId[])this.getSrArrayValueOf(code);
        return initiatorsKeys;
    }

    public ISCSISession[] getISCSISessions() throws RemoteException {
        ISCSISession[] array = new ISCSISession[this.m_sessions.size()];
        return this.m_sessions.toArray(array);
    }

    public void addSession(ISCSISession session) {
        this.m_sessions.add(session);
    }

    public void removeSession(ISCSISession session) {
        this.m_sessions.remove(session);
    }

    public void removeSessionStatisticsElement(ISCSISessionStatisticsImpl sessionImpl) {
        try {
            LogicObject[] sessions = this.getISCSISessionsStatistics();
            for (int i = 0; i < sessions.length; ++i) {
                ISCSISessionStatisticsImpl session = (ISCSISessionStatisticsImpl)sessions[i];
                if (session == null || !sessionImpl.equals(session)) continue;
                sessions[i] = null;
                break;
            }
            CommKeyClassId[] leftSessionCommkeys = this.convertSessionsVecToCommkeysClassIds(sessions);
            this.setOneParameter(ParameterCode.ISCSI_SESSION_STATISTICS_ID, leftSessionCommkeys, null);
        }
        catch (RemoteException re) {
            logger.error("Cannot remove sessions statistics from target!.", re);
        }
        catch (IllegalValueException ive) {
            logger.warning("Cannot set left sessions statistics of target! " + ive.getMessage());
        }
    }

    public ISCSISessionStatistics[] getISCSISessionsStatistics() throws RemoteException {
        ArrayList<ISCSISessionStatisticsImpl> allSessions = new ArrayList<ISCSISessionStatisticsImpl>();
        CommKeyClassId[] sessionsKeys = this.getSessionsKeys(ParameterCode.ISCSI_SESSION_STATISTICS_ID);
        if (sessionsKeys != null) {
            for (int i = 0; i < sessionsKeys.length; ++i) {
                ISCSISessionStatisticsImpl sessionImpl;
                if (sessionsKeys[i] == null || (sessionImpl = (ISCSISessionStatisticsImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(sessionsKeys[i])) == null) continue;
                allSessions.add(sessionImpl);
            }
        }
        ISCSISessionStatistics[] array = new ISCSISessionStatistics[allSessions.size()];
        return allSessions.toArray(array);
    }

    public void addSessionStatisticsElement(ISCSISessionStatisticsImpl sessionImpl) {
        try {
            LogicObject[] sessions = this.getISCSISessionsStatistics();
            CommKeyClassId[] leftSessionsCommkeys = this.convertAndAddSessionsVecToCommkeysClassIds(sessions, sessionImpl);
            this.setOneParameter(ParameterCode.ISCSI_SESSION_STATISTICS_ID, leftSessionsCommkeys, null);
        }
        catch (RemoteException re) {
            logger.error("Cannot add Session statistics from target!.", re);
        }
        catch (IllegalValueException ive) {
            logger.warning("Cannot set Session statistics of target! " + ive.getMessage());
        }
    }

    private CommKeyClassId[] convertSessionsVecToCommkeysClassIds(LogicObject[] array) {
        CommKeyClassId[] arr = new CommKeyClassId[array.length];
        int index = 0;
        try {
            for (int i = 0; i < array.length; ++i) {
                LogicObjectImpl session = (LogicObjectImpl)array[i];
                CommKeyClassId sessionCommkeyClassId = session.getCommKeyClassId();
                arr[index++] = sessionCommkeyClassId;
            }
            return arr;
        }
        catch (RemoteException re) {
            LogMgr.getServerLog().info("Cannot convert from session impl to commkeyclassid!");
            return arr;
        }
    }

    private CommKeyClassId[] convertAndAddSessionsVecToCommkeysClassIds(LogicObject[] array, LogicObject newObject) {
        CommKeyClassId[] arr = new CommKeyClassId[array.length];
        int index = 0;
        try {
            for (int i = 0; i < array.length; ++i) {
                LogicObjectImpl session = (LogicObjectImpl)array[i];
                CommKeyClassId sessionCommkeyClassId = session.getCommKeyClassId();
                arr[index++] = sessionCommkeyClassId;
            }
            arr[index++] = newObject.getCommKeyClassId();
            return arr;
        }
        catch (RemoteException re) {
            LogMgr.getServerLog().info("Cannot convert from session impl to commkeyclassid!");
            return arr;
        }
    }

    public boolean sessionStatisticsKnownByTarget(ISCSISessionStatisticsImpl sessionImpl) {
        try {
            ISCSISessionStatistics[] sessions = this.getISCSISessionsStatistics();
            for (int index = 0; index < sessions.length; ++index) {
                if (!sessionImpl.equals((ISCSISessionStatisticsImpl)sessions[index])) continue;
                return true;
            }
        }
        catch (RemoteException re) {
            LogMgr.getServerLog().info("Cannot get target sessions statistics!.");
        }
        return false;
    }

    public void synchronizeDiscoveryElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
        VSwitch vswitch = this.getExposedOnVSwitchObject();
        ArrayList clusterPortals = ((ClusterImpl)this.getCluster()).getAllTargetPortals(vswitch);
        String[] remoteTargetPortalIPs = new String[clusterPortals.size()];
        BigInteger[] remoteTargetPortalPorts = new BigInteger[clusterPortals.size()];
        Integer[] remoteTargetPortalGroupTags = new Integer[clusterPortals.size()];
        this.parseClusterPortalsToArrays(clusterPortals, remoteTargetPortalIPs, remoteTargetPortalPorts, remoteTargetPortalGroupTags);
        try {
            ((StorageImpl)remoteCluster.getStorage()).createISCSIRemoteTarget(this.getName(), this.getAlias(), null, null, remoteTargetPortalIPs, remoteTargetPortalPorts, remoteTargetPortalGroupTags, false);
        }
        catch (IllegalValueException ive) {
            // empty catch block
        }
    }

    private void parseClusterPortalsToArrays(ArrayList clusterPortals, String[] remoteTargetPortalIPs, BigInteger[] remoteTargetPortalPorts, Integer[] remoteTargetPortalGroupTags) throws RemoteException {
        for (int index = 0; index < clusterPortals.size(); ++index) {
            PortalTableRowImpl portal = (PortalTableRowImpl)clusterPortals.get(index);
            remoteTargetPortalIPs[index] = new String(portal.getIPAddress());
            remoteTargetPortalPorts[index] = new BigInteger(String.valueOf(portal.getPort()), 10);
            remoteTargetPortalGroupTags[index] = new Integer(portal.getTag());
        }
    }

    public void synchronizeNewElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
        ISCSIRemoteTarget equivalentRemoteTarget = ((ClusterImpl)this.getCluster()).findLocalTargetInRemoteCluster(remoteCluster, this.getName());
        if (equivalentRemoteTarget != null) {
            ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)equivalentRemoteTarget;
            VSwitch[] connectedVSwitches = remoteTarget.getConnectedVSwitches();
            VSwitch vswitch = this.getExposedOnVSwitchObject();
            ArrayList clusterPortals = ((ClusterImpl)this.getCluster()).getAllTargetPortals(vswitch);
            remoteTarget.createAllLocalPortalsInRemoteCluster(clusterPortals, connectedVSwitches);
        }
    }

    public void synchronizeChangeElementOnRemoteCluster(Cluster remoteCluster, HashMap changedValues) throws RemoteException {
    }

    public void synchronizePreRemoveElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
        ISCSIRemoteTarget equivalentRemoteTarget = ((ClusterImpl)this.getCluster()).findLocalTargetInRemoteCluster(remoteCluster, this.getName());
        if (equivalentRemoteTarget != null) {
            try {
                ((ISCSIRemoteTargetImpl)equivalentRemoteTarget).siteSynchronizationDelete();
            }
            catch (IllegalValueException ive) {
                LogMgr.getServerLog().info("Cannot delete remote target due to delete of a local target for site synch.");
            }
        }
    }

    public void synchronizePostRemoveElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
    }
}

