/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.nms.server.logic.AliasObjectValidator;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.RemoteTargetList;
import com.sanrad.nms.server.logic.target.TargetList;
import java.rmi.RemoteException;

public class ISCSIRemoteTargetValidator
extends AliasObjectValidator {
    private String m_name;
    private String m_alias;
    private TargetList m_targetList;
    private RemoteTargetList m_remoteTargetList;
    private ClusterImpl m_cluster;

    public ISCSIRemoteTargetValidator(ClusterImpl cluster, String name, String alias, TargetList targetList, RemoteTargetList remoteTargetList) {
        super(alias);
        this.m_cluster = cluster;
        this.m_name = name;
        this.m_alias = alias;
        this.m_targetList = targetList;
        this.m_remoteTargetList = remoteTargetList;
    }

    public boolean isValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        if (this.m_targetList.isNameExist(this.m_name) || this.m_remoteTargetList.isNameExist(this.m_name)) {
            this.setErrorMsg(ErrorMessage.NAME_ALREADY_IN_USE.getMessage(this.m_name));
            return false;
        }
        if (this.m_name.length() > 223) {
            this.setErrorMsg(ErrorMessage.TARGET_WWWI_TOO_LONG.getMessage(Integer.toString(223)));
            return false;
        }
        return true;
    }
}

