/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.util.NetUtil;
import java.math.BigInteger;
import java.rmi.RemoteException;

public class ISCSIRemoteTargetPortalValidator
extends LogicObjectValidator {
    private ISCSIRemoteTargetImpl m_remoteTarget;
    private String[] m_ip;
    private BigInteger[] m_port;
    private Integer[] m_portalGroupTag;
    private VSwitch m_vswitchToCreateOn;

    public ISCSIRemoteTargetPortalValidator(ISCSIRemoteTargetImpl remoteTarget, String[] ip, BigInteger[] port, Integer[] groupTag, VSwitch vswitchToCreateOn) {
        this.m_remoteTarget = remoteTarget;
        this.m_ip = ip;
        this.m_port = port;
        this.m_portalGroupTag = groupTag;
        this.m_vswitchToCreateOn = vswitchToCreateOn;
    }

    public boolean isValid() throws RemoteException {
        String currIP;
        int index;
        if (this.m_remoteTarget != null) {
            for (index = 0; index < this.m_ip.length; ++index) {
                StringBuffer sb;
                currIP = this.m_ip[index];
                int existed = this.m_remoteTarget.isPortalExisted(currIP, this.m_port[index].intValue(), this.m_portalGroupTag[index], this.m_vswitchToCreateOn);
                if (existed > 0) {
                    sb = new StringBuffer(ClassID.ISCSI_REMOTE_TARGET_PORTAL.toString());
                    sb.append(" ");
                    sb.append(this.m_ip[index]);
                    sb.append(":");
                    sb.append(this.m_port[index].intValue());
                    sb.append(" already exists in ");
                    sb.append(ClassID.ISCSI_REMOTE_TARGET);
                    sb.append(" ");
                    sb.append(this.m_remoteTarget.getName());
                    if (this.m_vswitchToCreateOn != null) {
                        sb.append(" on ");
                        sb.append(ClassID.VSWITCH);
                        sb.append(" ");
                        sb.append(this.m_vswitchToCreateOn.getName());
                    }
                    this.setErrorMsg(sb.toString());
                    return false;
                }
                sb = new StringBuffer();
                sb.append("IP ");
                sb.append(currIP);
                sb.append(" already exists ");
                if (((ClusterImpl)this.m_remoteTarget.getCluster()).isIPExistedAsISNSServer(currIP)) {
                    sb.append("an ISNS server IP in ");
                    sb.append(ClassID.CLUSTER);
                    sb.append(" ");
                    sb.append(((ClusterImpl)this.m_remoteTarget.getCluster()).getAlias());
                    this.setErrorMsg(sb.toString());
                    return false;
                }
                if (((ClusterImpl)this.m_remoteTarget.getCluster()).isIPExistedAsRadiusServer(currIP)) {
                    sb.append("as a radius server in ");
                    sb.append(ClassID.CLUSTER);
                    sb.append(" ");
                    sb.append(((ClusterImpl)this.m_remoteTarget.getCluster()).getAlias());
                    this.setErrorMsg(sb.toString());
                    return false;
                }
                if (this.m_vswitchToCreateOn != null) {
                    if (((VSwitchImpl)this.m_vswitchToCreateOn).isIPExistedAsLocalPortal(currIP)) {
                        sb.append("as a local portal in ");
                        sb.append(ClassID.VSWITCH);
                        sb.append(" ");
                        sb.append(this.m_vswitchToCreateOn.getName());
                        this.setErrorMsg(sb.toString());
                        return false;
                    }
                    if (((VSwitchImpl)this.m_vswitchToCreateOn).isIPExistedAsNeighbor(currIP)) {
                        sb.append("as a neighbor in ");
                        sb.append(ClassID.VSWITCH);
                        sb.append(" ");
                        sb.append(this.m_vswitchToCreateOn.getName());
                        this.setErrorMsg(sb.toString());
                        return false;
                    }
                    if (((VSwitchImpl)this.m_vswitchToCreateOn).isIPExistedAsLocalIP(currIP)) {
                        sb.append("as a local IP in ");
                        sb.append(ClassID.VSWITCH);
                        sb.append(" ");
                        sb.append(this.m_vswitchToCreateOn.getName());
                        this.setErrorMsg(sb.toString());
                        return false;
                    }
                    if (((VSwitchImpl)this.m_vswitchToCreateOn).isIPExistedAsRoutIP(currIP)) {
                        sb.append("as a rout IP in ");
                        sb.append(ClassID.VSWITCH);
                        sb.append(" ");
                        sb.append(this.m_vswitchToCreateOn.getName());
                        this.setErrorMsg(sb.toString());
                        return false;
                    }
                    if (!((VSwitchImpl)this.m_vswitchToCreateOn).isIPExistedAsSNMPManager(currIP)) continue;
                    sb.append("as an SNMP manager IP in ");
                    sb.append(ClassID.VSWITCH);
                    sb.append(" ");
                    sb.append(this.m_vswitchToCreateOn.getName());
                    this.setErrorMsg(sb.toString());
                    return false;
                }
                if (((ClusterImpl)this.m_remoteTarget.getCluster()).isIPExistedAsLocalPortal(currIP)) {
                    sb.append("as a local portal in ");
                    sb.append(ClassID.CLUSTER);
                    sb.append(" ");
                    sb.append(((ClusterImpl)this.m_remoteTarget.getCluster()).getAlias());
                    this.setErrorMsg(sb.toString());
                    return false;
                }
                if (((ClusterImpl)this.m_remoteTarget.getCluster()).isIPExistedAsNeighbor(currIP)) {
                    sb.append("as a neighbor in ");
                    sb.append(ClassID.CLUSTER);
                    sb.append(" ");
                    sb.append(((ClusterImpl)this.m_remoteTarget.getCluster()).getAlias());
                    this.setErrorMsg(sb.toString());
                    return false;
                }
                if (((ClusterImpl)this.m_remoteTarget.getCluster()).isIPExistedAsLocalIP(currIP)) {
                    sb.append("as a local IP in ");
                    sb.append(ClassID.CLUSTER);
                    sb.append(" ");
                    sb.append(((ClusterImpl)this.m_remoteTarget.getCluster()).getAlias());
                    this.setErrorMsg(sb.toString());
                    return false;
                }
                if (((ClusterImpl)this.m_remoteTarget.getCluster()).isIPExistedAsRoutIP(currIP)) {
                    sb.append("as a rout IP in ");
                    sb.append(ClassID.CLUSTER);
                    sb.append(" ");
                    sb.append(((ClusterImpl)this.m_remoteTarget.getCluster()).getAlias());
                    this.setErrorMsg(sb.toString());
                    return false;
                }
                if (!((ClusterImpl)this.m_remoteTarget.getCluster()).isIPExistedAsSNMPManager(currIP)) continue;
                sb.append("as an SNMP manager IP in ");
                sb.append(ClassID.CLUSTER);
                sb.append(" ");
                sb.append(((ClusterImpl)this.m_remoteTarget.getCluster()).getAlias());
                this.setErrorMsg(sb.toString());
                return false;
            }
        }
        for (index = 0; index < this.m_ip.length; ++index) {
            if (NetUtil.isNetworkIpValid(this.m_ip[index])) continue;
            this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.m_ip[index]));
            return false;
        }
        for (int startFromIndex = 0; startFromIndex < this.m_ip.length - 1; ++startFromIndex) {
            currIP = this.m_ip[startFromIndex];
            for (int iterIndex = startFromIndex + 1; iterIndex < this.m_ip.length; ++iterIndex) {
                String compareToIP = this.m_ip[iterIndex];
                if (!currIP.equals(compareToIP)) continue;
                this.setErrorMsg(ErrorMessage.MULTIPLE_IP_DEFINED.getMessage(currIP));
                return false;
            }
        }
        return true;
    }
}

