/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.target.ISCSIRemoteTargetPortalAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortal;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ISCSIRemoteTargetPortalImpl
extends SynchronizeableImpl
implements ISCSIRemoteTargetPortal {
    private static List parameterCodeList;

    public ISCSIRemoteTargetPortalImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.ISCSI_REMOTE_TARGET_PORTAL, parameterCodeList);
    }

    public ISCSIRemoteTarget getRemoteTarget() throws RemoteException {
        CommKeyClassId targetCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.ISCSI_REMOTE_TARGET_ID);
        if (targetCommKeyClassId != null) {
            ISCSIRemoteTargetImpl targetImpl = (ISCSIRemoteTargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(targetCommKeyClassId);
            return targetImpl;
        }
        return null;
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.getIPAddress() + ":" + this.getPort();
        return changedValues;
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)this.getRemoteTarget();
        ced.addParameter(new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_ID, remoteTarget.getCommKeyClassId()));
        if (remoteTarget.isInDeletionProcess()) {
            ced.addParameter(new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_IN_DELETE_PROCESS, new SrBoolean(true)));
        }
        this.deleteElement(ced);
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().debug("Start Sync of remote target portal " + this.toString());
        if (this.isSynchronizePending()) {
            logger.debug("Already synchronizing " + this.getClassId() + " " + this.toString());
            return 1;
        }
        int retVal = 0;
        try {
            retVal = super.synchronize();
            LogMgr.getServerLog().debug("Sync of remote target portal " + this.toString() + " After Super completion status " + retVal);
            if (retVal != 3) {
                if (!this.isNeedToSynchronize()) {
                    this.setSynchronizePending(false);
                    return retVal;
                }
                LogMgr.getServerLog().debug("Sync of ISCSI remote target portal " + this.toString() + " SyncMe status " + retVal);
            }
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            this.setSynchronizePending(false);
            throw ive;
        }
        return retVal;
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (this.canBeSynchronized() != null) {
            return 2;
        }
        Vector vSwitchToSync = this.cluster.getOtherVSwitches(this.getVSwitches());
        VSwitch[] vswitch = new VSwitch[]{(VSwitch)vSwitchToSync.get(0)};
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)this.getRemoteTarget();
        remoteTarget.createISCSIRemoteTargetPortal(this.getIPAddress(), this.getPort().intValue(), this.getPortalGroupTag(), vswitch, null);
        return 2;
    }

    public boolean isSynchronizedBetweenVSwitches(VSwitch sourceVSwitch) throws RemoteException {
        boolean reply = true;
        VSwitch[] vswitches = this.getConnectedVSwitches();
        if (vswitches.length > 1) {
            VSwitch vswitch1 = sourceVSwitch;
            VSwitch vswitch2 = vswitches[0].equals(sourceVSwitch) ? vswitches[1] : vswitches[0];
            Integer groupTagVSwitch1 = this.getPortalGroupTag(vswitch1);
            Integer groupTagVSwitch2 = this.getPortalGroupTag(vswitch2);
            String ipVSwitch1 = this.getIPAddress(vswitch1);
            String ipVSwitch2 = this.getIPAddress(vswitch2);
            BigInteger portVSwitch1 = this.getPort(vswitch1);
            BigInteger portVSwitch2 = this.getPort(vswitch2);
            if (!(groupTagVSwitch1.equals(groupTagVSwitch2) && ipVSwitch1.equals(ipVSwitch2) && portVSwitch1.equals(portVSwitch2))) {
                reply = false;
            }
        }
        return reply;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    public AlarmGenerator getAlarmGenerator() {
        return ISCSIRemoteTargetPortalAlarmGenerator.getInstance();
    }

    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)this.getRemoteTarget();
        if (remoteTarget.isNeedToSynchronize()) {
            if (!remoteTarget.isSynchronizePending()) {
                StringBuffer msg = new StringBuffer("Remote Target portal ");
                msg.append(this.toString());
                msg.append(" cannot be synchronized. ");
                msg.append(remoteTarget.getClassId().toString());
                msg.append(" ");
                msg.append(remoteTarget.getName());
                msg.append("is not synchronized yet");
                throw new IllegalValueException(msg.toString());
            }
            String msg = "Remote Target " + remoteTarget.getName() + " is not synchronized.";
            return msg;
        }
        return null;
    }

    public Integer getPortalGroupTag() throws RemoteException {
        return this.getPortalGroupTag(null);
    }

    public Integer getPortalGroupTag(VSwitch vswitch) throws RemoteException {
        return (Integer)this.getValueOf(vswitch, ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG, vswitch == null);
    }

    public String getIPAddress() throws RemoteException {
        return this.getIPAddress(null);
    }

    public String getIPAddress(VSwitch vswitch) throws RemoteException {
        Inet4Address ipAddress = (Inet4Address)this.getValueOf(vswitch, ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, vswitch == null);
        if (ipAddress != null) {
            String ipAddressStr = ipAddress.toString();
            if (ipAddressStr.startsWith("/")) {
                ipAddressStr = ipAddressStr.substring(1);
            }
            return ipAddressStr;
        }
        return null;
    }

    public BigInteger getPort() throws RemoteException {
        return this.getPort(null);
    }

    public BigInteger getPort(VSwitch vswitch) throws RemoteException {
        return (BigInteger)this.getValueOf(vswitch, ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT, vswitch == null);
    }

    public String getAlias() throws RemoteException {
        return this.getAlias(null);
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public boolean isRedundant() throws RemoteException {
        return true;
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, this.getIPAddress());
        return parameterList;
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.ISCSI_REMOTE_TARGET_ID);
        parameterCodes.addElement(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP);
        parameterCodes.addElement(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT);
        parameterCodes.addElement(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

