/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.target.ISCSIRemoteTargetAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SitesSynchronizeable;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentials;
import com.sanrad.nms.server.logic.identity.CredentialsValidator;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.scsi.RemoteTargetImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortal;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortalImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortalValidator;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ISCSIRemoteTargetImpl
extends RemoteTargetImpl
implements ISCSIRemoteTarget,
SitesSynchronizeable {
    private static final int PORTAL_AND_TAG_EXISTED = 1;
    private static final int PORTAL_ADDRESS_AND_PORT_ONLY_EXISTED = 0;
    private static final int PORTAL_NOT_EXISTED = -1;
    private ArrayList m_iscsiSessions = new ArrayList();
    private ArrayList m_portals = new ArrayList();
    private CHAPCredentials m_chapCredentials;
    private ArrayList m_pendingCreatedRemotePortals = new ArrayList();

    public ISCSIRemoteTargetImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.ISCSI_REMOTE_TARGET);
        this.addParameterCode(ParameterCode.SCSI_INITIATOR_ID);
        this.addParameterCode(ParameterCode.IDENTITY_ID);
        this.addParameterCode(ParameterCode.ISCSI_REMOTE_TARGET_NUM_OF_PORTALS);
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap paramList = super.getClientParameterList();
        paramList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_NUM_OF_PORTALS, this.getNumberOfPortals());
        return paramList;
    }

    public void changeElement(HashMap parameterList) throws RemoteException, IllegalValueException {
        Object chapUserName = parameterList.get(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME);
        Object chapPassword = parameterList.get(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD);
        boolean valuesChanged = false;
        HashMap map = new HashMap();
        if (chapUserName != null) {
            valuesChanged = true;
            map.put(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME, chapUserName);
        }
        if (chapPassword != null) {
            valuesChanged = true;
            map.put(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD, chapPassword);
        }
        if (this.m_chapCredentials != null && valuesChanged) {
            this.m_chapCredentials.changeElement(map);
        } else {
            logger.warning("CHAP Credentials of " + this.getClassId() + " " + this + " at cluster " + this.getCluster() + " is null - change cannot be made");
        }
        super.changeElement(parameterList);
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String result = super.isValid(parameterList);
        if (result == null) {
            String userName = (String)parameterList.get(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME);
            String password = (String)parameterList.get(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD);
            Identity chapCredParentIdentity = null;
            if (this.m_chapCredentials != null) {
                chapCredParentIdentity = this.m_chapCredentials.getIdentityParent();
            }
            CredentialsValidator chapCredValidator = new CredentialsValidator(chapCredParentIdentity, ClassID.CHAP_CREDENTIALS, userName, password, false);
            if (userName != null) {
                result = chapCredValidator.isUserNameValid(userName);
                if (result != null) {
                    return result;
                }
                parameterList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME, new SrString(userName));
            }
            if (password != null) {
                result = chapCredValidator.isPasswordValid(userName);
                if (result != null) {
                    return result;
                }
                parameterList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD, new SrString(password));
            }
        }
        return result;
    }

    public void clear() throws RemoteException {
        this.clearAllSessions();
        this.clearAllPortals();
        this.clearAllPendingCreatingRemotePortals();
        this.setCHAPCredentials(null);
        super.clear();
    }

    protected String canBeDeleted() throws RemoteException {
        String prefixMsg = "You cannot delete the remote target " + this.getName();
        if (this.isConnected()) {
            return prefixMsg + " because it is not disconnected.";
        }
        if (!this.isConfigured().booleanValue()) {
            return prefixMsg + " because it is not configured.";
        }
        if (this.areVolumesConnected()) {
            return prefixMsg + " because it has volumes connected.";
        }
        return null;
    }

    public void siteSynchronizationDelete() throws RemoteException, IllegalValueException {
        if (!this.areVolumesConnected()) {
            ConfigElementData ced = new ConfigElementData(this.getCommKeyClassId());
            this.deleteElement(ced);
        }
    }

    public AlarmGenerator getAlarmGenerator() {
        return ISCSIRemoteTargetAlarmGenerator.getInstance();
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().info("syncDataWasChanged called  " + this.toString());
        if (!this.isSynchronizePending()) {
            return;
        }
        try {
            if (this.isNeedToSynchronize()) {
                this.synchronizeMe();
                return;
            }
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            this.errorInSynchronizing();
            return;
        }
        this.doneSynchronizing();
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().debug("Start Sync of remote target " + this.getName());
        if (this.isSynchronizePending()) {
            logger.debug("Already synchronizing " + this.getClassId() + " " + this.toString());
            return 1;
        }
        int retVal = 0;
        try {
            retVal = super.synchronize();
            LogMgr.getServerLog().debug("Sync of remote target " + this.getName() + " After Super completion status " + retVal);
            if (retVal != 3) {
                switch (retVal) {
                    case 3: {
                        this.setSynchronizePending(false);
                        break;
                    }
                    case 1: {
                        retVal = 2;
                    }
                }
            }
            if (!this.isNeedToSynchronize()) {
                retVal = this.synchronizePortals();
            }
            if (!this.isNeedToSynchronize()) {
                this.setSynchronizePending(false);
                return retVal;
            }
            LogMgr.getServerLog().debug("Sync of ISCSI remote target " + this.getName() + " SyncMe status " + retVal);
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            this.setSynchronizePending(false);
            throw ive;
        }
        return retVal;
    }

    private int synchronizePortals() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().debug("Start Sync portals of remote target " + this.getName());
        int retVal = 0;
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        for (int index = 0; index < this.m_portals.size(); ++index) {
            try {
                ISCSIRemoteTargetPortalImpl portal = (ISCSIRemoteTargetPortalImpl)this.m_portals.get(index);
                int portalRetVal = portal.synchronize();
                LogMgr.getServerLog().debug("Sync of remote target " + this.getName() + " Portal " + portal.toString() + " status " + portalRetVal);
                if (portalRetVal <= retVal) continue;
                retVal = portalRetVal;
                continue;
            }
            catch (IllegalValueException ive) {
                logger.warning(ive.getMessage());
                errMsg.append(" \n");
                errMsg.append(ive.getMessage());
                errOccured = true;
            }
        }
        if (errOccured) {
            this.setSynchronizePending(false);
            throw new IllegalValueException(errMsg.toString());
        }
        return retVal;
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (this.canBeSynchronized() != null) {
            return 2;
        }
        if (super.isNeedToSynchronize()) {
            int retVal = this.createMeOnOtherVswitch();
            switch (retVal) {
                case 1: 
                case 2: {
                    retVal = 2;
                    break;
                }
                case 3: {
                    this.setSynchronizePending(false);
                }
            }
            return retVal;
        }
        return 0;
    }

    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        Vector vSwitchToSync = this.cluster.getOtherVSwitches(this.getVSwitches());
        VSwitch[] vswitch = new VSwitch[]{(VSwitch)vSwitchToSync.get(0)};
        Identity myIdentity = this.getIdentity();
        String chapUserName = this.m_chapCredentials != null ? this.m_chapCredentials.getUserName() : null;
        storage.createISCSIRemoteTarget(this.getName(), this.getAlias(), myIdentity.getAlias(), chapUserName, "", this.getPortalsIPs(), this.getPortalsPorts(), this.getPortalsGroupTags(), false, vswitch);
        return 2;
    }

    public ISCSIInitiator[] getAllConnectedInitiators() throws RemoteException {
        ArrayList<ISCSIInitiator> initiators = new ArrayList<ISCSIInitiator>();
        VSwitch[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            ISCSIInitiator initiator = this.getInitiator(connectedVswitches[index]);
            initiators.add(initiator);
        }
        ISCSIInitiator[] array = new ISCSIInitiator[initiators.size()];
        return initiators.toArray(array);
    }

    public ISCSIInitiator getInitiator(VSwitch vswitch) throws RemoteException {
        CommKeyClassId scsiInitiatorParentKey = (CommKeyClassId)this.getSrValueOf(vswitch, ParameterCode.SCSI_INITIATOR_ID, false);
        CommKeyClassId iscsiInitiatorParentKey = this.cluster.getISCSIId(scsiInitiatorParentKey);
        ISCSIInitiator initiatorImpl = (ISCSIInitiator)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(iscsiInitiatorParentKey);
        return initiatorImpl;
    }

    public Identity getIdentity() throws RemoteException {
        CommKeyClassId targetIdentity = (CommKeyClassId)this.getSrValueOf(ParameterCode.IDENTITY_ID);
        Identity identity = (Identity)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(targetIdentity);
        return identity;
    }

    public String toString() {
        try {
            return this.getAlias();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public BigInteger getNumberOfPortals() throws RemoteException {
        return new BigInteger(String.valueOf(this.m_portals.size()));
    }

    public String getCHAPUserName() throws RemoteException {
        return this.m_chapCredentials == null ? null : this.m_chapCredentials.getUserName();
    }

    public ISCSISession[] getISCSISessions() throws RemoteException {
        ISCSISession[] array = new ISCSISession[this.m_iscsiSessions.size()];
        return this.m_iscsiSessions.toArray(array);
    }

    public ISCSIRemoteTargetPortal[] getISCSIPortals() throws RemoteException {
        ISCSIRemoteTargetPortal[] array = new ISCSIRemoteTargetPortal[this.m_portals.size()];
        return this.m_portals.toArray(array);
    }

    public void createISCSIRemoteTargetPortal(String ip, int port, int portalGroupTag) throws RemoteException, IllegalValueException {
        this.createISCSIRemoteTargetPortal(ip, port, portalGroupTag, null);
    }

    public void createISCSIRemoteTargetPortal(String ip, int port, int portalGroupTag, CommKeyClassId remotePortalIdToRemoveIfNeeded) throws RemoteException, IllegalValueException {
        VSwitch[] connectedVSwitches = this.getConnectedVSwitches();
        this.createISCSIRemoteTargetPortal(ip, port, portalGroupTag, connectedVSwitches, remotePortalIdToRemoveIfNeeded);
    }

    public synchronized void createISCSIRemoteTargetPortal(String ip, int port, int portalGroupTag, VSwitch[] vSwitches, CommKeyClassId remotePortalIdToRemoveIfNeeded) throws RemoteException, IllegalValueException {
        for (int index = 0; index < vSwitches.length; ++index) {
            VSwitch currentVSwitch = vSwitches[index];
            boolean isRemotePortalCreatedOnPending = this.isRemotePortalCreatedOnPending(ip, port, currentVSwitch.getCommKeyClassId());
            if (isRemotePortalCreatedOnPending) continue;
            this.addPendingCreatedRemotePortal(ip, port, currentVSwitch.getCommKeyClassId());
            ConfigElementData element = this.createElementISCSIRemoteTargetPortal(ip, port, portalGroupTag, currentVSwitch, remotePortalIdToRemoveIfNeeded);
            ((ClusterImpl)this.getCluster()).createElement(element, ClassID.ISCSI_REMOTE_TARGET_PORTAL, ip + " : " + String.valueOf(port));
        }
    }

    public ConfigElementDataList createElementISCSIRemoteTargetPortal(String ip, int port, int portalGroupTag, CommKeyClassId remotePortalIdToRemoveIfNeeded) throws RemoteException, IllegalValueException {
        VSwitch[] connectedVSwitches = this.getConnectedVSwitches();
        ConfigElementDataList elements = new ConfigElementDataList();
        for (int index = 0; index < connectedVSwitches.length; ++index) {
            elements.add(this.createElementISCSIRemoteTargetPortal(ip, port, portalGroupTag, connectedVSwitches[index], remotePortalIdToRemoveIfNeeded));
        }
        return elements;
    }

    public ConfigElementData createElementISCSIRemoteTargetPortal(String ip, int port, int portalGroupTag, VSwitch vSwitch, CommKeyClassId remotePortalIdToRemoveIfNeeded) throws RemoteException, IllegalValueException {
        String[] ips = new String[1];
        BigInteger[] ports = new BigInteger[1];
        Integer[] groupTag = new Integer[1];
        ips[0] = ip;
        ports[0] = new BigInteger(String.valueOf(port));
        groupTag[0] = new Integer(portalGroupTag);
        ISCSIRemoteTargetPortalValidator validator = new ISCSIRemoteTargetPortalValidator(this, ips, ports, groupTag, vSwitch);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.ISCSI_REMOTE_TARGET_PORTAL);
        SrType[] vSwitchestoSet = new CommKeyClassId[]{vSwitch.getCommKeyClassId()};
        element.setValues(ParameterCode.VSWITCH_ID, vSwitchestoSet);
        element.setValue(ParameterCode.ISCSI_REMOTE_TARGET_ID, this.getCommKeyClassId());
        element.setValue(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, new SrIpAddress(ip));
        element.setValue(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT, new SrGauge(port));
        element.setValue(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG, new SrInteger(portalGroupTag));
        if (remotePortalIdToRemoveIfNeeded != null) {
            element.setValue(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_ID, remotePortalIdToRemoveIfNeeded);
        }
        return element;
    }

    private boolean hasPortals() {
        return this.m_portals.size() > 0;
    }

    private boolean areVolumesConnected() throws RemoteException {
        return ((StorageImpl)((ClusterImpl)this.getCluster()).getStorage()).areVolumesConnectedToRemoteTarget(this.getName());
    }

    public void addSession(ISCSISession session) {
        this.m_iscsiSessions.add(session);
    }

    public void removeSession(ISCSISession session) {
        this.m_iscsiSessions.remove(session);
    }

    public void clearAllSessions() {
        this.m_iscsiSessions.clear();
    }

    public void addPortal(ISCSIRemoteTargetPortal portal) throws RemoteException {
        this.m_portals.add(portal);
    }

    public void removePortal(ISCSIRemoteTargetPortal portal) throws RemoteException {
        this.m_portals.remove(portal);
        try {
            if (this.isInDeletionProcess() && this.hasPortals()) {
                ISCSIRemoteTargetPortal nextPortalToDelete = (ISCSIRemoteTargetPortal)this.m_portals.get(0);
                nextPortalToDelete.deleteElement();
                return;
            }
            if (this.isInDeletionProcess()) {
                ConfigElementData ced = new ConfigElementData(this.getCommKeyClassId());
                this.deleteElement(ced);
            }
        }
        catch (IllegalValueException ive) {
            logger.warning(ive);
        }
    }

    public void clearAllPortals() {
        this.m_portals.clear();
    }

    public int isPortalExisted(String ip, int port, int groupTag, VSwitch vswitch) throws RemoteException {
        for (int index = 0; index < this.m_portals.size(); ++index) {
            ISCSIRemoteTargetPortalImpl portal = (ISCSIRemoteTargetPortalImpl)this.m_portals.get(index);
            Vector remotePortalConnectedVSwitches = portal.getConnectedVSwitchesAsVector();
            if (!(vswitch == null || remotePortalConnectedVSwitches != null && remotePortalConnectedVSwitches.size() != 0 && remotePortalConnectedVSwitches.contains(vswitch))) {
                return -1;
            }
            String existedIP = portal.getIPAddress(vswitch);
            BigInteger existedPort = portal.getPort(vswitch);
            Integer existedTag = portal.getPortalGroupTag(vswitch);
            if (existedIP == null || !existedIP.equals(ip) || existedPort == null || existedPort.intValue() != port) continue;
            if (existedTag != null && existedTag == groupTag) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public ISCSIRemoteTargetPortal getPortalTableRow(String ip, int port, int groupTag) throws RemoteException {
        for (int index = 0; index < this.m_portals.size(); ++index) {
            ISCSIRemoteTargetPortal portal = (ISCSIRemoteTargetPortal)this.m_portals.get(index);
            if (!portal.getIPAddress().equals(ip) || portal.getPort().intValue() != port || portal.getPortalGroupTag() != groupTag) continue;
            return portal;
        }
        return null;
    }

    private String[] getPortalsIPs() {
        String[] ips = new String[this.m_portals.size()];
        try {
            for (int index = 0; index < this.m_portals.size(); ++index) {
                ISCSIRemoteTargetPortal portal = (ISCSIRemoteTargetPortal)this.m_portals.get(index);
                ips[index] = ((ISCSIRemoteTargetPortalImpl)portal).getIPAddress();
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return ips;
    }

    private BigInteger[] getPortalsPorts() {
        BigInteger[] ports = new BigInteger[this.m_portals.size()];
        try {
            for (int index = 0; index < this.m_portals.size(); ++index) {
                ISCSIRemoteTargetPortal portal = (ISCSIRemoteTargetPortal)this.m_portals.get(index);
                ports[index] = ((ISCSIRemoteTargetPortalImpl)portal).getPort();
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return ports;
    }

    private Integer[] getPortalsGroupTags() {
        Integer[] groupTags = new Integer[this.m_portals.size()];
        try {
            for (int index = 0; index < this.m_portals.size(); ++index) {
                ISCSIRemoteTargetPortal portal = (ISCSIRemoteTargetPortal)this.m_portals.get(index);
                groupTags[index] = ((ISCSIRemoteTargetPortalImpl)portal).getPortalGroupTag();
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return groupTags;
    }

    private void addPendingCreatedRemotePortal(String ip, int port, CommKeyClassId vSwitchId) {
        PendingCreatedRemotePortal p = new PendingCreatedRemotePortal(ip, port, vSwitchId);
        this.m_pendingCreatedRemotePortals.add(p);
    }

    public void removePendingCreatedRemotePortalIfNeeded(ISCSIRemoteTargetPortal remotePortal, CommKeyClassId vSwitchId) throws RemoteException {
        for (int index = 0; index < this.m_pendingCreatedRemotePortals.size(); ++index) {
            boolean ret;
            PendingCreatedRemotePortal p = (PendingCreatedRemotePortal)this.m_pendingCreatedRemotePortals.get(index);
            if (!p.isEquivalent(remotePortal.getIPAddress(), remotePortal.getPort().intValue(), vSwitchId) || (ret = this.m_pendingCreatedRemotePortals.remove(p))) continue;
            logger.warning("Couldn't remove pending created remote portal: " + p);
        }
    }

    private boolean isRemotePortalCreatedOnPending(String ip, int port, CommKeyClassId vSwitchId) {
        for (int index = 0; index < this.m_pendingCreatedRemotePortals.size(); ++index) {
            PendingCreatedRemotePortal p = (PendingCreatedRemotePortal)this.m_pendingCreatedRemotePortals.get(index);
            if (!p.isEquivalent(ip, port, vSwitchId)) continue;
            return true;
        }
        return false;
    }

    private void clearAllPendingCreatingRemotePortals() {
        this.m_pendingCreatedRemotePortals.clear();
    }

    public void setCHAPCredentials(CHAPCredentials credentials) {
        this.m_chapCredentials = credentials;
    }

    public CHAPCredentials getCHAPCredentials() {
        return this.m_chapCredentials;
    }

    public boolean anyPortalsDefined() throws RemoteException {
        return this.m_portals.size() > 0;
    }

    public boolean anyPortalsDefined(VSwitch vSwitch) throws RemoteException {
        for (int index = 0; index < this.m_portals.size(); ++index) {
            ISCSIRemoteTargetPortalImpl portal = (ISCSIRemoteTargetPortalImpl)this.m_portals.get(index);
            if (!portal.isKnownByVSwitch(vSwitch)) continue;
            return true;
        }
        return false;
    }

    public void synchronizeDiscoveryElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
    }

    public void synchronizeNewElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
    }

    public void synchronizeNewElementOnRemoteCluster(Cluster remoteCluster, VSwitch[] createOnVSwiches) throws RemoteException {
        ArrayList<Cluster> clustersInOtherSites = new ArrayList<Cluster>(1);
        clustersInOtherSites.add(remoteCluster);
        try {
            ISCSITarget equivalentLocalTarget = ((ClusterImpl)this.getCluster()).findEquivLocalTargetOfRemoteTargetInRemoteClusters(clustersInOtherSites, this.getName());
            if (equivalentLocalTarget != null) {
                VSwitch vswitch = ((ISCSITargetImpl)equivalentLocalTarget).getExposedOnVSwitchObject();
                ArrayList localTargetPortals = ((ClusterImpl)remoteCluster).getAllTargetPortals(vswitch);
                this.createAllLocalPortalsInRemoteCluster(localTargetPortals, createOnVSwiches);
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    public void synchronizeChangeElementOnRemoteCluster(Cluster remoteCluster, HashMap changedValues) throws RemoteException {
    }

    public void synchronizePreRemoveElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
    }

    public void synchronizePostRemoveElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
    }

    public synchronized void createLocalPortalInRemoteCluster(PortalTableRowImpl portal, VSwitch[] createOnVSwitches) throws RemoteException {
        try {
            String ip = portal.getIPAddress();
            int port = portal.getPort();
            int tag = portal.getTag();
            if (createOnVSwitches != null) {
                boolean createOnVSwicth = false;
                for (int index1 = 0; index1 < createOnVSwitches.length; ++index1) {
                    VSwitch onVSwitch = createOnVSwitches[index1];
                    VSwitch[] createOnVSwitch = new VSwitch[]{onVSwitch};
                    int existed = this.isPortalExisted(ip, port, tag, onVSwitch);
                    if (existed == -1) {
                        this.createISCSIRemoteTargetPortal(ip, port, tag, createOnVSwitch, null);
                        continue;
                    }
                    if (existed != 0) continue;
                    ISCSIRemoteTargetPortalImpl remotePortal = this.getExistedRemotePortal(ip, port, false, tag, null);
                    this.createISCSIRemoteTargetPortal(ip, port, tag, createOnVSwitch, remotePortal.getCommKeyClassId());
                }
            }
        }
        catch (IllegalValueException illegalValueException) {
            // empty catch block
        }
    }

    public synchronized void createAllLocalPortalsInRemoteCluster(ArrayList localPortalsToCreate, VSwitch[] createOnVSwitches) throws RemoteException {
        for (int index0 = 0; index0 < localPortalsToCreate.size(); ++index0) {
            PortalTableRowImpl portal = (PortalTableRowImpl)localPortalsToCreate.get(index0);
            this.createLocalPortalInRemoteCluster(portal, createOnVSwitches);
        }
    }

    protected void deleteElement(ConfigElementData ced) throws RemoteException, IllegalValueException {
        if (!this.isInDeletionProcess()) {
            String msg = this.canBeDeleted();
            if (msg != null) {
                logger.debug(msg);
                throw new IllegalValueException(msg);
            }
            this.setInDeletionProcess();
        }
        if (this.hasPortals()) {
            ISCSIRemoteTargetPortal portal = (ISCSIRemoteTargetPortal)this.m_portals.get(0);
            portal.deleteElement();
            return;
        }
        this.clearInDeletionProcess();
        this.deleteElementFromDataMgr(ced);
    }

    public ISCSIRemoteTargetPortalImpl getExistedRemotePortal(String ip, int port, boolean checkGroupTag, int groupTag, VSwitch vswitch) throws RemoteException {
        for (int index = 0; index < this.m_portals.size(); ++index) {
            ISCSIRemoteTargetPortalImpl portal = (ISCSIRemoteTargetPortalImpl)this.m_portals.get(index);
            String existedIP = portal.getIPAddress(vswitch);
            BigInteger existedPort = portal.getPort(vswitch);
            Integer existedTag = portal.getPortalGroupTag(vswitch);
            if (existedIP == null || !existedIP.equals(ip) || existedPort == null || existedPort.intValue() != port) continue;
            if (checkGroupTag) {
                if (existedTag == null || existedTag != groupTag) continue;
                return portal;
            }
            return portal;
        }
        return null;
    }

    public ISCSITarget getConfiguredAsLocalTargetOnSameCluster() throws RemoteException {
        ClusterImpl cluster = (ClusterImpl)this.getCluster();
        ISCSITarget target = (ISCSITarget)((StorageImpl)cluster.getStorage()).getTargetListMgr().getTargetByName(this.getName());
        return target;
    }

    public class PendingCreatedRemotePortal {
        private String m_ip;
        private int m_port;
        private CommKeyClassId m_vSwitchId;

        public PendingCreatedRemotePortal(String ip, int port, CommKeyClassId vSwitchId) {
            this.m_ip = ip;
            this.m_port = port;
            this.m_vSwitchId = vSwitchId;
        }

        public boolean isEquivalent(String ip, int port, CommKeyClassId vSwitchId) {
            return ip.equals(this.m_ip) && port == this.m_port && vSwitchId.equals(this.m_vSwitchId);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.m_ip);
            sb.append(":");
            sb.append(this.m_port);
            sb.append(" on ");
            sb.append(this.m_vSwitchId.getClassID());
            sb.append(" ");
            sb.append(this.m_vSwitchId);
            return super.toString();
        }
    }
}

