/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.target;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.constants.ISCSIRemotePortalDiscoveryFailureTypeConstant;
import com.sanrad.nms.server.util.types.constants.ISCSIRemotePortalDiscoveryStateConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ISCSIRemotePortalDiscoveryImpl
extends SynchronizeableImpl
implements ISCSIRemotePortalDiscovery {
    private static final String IDLE = "Idle";
    private static final String DISCOVERING = "Discovering";
    private static final String COMPLETED = "Completed";
    private static final String FAILED = "Failed";
    private static final String ALL = "all";
    private static List parameterCodeList;
    private String m_clusterDisplayedState;
    private HashMap m_vswitchDisplayedStates = new HashMap();
    private boolean m_isOnInitProcess = false;

    public ISCSIRemotePortalDiscoveryImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL, parameterCodeList);
    }

    public void setOnInitProcess(boolean flag) {
        this.m_isOnInitProcess = flag;
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_CLUSTER_STATE, this.getClusterDisplayedState());
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_STATE, this.getVSwitchDisplayedState());
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_LAST_FAILURE, this.getLastFailureType());
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_LAST_SUCCESSFUL_DISCOVERY, this.getLastSuccessfulDiscovery());
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_NEXT_PLANNED_DISCOVERY, this.getNextPlannedDiscovery());
        return parameterList;
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        VSwitch vSwitch = this.getVSwitch(parameterList);
        HashMap changedValues = super.setParameterList(parameterList);
        if (changedValues.containsKey(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE)) {
            changedValues.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE, this.getLastFailureType());
        }
        if (changedValues.containsKey(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME)) {
            changedValues.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME, this.getLastSuccessfulDiscovery());
        }
        if (changedValues.containsKey(ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY)) {
            changedValues.put(ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY, this.getNextPlannedDiscovery());
        }
        this.toStringValue = this.getIPAddress() + ":" + this.getPort();
        this.setDisplayedState(vSwitch, changedValues);
        return changedValues;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().debug("Start Sync of remote discovery portal " + this.toString());
        int retVal = 0;
        try {
            retVal = super.synchronize();
            LogMgr.getServerLog().debug("Sync of remote discovery portal " + this.toString() + " After Super completion status " + retVal);
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            this.setSynchronizePending(false);
            throw ive;
        }
        return retVal;
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (this.canBeSynchronized() != null) {
            return 2;
        }
        VSwitch otherVSwitchInCluster = ((ClusterImpl)this.getCluster()).getOtherVSwitch(this.getActiveVswitch());
        ISCSIInitiatorImpl iscsiInitiator = (ISCSIInitiatorImpl)otherVSwitchInCluster.getISCSIInitiators()[0];
        iscsiInitiator.createRemoteDiscoveryPortal(this.getIPAddress(), this.getPort(), this.getPeriod());
        return 2;
    }

    public boolean isSynchronizedBetweenVSwitches(VSwitch sourceVSwitch) throws RemoteException {
        boolean reply = true;
        VSwitch[] vswitches = this.getConnectedVSwitches();
        if (vswitches.length > 1) {
            VSwitch vswitch1 = sourceVSwitch;
            VSwitch vswitch2 = vswitches[0].equals(sourceVSwitch) ? vswitches[1] : vswitches[0];
            String ipVSwitch1 = this.getIPAddress(vswitch1);
            String ipVSwitch2 = this.getIPAddress(vswitch2);
            Integer portVSwitch1 = this.getPort(vswitch1);
            Integer portVSwitch2 = this.getPort(vswitch2);
            if (!ipVSwitch1.equals(ipVSwitch2) || !portVSwitch1.equals(portVSwitch2)) {
                reply = false;
            }
        }
        return reply;
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    public ISCSIInitiator[] getAllConnectedInitiators() throws RemoteException {
        ArrayList<ISCSIInitiator> initiators = new ArrayList<ISCSIInitiator>();
        VSwitch[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            ISCSIInitiator initiator = this.getInitiator(connectedVswitches[index]);
            initiators.add(initiator);
        }
        ISCSIInitiator[] array = new ISCSIInitiator[initiators.size()];
        return initiators.toArray(array);
    }

    public ISCSIInitiator getInitiator(VSwitch vswitch) throws RemoteException {
        ISCSIInitiator[] initiators = vswitch.getISCSIInitiators();
        return initiators[0];
    }

    public String getIPAddress() throws RemoteException {
        return this.getIPAddress(null);
    }

    public String getIPAddress(VSwitch vswitch) throws RemoteException {
        SrIpAddress ipAddress = (SrIpAddress)this.getSrValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_ADDRESS, vswitch == null);
        String ipAddressStr = ipAddress.toString();
        if (ipAddressStr.startsWith("/")) {
            ipAddressStr = ipAddressStr.substring(1);
        }
        return ipAddressStr;
    }

    public Integer getPort() throws RemoteException {
        return this.getPort(null);
    }

    public Integer getPort(VSwitch vswitch) throws RemoteException {
        return (Integer)this.getValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_PORT, vswitch == null);
    }

    private void setDisplayedState(VSwitch changedOnVSwitch, HashMap changedValues) throws RemoteException {
        Long lastSuccessfulDiscoveryOnVSwitch;
        Date newDate;
        String newDateStr;
        HashMap lastSuccessfulDiscovery;
        ISCSIRemotePortalDiscoveryFailureTypeConstant failureTypeOnVSwitch;
        HashMap failureType;
        ISCSIRemotePortalDiscoveryStateConstant state;
        if (this.m_isOnInitProcess) {
            state = this.getState(changedOnVSwitch);
            this.m_clusterDisplayedState = state.toString();
            this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), state.toString());
        }
        if ((state = (ISCSIRemotePortalDiscoveryStateConstant)changedValues.get(ParameterCode.REMOTE_PORTAL_DISC_STATE)) != null && state.equals(ISCSIRemotePortalDiscoveryStateConstant.DISCOVERING)) {
            if (this.getConnectedVSwitches().length == 1) {
                this.m_clusterDisplayedState = state.toString();
                this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), state.toString());
            } else {
                StringBuffer sb;
                if (this.m_clusterDisplayedState.indexOf(DISCOVERING) > -1 && this.m_clusterDisplayedState.indexOf(ClassID.VSWITCH.toString()) > -1) {
                    sb = new StringBuffer();
                    sb.append(DISCOVERING);
                    sb.append(" [on ");
                    sb.append(ALL);
                    sb.append(" ");
                    sb.append(ClassID.VSWITCH.toString());
                    sb.append("es]");
                    this.m_clusterDisplayedState = sb.toString();
                } else {
                    sb = new StringBuffer();
                    sb.append(DISCOVERING);
                    sb.append(" [on ");
                    sb.append(ClassID.VSWITCH.toString());
                    sb.append(" ");
                    sb.append(changedOnVSwitch.getName());
                    sb.append("]");
                    this.m_clusterDisplayedState = sb.toString();
                }
                this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), state.toString());
            }
        }
        if ((failureType = (HashMap)changedValues.get(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE)) != null && !(failureTypeOnVSwitch = (ISCSIRemotePortalDiscoveryFailureTypeConstant)failureType.get(changedOnVSwitch.getName())).isNoFailure()) {
            StringBuffer sb;
            if (this.getConnectedVSwitches().length == 1) {
                sb = new StringBuffer();
                sb.append(FAILED);
                sb.append(". Failure type: ");
                sb.append(failureTypeOnVSwitch.toString());
                this.m_clusterDisplayedState = sb.toString();
                this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), sb.toString());
            } else {
                if ((this.m_clusterDisplayedState.indexOf(DISCOVERING) > -1 || this.m_clusterDisplayedState.indexOf(COMPLETED) > -1) && this.m_clusterDisplayedState.indexOf(ALL) > -1) {
                    sb = new StringBuffer();
                    sb.append(DISCOVERING);
                    sb.append(" [on ");
                    sb.append(ClassID.VSWITCH.toString());
                    sb.append(" ");
                    sb.append(changedOnVSwitch.getName());
                    sb.append("]");
                    this.m_clusterDisplayedState = sb.toString();
                } else if (this.m_clusterDisplayedState.indexOf(DISCOVERING) > -1 || this.m_clusterDisplayedState.indexOf(FAILED) > -1 && this.m_clusterDisplayedState.indexOf(changedOnVSwitch.getName()) == -1) {
                    sb = new StringBuffer();
                    sb.append(FAILED);
                    sb.append(" [on ");
                    sb.append(ALL);
                    sb.append(" ");
                    sb.append(ClassID.VSWITCH.toString());
                    sb.append("es]");
                    this.m_clusterDisplayedState = sb.toString();
                }
                sb = new StringBuffer();
                sb.append(FAILED);
                sb.append(". Failure type: ");
                sb.append(failureTypeOnVSwitch.toString());
                this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), sb.toString());
            }
        }
        if ((lastSuccessfulDiscovery = (HashMap)changedValues.get(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME)) != null && (newDateStr = this.convertToDisplayedSuccessfulTime(newDate = new Date(lastSuccessfulDiscoveryOnVSwitch = (Long)lastSuccessfulDiscovery.get(changedOnVSwitch.getName())))) != null && newDateStr != "N/A") {
            if (this.getConnectedVSwitches().length == 1) {
                StringBuffer sb = new StringBuffer();
                sb.append(COMPLETED);
                sb.append(" at ");
                sb.append(newDate.toString());
                this.m_clusterDisplayedState = sb.toString();
                this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), sb.toString());
            } else {
                StringBuffer sb;
                if (this.m_clusterDisplayedState.indexOf(IDLE) > -1 || this.m_clusterDisplayedState.indexOf(DISCOVERING) > -1 || this.m_clusterDisplayedState.indexOf(FAILED) > -1) {
                    sb = new StringBuffer();
                    sb.append(COMPLETED);
                    sb.append(" [on ");
                    sb.append(ClassID.VSWITCH.toString());
                    sb.append(" ");
                    sb.append(changedOnVSwitch.getName());
                    sb.append("]");
                    this.m_clusterDisplayedState = sb.toString();
                } else if (this.m_clusterDisplayedState.indexOf(COMPLETED) > -1) {
                    sb = new StringBuffer();
                    sb.append(COMPLETED);
                    sb.append(" [on ");
                    sb.append(ALL);
                    sb.append(" ");
                    sb.append(ClassID.VSWITCH.toString());
                    sb.append("es]");
                    this.m_clusterDisplayedState = sb.toString();
                }
                sb = new StringBuffer();
                sb.append(COMPLETED);
                sb.append(" at ");
                sb.append(newDate.toString());
                this.m_vswitchDisplayedStates.put(changedOnVSwitch.getName(), sb.toString());
            }
        }
    }

    private String convertToDisplayedSuccessfulTime(Date time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        if (hour == 0 && min == 0 && sec == 0) {
            return "N/A";
        }
        return time.toString();
    }

    public String getClusterDisplayedState() throws RemoteException {
        return this.m_clusterDisplayedState;
    }

    public String getVSwitchDisplayedState(VSwitch vswitch) throws RemoteException {
        return (String)this.m_vswitchDisplayedStates.get(vswitch.getName());
    }

    public HashMap getVSwitchDisplayedState() throws RemoteException {
        return this.m_vswitchDisplayedStates;
    }

    public HashMap getState() throws RemoteException {
        HashMap<String, ISCSIRemotePortalDiscoveryStateConstant> states = new HashMap<String, ISCSIRemotePortalDiscoveryStateConstant>();
        VSwitch[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitch vswitch = connectedVswitches[index];
            ISCSIRemotePortalDiscoveryStateConstant state = this.getState(vswitch);
            states.put(vswitch.getName(), state);
        }
        return states;
    }

    public ISCSIRemotePortalDiscoveryStateConstant getState(VSwitch vswitch) throws RemoteException {
        return (ISCSIRemotePortalDiscoveryStateConstant)this.getSrValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_STATE, vswitch == null);
    }

    public Integer getPeriod() throws RemoteException {
        return this.getPeriod(null);
    }

    public Integer getPeriod(VSwitch vswitch) throws RemoteException {
        return (Integer)this.getValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_PERIOD, vswitch == null);
    }

    public HashMap getLastFailureType() throws RemoteException {
        HashMap<String, ISCSIRemotePortalDiscoveryFailureTypeConstant> types = new HashMap<String, ISCSIRemotePortalDiscoveryFailureTypeConstant>();
        VSwitch[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitch vswitch = connectedVswitches[index];
            ISCSIRemotePortalDiscoveryFailureTypeConstant type = this.getLastFailureType(vswitch);
            types.put(vswitch.getName(), type);
        }
        return types;
    }

    public ISCSIRemotePortalDiscoveryFailureTypeConstant getLastFailureType(VSwitch vswitch) throws RemoteException {
        return (ISCSIRemotePortalDiscoveryFailureTypeConstant)this.getSrValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE, vswitch == null);
    }

    public HashMap getLastSuccessfulDiscovery() throws RemoteException {
        HashMap<String, Long> times = new HashMap<String, Long>();
        VSwitch[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitch vswitch = connectedVswitches[index];
            Long time = this.getLastSuccessfulDiscovery(vswitch);
            times.put(vswitch.getName(), time);
        }
        return times;
    }

    public Long getLastSuccessfulDiscovery(VSwitch vswitch) throws RemoteException {
        return (Long)this.getValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME, vswitch == null);
    }

    public HashMap getNextPlannedDiscovery() throws RemoteException {
        HashMap<String, BigInteger> times = new HashMap<String, BigInteger>();
        VSwitch[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitch vswitch = connectedVswitches[index];
            BigInteger time = this.getNextPlannedDiscovery(vswitch);
            times.put(vswitch.getName(), time);
        }
        return times;
    }

    public BigInteger getNextPlannedDiscovery(VSwitch vswitch) throws RemoteException {
        return (BigInteger)this.getValueOf(vswitch, ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY, vswitch == null);
    }

    public String getAlias() throws RemoteException {
        return this.getAlias(null);
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public boolean isEqual(String ip, int port) throws RemoteException {
        return this.getIPAddress().equals(ip) && this.getPort() == port;
    }

    protected void setVswitchesToPerformOperation(ConfigElementData element, HashMap parameterList) throws RemoteException, IllegalValueException {
        CommKeyClassId[] vswitches = this.getConnectedVswitchesData();
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vswitches));
    }

    public void discoverRemoteTargets() throws RemoteException, IllegalValueException {
        this.changeElement(ClientParameterCode.ISCSI_REMOTE_DISCOVERY_PORTAL_ACTIVATE, ISCSIRemotePortalDiscoveryStateConstant.DISCOVERING);
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.REMOTE_PORTAL_DISC_ADDRESS);
        parameterCodes.addElement(ParameterCode.REMOTE_PORTAL_DISC_PORT);
        parameterCodes.addElement(ParameterCode.REMOTE_PORTAL_DISC_PERIOD);
        parameterCodes.addElement(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE);
        parameterCodes.addElement(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME);
        parameterCodes.addElement(ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY);
        parameterCodes.addElement(ParameterCode.REMOTE_PORTAL_DISC_STATE);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

