/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.CommKeyRefMap;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.LUIdentifier;
import com.sanrad.nms.server.logic.physstorage.LUIdentifierImpl;
import com.sanrad.nms.server.logic.physstorage.Storageable;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class StoragePool {
    private Vector pool = new Vector();

    public BigInteger getTotalCapacity() throws RemoteException {
        BigInteger capacity = BigInteger.ZERO;
        Enumeration e = this.getAll().elements();
        while (e.hasMoreElements()) {
            GeneralSCSIDevice storage = (GeneralSCSIDevice)e.nextElement();
            BigInteger total = storage.getTotalSpace();
            if (total == null) continue;
            capacity = capacity.add(storage.getTotalSpace());
        }
        return capacity;
    }

    public boolean addStorage(GeneralSCSIDevice storage) {
        this.getAll().addElement(storage);
        return true;
    }

    public boolean isContain(GeneralSCSIDevice storage) {
        return this.getAll().contains(storage);
    }

    public boolean removeStorage(GeneralSCSIDevice storage) {
        return this.getAll().remove(storage);
    }

    public void storageChanged(GeneralSCSIDeviceImpl storage) throws RemoteException, IllegalValueException {
        if (storage == null) {
            return;
        }
        ClusterImpl cluster = (ClusterImpl)storage.getCluster();
        GeneralSCSIDeviceImpl matchDevice = this.getMatchingSCSIDevice(storage);
        if (matchDevice != null) {
            int noOfConnectedVSwitches = cluster.getConnectedVSwitches().length;
            Vector storageVSwitches = storage.getConnectedVSwitchesAsVector();
            Vector matchDeviceVSwitches = matchDevice.getConnectedVSwitchesAsVector();
            boolean complementaryElements = storageVSwitches.size() < noOfConnectedVSwitches && matchDeviceVSwitches.size() < noOfConnectedVSwitches && !storageVSwitches.containsAll(matchDeviceVSwitches);
            matchDevice = this.getMatchingSCSIDevice(storage);
            if (complementaryElements) {
                matchDevice.merge(storage);
                DRRootImpl.getInstance().notifyVolumeReplaced(storage, matchDevice);
            }
        }
    }

    private GeneralSCSIDeviceImpl getMatchingSCSIDevice(GeneralSCSIDeviceImpl storage) throws RemoteException {
        if (PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.equals(storage.getTransportType())) {
            ClusterImpl cluster = (ClusterImpl)storage.getCluster();
            int numberOfConnectedVSwitches = cluster.getConnectedVSwitches().length;
            Vector storageVSwitches = storage.getConnectedVSwitchesAsVector();
            if (storageVSwitches.size() < numberOfConnectedVSwitches) {
                VSwitchImpl otherVs = (VSwitchImpl)cluster.getOtherVSwitch((VSwitch)storageVSwitches.firstElement());
                GeneralSCSIDevice match = this.getSCSIDeviceByEntityNameAndLun(storage.getTypeConstant(), storage.getEntityName(), storage.getLUN(), storage.getSerialNumber(), false, otherVs);
                return (GeneralSCSIDeviceImpl)match;
            }
        }
        return null;
    }

    private GeneralSCSIDevice getSCSIDeviceByEntityNameAndLun(PhysicalStorageTypeConstant type, String entityName, String lunStr, String lunSn, boolean ignoreSn, VSwitchImpl vswitch) throws RemoteException {
        Iterator i = this.getAll().iterator();
        while (i.hasNext()) {
            GeneralSCSIDeviceImpl device = (GeneralSCSIDeviceImpl)i.next();
            if (vswitch != null && !device.isKnownByVSwitch(vswitch) || !device.getTypeConstant().equals(type) || !device.getEntityName().equals(entityName) || !device.getLUN().equalsIgnoreCase(lunStr)) continue;
            if (ignoreSn) {
                return device;
            }
            String deviceSn = device.getSerialNumber();
            if ((lunSn == null || deviceSn == null || deviceSn.length() <= 0 || !deviceSn.equals(lunSn)) && (lunSn != null && lunSn.length() != 0 || deviceSn != null && deviceSn.length() != 0)) continue;
            return device;
        }
        return null;
    }

    public void removeAll() {
        this.getAll().removeAllElements();
    }

    public int size() {
        return this.getAll().size();
    }

    public synchronized Vector getAll() {
        return this.pool;
    }

    public Storageable getStorageByAlias(String alias) throws RemoteException {
        Enumeration e = this.getAll().elements();
        while (e.hasMoreElements()) {
            GeneralSCSIDeviceImpl storage = (GeneralSCSIDeviceImpl)e.nextElement();
            if (!storage.getAlias().equals(alias)) continue;
            return storage;
        }
        return null;
    }

    public GeneralSCSIDevice[] getStoragesByEntityName(String entityName) throws RemoteException {
        ArrayList<GeneralSCSIDeviceImpl> storages = new ArrayList<GeneralSCSIDeviceImpl>();
        Enumeration e = this.getAll().elements();
        while (e.hasMoreElements()) {
            GeneralSCSIDeviceImpl storage = (GeneralSCSIDeviceImpl)e.nextElement();
            if (!storage.getEntityName().equals(entityName)) continue;
            storages.add(storage);
        }
        GeneralSCSIDevice[] storagesArray = new GeneralSCSIDevice[storages.size()];
        return storages.toArray(storagesArray);
    }

    public GeneralSCSIDevice getStoragesByEntityNameAndLUN(String entityName, int lun) throws RemoteException {
        GeneralSCSIDevice[] devices = this.getStoragesByEntityName(entityName);
        for (int i = 0; i < devices.length; ++i) {
            if (Integer.parseInt(devices[i].getLUN()) != lun) continue;
            return devices[i];
        }
        return null;
    }

    public GeneralSCSIDevice getSCSIDeviceParameterList(Cluster clusterForDebug, HashMap parameterList) throws RemoteException {
        SrString serialNo = (SrString)parameterList.get(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER);
        CommKeyClassId[] luIds = (CommKeyClassId[])parameterList.get(ParameterCode.PHYSICAL_STORAGE_LU_IDENTIFIER);
        try {
            String serialNoValue;
            Object alias = parameterList.get(ParameterCode.PHYSICAL_STORAGE_ALIAS);
            CommKeyClassId vSwitch = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
            StringBuffer msg = new StringBuffer();
            msg.append(vSwitch);
            msg.append(" - New element: ");
            msg.append(alias);
            msg.append("; Serial No. ");
            msg.append(serialNo);
            LUIdentifierImpl luId = null;
            if (luIds != null) {
                luId = (LUIdentifierImpl)clusterForDebug.getCommKeyRefMap().getRefByCommKeyClassID(luIds[0]);
                if (luId != null) {
                    msg.append("; LU ID (assoc., codeset, type, value): ");
                    msg.append(luId.getAssociation());
                    msg.append(", ");
                    msg.append(luId.getCodeSet());
                    msg.append(", ");
                    msg.append(luId.getType());
                    msg.append(", ");
                    msg.append(luId.getValue());
                } else {
                    msg.append("; LU ID is null (in logic) ");
                }
            } else {
                msg.append("; LU ID is null (in parameterList) ");
            }
            LogMgr.getServerLog().debug(msg.toString());
            PhysicalStorageTypeConstant type = (PhysicalStorageTypeConstant)parameterList.get(ParameterCode.PHYSICAL_STORAGE_TYPE);
            SrLunFormat blockNum = (SrLunFormat)parameterList.get(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM);
            BigInteger blockNumValue = null;
            if (blockNum != null) {
                blockNumValue = (BigInteger)blockNum.value();
            }
            SrInteger blockSize = (SrInteger)parameterList.get(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE);
            Integer blockSizeValue = null;
            if (blockSize != null) {
                blockSizeValue = (Integer)blockSize.value();
            }
            boolean storageComparison3 = false;
            if (clusterForDebug instanceof ClusterImpl) {
                storageComparison3 = ((ClusterImpl)clusterForDebug).isStorageComparison3();
            }
            String string = serialNoValue = serialNo != null ? (String)serialNo.value() : null;
            if (serialNo != null && !serialNo.equals("") && luIds != null && !storageComparison3) {
                return this.getSCSIDeviceBySerialNoAndLUIds(serialNoValue, luIds, type, blockNumValue, blockSizeValue);
            }
            String entityName = parameterList.get(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME).toString();
            String lun = GeneralSCSIDeviceImpl.formatSCSIDeviceLUN((SrLunFormat)parameterList.get(ParameterCode.PHYSICAL_STORAGE_LUN));
            return this.getSCSIDeviceByEntityNameAndLun(entityName, lun, type, serialNoValue, blockNumValue, blockSizeValue);
        }
        catch (Exception e) {
            LogMgr.getServerLog().debug("temporary code for debuging", e);
            return null;
        }
    }

    private boolean isDeviceBlockEquals(GeneralSCSIDeviceImpl device, BigInteger blockNum, Integer blockSize) throws RemoteException {
        if (device.getClassId().equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            BigInteger deviceBlockNum = ((DirectAccessDeviceImpl)device).getNumberOfBlocks();
            int deviceBlockSize = ((DirectAccessDeviceImpl)device).getBlockSize();
            boolean blockSizeEqual = deviceBlockSize == blockSize || deviceBlockSize == 1 || blockSize == 1;
            boolean blockNumEqual = deviceBlockNum.compareTo(blockNum) == 0 || blockNum.compareTo(BigInteger.ZERO) == 0 || deviceBlockNum.compareTo(BigInteger.ZERO) == 0;
            return blockNumEqual && blockSizeEqual;
        }
        return true;
    }

    private GeneralSCSIDevice getSCSIDeviceByEntityNameAndLun(String entityName, String lun, PhysicalStorageTypeConstant type, String serialNo, BigInteger blockNum, Integer blockSize) throws RemoteException {
        Enumeration e = this.getAll().elements();
        while (e.hasMoreElements()) {
            boolean snExists;
            GeneralSCSIDeviceImpl device = (GeneralSCSIDeviceImpl)e.nextElement();
            String deviceSerialNo = device.getSerialNumber();
            Cluster cluster = device.getCluster();
            boolean storageComparison3 = false;
            if (cluster instanceof ClusterImpl) {
                storageComparison3 = ((ClusterImpl)cluster).isStorageComparison3();
            }
            boolean deviceSNExists = deviceSerialNo != null && deviceSerialNo.length() > 0;
            boolean bl = snExists = serialNo != null && serialNo.length() > 0;
            if (!storageComparison3 && (!deviceSNExists || !snExists || !deviceSerialNo.equals(serialNo)) && (deviceSNExists || snExists) || !device.getTypeConstant().equals(type) || !device.getEntityNameValue().equals(entityName) || !device.getLUN().equalsIgnoreCase(lun) || !this.isDeviceBlockEquals(device, blockNum, blockSize)) continue;
            return device;
        }
        return null;
    }

    public GeneralSCSIDevice getSCSIDeviceByEntityNameLunAndSerialNumber(String entityName, String lunStr, String lunSn, PhysicalStorageTypeConstant type) throws RemoteException {
        return this.getSCSIDeviceByEntityNameAndLun(type, entityName, lunStr, lunSn, false, null);
    }

    public GeneralSCSIDevice getSCSIDeviceByEntityNameAndLun(String entityName, String lunStr, PhysicalStorageTypeConstant type) throws RemoteException {
        return this.getSCSIDeviceByEntityNameAndLun(type, entityName, lunStr, null, true, null);
    }

    private GeneralSCSIDevice getSCSIDeviceBySerialNoAndLUIds(String serialNo, CommKeyClassId[] luIdsCommKeyClassId, PhysicalStorageTypeConstant type, BigInteger blockNum, Integer blockSize) throws RemoteException {
        if (luIdsCommKeyClassId.length > 0) {
            Iterator e = this.getAll().iterator();
            while (e.hasNext()) {
                GeneralSCSIDeviceImpl device = (GeneralSCSIDeviceImpl)e.next();
                if (!device.getTypeConstant().equals(type)) continue;
                Vector deviceLuIds = device.getLUIdentifier();
                String deviceSerialNo = device.getSerialNumber();
                if (deviceSerialNo != null && !deviceSerialNo.equals("") && deviceLuIds != null && deviceLuIds.size() > 0) {
                    if (deviceSerialNo.equals(serialNo) && luIdsCommKeyClassId.length == deviceLuIds.size()) {
                        CommKeyRefMap refMap = device.getCluster().getCommKeyRefMap();
                        Vector<LUIdentifier> luIds = new Vector<LUIdentifier>(luIdsCommKeyClassId.length);
                        for (int i = 0; i < luIdsCommKeyClassId.length; ++i) {
                            LUIdentifier luId = (LUIdentifier)refMap.getRefByCommKeyClassID(luIdsCommKeyClassId[i]);
                            luIds.addElement(luId);
                        }
                        if (!deviceLuIds.containsAll(luIds) || !this.isDeviceBlockEquals(device, blockNum, blockSize)) continue;
                        return device;
                    }
                    if (!deviceSerialNo.equals(serialNo)) {
                        LogMgr.getServerLog().debug(device.getClassId() + " " + device.getAlias() + " - SerialNo " + deviceSerialNo + " is not equal to " + serialNo);
                        continue;
                    }
                    LogMgr.getServerLog().debug(device.getClassId() + " " + device.getAlias() + " - LU ID size " + deviceLuIds.size() + " is not equal to " + luIdsCommKeyClassId.length);
                    continue;
                }
                if (deviceLuIds != null && deviceLuIds.size() != 0) continue;
                if (deviceSerialNo != null) {
                    LogMgr.getServerLog().debug(device.getClassId() + " " + device.getAlias() + " Serial# " + deviceSerialNo + " ; deviceLuIds " + deviceLuIds + " - LU ID is empty ==> is not equal to serialNo with length " + luIdsCommKeyClassId.length);
                    continue;
                }
                LogMgr.getServerLog().debug(device.getClassId() + " " + device.getAlias() + " Serial# is null ==> is not equal to " + serialNo);
            }
        }
        return null;
    }

    public boolean isAliasExist(String alias) throws RemoteException {
        if (this.isSCSIDeviceAliasExist(alias)) {
            return true;
        }
        return this.isSubDirectAccessDeviceAliasExist(alias) != null;
    }

    public boolean isSCSIDeviceAliasExist(String alias) throws RemoteException {
        Enumeration e = this.getAll().elements();
        while (e.hasMoreElements()) {
            GeneralSCSIDevice device = (GeneralSCSIDevice)e.nextElement();
            if (!device.getAlias().equals(alias)) continue;
            return true;
        }
        return false;
    }

    public DirectAccessDevice isSubDirectAccessDeviceAliasExist(String alias) throws RemoteException {
        Enumeration e = this.getAll().elements();
        while (e.hasMoreElements()) {
            Object device = e.nextElement();
            if (!(device instanceof DirectAccessDevice) || !((DirectAccessDeviceImpl)device).isSubDirectAccessDeviceAliasExist(alias)) continue;
            return (DirectAccessDevice)device;
        }
        return null;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        int retVal = 0;
        Enumeration e = this.getAll().elements();
        while (e.hasMoreElements()) {
            try {
                GeneralSCSIDevice device = (GeneralSCSIDevice)e.nextElement();
                int deviceRetVal = device.synchronize();
                if (deviceRetVal <= retVal) continue;
                retVal = deviceRetVal;
            }
            catch (IllegalValueException ive) {
                LogMgr.getServerLog().warning(ive.getMessage());
                errMsg.append(ive.getMessage());
                errOccured = true;
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return retVal;
    }
}

