/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.storage;

import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.logic.AliasObjectImpl;
import com.sanrad.nms.server.logic.AlreadyKnownByVSwitch;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.acl.PolicyManagerImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.lu.LUCreateValidator;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.lu.LUValidator;
import com.sanrad.nms.server.logic.lu.SCSILunImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralFiberChannelDeviceValidator;
import com.sanrad.nms.server.logic.physstorage.GeneralISCSIDeviceValidator;
import com.sanrad.nms.server.logic.physstorage.GeneralPSCSIDeviceValidator;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.LUIdentifier;
import com.sanrad.nms.server.logic.physstorage.LUIdentifierImpl;
import com.sanrad.nms.server.logic.physstorage.SequentialAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SequentialAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.Storageable;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.storage.Storage;
import com.sanrad.nms.server.logic.storage.StoragePool;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscoveryImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetCHAPCredentialsValidator;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortal;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortalImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortalValidator;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetValidator;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetValidator;
import com.sanrad.nms.server.logic.target.RemoteTargetList;
import com.sanrad.nms.server.logic.target.SCSITargetPort;
import com.sanrad.nms.server.logic.target.SCSITargetPortImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.target.TargetList;
import com.sanrad.nms.server.logic.target.TargetValidator;
import com.sanrad.nms.server.logic.volume.ConcatinationVolume;
import com.sanrad.nms.server.logic.volume.ConcatinationVolumeImpl;
import com.sanrad.nms.server.logic.volume.CubeVolume;
import com.sanrad.nms.server.logic.volume.CubeVolumeImpl;
import com.sanrad.nms.server.logic.volume.CubeVolumeValidator;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.nms.server.logic.volume.JournalVolumeImpl;
import com.sanrad.nms.server.logic.volume.MirrorVolume;
import com.sanrad.nms.server.logic.volume.MirrorVolumeImpl;
import com.sanrad.nms.server.logic.volume.SnapshotManager;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.StripeVolume;
import com.sanrad.nms.server.logic.volume.StripeVolumeImpl;
import com.sanrad.nms.server.logic.volume.TransparentVolume;
import com.sanrad.nms.server.logic.volume.TransparentVolumeImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeForest;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeTree;
import com.sanrad.nms.server.logic.volume.VolumeTreeImpl;
import com.sanrad.nms.server.logic.volume.validators.ConcatinationVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.CreateVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.JournalVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.MirrorVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.SnapshotVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.StripeVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.TransparentVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrScsiLUNFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.JournalVolumeActivityConstants;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class StorageImpl
extends RemoteObjectImpl
implements Storage {
    private StoragePool storagePool = new StoragePool();
    private VolumeForest volumeForest = new VolumeForest();
    private TargetList targetList = new TargetList();
    private RemoteTargetList m_remoteTargetList = new RemoteTargetList();
    private VolumeManager volumeManager;
    private ClusterImpl cluster;

    public StorageImpl(ClusterImpl cluster) throws RemoteException {
        this.volumeManager = new VolumeManager(this.targetList, this.volumeForest, cluster);
        this.cluster = cluster;
    }

    private ConfigElementData createConfigElementDataForVolume(String volAlias, Object children, ClassID volClassId, VSwitch alreadyExistOnVSwitch, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        if (volAlias.equals("")) {
            volAlias = CreateVolumeValidator.getDefaultAlias();
        }
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        CreateVolumeValidator validator = new CreateVolumeValidator(this.cluster, volClassId, volAlias, children, storage.getVolumeMgr());
        SrType[] vSwitchesToSetData = null;
        if (alreadyExistOnVSwitch != null) {
            CommKeyClassId[] vSwitchToSet = new CommKeyClassId[]{this.cluster.getOtherVSwitch(alreadyExistOnVSwitch).getCommKeyClassId()};
            vSwitchesToSetData = validator.getLegalVSwitchesForOperation(vSwitchToSet);
        } else {
            vSwitchesToSetData = validator.getLegalVSwitchesForOperation(this.cluster.getVSwitches());
        }
        ConfigElementData element = new ConfigElementData(volClassId);
        Parameter alias = new Parameter(ParameterCode.VOLUME_ALIAS, new SrString(volAlias));
        element.addParameter(alias);
        SrType[] childrenCommKeys = this.getChildrenDataByPosition(children, alreadyExistOnVSwitch);
        element.setValues(ParameterCode.VOLUME_CHILDREN, childrenCommKeys);
        element.setOperationInvoker(operationInvoker);
        element.setValues(ParameterCode.VSWITCH_ID, vSwitchesToSetData);
        return element;
    }

    public void createConcatinationVolume(String volAlias, CommKeyClassId[] childrenCommKeyClassId) throws RemoteException, IllegalValueException {
        Vector children = this.convertToVolumeChildrenVector(childrenCommKeyClassId);
        ConcatinationVolumeValidator validator = new ConcatinationVolumeValidator(this.cluster, volAlias, children, this.volumeManager);
        for (int i = 0; i < childrenCommKeyClassId.length; ++i) {
            VolumeNodeImpl vol = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
            DRPairImpl pair = DRRootImpl.getInstance().getPairUseingVolume(vol);
            if (pair == null) continue;
            throw new IllegalValueException(" cannot create volume since one of it's child is belong to pair");
        }
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        this.createConcatinationVolume(volAlias, children, null, null, null);
    }

    public void createConcatinationVolume(String volAlias, Vector children, Vector vSwitches, VSwitch alreadyExistOn, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, children, ClassID.CONCAT_VOLUME, alreadyExistOn, operationInvoker);
        this.cluster.createElement(element, ClassID.CONCAT_VOLUME, volAlias, vSwitches);
    }

    public void createCubeVolume(String volAlias, CommKeyClassId[] childrenCommKeyClassId) throws RemoteException, IllegalValueException {
        Vector children = this.convertToVolumeChildrenVector(childrenCommKeyClassId);
        CubeVolumeValidator validator = new CubeVolumeValidator(this.cluster, volAlias, children, this.volumeManager);
        for (int i = 0; i < childrenCommKeyClassId.length; ++i) {
            VolumeNodeImpl vol = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
            DRPairImpl pair = DRRootImpl.getInstance().getPairUseingVolume(vol);
            if (pair == null) continue;
            throw new IllegalValueException(" cannot create volume since one of it's child is belong to pair");
        }
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        this.createCubeVolume(volAlias, children, null, null, null);
    }

    public void createCubeVolume(String volAlias, Vector children, Vector vSwitches, VSwitch alreadyExistOn, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, children, ClassID.CUBE_VOLUME, alreadyExistOn, operationInvoker);
        this.cluster.createElement(element, ClassID.CUBE_VOLUME, volAlias, vSwitches);
    }

    private Vector convertToVolumeChildrenVector(CommKeyClassId[] childrenCommKeyClassId) throws RemoteException {
        Vector<VolumeNodeImpl> children = new Vector<VolumeNodeImpl>(childrenCommKeyClassId.length);
        for (int i = 0; i < childrenCommKeyClassId.length; ++i) {
            VolumeNodeImpl child = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
            children.addElement(child);
        }
        return children;
    }

    public void createMirrorVolume(String volAlias, CommKeyClassId[] childrenCommKeyClassId) throws RemoteException, IllegalValueException {
        Vector children = this.convertToVolumeChildrenVector(childrenCommKeyClassId);
        MirrorVolumeValidator validator = new MirrorVolumeValidator(this.cluster, volAlias, children, this.volumeManager);
        for (int i = 0; i < childrenCommKeyClassId.length; ++i) {
            VolumeNodeImpl vol = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
            DRPairImpl pair = DRRootImpl.getInstance().getPairUseingVolume(vol);
            if (pair == null) continue;
            throw new IllegalValueException(" cannot create volume since one of it's child is belong to pair");
        }
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        this.createMirrorVolume(volAlias, children, null, null, null);
    }

    public void createMirrorVolume(String volAlias, Vector children, Vector vSwitches, VSwitch alreadyExistOn, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, children, ClassID.MIRROR_VOLUME, alreadyExistOn, operationInvoker);
        this.cluster.createElement(element, ClassID.MIRROR_VOLUME, volAlias, vSwitches);
    }

    public void createStripeVolume(String volAlias, CommKeyClassId[] childrenCommKeyClassId, BigInteger stripeSize) throws RemoteException, IllegalValueException {
        Vector children = this.convertToVolumeChildrenVector(childrenCommKeyClassId);
        StripeVolumeValidator validator = new StripeVolumeValidator(this.cluster, volAlias, children, stripeSize, this.volumeManager);
        for (int i = 0; i < childrenCommKeyClassId.length; ++i) {
            VolumeNodeImpl vol = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
            DRPairImpl pair = DRRootImpl.getInstance().getPairUseingVolume(vol);
            if (pair == null) continue;
            throw new IllegalValueException(" cannot create volume since one of it's child is belong to pair");
        }
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        this.createStripeVolume(volAlias, children, stripeSize, null, null, null);
    }

    public void createStripeVolume(String volAlias, Vector children, BigInteger stripeSize, Vector vSwitches, VSwitch alreadyExistOn, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, children, ClassID.STRIPE_VOLUME, alreadyExistOn, operationInvoker);
        int blockSize = ((VolumeNode)children.firstElement()).getBlockSize();
        BigInteger stripeSizeBlocks = Util.bytesToBlocks(stripeSize, blockSize);
        SrLunFormat stripeSizeValue = new SrLunFormat(stripeSizeBlocks);
        Parameter stripeSizeParam = new Parameter(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, stripeSizeValue);
        element.addParameter(stripeSizeParam);
        this.cluster.createElement(element, ClassID.STRIPE_VOLUME, volAlias, vSwitches);
    }

    public void createJournalVolume(String volAlias, Integer threshold, Vector volumeNodeChildren, VSwitch activeOnVswitch, VSwitch inactiveVswitch, boolean shouldValidate) throws RemoteException, IllegalValueException {
        SrType[] vSwitchesToSet;
        JournalVolumeValidator validator;
        boolean createActiveJournalOnly = activeOnVswitch != null && inactiveVswitch == null;
        boolean createInActiveJournalOnly = activeOnVswitch == null && inactiveVswitch != null;
        for (int i = 0; i < volumeNodeChildren.size(); ++i) {
            VolumeNodeImpl vol = (VolumeNodeImpl)volumeNodeChildren.get(i);
            DRPairImpl pair = DRRootImpl.getInstance().getPairUseingVolume(vol);
            if (pair == null) continue;
            throw new IllegalValueException(" cannot create volume since one of it's child is belong to pair");
        }
        if (shouldValidate && !(validator = new JournalVolumeValidator(this.cluster, volAlias, threshold, volumeNodeChildren, true, activeOnVswitch, inactiveVswitch, this.volumeManager)).isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, volumeNodeChildren, ClassID.JOURNAL_VOLUME, null, null);
        element.addParameter(new Parameter(ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, new SrInteger(threshold)));
        if (activeOnVswitch != null) {
            vSwitchesToSet = new CommKeyClassId[]{activeOnVswitch.getCommKeyClassId()};
            element.setValues(ParameterCode.VSWITCH_ID, vSwitchesToSet);
            element.addParameter(new Parameter(ParameterCode.JOURNAL_VOLUME_ACTIVITY, JournalVolumeActivityConstants.ACTIVE));
            this.cluster.createElement(element, ClassID.JOURNAL_VOLUME, volAlias);
        }
        if (inactiveVswitch != null) {
            vSwitchesToSet = new CommKeyClassId[]{inactiveVswitch.getCommKeyClassId()};
            element.setValues(ParameterCode.VSWITCH_ID, vSwitchesToSet);
            element.setValue(ParameterCode.JOURNAL_VOLUME_ACTIVITY, JournalVolumeActivityConstants.INACTIVE);
            this.cluster.createElement(element, ClassID.JOURNAL_VOLUME, volAlias);
        }
    }

    public void createJournalVolume(String volAlias, Integer threshold, Vector volumeNodeChilds, VSwitch activeOnVswitch, VSwitch inActiveOnVswitch) throws RemoteException, IllegalValueException {
        this.createJournalVolume(volAlias, threshold, volumeNodeChilds, activeOnVswitch, inActiveOnVswitch, true);
    }

    public void createJournalVolume(String volAlias, Integer threshold, CommKeyClassId volumeNodeChildId, CommKeyClassId activeOnVswitchId) throws RemoteException, IllegalValueException {
        CommKeyClassId[] childrenCommKeyClassId = new CommKeyClassId[]{volumeNodeChildId};
        Vector children = this.convertToVolumeChildrenVector(childrenCommKeyClassId);
        VSwitch vswitch = (VSwitch)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(activeOnVswitchId);
        VSwitch otherVswitch = ((ClusterImpl)this.getCluster()).getOtherVSwitch(vswitch);
        this.createJournalVolume(volAlias, threshold, children, vswitch, otherVswitch);
    }

    public void createTransparentVolume(String volAlias, CommKeyClassId childCommKeyClassId) throws RemoteException, IllegalValueException {
        GeneralSCSIDeviceImpl child = (GeneralSCSIDeviceImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childCommKeyClassId);
        TransparentVolumeValidator validator = new TransparentVolumeValidator(this.cluster, volAlias, child, this.volumeManager);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        this.createTransparentVolume(volAlias, child, null, null, null);
    }

    public void createTransparentVolume(String volAlias, GeneralSCSIDevice child, Vector vSwitches, VSwitch alreadyExistOn, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, child, ClassID.TRANSPARENT_VOLUME, alreadyExistOn, operationInvoker);
        this.cluster.createElement(element, ClassID.TRANSPARENT_VOLUME, volAlias, vSwitches);
    }

    public void createSnapshotVolume(String volAlias, CommKeyClassId sourceVolumeCommKeyClassId, CommKeyClassId childCommKeyClassId, int threshold) throws RemoteException, IllegalValueException {
        VolumeNodeImpl child = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(childCommKeyClassId);
        VolumeNodeImpl source = (VolumeNodeImpl)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(sourceVolumeCommKeyClassId);
        if (source.isDROfflineLocalCopy() || child.isDROfflineLocalCopy()) {
            throw new IllegalValueException("cannot create snapshot since source or child are local copy");
        }
        SnapshotVolumeValidator validator = new SnapshotVolumeValidator(this.cluster, source, volAlias, child, threshold, this.volumeManager);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        this.createSnapshotVolume(volAlias, source, child, threshold, null, null, null);
    }

    public void createSnapshotVolume(String volAlias, VolumeNode source, VolumeNode child, int threshold, Vector vSwitches, VSwitch alreadyExistOn, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        ConfigElementData element = this.createConfigElementDataForVolume(volAlias, child, ClassID.SNAPSHOT_VOLUME, alreadyExistOn, operationInvoker);
        SrType[] vSwitchToSet = (CommKeyClassId[])element.getValue(ParameterCode.VSWITCH_ID);
        CommKeyClassId[] vSwitchSourceVolExistOn = this.getVSwitchesAllChildrenExistIn(source);
        Vector<SrType> vses = new Vector<SrType>();
        block0: for (int i = 0; i < vSwitchToSet.length; ++i) {
            for (int j = 0; j < vSwitchSourceVolExistOn.length; ++j) {
                if (!vSwitchToSet[i].equals(vSwitchSourceVolExistOn[j])) continue;
                VSwitch vs = (VSwitch)SystemRootImpl.getInstance().getRefByStub((CommKeyClassId)vSwitchToSet[i]);
                if (vSwitches != null && !vSwitches.contains(vs)) continue block0;
                vses.add(vSwitchToSet[i]);
                continue block0;
            }
        }
        if (vSwitchToSet.length != vses.size()) {
            vSwitchToSet = new CommKeyClassId[vses.size()];
            vses.toArray(vSwitchToSet);
            element.setValues(ParameterCode.VSWITCH_ID, vSwitchToSet);
        }
        element.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE, source.getCommKeyClassId()));
        if (threshold > -1) {
            element.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, new SrInteger(threshold)));
        }
        element.addParameter(new Parameter(ParameterCode.SNAPSHOT_ACTIVATE, SnapshotActivateTypeConstants.SNAPSHOT_INACTIVE));
        this.cluster.createElement(element, ClassID.SNAPSHOT_VOLUME, volAlias, vSwitches);
    }

    public void exposeVolume(int luNumber, CommKeyClassId volumeCommKeyClassId, CommKeyClassId targetCommKeyClassId) throws RemoteException, IllegalValueException {
        this.exposeVolume(luNumber, volumeCommKeyClassId, targetCommKeyClassId, null);
    }

    public void exposeVolume(int luNumber, CommKeyClassId volumeCommKeyClassId, CommKeyClassId targetCommKeyClassId, String serialNumber) throws RemoteException, IllegalValueException {
        TargetImpl target = (TargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(targetCommKeyClassId);
        VolumeNodeImpl volume = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(volumeCommKeyClassId);
        Vector<VSwitch> vSwitches = new Vector<VSwitch>(Arrays.asList(target.getConnectedVSwitches()));
        LUCreateValidator validator = new LUCreateValidator(this.cluster, luNumber, volume, (Target)target);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        this.exposeVolume(luNumber, volume, target, vSwitches, null, serialNumber);
    }

    public void exposeVolume(int luNumber, VolumeNode volume, Target target, Vector vSwitches, CommKeyClassId operationInvoker, String serialNumber) throws RemoteException, IllegalValueException {
        ConfigElementData element = new ConfigElementData(ClassID.LUN);
        element.addParameter(new Parameter(ParameterCode.LU_LUN_NUMBER, new SrGauge(luNumber)));
        if (serialNumber != null && !serialNumber.trim().equals("")) {
            element.addParameter(new Parameter(ParameterCode.LU_SERIAL_NUMBER, new SrString(serialNumber)));
        }
        VolumeNode vol = volume;
        CommKeyClassId volCommKeyClassId = new CommKeyClassId(vol.getCommKeys(), vol.getClassId());
        element.addParameter(new Parameter(ParameterCode.LU_VOLUME_ID, volCommKeyClassId));
        CommKeyClassId targetCommKeyClassId = new CommKeyClassId(target.getCommKeys(), target.getClassId());
        element.addParameter(new Parameter(ParameterCode.LU_PARENT, targetCommKeyClassId));
        LUValidator validator = new LUValidator(this.cluster, luNumber, volume, target);
        CommKeyClassId[] vSwitchesToSetData = validator.getLegalVSwitchesForOperation(vSwitches);
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchesToSetData));
        element.setOperationInvoker(operationInvoker);
        this.cluster.createElement(element, "Trying to expose " + volume.getAlias() + " with LUN " + luNumber + " on target " + target.getAlias(), null);
    }

    public void createGeneralPhysStorageDevice(PhysicalStorageTypeConstant type, String alias, SrEntityNameFormat targetName, int lun, PhysStorTransportTypeConstant transType, String serialNumber, Vector vSwitches) throws RemoteException, IllegalValueException {
        ConfigElementData element = new ConfigElementData(ClassID.DIRECT_ACCESS_DEVICE);
        element.setValue(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, targetName);
        element.setValue(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, transType);
        element.setValue(ParameterCode.PHYSICAL_STORAGE_LUN, GeneralSCSIDeviceImpl.parseSCSIDeviceLUN(lun));
        if (alias != null) {
            element.setValue(ParameterCode.PHYSICAL_STORAGE_ALIAS, new SrString(alias));
        }
        if (serialNumber != null) {
            element.setValue(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER, new SrString(serialNumber));
        }
        this.cluster.createElement(element, ClassID.DIRECT_ACCESS_DEVICE, alias, vSwitches);
    }

    private void createGeneralPhysStorageDevice(PhysicalStorageTypeConstant type, String alias, SrEntityNameFormat targetName, int lun, PhysStorTransportTypeConstant transType, String serialNumber) throws RemoteException, IllegalValueException {
        this.createGeneralPhysStorageDevice(type, alias, targetName, lun, transType, serialNumber, null);
    }

    public void createGeneralISCSIDevice(PhysicalStorageTypeConstant type, String alias, String targetName, int lun, String serialNumber) throws RemoteException, IllegalValueException {
        GeneralISCSIDeviceValidator validator = new GeneralISCSIDeviceValidator(this.cluster, this.targetList, type, alias, targetName, lun, serialNumber);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        this.createGeneralPhysStorageDevice(type, alias, new SrEntityNameFormat(targetName), lun, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI, serialNumber);
    }

    public void createGeneralParallelSCSIDevice(PhysicalStorageTypeConstant type, String alias, int port, int bus, int lun, String serialNumber) throws RemoteException, IllegalValueException {
        GeneralPSCSIDeviceValidator validator = new GeneralPSCSIDeviceValidator(this.cluster, this.targetList, type, alias, port, bus, lun, serialNumber);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        SrEntityNameFormat entityName = new SrEntityNameFormat(new byte[]{0, 0, 0, (byte)port, 0, 0, 0, (byte)bus});
        this.createGeneralPhysStorageDevice(type, alias, entityName, lun, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI, serialNumber);
    }

    public void createGeneralFiberChannelDevice(PhysicalStorageTypeConstant type, String alias, byte[] targetName, int lun, String serialNumber) throws RemoteException, IllegalValueException {
        GeneralFiberChannelDeviceValidator validator = new GeneralFiberChannelDeviceValidator(this.cluster, this.targetList, type, alias, targetName, lun, serialNumber);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        SrEntityNameFormat entityNameFormat = new SrEntityNameFormat(targetName);
        this.createGeneralPhysStorageDevice(type, alias, entityNameFormat, lun, PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_FCP, serialNumber);
    }

    public void createISCSITarget(String name, String alias, Permission defaultAccess, String vSwitch, Vector vSwitches) throws RemoteException, IllegalValueException {
        if (alias.equals("")) {
            alias = TargetValidator.getDefaultAlias();
        }
        ConfigElementData element = new ConfigElementData(ClassID.ISCSI_TARGET);
        Parameter targetName = new Parameter(ParameterCode.ISCSI_TARGET_NAME, new SrString(name));
        element.addParameter(targetName);
        Parameter targetAlias = new Parameter(ParameterCode.ISCSI_TARGET_ALIAS, new SrString(alias));
        element.addParameter(targetAlias);
        Parameter targetVSwitch = new Parameter(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON, new SrString(vSwitch));
        element.addParameter(targetVSwitch);
        if (defaultAccess != null) {
            Parameter defaultAccessParameter = new Parameter(ParameterCode.ISCSI_TARGET_DEFAULT_ACCESS, new SrInteger(defaultAccess.intValue()));
            element.addParameter(defaultAccessParameter);
        }
        this.cluster.createElement(element, ClassID.ISCSI_TARGET, alias, vSwitches);
    }

    public void createISCSITarget(String name, String alias, String vSwitch) throws RemoteException, IllegalValueException {
        this.createISCSITarget(name, alias, null, vSwitch, null);
    }

    public void createISCSITarget(String name, String alias, Permission defaultAccess, String vSwitch) throws RemoteException, IllegalValueException {
        ISCSITargetValidator validator = new ISCSITargetValidator((ClusterImpl)this.getCluster(), name, alias, vSwitch);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        this.createISCSITarget(name, alias, defaultAccess, vSwitch, null);
    }

    public void createISCSIRemoteTarget(CommKeyClassId remoteTargetId, String remoteTargetCHAPUserName, String remoteTargetCHAPPassword, String[] remoteTargetPortalIPs, BigInteger[] remoteTargetPortalPorts, Integer[] remoteTargetPortalGroupTags) throws RemoteException, IllegalValueException {
        ISCSIRemoteTargetImpl remotetarget = (ISCSIRemoteTargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(remoteTargetId);
        if (remotetarget == null) {
            throw new IllegalValueException("A remote target must be specified");
        }
        ISCSIRemoteTargetPortalValidator remoteTargetPortalValidator = new ISCSIRemoteTargetPortalValidator(remotetarget, remoteTargetPortalIPs, remoteTargetPortalPorts, remoteTargetPortalGroupTags, null);
        if (!remoteTargetPortalValidator.isValid()) {
            throw new IllegalValueException(remoteTargetPortalValidator.getErrorMsg());
        }
    }

    public void createISCSIRemoteTarget(String remoteTargetName, String remoteTargetAlias) throws RemoteException, IllegalValueException {
        this.createISCSIRemoteTarget(remoteTargetName, remoteTargetAlias, null, null, null, null, null, true);
    }

    public void createISCSIRemoteTarget(String remoteTargetName, String remoteTargetAlias, String remoteTargetCHAPUserName, String remoteTargetCHAPPassword, String[] remoteTargetPortalIPs, BigInteger[] remoteTargetPortalPorts, Integer[] remoteTargetPortalGroupTags) throws RemoteException, IllegalValueException {
        this.createISCSIRemoteTarget(remoteTargetName, remoteTargetAlias, remoteTargetCHAPUserName, remoteTargetCHAPPassword, remoteTargetPortalIPs, remoteTargetPortalPorts, remoteTargetPortalGroupTags, true);
    }

    public void createISCSIRemoteTarget(String remoteTargetName, String remoteTargetAlias, String remoteTargetCHAPUserName, String remoteTargetCHAPPassword, String[] remoteTargetPortalIPs, BigInteger[] remoteTargetPortalPorts, Integer[] remoteTargetPortalGroupTags, boolean validateTargetValues) throws RemoteException, IllegalValueException {
        VSwitch[] array = this.getCluster().getConnectedVSwitches();
        this.createISCSIRemoteTarget(remoteTargetName, remoteTargetAlias, null, remoteTargetCHAPUserName, remoteTargetCHAPPassword, remoteTargetPortalIPs, remoteTargetPortalPorts, remoteTargetPortalGroupTags, validateTargetValues, array);
    }

    public void createISCSIRemoteTarget(String remoteTargetName, String remoteTargetAlias, String remoteTargetIdentityAlias, String remoteTargetCHAPUserName, String remoteTargetCHAPPassword, String[] remoteTargetPortalIPs, BigInteger[] remoteTargetPortalPorts, Integer[] remoteTargetPortalGroupTags, boolean validateTargetValues, VSwitch[] vswitches) throws RemoteException, IllegalValueException {
        ISCSIRemoteTargetPortalValidator remoteTargetPortalValidator;
        ISCSIRemoteTargetCHAPCredentialsValidator remoteTargetPortalCHAPCredentialsValidator;
        ISCSIRemoteTargetValidator remoteTargetValidator;
        if (remoteTargetAlias.equals("")) {
            remoteTargetAlias = remoteTargetName;
        }
        if (validateTargetValues && !(remoteTargetValidator = new ISCSIRemoteTargetValidator((ClusterImpl)this.getCluster(), remoteTargetName, remoteTargetAlias, this.targetList, this.m_remoteTargetList)).isValid()) {
            throw new IllegalValueException(remoteTargetValidator.getErrorMsg());
        }
        if (validateTargetValues && (remoteTargetCHAPUserName != null || remoteTargetCHAPPassword != null) && !(remoteTargetPortalCHAPCredentialsValidator = new ISCSIRemoteTargetCHAPCredentialsValidator(remoteTargetCHAPPassword)).isValid()) {
            throw new IllegalValueException(remoteTargetPortalCHAPCredentialsValidator.getErrorMsg());
        }
        if (validateTargetValues && remoteTargetPortalIPs != null && !(remoteTargetPortalValidator = new ISCSIRemoteTargetPortalValidator(null, remoteTargetPortalIPs, remoteTargetPortalPorts, remoteTargetPortalGroupTags, null)).isValid()) {
            throw new IllegalValueException(remoteTargetPortalValidator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.ISCSI_REMOTE_TARGET);
        SrType[] vSwitchestoSet = new CommKeyClassId[vswitches.length];
        for (int index = 0; index < vswitches.length; ++index) {
            vSwitchestoSet[index] = vswitches[index].getCommKeyClassId();
        }
        element.setValues(ParameterCode.VSWITCH_ID, vSwitchestoSet);
        Parameter rTargetConnectedInitiator = new Parameter(ParameterCode.ISCSI_INITIATOR_ID, this.getLocalInitiatorsInCluster(vswitches));
        element.addParameter(rTargetConnectedInitiator);
        Parameter rTargetName = new Parameter(ParameterCode.DISCOVERED_TARGET_NAME, new SrString(remoteTargetName));
        element.addParameter(rTargetName);
        Parameter rTargetAlias = new Parameter(ParameterCode.SCSI_REMOTE_TARGET_ALIAS, new SrString(remoteTargetAlias));
        element.addParameter(rTargetAlias);
        if (remoteTargetIdentityAlias != null) {
            Parameter rTargetIdentityAlias = new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_IDENTITY_ALIAS, new SrString(remoteTargetIdentityAlias));
            element.addParameter(rTargetIdentityAlias);
        }
        if (remoteTargetCHAPUserName != null) {
            Parameter rTargetCHAPUserName = new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME, new SrString(remoteTargetCHAPUserName));
            element.addParameter(rTargetCHAPUserName);
        }
        if (remoteTargetCHAPPassword != null) {
            Parameter rTargetCHAPPassword = new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD, new SrString(remoteTargetCHAPPassword));
            element.addParameter(rTargetCHAPPassword);
        }
        if (remoteTargetPortalIPs != null) {
            SrString[] arrayOfrTargetPortalIPs = new SrString[remoteTargetPortalIPs.length];
            SrString.copyStringArrays(remoteTargetPortalIPs, arrayOfrTargetPortalIPs);
            Parameter rTargetPortalIPs = new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, arrayOfrTargetPortalIPs);
            element.addParameter(rTargetPortalIPs);
            SrGauge[] arrayOfrTargetPortalPorts = new SrGauge[remoteTargetPortalPorts.length];
            SrGauge.copyIntegerArrays(remoteTargetPortalPorts, arrayOfrTargetPortalPorts);
            Parameter rTargetPortalPorts = new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT, arrayOfrTargetPortalPorts);
            element.addParameter(rTargetPortalPorts);
            SrInteger[] arrayOfrTargetPortalGroupTags = new SrInteger[remoteTargetPortalGroupTags.length];
            SrInteger.copyIntegerArrays(remoteTargetPortalGroupTags, arrayOfrTargetPortalGroupTags);
            Parameter rTargetPortalGroupTags = new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG, arrayOfrTargetPortalGroupTags);
            element.addParameter(rTargetPortalGroupTags);
        }
        this.cluster.createElement(element, ClassID.ISCSI_REMOTE_TARGET, remoteTargetName);
    }

    private CommKeyClassId[] getLocalInitiatorsInCluster(VSwitch[] vswitches) throws RemoteException {
        ArrayList<CommKeyClassId> initiators = new ArrayList<CommKeyClassId>();
        for (int index = 0; index < vswitches.length; ++index) {
            VSwitch vswitch = vswitches[index];
            ISCSIInitiator[] vswitchInitiators = vswitch.getISCSIInitiators();
            CommKeyClassId iscsiInitiatorId = vswitchInitiators[0].getCommKeyClassId();
            CommKeyClassId scsiInitiatorId = ((ClusterImpl)this.getCluster()).getSCSIId(iscsiInitiatorId);
            initiators.add(scsiInitiatorId);
        }
        CommKeyClassId[] initiatorsIds = new CommKeyClassId[initiators.size()];
        for (int index = 0; index < initiators.size(); ++index) {
            initiatorsIds[index] = (CommKeyClassId)initiators.get(index);
        }
        return initiatorsIds;
    }

    public Vector getTargetList() throws RemoteException {
        return this.getTargetListMgr().getAll();
    }

    public TargetList getTargetListMgr() {
        return this.targetList;
    }

    public ISCSIRemoteTarget[] getRemoteTargetList() throws RemoteException {
        return this.getRemoteTargetListMgr().getAll();
    }

    public RemoteTargetList getRemoteTargetListMgr() {
        return this.m_remoteTargetList;
    }

    public VolumeManager getVolumeMgr() {
        return this.volumeManager;
    }

    public Vector getStorageDevices() throws RemoteException {
        return this.storagePool.getAll();
    }

    public StoragePool getStoragePool() {
        return this.storagePool;
    }

    public Vector getVolumeTrees() throws RemoteException {
        Vector volumeTrees = this.targetList.getVolumeTrees();
        Vector forestTrees = this.volumeForest.getAll();
        volumeTrees.addAll(forestTrees);
        return volumeTrees;
    }

    public Vector getVolumeForest() throws RemoteException {
        return this.volumeForest.getAll();
    }

    public Vector getInteranlVolumesByType(ClassID volClassId) throws RemoteException {
        if (volClassId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE) || volClassId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            Vector devices = this.getStoragePool().getAll();
            if (volClassId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
                return devices;
            }
            Vector subdisks = new Vector();
            for (int i = 0; i < devices.size(); ++i) {
                DirectAccessDevice device = (DirectAccessDevice)devices.get(i);
                subdisks.addAll(device.getSubDirectAccessDevices());
            }
            return subdisks;
        }
        Vector volumesInCluster = this.getVolumeForest();
        Vector<VolumeTreeImpl> voluemsByType = new Vector<VolumeTreeImpl>();
        for (int index = 0; index < volumesInCluster.size(); ++index) {
            VolumeTreeImpl volume = (VolumeTreeImpl)volumesInCluster.elementAt(index);
            if (!volume.getTreeRoot().getClassId().equals(volClassId)) continue;
            voluemsByType.add(volume);
        }
        return voluemsByType;
    }

    private Volume getVolumeIfAlreadyKnownByCluster(ClassID type, HashMap parameterList) throws RemoteException {
        CommKeyClassId[] children = (CommKeyClassId[])parameterList.get(ParameterCode.VOLUME_CHILDREN);
        if (children != null && children.length > 0) {
            VolumeImpl candidateVolume;
            VolumeNodeImpl child = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(children[0]);
            if (child != null && (candidateVolume = (VolumeImpl)child.getParentVolume()) != null && candidateVolume.getClassId().equals(type)) {
                Vector<Object> childrenVec = new Vector<Object>(children.length);
                for (int i = 0; i < children.length; ++i) {
                    Object childImpl = this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(children[i]);
                    childrenVec.addElement(childImpl);
                }
                Vector candidateCildren = candidateVolume.getChildren();
                if (!candidateCildren.containsAll(childrenVec) && !childrenVec.containsAll(candidateCildren)) {
                    return null;
                }
                return candidateVolume;
            }
        } else {
            Object alias = parameterList.get(ParameterCode.VOLUME_ALIAS);
            Object vSwitch = parameterList.get(ParameterCode.VSWITCH_ID);
            logger.warning("No children for volume " + alias + " at " + ClassID.VSWITCH + " " + vSwitch + " in StorageImpl::getVolumeIfAlreadyKnownByCluster()");
        }
        return null;
    }

    private Volume checkForVolumeExistance(ClassID type, HashMap parameterList, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch {
        Volume volume = this.getVolumeIfAlreadyKnownByCluster(type, parameterList);
        if (volume != null) {
            VSwitch[] vSwitches = ((VolumeImpl)volume).getConnectedVSwitches();
            VSwitch vSwitch = this.cluster.getVSwitch(parameterList);
            boolean sameVSwitch = false;
            for (int i = 0; i < vSwitches.length; ++i) {
                if (!vSwitches[i].equals(vSwitch)) continue;
                sameVSwitch = true;
                if (!CommKeyUtil.isEqual(commKeys, volume.getCommKeys())) continue;
                throw new AlreadyKnownByVSwitch(volume);
            }
            if (!sameVSwitch) {
                throw new AlreadyKnownByVSwitch(volume);
            }
        }
        return volume;
    }

    private Volume newVolume(Volume volume, HashMap parameterList, CommKey[] commKeys) throws RemoteException, IllegalValueException {
        ((VolumeImpl)volume).setParameterList(parameterList);
        ((VolumeImpl)volume).setLeafsFree(false);
        this.volumeForest.addVolume(volume);
        return volume;
    }

    public ConcatinationVolume newConcatinationVolume(HashMap parameterList, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        this.checkForVolumeExistance(ClassID.CONCAT_VOLUME, parameterList, commKeys);
        ConcatinationVolumeImpl volume = new ConcatinationVolumeImpl(this.cluster);
        ConcatinationVolumeImpl newVolume = (ConcatinationVolumeImpl)this.newVolume(volume, parameterList, commKeys);
        newVolume.updateExpandAndRetractStatus();
        return newVolume;
    }

    public CubeVolume newCubeVolume(HashMap parameterList, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        this.checkForVolumeExistance(ClassID.CUBE_VOLUME, parameterList, commKeys);
        CubeVolumeImpl volume = new CubeVolumeImpl(this.cluster);
        CubeVolumeImpl newVolume = (CubeVolumeImpl)this.newVolume(volume, parameterList, commKeys);
        newVolume.updateExpandAndRetractStatus();
        return newVolume;
    }

    public MirrorVolume newMirrorVolume(HashMap parameterList, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        this.checkForVolumeExistance(ClassID.MIRROR_VOLUME, parameterList, commKeys);
        MirrorVolumeImpl volume = new MirrorVolumeImpl(this.cluster);
        return (MirrorVolume)this.newVolume(volume, parameterList, commKeys);
    }

    public SnapshotVolume newSnapshotVolume(HashMap parameterList, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        this.checkForVolumeExistance(ClassID.SNAPSHOT_VOLUME, parameterList, commKeys);
        SnapshotVolumeImpl volume = new SnapshotVolumeImpl(this.cluster);
        SnapshotVolumeImpl snapshotVolume = (SnapshotVolumeImpl)this.newVolume(volume, parameterList, commKeys);
        return snapshotVolume;
    }

    public JournalVolume newJournalVolume(HashMap parameterList, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        this.checkForVolumeExistance(ClassID.JOURNAL_VOLUME, parameterList, commKeys);
        JournalVolumeImpl volume = new JournalVolumeImpl(this.cluster);
        JournalVolumeImpl journalVolume = (JournalVolumeImpl)this.newVolume(volume, parameterList, commKeys);
        return journalVolume;
    }

    public StripeVolume newStripeVolume(HashMap parameterList, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        this.checkForVolumeExistance(ClassID.STRIPE_VOLUME, parameterList, commKeys);
        StripeVolumeImpl volume = new StripeVolumeImpl(this.cluster);
        return (StripeVolume)this.newVolume(volume, parameterList, commKeys);
    }

    public TransparentVolume newTransparentVolume(HashMap parameterList, CommKey[] commKeys) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        this.checkForVolumeExistance(ClassID.TRANSPARENT_VOLUME, parameterList, commKeys);
        TransparentVolumeImpl volume = new TransparentVolumeImpl(this.cluster);
        return (TransparentVolume)this.newVolume(volume, parameterList, commKeys);
    }

    public ISCSITarget newISCSITarget(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        String name = (String)((SrString)parameterList.get(ParameterCode.ISCSI_TARGET_NAME)).value();
        ISCSITarget target = (ISCSITarget)this.targetList.getTargetByName(name);
        if (target != null) {
            throw new AlreadyKnownByVSwitch(target);
        }
        target = new ISCSITargetImpl(this.cluster);
        ((ISCSITargetImpl)target).setParameterList(parameterList);
        this.targetList.addTarget(target);
        ((PolicyManagerImpl)this.getCluster().getPolicyManager()).newTarget(target);
        return target;
    }

    public ISCSIRemoteTarget newISCSIRemoteTarget(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        CommKeyClassId fromVSwitch = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
        VSwitchImpl vswitch = (VSwitchImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(fromVSwitch);
        ISCSIInitiator[] iscsiInitiators = vswitch.getISCSIInitiators();
        boolean isISCSIInitiatorExisted = iscsiInitiators != null && iscsiInitiators.length > 0 && iscsiInitiators[0] != null;
        SrString remoteTargetName = (SrString)parameterList.get(ParameterCode.DISCOVERED_TARGET_NAME);
        String name = (String)remoteTargetName.value();
        ISCSIRemoteTarget remoteTarget = this.getRemoteTargetListMgr().getRemoteTargetByName(name);
        if (remoteTarget != null) {
            if (isISCSIInitiatorExisted) {
                ((ISCSIInitiatorImpl)iscsiInitiators[0]).addRemoteTarget(remoteTarget);
            }
            throw new AlreadyKnownByVSwitch(remoteTarget);
        }
        remoteTarget = new ISCSIRemoteTargetImpl(this.cluster);
        ((ISCSIRemoteTargetImpl)remoteTarget).setParameterList(parameterList);
        ISCSITarget localTarget = ((ISCSIRemoteTargetImpl)remoteTarget).getConfiguredAsLocalTargetOnSameCluster();
        if (localTarget != null) {
            logger.error(">>>> Cluster " + this.getCluster().getAlias() + " : Remote target " + remoteTarget.getName() + " is configured as a local target in the cluster " + this.cluster.getAlias());
        }
        this.m_remoteTargetList.addRemoteTarget(remoteTarget);
        if (isISCSIInitiatorExisted) {
            ((ISCSIInitiatorImpl)iscsiInitiators[0]).addRemoteTarget(remoteTarget);
        }
        return remoteTarget;
    }

    public ISCSIRemoteTargetPortal newISCSIRemoteTargetPortal(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        String ip = ((SrIpAddress)parameterList.get(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP)).toDisplayString();
        int port = ((BigInteger)((SrGauge)parameterList.get(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT)).value()).intValue();
        int groupTag = (Integer)((SrInteger)parameterList.get(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG)).value();
        CommKeyClassId remoteTargetParent = (CommKeyClassId)parameterList.get(ParameterCode.ISCSI_REMOTE_TARGET_ID);
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(remoteTargetParent);
        ISCSIRemoteTargetPortal remoteTargetPortal = null;
        if (remoteTarget != null) {
            remoteTargetPortal = remoteTarget.getPortalTableRow(ip, port, groupTag);
            if (remoteTargetPortal != null) {
                throw new AlreadyKnownByVSwitch(remoteTargetPortal);
            }
            remoteTargetPortal = new ISCSIRemoteTargetPortalImpl(this.cluster);
            ((ISCSIRemoteTargetPortalImpl)remoteTargetPortal).setParameterList(parameterList);
            remoteTarget.addPortal(remoteTargetPortal);
            return remoteTargetPortal;
        }
        return remoteTargetPortal;
    }

    public ISCSIRemotePortalDiscovery newISCSIRemotePortalDiscovery(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        String ip = ((SrIpAddress)parameterList.get(ParameterCode.REMOTE_PORTAL_DISC_ADDRESS)).toDisplayString();
        int port = (Integer)((SrInteger)parameterList.get(ParameterCode.REMOTE_PORTAL_DISC_PORT)).value();
        CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
        VSwitch vswitch = (VSwitch)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
        ISCSIInitiator[] iscsiInitiators = vswitch.getISCSIInitiators();
        ISCSIRemotePortalDiscovery remoteDiscoveryPortal = null;
        if (iscsiInitiators != null && iscsiInitiators.length > 0) {
            ISCSIInitiatorImpl initiator = (ISCSIInitiatorImpl)iscsiInitiators[0];
            remoteDiscoveryPortal = initiator.getRemoteDiscoveryPortal(ip, port);
            VSwitch otherVSwitchInCluster = ((ClusterImpl)this.getCluster()).getOtherVSwitch(vswitch);
            if (otherVSwitchInCluster != null) {
                ISCSIInitiator[] iscsiInitiatorsInOtherVSwitch = otherVSwitchInCluster.getISCSIInitiators();
                ISCSIRemotePortalDiscovery remoteDiscoveryPortalInOtherVSwitch = null;
                if (iscsiInitiatorsInOtherVSwitch != null && iscsiInitiatorsInOtherVSwitch.length > 0) {
                    ISCSIInitiatorImpl initiatorInOtherVSwitch = (ISCSIInitiatorImpl)iscsiInitiatorsInOtherVSwitch[0];
                    remoteDiscoveryPortalInOtherVSwitch = initiatorInOtherVSwitch.getRemoteDiscoveryPortal(ip, port);
                    if (remoteDiscoveryPortal == null && remoteDiscoveryPortalInOtherVSwitch == null) {
                        remoteDiscoveryPortal = new ISCSIRemotePortalDiscoveryImpl(this.cluster);
                        ((ISCSIRemotePortalDiscoveryImpl)remoteDiscoveryPortal).setOnInitProcess(true);
                        ((ISCSIRemotePortalDiscoveryImpl)remoteDiscoveryPortal).setParameterList(parameterList);
                        ((ISCSIRemotePortalDiscoveryImpl)remoteDiscoveryPortal).setOnInitProcess(false);
                        initiator.addRemoteDiscoveryPortal(remoteDiscoveryPortal);
                    } else if (remoteDiscoveryPortal == null && remoteDiscoveryPortalInOtherVSwitch != null) {
                        initiator.addRemoteDiscoveryPortal(remoteDiscoveryPortalInOtherVSwitch);
                        throw new AlreadyKnownByVSwitch(remoteDiscoveryPortalInOtherVSwitch);
                    }
                }
            } else if (remoteDiscoveryPortal == null) {
                remoteDiscoveryPortal = new ISCSIRemotePortalDiscoveryImpl(this.cluster);
                ((ISCSIRemotePortalDiscoveryImpl)remoteDiscoveryPortal).setOnInitProcess(true);
                ((ISCSIRemotePortalDiscoveryImpl)remoteDiscoveryPortal).setParameterList(parameterList);
                ((ISCSIRemotePortalDiscoveryImpl)remoteDiscoveryPortal).setOnInitProcess(false);
                initiator.addRemoteDiscoveryPortal(remoteDiscoveryPortal);
            }
        }
        return remoteDiscoveryPortal;
    }

    public SCSITargetPort newSCSITargetPort(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        SCSITargetPortImpl targetPort = new SCSITargetPortImpl(this.cluster);
        targetPort.setParameterList(parameterList);
        ISCSITarget target = targetPort.getTarget();
        if (target != null) {
            ((ISCSITargetImpl)target).addSCSIPort(targetPort);
        }
        return targetPort;
    }

    public LUIdentifier newLUIdentifier(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        LUIdentifierImpl luId = new LUIdentifierImpl(this.cluster);
        luId.setParameterList(parameterList);
        return luId;
    }

    public LU newLU(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        CommKeyClassId parent = (CommKeyClassId)parameterList.get(ParameterCode.LU_PARENT);
        TargetImpl target = (TargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(parent);
        LU lu = null;
        if (target != null) {
            SrGauge lun = (SrGauge)parameterList.get(ParameterCode.LU_LUN_NUMBER);
            try {
                int intValOfLu = Integer.parseInt(lun.longVal().toString());
                lu = target.getLU(intValOfLu);
            }
            catch (NumberFormatException nfe) {
                logger.error("LUN " + lun + " is not a valid number.  The target is " + target + " in cluster " + this.getCluster(), nfe);
            }
        }
        if (lu != null) {
            VolumeNode volume = lu.getVolumeChild();
            CommKeyClassId volumeCommKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.LU_VOLUME_ID);
            VolumeNode newVolume = (VolumeNode)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(volumeCommKeyClassId);
            if (newVolume.equals(volume)) {
                throw new AlreadyKnownByVSwitch(lu);
            }
        }
        lu = new LUImpl(this.cluster);
        ((LUImpl)lu).setParameterList(parameterList);
        this.targetList.addLU(lu);
        return lu;
    }

    public SCSILunImpl newSCSILun(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        CommKeyClassId parentTargetKey = this.cluster.getISCSIId((CommKeyClassId)parameterList.get(ParameterCode.SCSI_DEVICE_ID));
        TargetImpl parent = (TargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(parentTargetKey);
        SCSILunImpl scsiLun = null;
        if (parent != null) {
            LUImpl lu = (LUImpl)parent.getLU(((SrScsiLUNFormat)parameterList.get(ParameterCode.SCSI_LUN_LU_NUMBER)).toInt());
            if (lu != null) {
                scsiLun = lu.getScsiLun();
                if (scsiLun != null) {
                    throw new AlreadyKnownByVSwitch(scsiLun);
                }
                scsiLun = new SCSILunImpl(this.cluster, lu);
                lu.setScsiLun(scsiLun);
                scsiLun.setParameterList(parameterList);
            } else {
                logger.error("Trying to create a SCSILun failed due to inconsistency: couldn't find matching LU in the Target parent");
            }
        } else {
            logger.error("Trying to create a SCSILun failed due to inconsistency: couldn't find Target parent");
        }
        return scsiLun;
    }

    public SubDirectAccessDevice newSubDirectAccessDevice(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        CommKeyClassId parent = (CommKeyClassId)parameterList.get(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID);
        DirectAccessDeviceImpl directAccessDevice = (DirectAccessDeviceImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(parent);
        SubDirectAccessDevice subStorageDevice = null;
        if (directAccessDevice != null) {
            BigInteger endAddr = (BigInteger)((SrLunFormat)parameterList.get(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR)).value();
            subStorageDevice = directAccessDevice.getSubDirectAccessDevice(endAddr);
        }
        if (subStorageDevice != null) {
            throw new AlreadyKnownByVSwitch(subStorageDevice);
        }
        subStorageDevice = new SubDirectAccessDeviceImpl(this.cluster);
        try {
            subStorageDevice.setParameterList(parameterList);
        }
        catch (NullPointerException npe) {
            logger.error(npe.getMessage());
            subStorageDevice = null;
        }
        return subStorageDevice;
    }

    public SequentialAccessDevice newSequentialAccessDevice(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        SequentialAccessDevice storageDevice = (SequentialAccessDevice)this.storagePool.getSCSIDeviceParameterList(this.getCluster(), parameterList);
        if (storageDevice != null) {
            throw new AlreadyKnownByVSwitch(storageDevice);
        }
        storageDevice = new SequentialAccessDeviceImpl(this.cluster);
        ((SequentialAccessDeviceImpl)storageDevice).setParameterList(parameterList);
        this.storagePool.addStorage(storageDevice);
        return storageDevice;
    }

    public GeneralSCSIDevice newGeneralSCSIDevice(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        GeneralSCSIDevice storageDevice = this.storagePool.getSCSIDeviceParameterList(this.getCluster(), parameterList);
        if (storageDevice != null) {
            throw new AlreadyKnownByVSwitch(storageDevice);
        }
        storageDevice = new GeneralSCSIDeviceImpl(this.cluster);
        ((GeneralSCSIDeviceImpl)storageDevice).setParameterList(parameterList);
        this.storagePool.addStorage(storageDevice);
        return storageDevice;
    }

    public DirectAccessDevice newDirectAccessDevice(HashMap parameterList) throws RemoteException, AlreadyKnownByVSwitch, IllegalValueException {
        DirectAccessDevice storageDevice = (DirectAccessDevice)this.storagePool.getSCSIDeviceParameterList(this.getCluster(), parameterList);
        if (storageDevice != null) {
            throw new AlreadyKnownByVSwitch(storageDevice);
        }
        storageDevice = new DirectAccessDeviceImpl(this.cluster);
        ((DirectAccessDeviceImpl)storageDevice).setParameterList(parameterList);
        this.storagePool.addStorage(storageDevice);
        return storageDevice;
    }

    public GeneralSCSIDevice removeGeneralSCSIDevice(GeneralSCSIDeviceImpl generalSCSIDevice) throws RemoteException {
        if (generalSCSIDevice.getConnectedVSwitchCounter() == 1) {
            this.storagePool.removeStorage(generalSCSIDevice);
        }
        return generalSCSIDevice;
    }

    public SequentialAccessDevice removeSequentialAccessDevice(SequentialAccessDeviceImpl sequentialAccessDevice) throws RemoteException {
        return (SequentialAccessDevice)this.removeGeneralSCSIDevice(sequentialAccessDevice);
    }

    public DirectAccessDevice removeDirectAccessDevice(DirectAccessDeviceImpl directAccessDevice) throws RemoteException {
        return (DirectAccessDevice)this.removeGeneralSCSIDevice(directAccessDevice);
    }

    public SubDirectAccessDevice removeSubDirectAccessDevice(SubDirectAccessDeviceImpl subDirectAccessDevice) throws RemoteException {
        if (subDirectAccessDevice.getConnectedVSwitchCounter() == 1) {
            DirectAccessDeviceImpl parent = (DirectAccessDeviceImpl)subDirectAccessDevice.getDirectAccessDeviceParent();
            parent.removeSubDirectAccessDevice(subDirectAccessDevice);
        }
        return subDirectAccessDevice;
    }

    public LU removeLU(LUImpl lu) throws RemoteException {
        if (lu.getConnectedVSwitchCounter() == 1) {
            VolumeNodeImpl volume = (VolumeNodeImpl)this.targetList.removeLU(lu);
            ((StorageImpl)this.cluster.getStorage()).returnVolumeToForest(volume);
        }
        return lu;
    }

    public SCSILunImpl removeSCSILun(SCSILunImpl scsiLun) throws RemoteException {
        if (scsiLun.getConnectedVSwitchCounter() == 1) {
            LUImpl lu;
            CommKeyClassId parentTargetKey = scsiLun.getSCSITargetID();
            TargetImpl parent = (TargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(parentTargetKey);
            if (parent != null && (lu = (LUImpl)parent.getLU(scsiLun.getLUN())) != null) {
                lu.setScsiLun(null);
            }
        }
        return scsiLun;
    }

    public boolean returnVolumeToForest(VolumeNodeImpl volume) throws RemoteException {
        if (this.volumeForest.getAll().contains(volume)) {
            return false;
        }
        VolumeImpl parentVol = (VolumeImpl)volume.getParentVolume();
        if (parentVol != null) {
            parentVol.removeChild(volume);
            parentVol.removePropagationStateDependentObjectAndListener(volume);
        } else {
            LUImpl lu = (LUImpl)volume.getParentLU();
            if (lu == null) {
                return false;
            }
            lu.removeVol(volume);
            lu.removePropagationStateDependentObjectAndListener(volume);
        }
        volume.setExposed(false);
        volume.setParentLU(null);
        volume.setParent(null, 0);
        if (volume instanceof Volume) {
            this.volumeForest.addVolume((Volume)((Object)volume));
            Vector leafs = ((Volume)((Object)volume)).getLeafs();
            Enumeration e = leafs.elements();
            while (e.hasMoreElements()) {
                this.cluster.addPropagationStateDependentObjectAndListener((LogicObjectImpl)e.nextElement());
            }
        } else {
            this.cluster.addPropagationStateDependentObjectAndListener(volume);
        }
        AlarmMgrImpl.getInstance().setAlarmsOnAllVSwitchesIfNeed(volume);
        return true;
    }

    public Target removeTarget(TargetImpl target) throws RemoteException {
        if (target.getConnectedVSwitchCounter() == 1) {
            this.targetList.removeTarget(target);
        }
        return target;
    }

    public ISCSIRemoteTarget removeRemoteTarget(ISCSIRemoteTargetImpl remoteTarget) throws RemoteException {
        if (remoteTarget.getConnectedVSwitchCounter() == 1) {
            this.getRemoteTargetListMgr().removeRemoteTarget(remoteTarget);
        }
        return remoteTarget;
    }

    public ISCSIRemoteTargetPortal removeRemoteTargetPortal(ISCSIRemoteTargetPortalImpl remoteTargetPortal) throws RemoteException {
        if (remoteTargetPortal.getConnectedVSwitchCounter() == 1) {
            ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)remoteTargetPortal.getRemoteTarget();
            remoteTarget.removePortal(remoteTargetPortal);
        }
        return remoteTargetPortal;
    }

    public Volume removeVolume(VolumeImpl volume, VSwitch vSwitch) throws RemoteException {
        Vector mySnapshots;
        boolean result;
        if (volume.getConnectedVSwitchCounter() == 1 && (result = this.volumeForest.removeVolumeTreeRoot(volume))) {
            Vector children = volume.getChildren();
            Enumeration e = children.elements();
            while (e.hasMoreElements()) {
                VolumeNodeImpl childNode;
                Object child = e.nextElement();
                if (!(child instanceof Storageable) || !volume.equals((childNode = (VolumeNodeImpl)child).getParentVolume())) continue;
                childNode.setFree(true);
                childNode.setParent(null, -1);
            }
        }
        SnapshotManager snapMgr = this.volumeManager.getSnapshotManager();
        if (volume.getClassId().equals(ClassID.SNAPSHOT_VOLUME)) {
            snapMgr.removeSnapshot((SnapshotVolume)((Object)volume), vSwitch);
            VolumeNodeImpl snapshotSource = (VolumeNodeImpl)((SnapshotVolumeImpl)volume).getSourceVolume(vSwitch);
            VSwitch otherVs = this.cluster.getOtherVSwitch(vSwitch);
            VolumeNodeImpl otherSnapSource = (VolumeNodeImpl)((SnapshotVolumeImpl)volume).getSourceVolume(otherVs);
            if (snapshotSource != null && !snapshotSource.equals(otherSnapSource)) {
                snapshotSource.removeSynchronizeListener(volume);
                snapshotSource.removePropagatedStateEventListener(volume);
            }
        }
        if (snapMgr.isSourceOfSnapshot(volume) && (mySnapshots = snapMgr.getSnapshotsForSourceVolume(volume, vSwitch)) != null) {
            Iterator itr = mySnapshots.iterator();
            while (itr.hasNext()) {
                ConfigElementData element = new ConfigElementData(((VolumeNode)itr.next()).getCommKeyClassId());
                element.setValue(ParameterCode.SNAPSHOT_VOLUME_SOURCE, (SrType)null);
                SrType[] vSwitchData = new CommKeyClassId[]{vSwitch.getCommKeyClassId()};
                element.setValues(ParameterCode.VSWITCH_ID, vSwitchData);
                DataMgr.getInstance().readElement(element);
            }
        }
        Iterator iter = volume.getChildren().iterator();
        while (iter.hasNext()) {
            VolumeNodeImpl child = (VolumeNodeImpl)iter.next();
            AlarmMgrImpl.getInstance().setAlarmsOnAllVSwitchesIfNeed(child);
        }
        return volume;
    }

    public void clear() throws RemoteException {
        this.storagePool.removeAll();
        this.volumeManager.clear();
        this.getRemoteTargetListMgr().removeAll();
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        int storageRetVal;
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        int retVal = 0;
        try {
            storageRetVal = this.storagePool.synchronize();
            if (storageRetVal > retVal) {
                retVal = storageRetVal;
            }
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            errMsg.append(ive.getMessage());
            errOccured = true;
        }
        try {
            storageRetVal = this.targetList.synchronize();
            if (storageRetVal > retVal) {
                retVal = storageRetVal;
            }
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            errMsg.append(ive.getMessage());
            errOccured = true;
        }
        try {
            this.volumeForest.synchronize();
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            errMsg.append(ive.getMessage());
            errOccured = true;
        }
        try {
            int storageRetVal2 = this.getRemoteTargetListMgr().synchronize();
            if (storageRetVal2 > retVal) {
                retVal = storageRetVal2;
            }
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            errMsg.append(ive.getMessage());
            errOccured = true;
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return 0;
    }

    public Cluster getCluster() throws RemoteException {
        return this.cluster;
    }

    public void readSnapshotVolumes() throws RemoteException {
        this.volumeManager.readSnapshotVolumes();
    }

    private CommKeyClassId[] getChildrenDataByPosition(Object children, VSwitch vswitch) throws RemoteException {
        CommKeyClassId[] childrenCommKeys;
        if (children instanceof Vector) {
            childrenCommKeys = new CommKeyClassId[((Vector)children).size()];
            int childPosition = 0;
            Enumeration e = ((Vector)children).elements();
            while (e.hasMoreElements()) {
                Integer position;
                VolumeNodeImpl child = (VolumeNodeImpl)e.nextElement();
                childPosition = vswitch != null ? ((position = child.getPositionInParent(vswitch)) != null ? position : ++childPosition) : ++childPosition;
                childrenCommKeys[childPosition - 1] = child.getCommKeyClassId();
            }
        } else {
            childrenCommKeys = new CommKeyClassId[1];
            LogicObject child = (LogicObject)children;
            childrenCommKeys[0] = child.getCommKeyClassId();
        }
        return childrenCommKeys;
    }

    private CommKeyClassId[] getVSwitchesAllChildrenExistIn(Object children) throws IllegalValueException {
        try {
            Vector vSwitchesToSet = (Vector)this.cluster.getVSwitches().clone();
            if (children instanceof Vector) {
                Iterator itr = ((Vector)children).iterator();
                while (itr.hasNext()) {
                    AliasObjectImpl child = (AliasObjectImpl)itr.next();
                    if (child.isRedundant()) continue;
                    VSwitch[] childVSwitch = child.getConnectedVSwitches();
                    Iterator vSwitches = vSwitchesToSet.iterator();
                    while (vSwitches.hasNext()) {
                        boolean wasFound = false;
                        VSwitch vSwitch = (VSwitch)vSwitches.next();
                        for (int i = 0; i < childVSwitch.length; ++i) {
                            if (!childVSwitch[i].equals(vSwitch)) continue;
                            wasFound = true;
                            break;
                        }
                        if (wasFound) continue;
                        vSwitches.remove();
                    }
                }
                if (vSwitchesToSet.size() == 0) {
                    throw new IllegalValueException("Children volumes do not exist in the same VSwitches.");
                }
                CommKeyClassId[] retVal = new CommKeyClassId[vSwitchesToSet.size()];
                for (int i = 0; i < vSwitchesToSet.size(); ++i) {
                    retVal[i] = ((VSwitch)vSwitchesToSet.elementAt(i)).getCommKeyClassId();
                }
                return retVal;
            }
            VSwitch[] connectedVSwitches = ((VolumeNodeImpl)children).getConnectedVSwitches();
            CommKeyClassId[] retVal = new CommKeyClassId[connectedVSwitches.length];
            for (int i = 0; i < connectedVSwitches.length; ++i) {
                retVal[i] = connectedVSwitches[i].getCommKeyClassId();
            }
            return retVal;
        }
        catch (RemoteException re) {
            logger.error(re);
            return new CommKeyClassId[0];
        }
    }

    public VSwitch getVSwitch(HashMap parameterList) throws RemoteException {
        Object vSwitchObj = parameterList.get(ParameterCode.VSWITCH_ID);
        if (vSwitchObj != null) {
            CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)vSwitchObj;
            VSwitch vSwitch = (VSwitch)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
            return vSwitch;
        }
        return null;
    }

    public boolean areVolumesConnectedToRemoteTarget(String remoteTargetName) throws RemoteException {
        GeneralSCSIDevice[] remoteTargetStorages = this.storagePool.getStoragesByEntityName(remoteTargetName);
        return remoteTargetStorages != null && remoteTargetStorages.length > 0;
    }

    public Vector getOtherVolumesConnectedToEntityName(String entityName, GeneralSCSIDevice excludeSCSIDevice) throws RemoteException {
        GeneralSCSIDevice[] storages = this.storagePool.getStoragesByEntityName(entityName);
        Vector<GeneralSCSIDevice> otherStorages = new Vector<GeneralSCSIDevice>(storages.length);
        for (int index = 0; index < storages.length; ++index) {
            if (excludeSCSIDevice.equals(storages[index])) continue;
            otherStorages.add(storages[index]);
        }
        return otherStorages;
    }

    public ISCSIRemoteTarget getRemoteTargetByName(String name) throws RemoteException {
        return this.getRemoteTargetListMgr().getRemoteTargetByName(name);
    }

    public JournalVolume getJournalVolume(VSwitch vswitch) throws RemoteException {
        Vector list = this.getVolumeForest();
        for (int i = 0; i < list.size(); ++i) {
            VolumeTree currTree = (VolumeTree)list.get(i);
            VolumeNode currNode = currTree.getTreeRoot();
            if (!(currNode instanceof JournalVolume)) continue;
            CommKeyClassId vswitchData = vswitch.getCommKeyClassId();
            VSwitchImpl vSwitch = (VSwitchImpl)SystemRootImpl.getInstance().getRefByStub(vswitchData);
            if (!currNode.getActiveVswitch().equals(vSwitch)) continue;
            return (JournalVolume)currNode;
        }
        return null;
    }

    public Storageable getStorageByAlias(String alias) throws RemoteException {
        return this.storagePool.getStorageByAlias(alias);
    }

    public Volume getVolumeByAlias(String alias) throws RemoteException {
        return this.volumeForest.getVolumeByAlias(alias);
    }

    public void discoverRemoteTargets(ISCSIRemotePortalDiscovery[] remoteDiscoveryPortals) throws RemoteException, IllegalValueException {
        if (remoteDiscoveryPortals != null) {
            for (int index = 0; index < remoteDiscoveryPortals.length; ++index) {
                remoteDiscoveryPortals[index].discoverRemoteTargets();
            }
        }
    }

    public void activateDeactivateSnapshots(SnapshotVolume[] snapshots, SnapshotActivateTypeConstants sat) throws RemoteException, IllegalValueException {
        for (int index = 0; index < snapshots.length; ++index) {
            snapshots[index].changeElement(ClientParameterCode.SNAPSHOT_ACTIVATE, sat);
        }
    }
}

