/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.statistics;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ClientStateEvent;
import com.sanrad.nms.server.logic.ClientStateListener;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.statistics.Statistics;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrType;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class StatisticsImpl
extends TableRowImpl
implements Statistics,
ClientStateListener {
    private static final int POLL_INTERVAL = 5;
    protected HashMap s_parametersToCalculateMap = null;
    private HashMap m_lastValues = null;
    private HashMap m_clientRates = new HashMap();
    private CommKeyClassId m_activeVSwitchCommkeyClassId = null;

    protected StatisticsImpl(ClusterImpl cluster, ClassID classId, List parameterCodeList, HashMap parametersToCalculateCodeMap) throws RemoteException {
        super(cluster, classId, parameterCodeList);
        this.setParametersToCalculateMap(parametersToCalculateCodeMap);
        EventServiceImpl.getInstance().addClientStateListener(this);
    }

    protected String canBeDeleted() {
        throw new UnsupportedOperationException("This statistics element cannot be deleted " + this.toString());
    }

    protected String isValid(HashMap parameterList) {
        throw new UnsupportedOperationException("This element cannot be changed " + this.toString());
    }

    private void setParametersToCalculateMap(HashMap parametersToCalculateMap) {
        this.s_parametersToCalculateMap = parametersToCalculateMap;
    }

    private HashMap getParametersToCalculateMap() {
        return this.s_parametersToCalculateMap;
    }

    protected abstract PollingGroupType getGroupType();

    public void startPolling() throws RemoteException {
        DataMgr.getInstance().startPollingProcess(this.getActiveVswitch().getCommKeyClassId(), this.getGroupType());
        logger.debug(this + ": " + ClassID.VSWITCH + " " + this.getActiveVswitch() + " start polling");
    }

    public int stopPolling() throws RemoteException, IllegalValueException {
        this.clearParameterList();
        CommKeyClassId vswitchData = this.getActiveVswitch() == null ? this.m_activeVSwitchCommkeyClassId : this.getActiveVswitch().getCommKeyClassId();
        DataMgr.getInstance().stopPollingProcess(vswitchData, this.getGroupType());
        this.m_lastValues = null;
        logger.debug(this + ": " + ClassID.VSWITCH + " " + vswitchData + " stop polling");
        return 0;
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        if (this.m_lastValues == null) {
            this.m_lastValues = new HashMap();
        }
        HashMap<ClientParameterCode, Long> clientRates = new HashMap<ClientParameterCode, Long>();
        HashMap calculationParams = this.getParametersToCalculateMap();
        Iterator i = calculationParams.keySet().iterator();
        while (i.hasNext()) {
            ParameterCode currParam = (ParameterCode)i.next();
            if (!parameterList.containsKey(currParam)) continue;
            ClientParameterCode clientParamCode = (ClientParameterCode)calculationParams.get(currParam);
            if (!this.m_lastValues.containsKey(currParam) || this.m_lastValues.get(currParam) == null) {
                this.m_lastValues.put(currParam, parameterList.get(currParam));
                continue;
            }
            SrType srValue = (SrType)this.m_lastValues.get(currParam);
            long diff = ((Number)((SrType)parameterList.get(currParam)).value()).longValue() - ((Number)srValue.value()).longValue();
            long rate = diff / 5L;
            Long rateInt = new Long(rate);
            this.m_lastValues.put(currParam, parameterList.get(currParam));
            clientRates.put(clientParamCode, rateInt);
        }
        this.m_clientRates = clientRates;
        this.m_activeVSwitchCommkeyClassId = this.getActiveVswitch().getCommKeyClassId();
        return changedValues;
    }

    public HashMap getClientRates() {
        return this.m_clientRates;
    }

    public void remoteClientClosed(ClientStateEvent e) {
        if (e.getNumberOfCurrentRemoteClients() == 0) {
            try {
                this.stopPolling();
            }
            catch (RemoteException re) {
                logger.error(re);
            }
            catch (IllegalValueException ive) {
                logger.error(ive);
            }
        }
    }

    public VSwitch getDominentVswitch() throws RemoteException {
        return this.getParentVSwitch();
    }

    protected void finalize() throws Throwable {
        EventServiceImpl.getInstance().removeClientStateListener(this);
        super.finalize();
    }

    public void clearParameterList() throws RemoteException {
    }

    public void clear() throws RemoteException {
        super.clear();
        EventServiceImpl.getInstance().removeClientStateListener(this);
    }
}

