/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.srv.radius;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.srv.ExternalServerValidator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.util.NetUtil;
import java.rmi.RemoteException;

public class RadiusServerValidator
extends ExternalServerValidator {
    public static final int MAX_RADIUS_SERVERS = 2;
    private String port;
    private String key;

    public RadiusServerValidator(Cluster cluster, String serverIp, String port, String key) {
        this.cluster = cluster;
        this.port = port;
        this.key = key;
        this.serverIp = serverIp;
    }

    public boolean isValid() throws RemoteException {
        if (((ClusterImpl)this.cluster).getRadiusServersList().getAllServers().size() == 2) {
            this.setErrorMsg(ErrorMessage.MAX_RADIUS_SERVERS_IN_SYSTEM.getMessage(this.serverIp));
            return false;
        }
        if (this.serverIp.equals("")) {
            this.setErrorMsg("IP of " + ClassID.RADIUS_SERVER + " cannot be empty");
            return false;
        }
        if (!NetUtil.isNetworkIpValid(this.serverIp)) {
            this.setErrorMsg("IP " + this.serverIp + " is not valid");
            return false;
        }
        if (((ClusterImpl)this.cluster).getRadiusServersList().isServerExist(this.serverIp)) {
            String[] errorBody = new String[]{ClassID.RADIUS_SERVER.toString(), this.serverIp};
            this.setErrorMsg(ErrorMessage.SERVER_ALREADY_EXIST.getMessage(errorBody));
            return false;
        }
        return true;
    }
}

