/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.srv.radius;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.srv.radius.RadiusServerAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.srv.ExternalServerImpl;
import com.sanrad.nms.server.logic.srv.ExternalServerList;
import com.sanrad.nms.server.logic.srv.radius.RadiusServer;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class RadiusServerImpl
extends ExternalServerImpl
implements RadiusServer {
    private static List parameterCodeList;

    public RadiusServerImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.RADIUS_SERVER, parameterCodeList);
    }

    public Integer getRadiusServerPort() throws RemoteException {
        return this.getRadiusServerPort(null);
    }

    public Integer getRadiusServerPort(VSwitch vSwitch) throws RemoteException {
        return (Integer)this.getValueOf(vSwitch, ParameterCode.RADIUS_SERVER_PORT, vSwitch == null);
    }

    public String getRadiusServerKey() throws RemoteException {
        return this.getRadiusServerKey(null);
    }

    public String getRadiusServerKey(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.RADIUS_SERVER_KEY, vSwitch == null);
    }

    public String getServerIP(VSwitch vSwitch) throws RemoteException {
        return this.getDisplayStringOf(vSwitch, ParameterCode.RADIUS_SERVER_IP_ADDRESS, vSwitch == null);
    }

    public String getAlias() throws RemoteException {
        return this.getServerIP();
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        return "";
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!super.isRedundant()) {
            logger.debug("Synchronizing: creating Radius server on other " + ClassID.VSWITCH);
            this.cluster.createRadiusServer(this.getServerIP(), this.getRadiusServerPort().toString(), this.getRadiusServerKey(), this.cluster.getOtherVSwitches(this.getVSwitches()));
            return 2;
        }
        return 0;
    }

    protected String canBeDeleted() throws RemoteException {
        Identity identity = this.getIdentityUsingRADIUS();
        if (identity != null && this.isLastOneInCluster()) {
            String msg = "The " + this.getClassId() + " " + this + " is being used by an " + identity.getClassId() + " " + identity + " for access control.  First remove the " + this.getClassId() + " from the " + identity.getClassId() + " and then delete it.";
            return msg;
        }
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return RadiusServerAlarmGenerator.getInstatnce();
    }

    public String toString() {
        return this.serverIpAddress;
    }

    public Identity getIdentityUsingRADIUS() throws RemoteException {
        return ((ClusterImpl)this.getCluster()).getIdentityUsingRADIUS(this);
    }

    public boolean isLastOneInCluster() throws RemoteException {
        ExternalServerList list = ((ClusterImpl)this.getCluster()).getRadiusServersList();
        return list.size() == 1;
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.RADIUS_SERVER_IP_ADDRESS);
        parameterCodes.addElement(ParameterCode.RADIUS_SERVER_PORT);
        parameterCodes.addElement(ParameterCode.RADIUS_SERVER_KEY);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

