/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.srv.isns;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.srv.ExternalServerValidator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.util.NetUtil;
import java.rmi.RemoteException;

public class ISNSServerValidator
extends ExternalServerValidator {
    private static final int MAX_ISNS_SERVERS = 2;

    public ISNSServerValidator(Cluster cluster, String serverIp) {
        this.cluster = cluster;
        this.serverIp = serverIp;
    }

    public boolean isValid() throws RemoteException {
        if (((ClusterImpl)this.cluster).getISNSServersList().getAllServers().size() == 2) {
            this.setErrorMsg(ErrorMessage.MAX_ISNS_SERVERS_IN_SYSTEM.getMessage(this.serverIp));
            return false;
        }
        if (this.serverIp.equals("")) {
            this.setErrorMsg("IP of " + ClassID.ISNS_SERVER + " cannot be empty");
            return false;
        }
        if (!NetUtil.isNetworkIpValid(this.serverIp)) {
            this.setErrorMsg("IP " + this.serverIp + " is not valid");
            return false;
        }
        if (((ClusterImpl)this.cluster).getISNSServersList().isServerExist(this.serverIp)) {
            String[] errorBody = new String[]{ClassID.ISNS_SERVER.toString(), this.serverIp};
            this.setErrorMsg(ErrorMessage.SERVER_ALREADY_EXIST.getMessage(errorBody));
            return false;
        }
        return true;
    }
}

