/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.srv.isns;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.srv.isns.ISNSServerAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.srv.ExternalServerImpl;
import com.sanrad.nms.server.logic.srv.isns.ISNSServer;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ISNSServerImpl
extends ExternalServerImpl
implements ISNSServer {
    private static List parameterCodeList;

    public ISNSServerImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    public String getAlias() throws RemoteException {
        return this.getServerIP();
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        return "";
    }

    public String getServerIP(VSwitch vSwitch) throws RemoteException {
        return this.getDisplayStringOf(vSwitch, ParameterCode.ISNS_SERVER_IP_ADDRESS, vSwitch == null);
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!super.isRedundant()) {
            logger.debug("Synchronizing: creating ISNS server on other " + ClassID.VSWITCH);
            this.cluster.createISNSServer(this.getServerIP(), this.cluster.getOtherVSwitches(this.getVSwitches()));
            return 2;
        }
        return 0;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return ISNSServerAlarmGenerator.getInstatnce();
    }

    public String toString() {
        return "iSNS server-" + this.serverIpAddress;
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.ISNS_SERVER_IP_ADDRESS);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

