/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.srv;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.srv.ExternalServer;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ExternalServerList {
    private Hashtable serverList;
    private Log logger = LogMgr.getServerLog();

    public ExternalServerList() {
        this.serverList = new Hashtable();
    }

    public void addExternalServer(ExternalServer server) throws RemoteException {
        this.serverList.put(server.getServerIP(), server);
    }

    public Object getExternalServerByIP(String ip) {
        return this.serverList.get(ip);
    }

    public void removeExternalServerByIP(String ip) {
        this.serverList.remove(ip);
    }

    public void removeExternalServer(ExternalServer server) throws RemoteException {
        this.serverList.remove(server.getServerIP());
    }

    public Vector getAllServers() {
        Vector<ExternalServer> servers = new Vector<ExternalServer>(this.serverList.size());
        Enumeration e = this.serverList.elements();
        while (e.hasMoreElements()) {
            ExternalServer server = (ExternalServer)e.nextElement();
            servers.addElement(server);
        }
        return servers;
    }

    public boolean isServerExist(String ipAddress) {
        return this.serverList.containsKey(ipAddress);
    }

    public boolean synchronize() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        Enumeration e = this.serverList.elements();
        while (e.hasMoreElements()) {
            ExternalServer extServer = (ExternalServer)e.nextElement();
            try {
                extServer.synchronize();
            }
            catch (IllegalValueException ive) {
                errMsg.append("\n");
                errMsg.append(ive.getMessage());
                errOccured = true;
                this.logger.warning(ive.getMessage() + " when trying to synchronize " + extServer.getClassId() + " " + extServer);
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return false;
    }

    public boolean isServerExistOnVSwitches(Vector vSwitches) throws RemoteException {
        Enumeration servers = this.serverList.elements();
        while (servers.hasMoreElements()) {
            ExternalServer server = (ExternalServer)servers.nextElement();
            VSwitch[] connectedVSwitches = server.getConnectedVSwitchesList();
            for (int i = 0; i < connectedVSwitches.length; ++i) {
                if (!vSwitches.contains(connectedVSwitches[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.serverList.clear();
        this.serverList = new Hashtable();
    }

    public int size() {
        return this.serverList.size();
    }
}

