/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.scsi;

import com.sanrad.nms.server.util.CommKeyClassId;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SCSIISCSIDeviceMap {
    private HashMap m_map = new HashMap();
    private StringBuffer m_mapLog = new StringBuffer();

    public void addEntryToMap(CommKeyClassId scsiId, CommKeyClassId iscsiId) throws RemoteException {
        this.m_map.put(scsiId, iscsiId);
        this.m_mapLog.append(">>>> SCSIISCSIDeviceMap: Added entry <" + scsiId + ":" + iscsiId + ">\n");
        this.m_map.put(iscsiId, scsiId);
        this.m_mapLog.append(">>>> SCSIISCSIDeviceMap: Added entry <" + iscsiId + ":" + scsiId + ">\n");
    }

    public void removeEntryFromMap(CommKeyClassId iscsiId) {
        CommKeyClassId scsiId = (CommKeyClassId)this.m_map.get(iscsiId);
        this.m_map.remove(iscsiId);
        this.m_mapLog.append(">>>> SCSIISCSIDeviceMap: Removed entry <" + iscsiId + ":" + scsiId + ">\n");
        this.m_map.remove(scsiId);
        this.m_mapLog.append(">>>> SCSIISCSIDeviceMap: Removed entry <" + scsiId + ":" + iscsiId + ">\n");
    }

    public void clearAllEntries() {
        this.m_map.clear();
        this.m_mapLog = new StringBuffer();
    }

    public CommKeyClassId getISCSIId(CommKeyClassId scsiId) {
        return this.getOppositeId(scsiId);
    }

    public CommKeyClassId getSCSIId(CommKeyClassId iscsiId) {
        return this.getOppositeId(iscsiId);
    }

    private CommKeyClassId getOppositeId(CommKeyClassId id) {
        CommKeyClassId retId = (CommKeyClassId)this.m_map.get(id);
        return retId;
    }

    public void printMap(String clusterAlias) {
        System.err.println(">>>>>");
        System.err.println(">>>>> " + clusterAlias + ": Current state in iscsi-scsi ids map is:");
        Set keys = this.m_map.keySet();
        Iterator i = this.m_map.keySet().iterator();
        while (i.hasNext()) {
            CommKeyClassId commkeyKEY = (CommKeyClassId)i.next();
            CommKeyClassId commkeyVALUE = (CommKeyClassId)this.m_map.get(commkeyKEY);
            System.err.println(">>>>> " + clusterAlias + ": <" + commkeyKEY + "=" + commkeyVALUE + ">");
        }
        System.err.println(">>>>>");
        System.err.println(">>>>> " + clusterAlias + ": start map log");
        System.err.println(this.m_mapLog.toString());
        System.err.println(">>>>> " + clusterAlias + ": end map log");
    }
}

