/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.scsi;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.scsi.SCSIDevice;
import com.sanrad.nms.server.logic.scsi.SCSIPort;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.SCSIDeviceRoleConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public abstract class SCSIDeviceImpl
extends SynchronizeableImpl
implements SCSIDevice {
    public static final int MAX_WWWI_LEN = 223;
    private ArrayList m_scsiPorts = new ArrayList();
    private static List parameterCodeList;

    protected SCSIDeviceImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        return 0;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public CommKeyClassId getSCSIDeviceId() throws RemoteException {
        return this.getSCSIDeviceId(null);
    }

    public CommKeyClassId getSCSIDeviceId(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId commkeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.SCSI_DEVICE_ID, vSwitch == null);
        return commkeyClassId;
    }

    public abstract String getAlias() throws RemoteException;

    public abstract String getAlias(VSwitch var1) throws RemoteException;

    public abstract String getName() throws RemoteException;

    public abstract String getName(VSwitch var1) throws RemoteException;

    public SCSIDeviceRoleConstant getRole() throws RemoteException {
        return this.getRole(null);
    }

    public SCSIDeviceRoleConstant getRole(VSwitch vSwitch) throws RemoteException {
        return (SCSIDeviceRoleConstant)this.getValueOf(vSwitch, ParameterCode.SCSI_DEVICE_ROLE, vSwitch == null);
    }

    public Integer getNumberOfPorts() throws RemoteException {
        return this.getNumberOfPorts(null);
    }

    public Integer getNumberOfPorts(VSwitch vSwitch) throws RemoteException {
        return (Integer)this.getValueOf(vSwitch, ParameterCode.SCSI_DEVICE_NUM_OF_PORTS, vSwitch == null);
    }

    public SCSIPort[] getPorts() throws RemoteException {
        SCSIPort[] array = new SCSIPort[this.m_scsiPorts.size()];
        return this.m_scsiPorts.toArray(array);
    }

    public void addSCSIPort(SCSIPort port) {
        this.m_scsiPorts.add(port);
    }

    public void removeSCSIPort(SCSIPort port) {
        this.m_scsiPorts.remove(port);
    }

    public void clear() throws RemoteException {
        this.m_scsiPorts.clear();
        super.clear();
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.SCSI_DEVICE_ROLE);
        parameterCodes.addElement(ParameterCode.SCSI_DEVICE_NUM_OF_PORTS);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

