/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.scsi;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.scsi.RemoteTarget;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.RemoteTargetFailureTypeConstant;
import com.sanrad.nms.server.util.types.constants.RemoteTargetLoginStatusConstant;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public abstract class RemoteTargetImpl
extends SynchronizeableImpl
implements RemoteTarget {
    private static List parameterCodeList;

    protected RemoteTargetImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        Object failureTypeVal;
        HashMap changedValues = super.setParameterList(parameterList);
        Object loginStatusVal = changedValues.get(ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS);
        if (loginStatusVal != null) {
            changedValues.put(ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS, this.getLoginStatus());
        }
        if ((failureTypeVal = changedValues.get(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE)) != null) {
            changedValues.put(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE, this.getFailureType());
        }
        return changedValues;
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_LOGIN_STATUS, this.getLoginStatus());
        parameterList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_FAILURE_TYPE, this.getFailureType());
        return parameterList;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String alias = (String)parameterList.get(ClientParameterCode.ISCSI_REMOTE_TARGET_ALIAS);
        if (alias != null) {
            String errorMsg;
            if (alias.equals("")) {
                alias = this.getName();
            }
            if ((errorMsg = this.isAliasValid(alias)) != null) {
                return errorMsg;
            }
            parameterList.put(ClientParameterCode.ISCSI_REMOTE_TARGET_ALIAS, new SrString(alias));
        }
        return null;
    }

    public boolean isEqual(HashMap parameterList) {
        try {
            Object name = parameterList.get(ParameterCode.SCSI_REMOTE_TARGET_NAME);
            SrType thisName = this.getSrValueOf(ParameterCode.SCSI_REMOTE_TARGET_NAME);
            return ((Object)thisName).equals(name);
        }
        catch (RemoteException re) {
            logger.warning(re);
            return false;
        }
    }

    public String getAlias() throws RemoteException {
        return this.getAlias(null);
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        String alias = (String)this.getValueOf(vSwitch, ParameterCode.SCSI_REMOTE_TARGET_ALIAS, vSwitch == null);
        return alias;
    }

    public String getName() throws RemoteException {
        return this.getName(null);
    }

    public String getName(VSwitch vSwitch) throws RemoteException {
        String name = (String)this.getValueOf(vSwitch, ParameterCode.DISCOVERED_TARGET_NAME, vSwitch == null);
        return name;
    }

    public Boolean isConfigured(VSwitch vSwitch) throws RemoteException {
        Boolean configured = (Boolean)this.getValueOf(vSwitch, ParameterCode.SCSI_REMOTE_TARGET_IS_CONFIGURED, vSwitch == null);
        return configured;
    }

    public Boolean isConfigured() throws RemoteException {
        VSwitch[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitch vswitch = connectedVswitches[index];
            Boolean configured = this.isConfigured(vswitch);
            if (!configured.equals(Boolean.FALSE)) continue;
            return configured;
        }
        return Boolean.TRUE;
    }

    public Boolean isDiscovered() throws RemoteException {
        VSwitch[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitch vswitch = connectedVswitches[index];
            Boolean discovered = this.isDiscovered(vswitch);
            if (!discovered.equals(Boolean.FALSE)) continue;
            return discovered;
        }
        return Boolean.TRUE;
    }

    public Boolean isDiscovered(VSwitch vSwitch) throws RemoteException {
        Boolean discovered = (Boolean)this.getValueOf(vSwitch, ParameterCode.SCSI_REMOTE_TARGET_IS_DISCOVERED, vSwitch == null);
        return discovered;
    }

    public HashMap getLoginStatus() throws RemoteException {
        HashMap<String, RemoteTargetLoginStatusConstant> statuses = new HashMap<String, RemoteTargetLoginStatusConstant>();
        VSwitch[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitch vswitch = connectedVswitches[index];
            RemoteTargetLoginStatusConstant status = this.getLoginStatus(vswitch);
            statuses.put(vswitch.getName(), status);
        }
        return statuses;
    }

    public boolean isConnected() throws RemoteException {
        HashMap loginStatuses = this.getLoginStatus();
        boolean isInitiatorConnetced = loginStatuses.containsValue(RemoteTargetLoginStatusConstant.CONNECTED);
        return isInitiatorConnetced;
    }

    public boolean isConnected(VSwitch vSwitch) throws RemoteException {
        RemoteTargetLoginStatusConstant loginStatuse = this.getLoginStatus(vSwitch);
        return loginStatuse != null && loginStatuse.equals(RemoteTargetLoginStatusConstant.CONNECTED);
    }

    public RemoteTargetLoginStatusConstant getLoginStatus(VSwitch vSwitch) throws RemoteException {
        RemoteTargetLoginStatusConstant status = (RemoteTargetLoginStatusConstant)this.getSrValueOf(vSwitch, ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS, vSwitch == null);
        return status;
    }

    public HashMap getFailureType() throws RemoteException {
        HashMap<String, RemoteTargetFailureTypeConstant> types = new HashMap<String, RemoteTargetFailureTypeConstant>();
        VSwitch[] connectedVswitches = this.getConnectedVSwitches();
        for (int index = 0; index < connectedVswitches.length; ++index) {
            VSwitch vswitch = connectedVswitches[index];
            RemoteTargetFailureTypeConstant type = this.getFailureType(vswitch);
            types.put(vswitch.getName(), type);
        }
        return types;
    }

    public RemoteTargetFailureTypeConstant getFailureType(VSwitch vSwitch) throws RemoteException {
        RemoteTargetFailureTypeConstant type = (RemoteTargetFailureTypeConstant)this.getSrValueOf(vSwitch, ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE, vSwitch == null);
        return type;
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.DISCOVERED_TARGET_NAME);
        parameterCodes.addElement(ParameterCode.SCSI_REMOTE_TARGET_ALIAS);
        parameterCodes.addElement(ParameterCode.SCSI_REMOTE_TARGET_IS_CONFIGURED);
        parameterCodes.addElement(ParameterCode.SCSI_REMOTE_TARGET_IS_DISCOVERED);
        parameterCodes.addElement(ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS);
        parameterCodes.addElement(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

