/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.policies;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.policies.MergePolicyImpl;
import com.sanrad.nms.server.logic.policies.PeriodicPolicyImpl;
import com.sanrad.nms.server.logic.policies.Policy;
import com.sanrad.nms.server.logic.policies.PolicyImpl;
import com.sanrad.nms.server.logic.policies.PolicyParamTableEntryImpl;
import com.sanrad.nms.server.logic.policies.PolicyTableEntryImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.table.MultiKey;
import com.sanrad.nms.server.util.table.MultiKeyTable;
import com.sanrad.nms.server.util.table.MultiKeysArrayList;
import com.sanrad.nms.server.util.table.SelectionResult;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class PoliciesManager {
    private static Log logger = LogMgr.getServerLog();
    private static PoliciesManager theInstance = null;
    PolicyParamsValuesTable m_policyParamsTable = new PolicyParamsValuesTable();
    PolicyStartatValuesTable m_policyStartatTable = new PolicyStartatValuesTable();
    PolicyMainTable m_policyMainTable = new PolicyMainTable();
    static /* synthetic */ Class class$com$sanrad$nms$server$util$table$MultiKey;
    static /* synthetic */ Class class$com$sanrad$nms$server$logic$policies$PolicyImpl;
    static /* synthetic */ Class class$com$sanrad$nms$server$util$table$MultiKeysArrayList;

    private PoliciesManager() throws RemoteException {
    }

    public static PoliciesManager getInstance() throws RemoteException {
        if (theInstance == null) {
            theInstance = new PoliciesManager();
        }
        return theInstance;
    }

    public synchronized void newPolicyStart(CommKeyClassId startatCommKey, HashMap parameterList) {
        try {
            SelectionResult sr2;
            MultiKeysArrayList keyList;
            MultiKey keyToMainTable = PolicyStartatValuesTable.createKeyToMainTable(startatCommKey, parameterList);
            MultiKey keyToStartatTable = PolicyStartatValuesTable.createKey(parameterList);
            SelectionResult sr = this.m_policyStartatTable.getSelectionResult(keyToStartatTable);
            if (sr.getRowCount() > 0) {
                keyList = (MultiKeysArrayList)sr.getValueAt(0, PolicyStartatValuesTable.COLUMN_KEY_LIST);
            } else {
                keyList = new MultiKeysArrayList();
                this.m_policyStartatTable.addRow(keyToStartatTable, new Object[]{keyList});
            }
            if (!keyList.contains(keyToMainTable)) {
                keyList.add(keyToMainTable);
            }
            if ((sr2 = this.m_policyMainTable.getSelectionResult(keyToMainTable)).getRowCount() == 0) {
                MultiKey keyInParamsTable = keyToMainTable.partialKey(new boolean[]{true, false, true});
                MultiKey keyToParamsTable = this.findRowContainsKey(this.m_policyParamsTable, keyInParamsTable);
                Policy newPolicy = null;
                if (keyToParamsTable != null) {
                    Long startAt = (Long)((SrDateAndTime)parameterList.get(ParameterCode.POLICY_START_AT)).value();
                    Object[] paramsKeyComps = keyToParamsTable.getKeyValues();
                    PolicyTypeConstant type = (PolicyTypeConstant)paramsKeyComps[0];
                    Integer param1 = (Integer)paramsKeyComps[1];
                    Integer param2 = (Integer)paramsKeyComps[2];
                    newPolicy = this.createNewPolicy(type, startAt, param1, param2);
                }
                Object[] row = new Object[]{keyToStartatTable, keyToParamsTable, newPolicy};
                this.m_policyMainTable.addRow(keyToMainTable, row);
            }
        }
        catch (IllegalValueException ive) {
            logger.error(ive);
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public synchronized void newPolicyParams(CommKeyClassId paramsCommKey, HashMap parameterList) {
        try {
            MultiKeysArrayList keyList;
            MultiKey keyToMainTable = PolicyParamsValuesTable.createKeyToMainTable(paramsCommKey, parameterList);
            MultiKey keyToParamsTable = PolicyParamsValuesTable.createKey(parameterList);
            SelectionResult sr = this.m_policyParamsTable.getSelectionResult(keyToParamsTable);
            if (sr.getRowCount() > 0) {
                keyList = (MultiKeysArrayList)sr.getValueAt(0, PolicyParamsValuesTable.COLUMN_KEY_LIST);
            } else {
                keyList = new MultiKeysArrayList();
                this.m_policyParamsTable.addRow(keyToParamsTable, new Object[]{keyList});
            }
            if (!keyList.contains(keyToMainTable)) {
                keyList.add(keyToMainTable);
            }
            SelectionResult matchingMainTableRows = this.m_policyMainTable.getSelectionResult(keyToMainTable);
            int i = matchingMainTableRows.getRowCount();
            while (i-- > 0) {
                matchingMainTableRows.setValueAt(i, "Params Key Column", (Object)keyToParamsTable);
                Policy policyObject = (Policy)matchingMainTableRows.getValueAt(i, "Policy Object Column");
                if (policyObject != null) continue;
                MultiKey keyToStartAt = (MultiKey)matchingMainTableRows.getValueAt(i, "Start At Key Column");
                Long startAt = (Long)keyToStartAt.getKeyValues()[0];
                PolicyTypeConstant policyType = (PolicyTypeConstant)parameterList.get(ParameterCode.POLICY_PARAM_TYPE);
                Integer param1 = (Integer)((SrInteger)parameterList.get(ParameterCode.POLICY_PARAM_PARAM1)).value();
                Integer param2 = (Integer)((SrInteger)parameterList.get(ParameterCode.POLICY_PARAM_PARAM2)).value();
                policyObject = this.createNewPolicy(policyType, startAt, param1, param2);
                matchingMainTableRows.setValueAt(i, "Policy Object Column", (Object)policyObject);
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public synchronized void removePolicyElement(LogicObjectImpl element) throws RemoteException {
        if (element.getClassId().equals(ClassID.POLICY_START)) {
            this.removePolicyStartatElement((PolicyTableEntryImpl)element);
        } else if (element.getClassId().equals(ClassID.POLICY_PARAMS)) {
            this.removePolicyParamsElement((PolicyParamTableEntryImpl)element);
        }
    }

    public synchronized void changePolicyElement(LogicObjectImpl element) throws RemoteException {
        if (element.getClassId().equals(ClassID.POLICY_START)) {
            this.changePolicyStartatElement((PolicyTableEntryImpl)element);
        } else if (element.getClassId().equals(ClassID.POLICY_PARAMS)) {
            this.changePolicyParamsElement((PolicyParamTableEntryImpl)element);
        }
    }

    public synchronized PolicyImpl getPolicy(CommKeyClassId vSwitchID, CommKeyClassId startAtKey, CommKeyClassId paramsKey) {
        MultiKey keyToDB = new MultiKey(new Object[]{vSwitchID, startAtKey, paramsKey});
        SelectionResult sr = this.m_policyMainTable.getSelectionResult(keyToDB);
        PolicyImpl retVal = null;
        if (sr.getRowCount() > 0) {
            retVal = (PolicyImpl)sr.getValueAt(0, "Policy Object Column");
        }
        return retVal;
    }

    public synchronized HashMap getPolicyKeysParameterList(ClusterImpl cluster, Long startat, PolicyTypeConstant policyType, Long runEvery) throws RemoteException {
        HashMap<ParameterCode, CommKeyClassId> parameters = new HashMap<ParameterCode, CommKeyClassId>();
        Vector vSwitchIDs = cluster.getVSwitches();
        int i = vSwitchIDs.size();
        while (i-- > 0) {
            HashMap vsParams = this.getPolicyKeysParameterList(((VSwitch)vSwitchIDs.get(i)).getCommKeyClassId(), startat, policyType, runEvery);
            CommKeyClassId prevPolicyID = (CommKeyClassId)parameters.get(ParameterCode.POLICY_ID);
            CommKeyClassId prevParamID = (CommKeyClassId)parameters.get(ParameterCode.POLICY_PARAM_ID);
            CommKeyClassId nextPolicyID = (CommKeyClassId)vsParams.get(ParameterCode.POLICY_ID);
            CommKeyClassId nextParamID = (CommKeyClassId)vsParams.get(ParameterCode.POLICY_PARAM_ID);
            parameters.put(ParameterCode.POLICY_ID, CommKeyUtil.mergeCommKeyClassIDs(prevPolicyID, nextPolicyID));
            parameters.put(ParameterCode.POLICY_PARAM_ID, CommKeyUtil.mergeCommKeyClassIDs(prevParamID, nextParamID));
        }
        return parameters;
    }

    private HashMap getPolicyKeysParameterList(CommKeyClassId vSwitchID, Long startat, PolicyTypeConstant policyType, Long runEvery) {
        HashMap<ParameterCode, CommKeyClassId> parameters = new HashMap<ParameterCode, CommKeyClassId>();
        ArrayList mainTableKeys = this.getMatchingMainTableKeys(vSwitchID, startat);
        ArrayList paramCommKeys = this.getMatchingParamCommKeys(vSwitchID, policyType, runEvery);
        int i = mainTableKeys.size();
        while (i-- > 0) {
            MultiKey mainKey = (MultiKey)mainTableKeys.get(i);
            CommKeyClassId paramId = (CommKeyClassId)mainKey.getKeyValues()[2];
            if (!paramCommKeys.contains(paramId)) continue;
            Object[] keyComps = mainKey.getKeyValues();
            parameters.put(ParameterCode.POLICY_ID, (CommKeyClassId)keyComps[1]);
            parameters.put(ParameterCode.POLICY_PARAM_ID, (CommKeyClassId)keyComps[2]);
            return parameters;
        }
        if (paramCommKeys.size() > 0) {
            parameters.put(ParameterCode.POLICY_PARAM_ID, (CommKeyClassId)paramCommKeys.get(0));
        }
        return parameters;
    }

    private ArrayList getMatchingParamCommKeys(CommKeyClassId vSwitchID, PolicyTypeConstant policyType, Long runEvery) {
        ArrayList<Object> paramCommKeyList = new ArrayList<Object>();
        Integer param1 = this.extractParam1FromRunEvery(policyType, runEvery);
        Integer param2 = this.extractParam2FromRunEvery(policyType, runEvery);
        MultiKey keyToParamTable = new MultiKey(new Object[]{policyType, param1, param2});
        SelectionResult sr = this.m_policyParamsTable.getSelectionResult(keyToParamTable);
        if (sr.getRowCount() > 0) {
            int r = sr.getRowCount();
            while (r-- > 0) {
                MultiKeysArrayList keylist = (MultiKeysArrayList)sr.getValueAt(r, 0);
                int i = keylist.size();
                while (i-- > 0) {
                    MultiKey partialKeyToMainTable = keylist.getMultiKeyAt(i);
                    Object[] keyValues = partialKeyToMainTable.getKeyValues();
                    if (!keyValues[0].equals(vSwitchID)) continue;
                    paramCommKeyList.add(keyValues[2]);
                }
            }
        }
        return paramCommKeyList;
    }

    private ArrayList getMatchingMainTableKeys(CommKeyClassId vSwitchID, Long startat) {
        ArrayList<MultiKey> mainTableKeyList = new ArrayList<MultiKey>();
        MultiKey keyToStartatTable = new MultiKey(new Object[]{startat});
        SelectionResult sr = this.m_policyStartatTable.getSelectionResult(keyToStartatTable);
        int row = sr.getRowCount();
        while (row-- > 0) {
            MultiKeysArrayList keylist = (MultiKeysArrayList)sr.getValueAt(row, 0);
            int i = keylist.size();
            while (i-- > 0) {
                MultiKey keyToMainTable = keylist.getMultiKeyAt(i);
                Object[] keyValues = keyToMainTable.getKeyValues();
                if (!keyValues[0].equals(vSwitchID)) continue;
                mainTableKeyList.add(keyToMainTable);
            }
        }
        return mainTableKeyList;
    }

    private MultiKey findRowContainsKey(MultiKeyTable table, MultiKey value) {
        try {
            if (table != null && table.keySet() != null) {
                Iterator i = table.keySet().iterator();
                while (i.hasNext()) {
                    MultiKey currKey = (MultiKey)i.next();
                    MultiKeysArrayList currList = (MultiKeysArrayList)table.getSelectionResult(currKey).getValueAt(0, 0);
                    if (!currList.contains(value)) continue;
                    return currKey;
                }
            }
            return null;
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    private Policy createNewPolicy(PolicyTypeConstant policyType, Long startAt, Integer param1, Integer param2) throws RemoteException {
        PolicyImpl newPolicy = null;
        if (policyType == PolicyTypeConstant.REPLICATE_PERIODIC) {
            newPolicy = new PeriodicPolicyImpl();
        }
        if (policyType == PolicyTypeConstant.MERGE_ONLY_CURRENT || policyType == PolicyTypeConstant.MERGE_NO_MERGE) {
            newPolicy = new MergePolicyImpl(policyType);
        }
        ((PolicyImpl)newPolicy).update(startAt, param1, param2);
        return newPolicy;
    }

    private Integer extractParam1FromRunEvery(PolicyTypeConstant type, Long runEvery) {
        if (type.equals(PolicyTypeConstant.REPLICATE_PERIODIC)) {
            return new Integer(runEvery.intValue() / 60);
        }
        return new Integer(runEvery.intValue());
    }

    private Integer extractParam2FromRunEvery(PolicyTypeConstant type, Long runEvery) {
        if (type.equals(PolicyTypeConstant.REPLICATE_PERIODIC)) {
            return new Integer(runEvery.intValue() % 60);
        }
        return new Integer(0);
    }

    private void removePolicyStartatElement(PolicyTableEntryImpl element) throws RemoteException {
        HashMap paramList = element.getParameterListValues(element.getActiveVswitch());
        MultiKey keyToMainTable = PolicyStartatValuesTable.createKeyToMainTable(element.getCommKeyClassId(), paramList);
        MultiKey keyToStartatTable = PolicyStartatValuesTable.createKey(paramList);
        this.m_policyMainTable.remove(keyToMainTable);
        SelectionResult sr = this.m_policyStartatTable.getSelectionResult(keyToStartatTable);
        int i = sr.getRowCount();
        while (i-- > 0) {
            MultiKeysArrayList mainKeysList = (MultiKeysArrayList)sr.getValueAt(i, PolicyStartatValuesTable.COLUMN_KEY_LIST);
            mainKeysList.remove(keyToMainTable);
            if (!mainKeysList.isEmpty()) continue;
            this.m_policyStartatTable.remove(keyToStartatTable);
        }
    }

    private void removePolicyParamsElement(PolicyParamTableEntryImpl element) throws RemoteException {
        HashMap paramList = element.getParameterListValues(element.getActiveVswitch());
        MultiKey keyToMainTable = PolicyParamsValuesTable.createKeyToMainTable(element.getCommKeyClassId(), paramList);
        MultiKey keyToParamsTable = PolicyParamsValuesTable.createKey(paramList);
        SelectionResult sr = this.m_policyParamsTable.getSelectionResult(keyToParamsTable);
        int i = sr.getRowCount();
        while (i-- > 0) {
            MultiKeysArrayList mainKeysList = (MultiKeysArrayList)sr.getValueAt(i, PolicyStartatValuesTable.COLUMN_KEY_LIST);
            mainKeysList.remove(keyToMainTable);
            if (!mainKeysList.isEmpty()) continue;
            this.m_policyParamsTable.remove(keyToParamsTable);
        }
        SelectionResult matchingMainTableRows = this.m_policyMainTable.getSelectionResult(keyToMainTable);
        int i2 = matchingMainTableRows.getRowCount();
        while (i2-- > 0) {
            matchingMainTableRows.setValueAt(i2, "Params Key Column", null);
            matchingMainTableRows.setValueAt(i2, "Policy Object Column", null);
        }
    }

    private void changePolicyStartatElement(PolicyTableEntryImpl element) {
    }

    private void changePolicyParamsElement(PolicyParamTableEntryImpl element) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PolicyParamsValuesTable
    extends MultiKeyTable {
        static String COLUMN_KEY_LIST = "Key List Column";
        static final String[] ALL_COLUMNS = new String[]{COLUMN_KEY_LIST};
        static Class[] policyParamsValueTypes = new Class[]{class$com$sanrad$nms$server$util$table$MultiKeysArrayList == null ? (class$com$sanrad$nms$server$util$table$MultiKeysArrayList = PoliciesManager.class$("com.sanrad.nms.server.util.table.MultiKeysArrayList")) : class$com$sanrad$nms$server$util$table$MultiKeysArrayList};

        PolicyParamsValuesTable() {
            super(3, ALL_COLUMNS, policyParamsValueTypes);
        }

        static MultiKey createKey(HashMap parameterList) {
            PolicyTypeConstant type = (PolicyTypeConstant)parameterList.get(ParameterCode.POLICY_PARAM_TYPE);
            Integer param1 = (Integer)((SrInteger)parameterList.get(ParameterCode.POLICY_PARAM_PARAM1)).value();
            Integer param2 = (Integer)((SrInteger)parameterList.get(ParameterCode.POLICY_PARAM_PARAM2)).value();
            return new MultiKey(new Object[]{type, param1, param2});
        }

        static MultiKey createKeyToMainTable(CommKeyClassId paramCommKey, HashMap parameterList) {
            CommKeyClassId vSwitchId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
            return new MultiKey(new Object[]{vSwitchId, null, paramCommKey});
        }
    }

    private static class PolicyStartatValuesTable
    extends MultiKeyTable {
        static String COLUMN_KEY_LIST = "Key List Column";
        static final String[] ALL_COLUMNS = new String[]{COLUMN_KEY_LIST};
        static Class[] policyStartValueTypes = new Class[]{class$com$sanrad$nms$server$util$table$MultiKeysArrayList == null ? (class$com$sanrad$nms$server$util$table$MultiKeysArrayList = PoliciesManager.class$("com.sanrad.nms.server.util.table.MultiKeysArrayList")) : class$com$sanrad$nms$server$util$table$MultiKeysArrayList};

        PolicyStartatValuesTable() {
            super(1, ALL_COLUMNS, policyStartValueTypes);
        }

        static MultiKey createKey(HashMap parameterList) {
            Long startAt = (Long)((SrDateAndTime)parameterList.get(ParameterCode.POLICY_START_AT)).value();
            return new MultiKey(new Object[]{startAt});
        }

        static MultiKey createKeyToMainTable(CommKeyClassId startatCommKey, HashMap parameterList) {
            CommKeyClassId vSwitchId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
            CommKeyClassId paramsId = (CommKeyClassId)parameterList.get(ParameterCode.POLICY_PARAM_ID);
            return new MultiKey(new Object[]{vSwitchId, startatCommKey, paramsId});
        }
    }

    private static class PolicyMainTable
    extends MultiKeyTable {
        static final String COLUMN_START_AT_KEY = "Start At Key Column";
        static final String COLUMN_PARAM_KEY = "Params Key Column";
        static final String COLUMN_POLICY_OBJECT = "Policy Object Column";
        static final String[] ALL_COLUMNS = new String[]{"Start At Key Column", "Params Key Column", "Policy Object Column"};
        static Class[] policyDBValueTypes = new Class[]{class$com$sanrad$nms$server$util$table$MultiKey == null ? (class$com$sanrad$nms$server$util$table$MultiKey = PoliciesManager.class$("com.sanrad.nms.server.util.table.MultiKey")) : class$com$sanrad$nms$server$util$table$MultiKey, class$com$sanrad$nms$server$util$table$MultiKey == null ? (class$com$sanrad$nms$server$util$table$MultiKey = PoliciesManager.class$("com.sanrad.nms.server.util.table.MultiKey")) : class$com$sanrad$nms$server$util$table$MultiKey, class$com$sanrad$nms$server$logic$policies$PolicyImpl == null ? (class$com$sanrad$nms$server$logic$policies$PolicyImpl = PoliciesManager.class$("com.sanrad.nms.server.logic.policies.PolicyImpl")) : class$com$sanrad$nms$server$logic$policies$PolicyImpl};

        PolicyMainTable() {
            super(3, ALL_COLUMNS, policyDBValueTypes);
        }
    }
}

