/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.policies;

import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.logic.policies.PeriodicPolicy;
import com.sanrad.nms.server.logic.policies.PolicyImpl;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import com.sanrad.nms.server.util.types.constants.UnitsConstant;
import java.rmi.RemoteException;

public class PeriodicPolicyImpl
extends PolicyImpl
implements PeriodicPolicy {
    private Integer period = null;

    public PeriodicPolicyImpl() throws RemoteException {
    }

    public PeriodicPolicyImpl(Long startAt, Integer period) throws RemoteException {
        super(startAt);
        this.period = period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public PolicyTypeConstant getType() throws RemoteException {
        return PolicyTypeConstant.REPLICATE_PERIODIC;
    }

    public Object getValue() throws RemoteException {
        return this.period;
    }

    public UnitsConstant getUnits() throws RemoteException {
        return UnitsConstant.Minutes;
    }

    public void update(Long startAt, Integer param1, Integer param2) {
        this.period = new Integer(param1 * 60 + param2);
        this.setStartAt(startAt);
    }

    public String toString() {
        StringBuffer toStringValue = new StringBuffer("PeriodicPolicy: ");
        toStringValue.append("period = " + this.period + " startAt = " + this.getStartAt() + "\n");
        return toStringValue.toString();
    }

    public boolean equals(Object compareTo) {
        try {
            if (compareTo instanceof PeriodicPolicyImpl) {
                return this.period.intValue() == ((Integer)((PeriodicPolicyImpl)compareTo).getValue()).intValue();
            }
            return false;
        }
        catch (RemoteException re) {
            logger.error(re);
            return false;
        }
    }

    public int hashCode() {
        return this.period + this.getStartAt().intValue() * 10;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public void propagatedStateChanged(PropagatedStateEvent e) {
    }
}

