/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.nms.server.logic.AliasObjectValidator;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Vector;

public class SubDirectAccessDeviceValidator
extends AliasObjectValidator {
    protected DirectAccessDeviceImpl parent;
    protected BigInteger startAddr;
    protected BigInteger size;

    public SubDirectAccessDeviceValidator(DirectAccessDeviceImpl parent, String alias, BigInteger startAddr, BigInteger size, ClusterImpl cluster) {
        super(alias);
        this.parent = parent;
        this.startAddr = startAddr;
        this.size = size;
        this.cluster = cluster;
    }

    public static String getDefaultAlias() {
        return "$sdad$" + System.currentTimeMillis();
    }

    public boolean isValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        BigInteger parentTotalSpace = this.parent.getTotalSpace();
        if (parentTotalSpace.compareTo(BigInteger.ZERO) == 0) {
            return true;
        }
        if (this.size.compareTo(parentTotalSpace) != -1 && parentTotalSpace.compareTo(BigInteger.ZERO) != 0) {
            this.setErrorMsg(ErrorMessage.CAPACITY_IS_TOO_HIGH.getMessage(this.size + " Bytes"));
            return false;
        }
        BigInteger parentNonAllocatedSpace = this.parent.getNonAllocatedSpace();
        if (this.size.compareTo(parentNonAllocatedSpace) == 1 && parentNonAllocatedSpace.compareTo(BigInteger.ZERO) != 0) {
            this.setErrorMsg(ErrorMessage.CAPACITY_IS_TOO_HIGH.getMessage(this.size + " Bytes"));
            return false;
        }
        return true;
    }

    public CommKeyClassId[] getLegalVSwitchesForOperation(Vector vSwitchToSet) throws RemoteException, IllegalValueException {
        VSwitch[] vSwitches = new VSwitch[vSwitchToSet.size()];
        return this.getLegalVSwitchesForOperation(vSwitchToSet.toArray(vSwitches));
    }

    public CommKeyClassId[] getLegalVSwitchesForOperation(VSwitch[] vSwitchToSet) throws RemoteException, IllegalValueException {
        CommKeyClassId[] toSet = new CommKeyClassId[vSwitchToSet.length];
        for (int i = 0; i < vSwitchToSet.length; ++i) {
            toSet[i] = ((VSwitchImpl)vSwitchToSet[i]).getCommKeyClassId();
        }
        return this.getLegalVSwitchesForOperation(toSet);
    }

    public CommKeyClassId[] getLegalVSwitchesForOperation(CommKeyClassId[] vSwitchToSet) throws RemoteException, IllegalValueException {
        CommKeyClassId[] parentExistsOn = this.getVSwitchesAllElementsExistIn(this.parent, this.cluster);
        int numOfLegalVSwitches = 0;
        for (int i = 0; i < parentExistsOn.length; ++i) {
            VSwitch vSwitch = (VSwitch)SystemRootImpl.getInstance().getRefByStub(parentExistsOn[i]);
            if (this.parent.isMissing(vSwitch)) {
                parentExistsOn[i] = null;
                continue;
            }
            ++numOfLegalVSwitches;
        }
        if (numOfLegalVSwitches < parentExistsOn.length) {
            CommKeyClassId[] newList = new CommKeyClassId[numOfLegalVSwitches];
            int j = 0;
            for (int i = 0; i < parentExistsOn.length; ++i) {
                if (parentExistsOn[i] == null) continue;
                newList[j++] = parentExistsOn[i];
            }
        }
        return this.getVSwitchesToSet(vSwitchToSet, parentExistsOn);
    }
}

