/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceValidator;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;

public class SubDirectAccessDeviceSyncValidator
extends SubDirectAccessDeviceValidator {
    private Vector vSwitches;

    public SubDirectAccessDeviceSyncValidator(DirectAccessDeviceImpl parent, String alias, BigInteger startAddr, BigInteger size, ClusterImpl cluster, Vector vSwitchToSync) {
        super(parent, alias, startAddr, size, cluster);
        this.vSwitches = vSwitchToSync;
    }

    public boolean isValid() throws RemoteException {
        VolumeNode volParent;
        if (super.isValid() && (volParent = this.getParentVolume(this.parent)) != null) {
            String[] msgBody = new String[]{this.parent.getAlias(), ((Volume)volParent).getClassId() + " " + volParent.getAlias()};
            this.setErrorMsg(ErrorMessage.DISK_HAS_VOLUME_CANNOT_CREATE_SUB_DISK.getMessage(msgBody));
            return false;
        }
        try {
            if (this.getLegalVSwitchesForOperation(this.vSwitches).length > 0) {
                return true;
            }
            this.setErrorMsg("Cannot find any legal " + ClassID.VSWITCH + " for Sub Direct Access Device Cluster Sync for: " + this.alias);
        }
        catch (Exception e) {
            LogMgr.getServerLog().debug("Failed to get legal " + ClassID.VSWITCH + "es for Sub Direct Access Device Cluster Sync for: " + this.alias, e);
        }
        return false;
    }

    private VolumeNode getParentVolume(DirectAccessDeviceImpl storage) {
        try {
            Iterator itr = this.vSwitches.iterator();
            while (itr.hasNext()) {
                Volume vol = this.parent.getParentVolume((VSwitch)itr.next());
                if (vol == null) continue;
                return vol;
            }
            return null;
        }
        catch (RemoteException re) {
            logger.error(re);
            return null;
        }
    }
}

