/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.physstorage.SubDirectAccessDeviceAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceCreateValidator;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceSyncValidator;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.SubDirectAccessDeviceOperStatusConstant;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;

public class SubDirectAccessDeviceImpl
extends VolumeNodeImpl
implements SubDirectAccessDevice {
    private DirectAccessDeviceImpl directAccessDeviceParent = null;
    private BigInteger endAddress = null;

    public SubDirectAccessDeviceImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.SUB_DIRECT_ACCESS_DEVICE);
        this.addParameterCode(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS);
        this.addParameterCode(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR);
        this.addParameterCode(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH);
        this.addParameterCode(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO);
        this.addParameterCode(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID);
        this.addParameterCode(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        CommKeyClassId parentCommKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID);
        if (parentCommKeyClassId != null) {
            this.directAccessDeviceParent = (DirectAccessDeviceImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(parentCommKeyClassId);
            if (this.directAccessDeviceParent != null) {
                this.endAddress = this.getEndAddress();
                this.directAccessDeviceParent.addSubDirectAccessDevice(this);
            } else {
                throw new NullPointerException(ClassID.DIRECT_ACCESS_DEVICE + " parent not found for " + this.getClassId() + " " + this.getAlias());
            }
        }
        return changedValues;
    }

    public DirectAccessDevice getDirectAccessDeviceParent() throws RemoteException {
        return this.directAccessDeviceParent;
    }

    public String getAlias() throws RemoteException {
        return this.getAlias(null);
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, vSwitch == null);
    }

    public String getInfo() throws RemoteException {
        return this.getInfo(null);
    }

    public String getInfo(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO, vSwitch == null);
    }

    public BigInteger getEndAddress() throws RemoteException {
        return this.getEndAddress(null);
    }

    public BigInteger getEndAddress(VSwitch vSwitch) throws RemoteException {
        BigInteger endAddressBlocks = (BigInteger)this.getValueOf(vSwitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR, vSwitch == null);
        int blockSize = this.getBlockSize(vSwitch);
        return Util.blocksToBytes(endAddressBlocks, blockSize);
    }

    public BigInteger getStartAddress() throws RemoteException {
        return this.getStartAddress(null);
    }

    public BigInteger getStartAddress(VSwitch vSwitch) throws RemoteException {
        BigInteger endAddress = this.getEndAddress(vSwitch);
        BigInteger size = this.getSize(vSwitch);
        if (endAddress == null || endAddress.intValue() == 0) {
            endAddress = BigInteger.ONE;
        }
        return endAddress.subtract(size).add(this.getBlockSizeBigInteger(vSwitch));
    }

    public boolean isSpaceFree() throws RemoteException {
        return false;
    }

    public String getEntityName() throws RemoteException {
        return this.getEntityName(null);
    }

    public String getEntityName(VSwitch vSwitch) throws RemoteException {
        return this.directAccessDeviceParent.getEntityName(vSwitch);
    }

    public boolean isLeaf() {
        return true;
    }

    public int getBlockSize(VSwitch vSwitch) throws RemoteException {
        return this.directAccessDeviceParent.getBlockSize(vSwitch);
    }

    public BigInteger getBlockSizeBigInteger(VSwitch vSwitch) throws RemoteException {
        return this.directAccessDeviceParent.getBlockSizeBigInteger(vSwitch);
    }

    public Vector getChildren() throws RemoteException {
        return null;
    }

    public BigInteger getSize() throws RemoteException {
        return this.getSize(null);
    }

    public BigInteger getSize(VSwitch vSwitch) throws RemoteException {
        BigInteger numberOfBlocks = (BigInteger)this.getValueOf(vSwitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, vSwitch == null);
        return Util.blocksToBytes(numberOfBlocks, this.getBlockSize(vSwitch));
    }

    public BigInteger getNumberOfBlocks(VSwitch vSwitch) throws RemoteException {
        return (BigInteger)this.getValueOf(vSwitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, vSwitch == null);
    }

    public BigInteger getNumberOfBlocks() throws RemoteException {
        return this.getNumberOfBlocks(null);
    }

    public double getBlockNum(VSwitch vSwitch) throws RemoteException {
        return ((BigInteger)this.getValueOf(vSwitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, vSwitch == null)).doubleValue();
    }

    public double getBlockNum() throws RemoteException {
        return this.getBlockNum(null);
    }

    public BigInteger getAccessibleSpace() throws RemoteException {
        return this.getSize();
    }

    public BigInteger getPotentialCapacity() throws RemoteException {
        return this.getSize();
    }

    public BigInteger getAllocatedSpace() throws RemoteException {
        return this.getSize();
    }

    public SubDirectAccessDeviceOperStatusConstant getOperStatus() throws RemoteException {
        return (SubDirectAccessDeviceOperStatusConstant)this.getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS);
    }

    public SubDirectAccessDeviceOperStatusConstant getOperStatus(VSwitch vswitch) throws RemoteException {
        return (SubDirectAccessDeviceOperStatusConstant)this.getSrValueOf(vswitch, ParameterCode.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS);
    }

    protected String canBeDeleted() throws RemoteException {
        Volume volumeParent = this.getParentVolume();
        if (volumeParent != null) {
            String[] msgBody = new String[]{this.getAlias(), volumeParent.getClassId() + " " + volumeParent.getAlias()};
            return ErrorMessage.CANNOT_DELETE_SUB_DISK_UNDER_VOLUME.getMessage(msgBody);
        }
        CopyOperationImpl oper = ((CopyOperationManagerImpl)this.cluster.getCopyOperManager()).getCopyForNode(this.getCommKeyClassId());
        if (oper != null) {
            String[] msg = new String[]{this.getClassId().toString() + " " + this.toString(), oper.getCopyType().toString(), oper.getCopyType().toString()};
            return ErrorMessage.CANNOT_DELETE_PHYS_STOR_IN_COPY.getMessage(msg);
        }
        return super.canBeDeleted();
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String info;
        String alias = (String)parameterList.get(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS);
        if (alias != null) {
            DirectAccessDevice device;
            String errorMsg = this.isAliasValid(alias);
            if (errorMsg != null) {
                return errorMsg;
            }
            if (alias.equals("")) {
                alias = SubDirectAccessDeviceCreateValidator.getDefaultAlias();
            }
            if ((device = this.cluster.getStoragePool().isSubDirectAccessDeviceAliasExist(alias)) != null) {
                String[] msgParts = new String[]{alias, device.getAlias()};
                return ErrorMessage.SUB_DISK_ALIAS_ALREADY_IN_USE.getMessage(msgParts);
            }
            parameterList.put(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, new SrString(alias));
        }
        if ((info = (String)parameterList.get(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO)) != null) {
            parameterList.put(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO, new SrString(info));
        }
        return null;
    }

    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        StringBuffer msg = new StringBuffer("Subdisk ");
        msg.append(this.getAlias());
        msg.append(" cannot be synchronized. ");
        msg.append(this.directAccessDeviceParent.getClassId());
        msg.append(" ");
        msg.append(this.directAccessDeviceParent.getAlias());
        boolean hasError = false;
        if (this.directAccessDeviceParent.isNeedToSynchronize()) {
            msg.append(" is not synchornized yet");
            hasError = true;
        } else if (!this.directAccessDeviceParent.isRedundant()) {
            msg.append(" is not redundant");
            hasError = true;
        } else if (this.directAccessDeviceParent.isIllegalUpHierarchy()) {
            msg.append(" is Illegal");
            hasError = true;
        }
        if (hasError) {
            LogMgr.getServerLog().warning(msg.toString());
            return msg.toString();
        }
        return null;
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (this.canBeSynchronized() != null) {
            return 3;
        }
        if (!this.isInSynchronizingMode()) {
            SubDirectAccessDeviceSyncValidator validator = new SubDirectAccessDeviceSyncValidator(this.directAccessDeviceParent, this.getAlias(), this.getStartAddress(), this.getSize(), this.cluster, this.cluster.getOtherVSwitches(this.getVSwitches()));
            if (!validator.isValid()) {
                throw new IllegalValueException(validator.getErrorMsg());
            }
            this.directAccessDeviceParent.createSubDirectAccessDevice(this.getAlias(), this.getStartAddress(), this.getSize(), this.cluster.getOtherVSwitches(this.getVSwitches()), this.getCommKeyClassId());
            this.setSynchronizingMode(true);
        }
        return 2;
    }

    public int getChildrenOfVirtualVolumeTypeCount() throws RemoteException {
        return 0;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof SubDirectAccessDevice) {
            try {
                DirectAccessDevice o1 = ((SubDirectAccessDevice)obj).getDirectAccessDeviceParent();
                DirectAccessDevice o2 = this.getDirectAccessDeviceParent();
                if (o1 == null || o2 == null) {
                    boolean i = false;
                }
                return ((SubDirectAccessDeviceImpl)obj).getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR) != null && ((SubDirectAccessDeviceImpl)obj).getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR).equals(this.getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR)) && ((SubDirectAccessDevice)obj).getDirectAccessDeviceParent().equals(this.getDirectAccessDeviceParent());
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
        return false;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        DirectAccessDeviceImpl parent = (DirectAccessDeviceImpl)this.getDirectAccessDeviceParent();
        if (parent != null) {
            this.addPropagationStateDependentObjectAndListener(parent);
            this.cluster.removePropagationStateDependentObjectAndListener(parent);
        } else {
            logger.error("parent of " + this.getClassId() + " " + this + " is null");
        }
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    public boolean isOneOfTheVolumesInHierarchyNeedSync() throws RemoteException {
        return this.isNeedSync();
    }

    public AlarmGenerator getAlarmGenerator() {
        return SubDirectAccessDeviceAlarmGenerator.getInstance();
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().debug("Sync of subDisk " + this.getAlias());
        if (this.isSynchronizePending()) {
            logger.debug("Already synchronizing " + this.getClassId() + " " + this.toString());
            return 1;
        }
        if (!this.isNeedToSynchronize()) {
            return 0;
        }
        logger.debug("Start to synchronize " + this.getClassId() + " " + this.toString());
        this.setSynchronizePending(true);
        int retVal = this.synchronizeMe();
        LogMgr.getServerLog().debug("Sync of subDisk " + this.getAlias() + " SyncMe status " + retVal);
        switch (retVal) {
            case 0: 
            case 3: {
                this.setSynchronizePending(false);
            }
        }
        return retVal;
    }

    public boolean isInternal(VSwitch vSwitch) throws RemoteException {
        return this.getParentLU(vSwitch) == null && this.getParentVolume(vSwitch) == null;
    }

    public void updateElementWithCreationParameters(ConfigElementData element, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        element.addParameter(new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, this.getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH)));
        element.addParameter(new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR, this.getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR)));
        element.addParameter(new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO, this.getSrValueOf(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO)));
        super.updateElementWithCreationParameters(element, remoteCluster);
    }

    protected void createIscsiDisk(HashMap devices, ConfigElementData element, Cluster remoteCluster) throws RemoteException, IllegalAccessException, IllegalValueException {
        element.setClassId(ClassID.SUB_DIRECT_ACCESS_DEVICE);
        DirectAccessDeviceImpl disk = (DirectAccessDeviceImpl)this.getDirectAccessDeviceParent();
        ConfigElementData diskCed = (ConfigElementData)devices.get(disk);
        if (diskCed == null) {
            diskCed = new ConfigElementData(ClassID.DIRECT_ACCESS_DEVICE);
            ((DirectAccessDeviceImpl)this.getDirectAccessDeviceParent()).updateElementWithCreationParameters(diskCed, remoteCluster);
            devices.put(disk, diskCed);
        }
        element.setValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID, diskCed);
    }

    protected LogicObject findEquivelentElement(Cluster cluster, LogicObject childVol) throws RemoteException, IllegalValueException {
        DirectAccessDeviceImpl device;
        Vector subdisks;
        if (childVol != null && (subdisks = (device = (DirectAccessDeviceImpl)childVol).getSubDirectAccessDevices()).contains(this)) {
            return (VolumeNode)subdisks.get(subdisks.indexOf(this));
        }
        return null;
    }

    public ConfigElementDataList buildCedListForRemoveVolumeTree(Vector subdisks, ConfigElementDataList elementList) throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeyClassId());
        ((ClusterImpl)this.getCluster()).prepareVSwitchIDs(element, "prepare element for remove volume tree", this.getConnectedVSwitchesAsVector());
        elementList.addElement(element);
        subdisks.addElement(this);
        ((DirectAccessDeviceImpl)this.getDirectAccessDeviceParent()).buildCedListForRemoveVolumeTree(subdisks, elementList);
        return elementList;
    }

    public boolean isProvisioned() throws RemoteException {
        return this.getDirectAccessDeviceParent().isProvisioned();
    }

    public boolean isMismatch(VSwitch vswitch) throws RemoteException {
        return SubDirectAccessDeviceOperStatusConstant.MISMATCH.equals(this.getOperStatus(vswitch));
    }

    public boolean isNonValidate(VSwitch vswitch) throws RemoteException {
        return SubDirectAccessDeviceOperStatusConstant.NON_VALIDATE.equals(this.getOperStatus(vswitch));
    }
}

