/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.nms.server.logic.physstorage.BestFitSpaceComparator;
import com.sanrad.nms.server.logic.physstorage.FirstFitSpaceComparator;
import com.sanrad.nms.server.logic.physstorage.StorageSpace;
import com.sanrad.nms.server.logic.physstorage.StorageSpaceImpl;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

class StorageSpaceManager {
    private Vector occupiedSpace = new Vector();
    private BigInteger totalSize;
    private BigInteger blockSize;
    private boolean isProvisioned;

    public StorageSpaceManager(BigInteger totalSize, int blockSize, boolean isProvisioned) {
        this.totalSize = totalSize;
        this.blockSize = new BigInteger(Integer.toString(blockSize));
        this.isProvisioned = isProvisioned;
    }

    void setTotalSize(BigInteger totalSize) {
        this.totalSize = totalSize;
    }

    void setBlockSize(int blockSize) {
        this.blockSize = new BigInteger(Integer.toString(blockSize));
    }

    void setProvisioned(boolean isProvisioned) {
        this.isProvisioned = isProvisioned;
    }

    public void addOccupiedSpace(BigInteger startAddr, BigInteger size) throws RemoteException {
        StorageSpaceImpl storageSpace = new StorageSpaceImpl(startAddr, size, false);
        this.occupiedSpace.addElement(storageSpace);
    }

    private void addIfFree(Vector freeSpace, BigInteger addr1, BigInteger addr2) throws RemoteException {
        BigInteger sizeFree;
        if (addr1 != null && addr2 != null && (sizeFree = addr2.subtract(addr1)).compareTo(BigInteger.ZERO) > 0) {
            StorageSpaceImpl free = new StorageSpaceImpl(addr1, sizeFree, true);
            freeSpace.addElement(free);
        }
    }

    public Vector getFreeSpaceVector() throws RemoteException {
        Vector freeSpace = new Vector();
        if (this.occupiedSpace.size() > 0) {
            Collections.sort(this.occupiedSpace, new FirstFitSpaceComparator());
            BigInteger addr1 = BigInteger.ZERO;
            Iterator i = this.occupiedSpace.iterator();
            while (i.hasNext()) {
                StorageSpace occupied = (StorageSpace)i.next();
                this.addIfFree(freeSpace, addr1, occupied.getStartAddress());
                addr1 = occupied.getStartAddress().add(occupied.getSize());
            }
            StorageSpace occupied = (StorageSpace)this.occupiedSpace.lastElement();
            this.addIfFree(freeSpace, occupied.getStartAddress().add(occupied.getSize()), this.totalSize);
        } else {
            this.addIfFree(freeSpace, BigInteger.ZERO, this.totalSize);
        }
        return freeSpace;
    }

    private int getStorageSpaceIndex(BigInteger startAddr, BigInteger size) throws RemoteException {
        for (int i = 0; i < this.occupiedSpace.size(); ++i) {
            StorageSpace storageSpace = (StorageSpace)this.occupiedSpace.elementAt(i);
            if (!storageSpace.getStartAddress().equals(startAddr) || !storageSpace.getSize().equals(size)) continue;
            return i;
        }
        return -1;
    }

    public void removeOccupiedSpace(BigInteger startAddr, BigInteger size) throws RemoteException {
        int index = this.getStorageSpaceIndex(startAddr, size);
        if (index > -1) {
            this.occupiedSpace.removeElementAt(index);
        }
    }

    public boolean isStartAddressCompatible(BigInteger startAddr, BigInteger size) throws RemoteException {
        Vector freeSpace = this.getFreeSpaceVector();
        Collections.sort(freeSpace, new FirstFitSpaceComparator());
        if (freeSpace.size() > 0) {
            Iterator i = freeSpace.iterator();
            while (i.hasNext()) {
                StorageSpace storageSpace = (StorageSpace)i.next();
                BigInteger endAddr = storageSpace.getStartAddress().add(storageSpace.getSize().subtract(this.blockSize));
                if (storageSpace.getStartAddress().compareTo(startAddr) == 1 || endAddr.compareTo(startAddr) != 1 || endAddr.compareTo(startAddr.add(size).subtract(this.blockSize)) == -1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFit(StorageSpace storageFreeSpace, BigInteger size) throws RemoteException {
        return storageFreeSpace.getSize().compareTo(size) != -1;
    }

    private BigInteger getStartAddress(Vector freeSpace, BigInteger size) throws RemoteException {
        if (freeSpace.size() > 0) {
            Iterator i = freeSpace.iterator();
            while (i.hasNext()) {
                StorageSpace storageSpace = (StorageSpace)i.next();
                if (!this.isFit(storageSpace, size)) continue;
                return storageSpace.getStartAddress();
            }
        }
        if (this.isProvisioned) {
            if (!this.occupiedSpace.isEmpty()) {
                StorageSpaceImpl lastSplit = (StorageSpaceImpl)this.occupiedSpace.lastElement();
                return lastSplit.getStartAddress().add(lastSplit.getSize());
            }
            return BigInteger.ZERO;
        }
        return null;
    }

    public BigInteger getFirstFitStartAddress(BigInteger size) throws RemoteException {
        Vector freeSpace = this.getFreeSpaceVector();
        Collections.sort(freeSpace, new FirstFitSpaceComparator());
        return this.getStartAddress(freeSpace, size);
    }

    public BigInteger getBestFitStartAddress(BigInteger size) throws RemoteException {
        Vector freeSpace = this.getFreeSpaceVector();
        Collections.sort(freeSpace, new BestFitSpaceComparator());
        return this.getStartAddress(freeSpace, size);
    }

    public BigInteger getLastAvailableSpaceSize() throws RemoteException {
        Vector freeSpace = this.getFreeSpaceVector();
        StorageSpace lastSpace = (StorageSpace)freeSpace.get(freeSpace.size() - 1);
        return lastSpace.getSize();
    }
}

