/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.LUIdentifier;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class LUIdentifierImpl
extends LogicObjectImpl
implements LUIdentifier,
Comparable {
    private static List parameterCodeList;
    private GeneralSCSIDeviceImpl deviceParent = null;
    private BigInteger codeSet = null;
    private BigInteger association = null;
    private BigInteger type = null;
    private String value = null;

    public LUIdentifierImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.LU_IDENTIFIER, parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.value = this.getValue();
        if (this.value != null) {
            this.toStringValue = this.value.toString();
        }
        this.codeSet = this.getCodeSet();
        this.association = this.getAssociation();
        this.type = this.getType();
        CommKeyClassId commKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.SCSI_DEVICE_ID);
        if (commKeyClassId != null) {
            this.deviceParent = (GeneralSCSIDeviceImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(commKeyClassId);
            if (this.deviceParent == null) {
                String message = ClassID.GENERAL_SCSI_DEVICE + " parent not found for " + this.getClassId() + " " + this.toString();
                logger.fatal("Snmp Configuration Error: " + message);
                ElementEventImpl elementEvent = new ElementEventImpl(this, this);
                elementEvent.setErrorMesaage(message);
                EventServiceImpl.getInstance().fireFatalConfigurationError(elementEvent);
            }
        }
        return changedValues;
    }

    protected String canBeDeleted() throws RemoteException {
        throw new UnsupportedOperationException();
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public BigInteger getCodeSet() throws RemoteException {
        return (BigInteger)this.getValueOf(ParameterCode.LU_ID_CODE_SET);
    }

    public BigInteger getAssociation() throws RemoteException {
        return (BigInteger)this.getValueOf(ParameterCode.LU_ID_ASSOC);
    }

    public BigInteger getType() throws RemoteException {
        return (BigInteger)this.getValueOf(ParameterCode.LU_ID_TYPE);
    }

    public String getValue() throws RemoteException {
        return (String)this.getValueOf(ParameterCode.LU_ID_VALUE);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LUIdentifier) {
            LUIdentifierImpl luId = (LUIdentifierImpl)obj;
            return this.codeSet.equals(luId.codeSet) && this.association.equals(luId.association) && this.type.equals(luId.type) && this.value.equals(luId.value);
        }
        return false;
    }

    public boolean isEqual(HashMap parameterList) throws RemoteException {
        BigInteger thisCodeSet = this.getCodeSet();
        BigInteger thisAssociation = this.getAssociation();
        BigInteger thisType = this.getType();
        String thisValue = this.getValue();
        if (thisCodeSet != null && thisAssociation != null && thisType != null && thisValue != null) {
            Object codeSet = parameterList.get(ParameterCode.LU_ID_CODE_SET);
            Object association = parameterList.get(ParameterCode.LU_ID_ASSOC);
            Object type = parameterList.get(ParameterCode.LU_ID_TYPE);
            Object value = parameterList.get(ParameterCode.LU_ID_VALUE);
            return codeSet.equals(thisCodeSet) && association.equals(thisAssociation) && type.equals(thisType) && value.equals(thisValue);
        }
        return false;
    }

    public int compareTo(Object obj) {
        int result = 0;
        try {
            LUIdentifierImpl luId = (LUIdentifierImpl)obj;
            result = this.getAssociation().compareTo(luId.getAssociation());
            if (result != 0) {
                return result;
            }
            result = this.getCodeSet().compareTo(luId.getCodeSet());
            if (result != 0) {
                return result;
            }
            result = this.getType().compareTo(luId.getType());
            if (result != 0) {
                return result;
            }
            result = this.getValue().compareTo(luId.getValue());
        }
        catch (RemoteException re) {
            logger.warning(re);
        }
        return result;
    }

    public GeneralSCSIDevice getSCSIDeviceParent() {
        return this.deviceParent;
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.LU_ID_CODE_SET);
        parameterCodes.addElement(ParameterCode.LU_ID_ASSOC);
        parameterCodes.addElement(ParameterCode.LU_ID_TYPE);
        parameterCodes.addElement(ParameterCode.LU_ID_VALUE);
        parameterCodes.addElement(ParameterCode.SCSI_DEVICE_ID);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

