/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.physstorage.GeneralSCSIDeviceAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SitesSynchronizeable;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.LUIdentifierImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageComAdminStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageComOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class GeneralSCSIDeviceImpl
extends VolumeNodeImpl
implements GeneralSCSIDevice,
SitesSynchronizeable {
    public static final int PSCSI_PORT_INDEX_IN_OCTET_STRING = 3;
    public static final int PSCSI_BUS_INDEX_IN_OCTET_STRING = 7;
    private Object entityName = null;
    private String lun = null;
    private String transportType = null;
    private String type = null;
    private String serialNumber = null;
    private Vector luIdentifier = null;
    private String m_keptEntityNameForRemoval = null;

    public GeneralSCSIDeviceImpl(ClusterImpl cluster) throws RemoteException {
        this(cluster, ClassID.GENERAL_SCSI_DEVICE);
    }

    protected GeneralSCSIDeviceImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_ALIAS);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_LUN);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_INFO);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_VENDOR_NAME);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_OPERATIONAL_STATUS);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_TYPE);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_COM_ADMIN_STATUS);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_COM_OPER_STATUS);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_COM_DURATION);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_PRODUCT_ID);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_REVISION_LEVEL);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_SCSI_VER);
        this.addParameterCode(ParameterCode.PHYSICAL_STORAGE_LU_IDENTIFIER);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        BigInteger prevNonAllocated = this.getNonAllocatedSpace();
        HashMap changedValues = super.setParameterList(parameterList);
        BigInteger newNonAllocated = this.getNonAllocatedSpace();
        if (newNonAllocated != null && !newNonAllocated.equals(prevNonAllocated)) {
            changedValues.put(ClientParameterCode.SCSI_DEVICE_NON_ALLOCATED_SPACE, newNonAllocated);
        }
        this.toStringValue = this.getAlias();
        this.entityName = this.getEntityNameValue();
        this.lun = this.getLUN();
        this.transportType = this.getTransportType().value().toString();
        this.type = this.getType();
        this.serialNumber = this.getSerialNumber();
        this.luIdentifier = this.getLUIdentifier();
        return changedValues;
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap params = super.getClientParameterList();
        params.put(ClientParameterCode.SCSI_DEVICE_NON_ALLOCATED_SPACE, this.getNonAllocatedSpace());
        return params;
    }

    protected void setVswitchesToPerformOperation(ConfigElementData element, HashMap parameterList) throws RemoteException, IllegalValueException {
        if (parameterList.containsKey(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE)) {
            logger.debug("Trying to Blink " + this.getClassId() + " " + this);
            CommKeyClassId[] vSwitchCommKeyClassId = new CommKeyClassId[1];
            Vector vSwitches = this.getVSwitches();
            if (!vSwitches.isEmpty()) {
                VSwitch vSwitch = null;
                PhysicalStorageComAdminStatusConstant newStatus = (PhysicalStorageComAdminStatusConstant)parameterList.get(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE);
                Iterator iter = vSwitches.iterator();
                while (iter.hasNext()) {
                    boolean rightVSwitch;
                    vSwitch = (VSwitch)iter.next();
                    boolean isBlinking = this.isInCommandState(vSwitch, PhysicalStorageComOperStatusConstant.PHYS_STOR_COM_OPER_STAT_BLINK);
                    boolean bl = rightVSwitch = newStatus.equals(PhysicalStorageComAdminStatusConstant.PHYS_STOR_COM_OPER_STAT_BLINK) && !isBlinking || !newStatus.equals(PhysicalStorageComAdminStatusConstant.PHYS_STOR_COM_OPER_STAT_BLINK) && isBlinking;
                    if (!vSwitch.isConnected() || !rightVSwitch) continue;
                    vSwitchCommKeyClassId[0] = new CommKeyClassId(vSwitch.getCommKeys(), vSwitch.getClassId());
                    element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchCommKeyClassId));
                    return;
                }
                logger.debug("No " + ClassID.VSWITCH + " is connected");
            } else {
                logger.debug("change element: Could not find any " + ClassID.VSWITCH);
            }
        }
    }

    public String getAlias() throws RemoteException {
        return this.getAlias(null);
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_ALIAS, vSwitch == null);
    }

    public String getLUN() throws RemoteException {
        return this.getLUN(null);
    }

    public String getLUN(VSwitch vSwitch) throws RemoteException {
        SrType value = this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_LUN, vSwitch == null);
        if (value == null) {
            return null;
        }
        return GeneralSCSIDeviceImpl.formatSCSIDeviceLUN((SrLunFormat)value);
    }

    public static String formatSCSIDeviceLUN(SrLunFormat lunFormat) {
        return String.valueOf(lunFormat.toInt());
    }

    public static SrLunFormat parseSCSIDeviceLUN(int lun) {
        byte lunByte = lun < 128 ? (byte)lun : (byte)(lun - 256);
        return new SrLunFormat(new byte[]{0, lunByte, 0, 0, 0, 0, 0, 0});
    }

    public boolean isLeaf() {
        return true;
    }

    private boolean isInState(VSwitch vSwitch, PhysicalStorageOperStatusConstant state) throws RemoteException {
        PhysicalStorageOperStatusConstant status = this.getOperationalStatus(vSwitch);
        return status != null && status.equals(state);
    }

    private boolean isInCommandState(VSwitch vSwitch, PhysicalStorageComOperStatusConstant state) throws RemoteException {
        PhysicalStorageComOperStatusConstant status = this.getComOperationalStatus(vSwitch);
        if (status == null) {
            return false;
        }
        return status.equals(state);
    }

    public boolean isEnable(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_ENABLE);
    }

    public boolean isUnknown(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_UNKNOWN);
    }

    public boolean isMissing() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (this.isMissing(vSwitches[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isProvisioned() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (this.isProvisioned(vSwitches[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isInvalid() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (this.isInvalid(vSwitches[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isBlinking() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isBlinking(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isMissing(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_MISSING);
    }

    public boolean isProvisioned(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_PROVISIONED);
    }

    public boolean isInvalid(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_INVALID);
    }

    public boolean isBlinking(VSwitch vSwitch) throws RemoteException {
        return this.isInCommandState(vSwitch, PhysicalStorageComOperStatusConstant.PHYS_STOR_COM_OPER_STAT_BLINK);
    }

    public Vector getChildren() throws RemoteException {
        return null;
    }

    public void clear() throws RemoteException {
        if (this.luIdentifier != null) {
            this.luIdentifier.clear();
        }
        this.setParent(null, -1);
        super.clear();
    }

    public boolean isISCSITarnsportType() throws RemoteException {
        return this.getTransportTypeConstant(null).equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI);
    }

    private PhysStorTransportTypeConstant getTransportTypeConstant(VSwitch vSwitch) throws RemoteException {
        return (PhysStorTransportTypeConstant)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, vSwitch == null);
    }

    public int getPSCSIPort() throws RemoteException {
        return this.getPSCSIPort(null);
    }

    public int getPSCSIPort(VSwitch vSwitch) throws RemoteException {
        PhysStorTransportTypeConstant type;
        SrEntityNameFormat entityName = (SrEntityNameFormat)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, vSwitch == null);
        if (entityName != null && (type = this.getTransportTypeConstant(vSwitch)).equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI)) {
            return entityName.getByteAt(3);
        }
        return -1;
    }

    public int getPSCSIBus() throws RemoteException {
        return this.getPSCSIBus(null);
    }

    public int getPSCSIBus(VSwitch vSwitch) throws RemoteException {
        PhysStorTransportTypeConstant type;
        SrEntityNameFormat entityName = (SrEntityNameFormat)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, vSwitch == null);
        if (entityName != null && (type = this.getTransportTypeConstant(vSwitch)).equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI)) {
            return entityName.getByteAt(7);
        }
        return -1;
    }

    public String getEntityNameValue() throws RemoteException {
        return this.getEntityNameValue(null);
    }

    public String getEntityNameValue(VSwitch vSwitch) throws RemoteException {
        return this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, vSwitch == null).toString();
    }

    public String getEntityName() throws RemoteException {
        return this.getEntityName(null);
    }

    public String getEntityName(VSwitch vSwitch) throws RemoteException {
        SrEntityNameFormat entityFormat = (SrEntityNameFormat)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, vSwitch == null);
        if (entityFormat == null) {
            return null;
        }
        String entityName = null;
        PhysStorTransportTypeConstant type = this.getTransportTypeConstant(vSwitch);
        if (type.equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_FCP)) {
            entityName = entityFormat.toHexStringFormat();
        } else if (type.equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI)) {
            entityName = new String((byte[])entityFormat.value());
        } else if (type.equals(PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_SPI)) {
            int port = this.getPSCSIPort(vSwitch);
            int bus = this.getPSCSIBus(vSwitch);
            entityName = GeneralSCSIDeviceImpl.getPSCSIEntityName(port, bus);
        }
        return entityName;
    }

    public static String getPSCSIEntityName(int port, int bus) {
        return "Port " + port + " Bus " + bus;
    }

    public String getInfo() throws RemoteException {
        return this.getInfo(null);
    }

    public String getInfo(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_INFO, vSwitch == null);
    }

    public String getVendor() throws RemoteException {
        return this.getVendor(null);
    }

    public String getVendor(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_VENDOR_NAME, vSwitch == null);
    }

    public PhysStorTransportTypeConstant getTransportType() throws RemoteException {
        return this.getTransportType(null);
    }

    public PhysStorTransportTypeConstant getTransportType(VSwitch vSwitch) throws RemoteException {
        return (PhysStorTransportTypeConstant)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, vSwitch == null);
    }

    public String getType() throws RemoteException {
        return this.getType(null);
    }

    public String getType(VSwitch vSwitch) throws RemoteException {
        return this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_TYPE, vSwitch == null).toString();
    }

    public PhysicalStorageTypeConstant getTypeConstant() throws RemoteException {
        return this.getTypeConstant(null);
    }

    public PhysicalStorageTypeConstant getTypeConstant(VSwitch vSwitch) throws RemoteException {
        return (PhysicalStorageTypeConstant)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_TYPE, vSwitch == null);
    }

    public int getChildrenOfVirtualVolumeTypeCount() throws RemoteException {
        return 0;
    }

    private PhysicalStorageOperStatusConstant getOperationalStatus(VSwitch vSwitch) throws RemoteException {
        return (PhysicalStorageOperStatusConstant)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_OPERATIONAL_STATUS, vSwitch == null);
    }

    private PhysicalStorageComOperStatusConstant getComOperationalStatus(VSwitch vSwitch) throws RemoteException {
        return (PhysicalStorageComOperStatusConstant)this.getSrValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_COM_OPER_STATUS, vSwitch == null);
    }

    public boolean isOneOfTheVolumesInHierarchyNeedSync() throws RemoteException {
        return this.isNeedSync();
    }

    protected String canBeDeleted() throws RemoteException {
        Volume volume;
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        if (vSwitches != null && vSwitches.length > 0) {
            VSwitch vswitch1 = vSwitches[0];
            boolean isMissingInVSwitch1 = this.isMissing(vswitch1);
            boolean isInvalidInVSwitch1 = this.isInvalid(vswitch1);
            boolean isConfiguredInVSwitch1 = this.isProvisioned(vswitch1);
            if (vSwitches.length > 1) {
                VSwitch vswitch2 = vSwitches[1];
                boolean isMissingInVSwitch2 = this.isMissing(vswitch2);
                boolean isInvalidInVSwitch2 = this.isInvalid(vswitch2);
                boolean isConfiguredInVSwitch2 = this.isProvisioned(vswitch2);
                if (!(isMissingInVSwitch1 && isMissingInVSwitch2 || isInvalidInVSwitch1 && isInvalidInVSwitch2 || isConfiguredInVSwitch1 && isConfiguredInVSwitch2 || isMissingInVSwitch1 && isInvalidInVSwitch2 || isMissingInVSwitch1 && isConfiguredInVSwitch2 || isInvalidInVSwitch1 && isMissingInVSwitch2 || isInvalidInVSwitch1 && isConfiguredInVSwitch2 || isConfiguredInVSwitch1 && isMissingInVSwitch2 || isConfiguredInVSwitch1 && isInvalidInVSwitch2)) {
                    return "You cannot remove " + this.getClassId() + " " + this.getAlias() + ", because it is not missing or invalid or provisioned";
                }
            } else if (!(isMissingInVSwitch1 || isInvalidInVSwitch1 || isConfiguredInVSwitch1)) {
                return "You cannot remove " + this.getClassId() + " " + this.getAlias() + ", because it is not missing or invalid or provisioned";
            }
        }
        if ((volume = this.getParentVolume()) != null) {
            return "You cannot remove " + this.getClassId() + " " + this.getAlias() + ", because it belongs to " + volume.getClassId() + " " + volume.getAlias();
        }
        return super.canBeDeleted();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof GeneralSCSIDevice) {
            try {
                return this.compareWith((GeneralSCSIDeviceImpl)obj);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected boolean compareWith(GeneralSCSIDeviceImpl device) throws RemoteException {
        boolean result;
        if (device == null) {
            return false;
        }
        Vector connVSwitchesTemp = this.getConnectedVSwitchesAsVector();
        connVSwitchesTemp.retainAll(device.getConnectedVSwitchesAsVector());
        if (connVSwitchesTemp.isEmpty()) {
            return false;
        }
        if (!this.isProvisioned() && !device.isProvisioned()) {
            if (this.supportsNewSCSIVersionCompare() && device.supportsNewSCSIVersionCompare()) {
                result = this.newSCSIVersionCompare(device);
            } else {
                if (this.supportsNewSCSIVersionCompare() || device.supportsNewSCSIVersionCompare()) {
                    return false;
                }
                result = this.oldSCSIVersionCompare(device);
            }
        } else {
            result = this.oldSCSIVersionCompare(device);
        }
        if (!result) {
            return false;
        }
        try {
            if (this.getSerialNumber() != null && !this.getSerialNumber().equals("") && !this.getSerialNumber().equals(device.getSerialNumber())) {
                if ((device.getSerialNumber() == null || device.getSerialNumber().equals("")) && device.isProvisioned()) {
                    return this.compareNoAffectOnVirtualizationWith(device);
                }
                return false;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return this.compareNoAffectOnVirtualizationWith(device);
    }

    protected boolean compareNoAffectOnVirtualizationWith(GeneralSCSIDeviceImpl device) {
        return this.type.equals(device.type);
    }

    protected boolean isLUIdentifierListEquals(GeneralSCSIDeviceImpl device) throws RemoteException {
        if (this.getLUIdentifiersCount() == device.getLUIdentifiersCount()) {
            for (int i = 0; i < this.getLUIdentifiersCount(); ++i) {
                LUIdentifierImpl deviceLUId;
                LUIdentifierImpl luId = (LUIdentifierImpl)this.luIdentifier.elementAt(i);
                if (luId.equals(deviceLUId = (LUIdentifierImpl)device.luIdentifier.elementAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean supportsNewSCSIVersionCompare() throws RemoteException {
        return this.hasSerialNumber() && this.hasLUIdentifier();
    }

    protected boolean newSCSIVersionCompare(GeneralSCSIDeviceImpl device) {
        try {
            return this.serialNumber.equals(device.serialNumber) && this.isLUIdentifierListEquals(device);
        }
        catch (RemoteException re) {
            logger.warning(re);
            return false;
        }
    }

    protected boolean oldSCSIVersionCompare(GeneralSCSIDeviceImpl device) {
        return device.entityName.equals(this.entityName) && device.lun.equalsIgnoreCase(this.lun) && device.transportType.equals(this.transportType);
    }

    protected boolean hasSerialNumber() {
        return this.serialNumber != null;
    }

    protected boolean hasLUIdentifier() {
        return this.luIdentifier != null && !this.luIdentifier.isEmpty();
    }

    public int getBlockSize(VSwitch vSwitch) throws RemoteException {
        return 0;
    }

    public double getBlockNum(VSwitch vSwitch) throws RemoteException {
        return 0.0;
    }

    public BigInteger getNumberOfBlocks(VSwitch vswitch) throws RemoteException {
        return BigInteger.ZERO;
    }

    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (this.canBeSynchronized() != null) {
            return 2;
        }
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        if (!this.isInSynchronizingMode()) {
            storage.createGeneralPhysStorageDevice(this.getTypeConstant(), this.getAlias(), (SrEntityNameFormat)this.getSrValueOf(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME), Integer.parseInt(this.getLUN()), this.getTransportType(), this.getSerialNumber(), this.cluster.getOtherVSwitches(this.getVSwitches()));
            this.setSynchronizingMode(true);
        }
        return 2;
    }

    protected String canBeSynchronized() throws RemoteException {
        if (!this.isProvisioned()) {
            return this.getClassId() + " " + this + " cannot be synchronized";
        }
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        Object blinkParam;
        String info;
        String alias = (String)parameterList.get(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_ALIAS);
        if (alias != null) {
            String errorMsg = this.isAliasValid(alias);
            if (errorMsg != null) {
                return errorMsg;
            }
            if (alias.equals("")) {
                alias = "$dad$" + System.currentTimeMillis();
            }
            if (this.cluster.getStoragePool().isSCSIDeviceAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            parameterList.put(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_ALIAS, new SrString(alias));
        }
        if ((info = (String)parameterList.get(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_INFO)) != null) {
            parameterList.put(ClientParameterCode.PHYSICAL_STORAGE_DEVICE_INFO, new SrString(info));
        }
        if ((blinkParam = parameterList.get(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE)) != null) {
            Boolean blink = (Boolean)blinkParam;
            if (this.isMissing()) {
                String[] msg = new String[]{this.getClassId().toString(), this.toString()};
                return ErrorMessage.BLINK_MISSING_STORAGE.getMessage(msg);
            }
            if (blink.booleanValue()) {
                if (this.isBlinking()) {
                    return this.getClassId() + " " + this + " is already blinking";
                }
                Integer duration = (Integer)parameterList.get(ClientParameterCode.PHYSICAL_STORAGE_BLINK_DURATION);
                parameterList.put(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE, PhysicalStorageComAdminStatusConstant.PHYS_STOR_COM_OPER_STAT_BLINK);
                parameterList.put(ClientParameterCode.PHYSICAL_STORAGE_BLINK_DURATION, new SrInteger(duration));
            } else {
                if (!this.isBlinking()) {
                    return this.getClassId() + " " + this + " is not blinking";
                }
                parameterList.put(ClientParameterCode.PHYSICAL_STORAGE_BLINK_ACTIVE, PhysicalStorageComAdminStatusConstant.PHYS_STOR_COM_OPER_STAT_ABORT);
            }
        }
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    public AlarmGenerator getAlarmGenerator() {
        return GeneralSCSIDeviceAlarmGenerator.getInstance();
    }

    public String getGroup() throws RemoteException {
        return "";
    }

    public BigInteger getTotalSpace() throws RemoteException {
        return BigInteger.ZERO;
    }

    public BigInteger getNonAllocatedSpace() throws RemoteException {
        return this.getTotalSpace();
    }

    public BigInteger getEndAddress() throws RemoteException {
        return this.getTotalSpace();
    }

    public BigInteger getAccessibleSpace() throws RemoteException {
        return this.getTotalSpace();
    }

    public BigInteger getAllocatedSpace() throws RemoteException {
        if (this.getParentVolume() == null && this.getParentLU() == null) {
            return BigInteger.ZERO;
        }
        return this.getTotalSpace();
    }

    public String getSerialNumber() throws RemoteException {
        return this.getSerialNumber(null);
    }

    public String getSerialNumber(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER, vSwitch == null);
    }

    public String getProductID() throws RemoteException {
        return this.getProductID(null);
    }

    public String getProductID(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_PRODUCT_ID, vSwitch == null);
    }

    public String getRevisionLevel() throws RemoteException {
        return this.getRevisionLevel(null);
    }

    public String getRevisionLevel(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_REVISION_LEVEL, vSwitch == null);
    }

    public Integer getSCSIVersion() throws RemoteException {
        return this.getSCSIVersion(null);
    }

    public Integer getSCSIVersion(VSwitch vSwitch) throws RemoteException {
        return (Integer)this.getValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_SCSI_VER, vSwitch == null);
    }

    public Vector getLUIdentifier() throws RemoteException {
        return this.getLUIdentifier(null);
    }

    public Vector getLUIdentifier(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId[] luIdCommKeyClassId = (CommKeyClassId[])this.getSrArrayValueOf(vSwitch, ParameterCode.PHYSICAL_STORAGE_LU_IDENTIFIER, vSwitch == null);
        if (luIdCommKeyClassId != null) {
            Vector<Object> luIds = new Vector<Object>();
            for (int i = 0; i < luIdCommKeyClassId.length; ++i) {
                Object luId = this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(luIdCommKeyClassId[i]);
                if (luId != null) {
                    luIds.addElement(luId);
                    continue;
                }
                logger.warning("LUIdentifier is null for CommKeyClassId " + luIdCommKeyClassId[i] + " in cluster " + this.cluster + " " + ClassID.VSWITCH + " " + vSwitch);
            }
            return luIds;
        }
        return null;
    }

    protected int getLUIdentifiersCount() throws RemoteException {
        return this.luIdentifier == null ? 0 : this.luIdentifier.size();
    }

    public boolean isInternal(VSwitch vSwitch) throws RemoteException {
        return this.getParentLU(vSwitch) == null && this.getParentVolume(vSwitch) == null;
    }

    public void synchronizeDiscoveryElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
    }

    public void synchronizeNewElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
    }

    public void synchronizeChangeElementOnRemoteCluster(Cluster remoteCluster, HashMap changedValues) throws RemoteException {
    }

    public void synchronizePreRemoveElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
        this.m_keptEntityNameForRemoval = this.getEntityName();
    }

    public void synchronizePostRemoveElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
    }

    public ConfigElementDataList buildCedListForRemoveVolumeTree(Vector subdisks, ConfigElementDataList elementList) throws RemoteException {
        if (this.isProvisioned()) {
            ConfigElementData element = new ConfigElementData(this.getCommKeyClassId());
            ((ClusterImpl)this.getCluster()).prepareVSwitchIDs(element, "prepare element for remove volume tree", this.getConnectedVSwitchesAsVector());
            elementList.addElement(element);
        }
        return elementList;
    }

    public boolean isDeviceSuitableForLocalCopy(HashSet set, VolumeNodeImpl volume, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        return false;
    }

    public VSwitch getDominentVswitch() throws RemoteException {
        VSwitch[] vswitches = this.getConnectedVSwitches();
        LUImpl lu = (LUImpl)this.getParentLU();
        if (lu == null) {
            for (int i = 0; i < vswitches.length; ++i) {
                PhysicalStorageOperStatusConstant state = (PhysicalStorageOperStatusConstant)this.getSrValueOf(vswitches[i], ParameterCode.PHYSICAL_STORAGE_OPERATIONAL_STATUS);
                if (!PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_ENABLE.equals(state) || !vswitches[i].isConnected()) continue;
                return vswitches[i];
            }
        }
        return super.getDominentVswitch();
    }
}

