/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceValidator;
import com.sanrad.nms.server.logic.target.TargetList;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import java.rmi.RemoteException;

public class GeneralPSCSIDeviceValidator
extends GeneralSCSIDeviceValidator {
    private static final int MIN_PORT_NUMBER = 1;
    private static final int MAX_PORT_NUMBER = 4;
    private static final int MIN_BUS_NUMBER = 0;
    private static final int MAX_BUS_NUMBER = 15;
    private int port;
    private int bus;

    public GeneralPSCSIDeviceValidator(ClusterImpl cluster, TargetList targetList, PhysicalStorageTypeConstant type, String alias, int port, int bus, int lun, String serialNumber) {
        super(cluster, targetList, type, alias, new SrEntityNameFormat(new byte[]{0, 0, 0, (byte)port, 0, 0, 0, (byte)bus}), lun, serialNumber);
        this.port = port;
        this.bus = bus;
    }

    public boolean isValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        if (this.port < 1 || this.port > 4) {
            StringBuffer sb = new StringBuffer();
            sb.append("Illegal Parallel SCSI port: port is between ");
            sb.append(1);
            sb.append(" to ");
            sb.append(4);
            this.setErrorMsg(sb.toString());
            return false;
        }
        if (this.bus < 0 || this.bus > 15) {
            StringBuffer sb = new StringBuffer();
            sb.append("Illegal Parallel SCSI bus: port is between ");
            sb.append(0);
            sb.append(" to ");
            sb.append(15);
            this.setErrorMsg(sb.toString());
            return false;
        }
        return true;
    }

    protected String getEntityName() {
        return GeneralSCSIDeviceImpl.getPSCSIEntityName(this.port, this.bus);
    }
}

