/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceValidator;
import com.sanrad.nms.server.logic.target.TargetList;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import java.rmi.RemoteException;

public class GeneralISCSIDeviceValidator
extends GeneralSCSIDeviceValidator {
    private String entityName;

    public GeneralISCSIDeviceValidator(ClusterImpl cluster, TargetList targetList, PhysicalStorageTypeConstant type, String alias, String entityName, int lun, String serialNumber) {
        super(cluster, targetList, type, alias, new SrEntityNameFormat(entityName), lun, serialNumber);
        this.entityName = entityName;
    }

    public boolean isValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        if (this.entityName == null || this.entityName.length() == 0) {
            this.setErrorMsg("Target name is mandatory");
            return false;
        }
        if (this.entityName.length() > 223) {
            this.setErrorMsg(ErrorMessage.TARGET_WWWI_TOO_LONG.getMessage(String.valueOf(223)));
            return false;
        }
        if (this.cluster.getTargetListMgr().getTargetByName(this.entityName) != null) {
            this.setErrorMsg("Target name already exists");
            return false;
        }
        return true;
    }

    protected String getEntityName() {
        SrEntityNameFormat entityFormat = new SrEntityNameFormat(this.entityName);
        return new String((byte[])entityFormat.value());
    }
}

