/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.physstorage.DirectAccessDeviceAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.StorageSpaceComparator;
import com.sanrad.nms.server.logic.physstorage.StorageSpaceManager;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceCreateValidator;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.BlockSizeConstant;
import com.sanrad.nms.server.util.types.constants.DirectAccessDeviceWCEStateConstants;
import com.sanrad.nms.server.util.types.constants.DirectAccessDeviceWPStateConstants;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class DirectAccessDeviceImpl
extends GeneralSCSIDeviceImpl
implements DirectAccessDevice {
    private ArrayList subDirectAccessDevices = new ArrayList();
    private ArrayList allocatedSpace = new ArrayList();
    private StorageSpaceManager storageSpaceManager = null;
    private Integer blockSize = null;
    private BigInteger numberOfBlocks = null;
    private Vector m_storageSpaceStatus = new Vector();

    public DirectAccessDeviceImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.DIRECT_ACCESS_DEVICE);
        this.addParameterCode(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE);
        this.addParameterCode(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM);
        this.addParameterCode(ParameterCode.DIRECT_ACCESS_DEVICE_WCE_STATE);
        this.addParameterCode(ParameterCode.DIRECT_ACCESS_DEVICE_WP);
        this.addParameterCode(ParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE);
    }

    public Boolean isWriteProtected() throws RemoteException {
        return this.isWriteProtected(null);
    }

    private Boolean isWriteProtected(VSwitch vSwitch) throws RemoteException {
        DirectAccessDeviceWPStateConstants state = (DirectAccessDeviceWPStateConstants)this.getSrValueOf(vSwitch, ParameterCode.DIRECT_ACCESS_DEVICE_WP, vSwitch == null);
        if (state != null) {
            if (state.equals(DirectAccessDeviceWPStateConstants.DIRECT_ACCESS_DEVICE_WP_STATE_ENABLE)) {
                return Boolean.TRUE;
            }
            if (state.equals(DirectAccessDeviceWPStateConstants.DIRECT_ACCESS_DEVICE_WP_STATE_DISABLE)) {
                return Boolean.FALSE;
            }
            if (state.equals(DirectAccessDeviceWPStateConstants.DIRECT_ACCESS_DEVICE_WP_STATE_UNKOWN)) {
                return null;
            }
        }
        logger.debug("Undefined WP state for " + this.getClassId() + " " + this);
        return null;
    }

    public Boolean isWriteCacheEnabled() throws RemoteException {
        return this.isWriteCacheEnabled(null);
    }

    private Boolean isWriteCacheEnabled(VSwitch vSwitch) throws RemoteException {
        DirectAccessDeviceWCEStateConstants state = (DirectAccessDeviceWCEStateConstants)this.getSrValueOf(vSwitch, ParameterCode.DIRECT_ACCESS_DEVICE_WCE_STATE, vSwitch == null);
        if (state != null) {
            if (state.equals(DirectAccessDeviceWCEStateConstants.DIRECT_ACCESS_DEVICE_WCE_STATE_ENABLE)) {
                return Boolean.TRUE;
            }
            if (state.equals(DirectAccessDeviceWCEStateConstants.DIRECT_ACCESS_DEVICE_WCE_STATE_DISABLE)) {
                return Boolean.FALSE;
            }
            if (state.equals(DirectAccessDeviceWCEStateConstants.DIRECT_ACCESS_DEVICE_WCE_STATE_UNKOWN)) {
                return null;
            }
        }
        logger.debug("Undefined WCE state for " + this.getClassId() + " " + this);
        return null;
    }

    public void updateElementWithCreationParameters(ConfigElementData element, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        super.updateElementWithCreationParameters(element, remoteCluster);
        element.addParameter(new Parameter(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, this.getSrValueOf(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE)));
        element.addParameter(new Parameter(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, this.getSrValueOf(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME)));
        element.addParameter(new Parameter(ParameterCode.PHYSICAL_STORAGE_LUN, this.getSrValueOf(ParameterCode.PHYSICAL_STORAGE_LUN)));
        element.addParameter(new Parameter(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER, this.getSrValueOf(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER)));
        element.addParameter(new Parameter(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, this.getSrValueOf(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE)));
        element.addParameter(new Parameter(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, this.getSrValueOf(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM)));
    }

    public boolean isDeviceSuitableForLocalCopy(HashSet set, VolumeNodeImpl volume, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        if (!set.contains(this)) {
            ArrayList devices = volume.getDevicesOfVolume();
            for (int j = 0; j < devices.size(); ++j) {
                if (((VolumeNodeImpl)devices.get(j)).getRootVolume().isPreventLocalCopy(set, remoteCluster)) continue;
                return false;
            }
            set.add(this);
        }
        return true;
    }

    public ConfigElementDataList buildCedListForRemoveVolumeTree(Vector subdisks, ConfigElementDataList elementList) throws RemoteException {
        for (int i = 0; i < this.subDirectAccessDevices.size(); ++i) {
            if (subdisks.contains(this.subDirectAccessDevices.get(i))) continue;
            return elementList;
        }
        return super.buildCedListForRemoveVolumeTree(subdisks, elementList);
    }

    protected LogicObject findEquivelentElement(Cluster cluster, LogicObject childVol) throws RemoteException, IllegalValueException {
        Vector devices = cluster.getStorage().getStorageDevices();
        for (int i = 0; i < devices.size(); ++i) {
            DirectAccessDevice device = (DirectAccessDevice)devices.get(i);
            if (!this.equals(device)) continue;
            return device;
        }
        return null;
    }

    protected void setExsistentElementIfNeeded(LogicObjectImpl source) throws RemoteException, IllegalValueException {
        HashMap<ClientParameterCode, Number> changeValues = new HashMap<ClientParameterCode, Number>();
        if (this.getBlockSize() == BlockSizeConstant.BLOCK_SIZE_ONE.getBlockSize()) {
            changeValues.put(ClientParameterCode.SCSI_DEVICE_BLOCK_SIZE, new Integer(((DirectAccessDeviceImpl)source).getBlockSize()));
        }
        if (this.getNumberOfBlocks().intValue() == 0) {
            changeValues.put(ClientParameterCode.SCSI_DEVICE_BLOCK_NUMBER, ((DirectAccessDeviceImpl)source).getNumberOfBlocks());
        }
        this.changeElement(changeValues);
    }

    public BigInteger getNumberOfBlocks() throws RemoteException {
        return this.getNumberOfBlocks(null);
    }

    protected void createIscsiDisk(ConfigElementData element, Cluster remoteCluster) throws RemoteException, IllegalAccessException, IllegalValueException {
        if (this.subDirectAccessDevices != null && !this.subDirectAccessDevices.isEmpty()) {
            throw new IllegalValueException("The disk already has sub disk on it you cannot create volume on it");
        }
    }

    public BigInteger getNumberOfBlocks(VSwitch vSwitch) throws RemoteException {
        return (BigInteger)this.getValueOf(vSwitch, ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, vSwitch == null);
    }

    public BigInteger getTotalSpace() throws RemoteException {
        return this.getTotalSpace(null);
    }

    public BigInteger getTotalSpace(VSwitch vSwitch) throws RemoteException {
        int blkSize = this.getBlockSize(vSwitch);
        if (blkSize != -1) {
            BigInteger blockSize = new BigInteger(Integer.toString(blkSize));
            return this.getNumberOfBlocks(vSwitch).multiply(blockSize);
        }
        return null;
    }

    public BigInteger getNonAllocatedSpace() throws RemoteException {
        BigInteger totalSpace = this.getTotalSpace();
        return totalSpace == null ? null : this.getTotalSpace().subtract(this.getAllocatedSpace());
    }

    public int getBlockSize(VSwitch vSwitch) throws RemoteException {
        SrType value = this.getSrValueOf(vSwitch, ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, vSwitch == null);
        if (value == null) {
            return -1;
        }
        return ((SrInteger)value).intValue();
    }

    public BigInteger getBlockSizeBigInteger(VSwitch vSwitch) throws RemoteException {
        int bs = this.getBlockSize(vSwitch);
        return new BigInteger(Integer.toString(bs));
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.numberOfBlocks = this.getNumberOfBlocks();
        this.blockSize = new Integer(this.getBlockSize());
        if (this.storageSpaceManager == null) {
            this.storageSpaceManager = new StorageSpaceManager(this.getTotalSpace(), this.getBlockSize(), this.isProvisioned());
        } else if (PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.equals(this.getTransportType())) {
            BigInteger totalSpace = this.getTotalSpace();
            int blockSize = this.getBlockSize();
            boolean isProv = this.isProvisioned();
            if (totalSpace != null) {
                this.storageSpaceManager.setTotalSize(totalSpace);
            }
            if (blockSize > -1) {
                this.storageSpaceManager.setBlockSize(blockSize);
            }
            this.storageSpaceManager.setProvisioned(isProv);
        }
        return changedValues;
    }

    public void addSubDirectAccessDevice(SubDirectAccessDevice subDirectAccessDevice) throws RemoteException {
        if (!this.subDirectAccessDevices.contains(subDirectAccessDevice)) {
            this.subDirectAccessDevices.add(subDirectAccessDevice);
            this.storageSpaceManager.addOccupiedSpace(subDirectAccessDevice.getStartAddress(), subDirectAccessDevice.getSize());
            this.setFree(false);
        }
    }

    public void removeSubDirectAccessDevice(SubDirectAccessDevice subDirectAccessDevice) throws RemoteException {
        this.subDirectAccessDevices.remove(subDirectAccessDevice);
        this.storageSpaceManager.removeOccupiedSpace(subDirectAccessDevice.getStartAddress(), subDirectAccessDevice.getSize());
        if (this.subDirectAccessDevices.isEmpty()) {
            this.setFree(true);
        }
    }

    public BigInteger getEndAddress() throws RemoteException {
        return this.getEndAddress(null);
    }

    public BigInteger getEndAddress(VSwitch vSwitch) throws RemoteException {
        return this.getTotalSpace(vSwitch).subtract(this.getBlockSizeBigInteger(vSwitch));
    }

    public Vector getSubDirectAccessDevices() throws RemoteException {
        return new Vector(this.subDirectAccessDevices);
    }

    private Vector getNotRedundantSubDirectAccessDevices(VSwitch vSwitch) throws RemoteException {
        Vector<SubDirectAccessDeviceImpl> notRedundantVector = new Vector<SubDirectAccessDeviceImpl>();
        Enumeration e = this.getSubDirectAccessDevices().elements();
        while (e.hasMoreElements()) {
            SubDirectAccessDeviceImpl sd = (SubDirectAccessDeviceImpl)e.nextElement();
            if (sd.isRedundant() || !sd.isKnownByVSwitch(vSwitch)) continue;
            notRedundantVector.addElement(sd);
        }
        return notRedundantVector;
    }

    public Vector getStorageSpaceStatus() throws RemoteException {
        Vector freeSpace;
        Vector tempStatus = new Vector();
        if (this.subDirectAccessDevices.size() > 0) {
            tempStatus.addAll(this.subDirectAccessDevices);
        }
        if ((freeSpace = this.storageSpaceManager.getFreeSpaceVector()).size() > 0) {
            tempStatus.addAll(freeSpace);
        }
        this.m_storageSpaceStatus.retainAll(tempStatus);
        tempStatus.removeAll(this.m_storageSpaceStatus);
        this.m_storageSpaceStatus.addAll(tempStatus);
        if (this.m_storageSpaceStatus.size() > 0) {
            Collections.sort(this.m_storageSpaceStatus, new StorageSpaceComparator());
        }
        return this.m_storageSpaceStatus;
    }

    public double getBlockNum() throws RemoteException {
        return this.getNumberOfBlocks(null).doubleValue();
    }

    public double getBlockNum(VSwitch vswitch) throws RemoteException {
        return this.getNumberOfBlocks(vswitch).doubleValue();
    }

    public int getSubDirectAccessDevicesCount() {
        return this.subDirectAccessDevices.size();
    }

    public Boolean isAllocable() throws RemoteException {
        Integer allocable = (Integer)this.getValueOf(this.getActiveVswitch(), ParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE);
        if (allocable != null) {
            return allocable == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public boolean isDiskFull() throws RemoteException {
        return this.getNonAllocatedSpace().longValue() == 0L;
    }

    public boolean isSubDirectAccessDeviceAliasExist(String alias) throws RemoteException {
        Iterator iter = this.subDirectAccessDevices.iterator();
        while (iter.hasNext()) {
            SubDirectAccessDevice device = (SubDirectAccessDevice)iter.next();
            if (!device.getAlias().equals(alias)) continue;
            return true;
        }
        return false;
    }

    public SubDirectAccessDeviceImpl getSubDirectAccessDevice(String alias) throws RemoteException {
        Iterator iter = this.subDirectAccessDevices.iterator();
        while (iter.hasNext()) {
            SubDirectAccessDeviceImpl device = (SubDirectAccessDeviceImpl)iter.next();
            if (!device.getAlias().equals(alias)) continue;
            return device;
        }
        return null;
    }

    public SubDirectAccessDevice isStartAddressOccupied(BigInteger startAddr) throws RemoteException {
        Enumeration e = this.getSubDirectAccessDevices().elements();
        while (e.hasMoreElements()) {
            SubDirectAccessDevice device = (SubDirectAccessDevice)e.nextElement();
            BigInteger min = device.getStartAddress();
            BigInteger max = device.getEndAddress();
            if (startAddr.compareTo(min) == -1 || startAddr.compareTo(max) == 1) continue;
            return device;
        }
        return null;
    }

    public boolean isStartAddressCompatible(BigInteger startAddr, BigInteger size) throws RemoteException {
        if (this.isStartAddressOccupied(startAddr) != null) {
            return false;
        }
        if (this.isProvisioned()) {
            return true;
        }
        return this.storageSpaceManager.isStartAddressCompatible(startAddr, size);
    }

    public SubDirectAccessDevice getSubDirectAccessDevice(BigInteger endAddr) throws RemoteException {
        Iterator iter = this.subDirectAccessDevices.iterator();
        while (iter.hasNext()) {
            BigInteger endBlocks;
            SubDirectAccessDevice subDirectAccessDevice = (SubDirectAccessDevice)iter.next();
            BigInteger endBytes = subDirectAccessDevice.getEndAddress();
            if (this.getBlockSize() == 0 || (endBlocks = Util.bytesToBlocks(endBytes, this.getBlockSize())).compareTo(endAddr) != 0) continue;
            return subDirectAccessDevice;
        }
        return null;
    }

    public void createSubDirectAccessDevice(String alias, BigInteger startAddr, BigInteger size, Vector vSwitches, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        int blockSize = this.getBlockSize();
        if (this.getBlockSize() == 0) {
            throw new IllegalValueException("The block size of " + this.getClassId() + " " + this.getAlias() + " is 0");
        }
        if (alias.equals("")) {
            alias = SubDirectAccessDeviceCreateValidator.getDefaultAlias();
        }
        SubDirectAccessDeviceCreateValidator validator = new SubDirectAccessDeviceCreateValidator(this, alias, startAddr, size, this.cluster);
        SrType[] vSwitchesToSetData = null;
        vSwitchesToSetData = vSwitches != null ? validator.getLegalVSwitchesForOperation(vSwitches) : validator.getLegalVSwitchesForOperation(this.cluster.getConnectedVSwitches());
        ConfigElementData element = new ConfigElementData(ClassID.SUB_DIRECT_ACCESS_DEVICE);
        Parameter aliasName = new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, new SrString(alias));
        element.addParameter(aliasName);
        BigInteger numberOfBlocks = Util.bytesToBlocks(size, blockSize);
        BigInteger endAddress = startAddr.add(size);
        BigInteger endAddrBlocks = Util.bytesToBlocks(endAddress, blockSize);
        endAddrBlocks = endAddrBlocks.subtract(BigInteger.ONE);
        Parameter endAddr = new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR, new SrLunFormat(endAddrBlocks));
        element.addParameter(endAddr);
        Parameter len = new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, new SrLunFormat(numberOfBlocks));
        element.addParameter(len);
        CommKeyClassId parentCommKeyClassId = new CommKeyClassId(this.getCommKeys(), this.getClassId());
        Parameter parent = new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID, parentCommKeyClassId);
        element.addParameter(parent);
        element.setOperationInvoker(operationInvoker);
        element.setValues(ParameterCode.VSWITCH_ID, vSwitchesToSetData);
        this.cluster.createElement(element, ClassID.SUB_DIRECT_ACCESS_DEVICE, alias + " for " + this.getAlias(), vSwitches);
    }

    public void createSubDirectAccessDevice(String alias, BigInteger startAddr, BigInteger size) throws RemoteException, IllegalValueException {
        SubDirectAccessDeviceCreateValidator validator = new SubDirectAccessDeviceCreateValidator(this, alias, startAddr, size, this.cluster);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        this.createSubDirectAccessDevice(alias, startAddr, size, null, null);
    }

    public void createSubDirectAccessDevice(String alias, BigInteger size) throws RemoteException, IllegalValueException {
        BigInteger startAddr = null;
        startAddr = this.storageSpaceManager.getBestFitStartAddress(size);
        if (startAddr == null) {
            String msg = ErrorMessage.CAPACITY_IS_TOO_HIGH.getMessage(size + " Bytes");
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        this.createSubDirectAccessDevice(alias, startAddr, size);
    }

    public void createSubDirectAccessDevice(String alias) throws RemoteException, IllegalValueException {
        BigInteger size = this.storageSpaceManager.getLastAvailableSpaceSize();
        this.createSubDirectAccessDevice(alias, size);
    }

    public BigInteger getAccessibleSpace() throws RemoteException {
        if (this.subDirectAccessDevices.size() > 0) {
            BigInteger accessibleSpace = BigInteger.ZERO;
            Iterator i = this.subDirectAccessDevices.iterator();
            while (i.hasNext()) {
                SubDirectAccessDevice subDirectAccessDevice = (SubDirectAccessDevice)i.next();
                accessibleSpace = accessibleSpace.add(subDirectAccessDevice.getAccessibleSpace());
            }
            return accessibleSpace;
        }
        return this.getTotalSpace();
    }

    public BigInteger getAllocatedSpace() throws RemoteException {
        if (this.subDirectAccessDevices.size() > 0) {
            BigInteger allocatedSpace = BigInteger.ZERO;
            Iterator i = this.subDirectAccessDevices.iterator();
            while (i.hasNext()) {
                SubDirectAccessDevice subDirectAccessDevice = (SubDirectAccessDevice)i.next();
                allocatedSpace = allocatedSpace.add(subDirectAccessDevice.getAllocatedSpace());
            }
            return allocatedSpace;
        }
        if (this.getParentVolume() == null && this.getParentLU() == null) {
            return BigInteger.ZERO;
        }
        return this.getTotalSpace();
    }

    protected String canBeDeleted() throws RemoteException {
        CopyOperationImpl oper;
        String msg = super.canBeDeleted();
        if (msg == null && !this.subDirectAccessDevices.isEmpty()) {
            return "You cannot remove " + this.getClassId() + " " + this.getAlias() + ", because it has sub-disks";
        }
        if (this.getParentVolume() == null && (oper = ((CopyOperationManagerImpl)this.cluster.getCopyOperManager()).getCopyForNode(this.getCommKeyClassId())) != null) {
            return ErrorMessage.CANNOT_DELETE_PHYS_STOR_IN_COPY.getMessage(msg);
        }
        return msg;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        BigInteger blockNum;
        Integer blockSize;
        Boolean allocable;
        String msg = super.isValid(parameterList);
        if (msg != null) {
            return msg;
        }
        Object wce = parameterList.get(ClientParameterCode.DIRECT_ACCESS_DEVICE_WCE_ENABLE_STATE);
        if (wce != null) {
            parameterList.put(ClientParameterCode.DIRECT_ACCESS_DEVICE_WCE_ENABLE_STATE, new SrBoolean((Boolean)wce));
        }
        if ((allocable = (Boolean)parameterList.get(ClientParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE)) != null) {
            parameterList.put(ClientParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE, new SrBoolean((boolean)allocable));
        }
        if ((blockSize = (Integer)parameterList.get(ClientParameterCode.SCSI_DEVICE_BLOCK_SIZE)) != null) {
            parameterList.put(ClientParameterCode.SCSI_DEVICE_BLOCK_SIZE, new SrInteger(blockSize));
        }
        if ((blockNum = (BigInteger)parameterList.get(ClientParameterCode.SCSI_DEVICE_BLOCK_NUMBER)) != null) {
            parameterList.put(ClientParameterCode.SCSI_DEVICE_BLOCK_NUMBER, new SrLunFormat(blockNum));
        }
        return null;
    }

    public void clear() throws RemoteException {
        this.subDirectAccessDevices.clear();
        this.allocatedSpace.clear();
        this.storageSpaceManager = null;
        this.m_storageSpaceStatus.clear();
        super.clear();
    }

    private int synchronizeSubdisks() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        int syncRetVal = 0;
        Iterator iter = this.subDirectAccessDevices.iterator();
        while (iter.hasNext()) {
            try {
                SubDirectAccessDevice subDirectAccessDevice = (SubDirectAccessDevice)iter.next();
                int sdRetVal = subDirectAccessDevice.synchronize();
                LogMgr.getServerLog().debug("Sync of Disk " + this.getAlias() + "Subdisk " + subDirectAccessDevice.getAlias() + " Sync status " + sdRetVal);
                if (sdRetVal <= syncRetVal) continue;
                syncRetVal = sdRetVal;
            }
            catch (IllegalValueException ive) {
                logger.warning(ive.getMessage());
                errMsg.append(" \n");
                errMsg.append(ive.getMessage());
                errOccured = true;
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        if (syncRetVal == 1) {
            syncRetVal = 2;
        }
        return syncRetVal;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        logger.debug("Start to synchronize " + this.getClassId() + " " + this.toString());
        LogMgr.getServerLog().info("Start Sync of Disk " + this.getAlias());
        int retVal = 0;
        retVal = super.synchronize();
        LogMgr.getServerLog().debug("Sync of target " + this.getAlias() + " After Super completion status " + retVal);
        if (retVal == 0) {
            retVal = this.synchronizeSubdisks();
            switch (retVal) {
                case 3: {
                    this.setSynchronizePending(false);
                    break;
                }
                case 1: {
                    retVal = 2;
                }
            }
        }
        return retVal;
    }

    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        if (!this.isNeedToSynchronize()) {
            this.synchronizeSubdisks();
            return;
        }
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    public AlarmGenerator getAlarmGenerator() {
        return DirectAccessDeviceAlarmGenerator.getThisInstance();
    }

    public SubDirectAccessDevice getSubDirectAccessDevice(BigInteger startAddr, BigInteger endAddr, VSwitch vSwitch) throws RemoteException {
        Enumeration e = this.getSubDirectAccessDevices().elements();
        while (e.hasMoreElements()) {
            SubDirectAccessDeviceImpl sd = (SubDirectAccessDeviceImpl)e.nextElement();
            if (!sd.isKnownByVSwitch(vSwitch)) continue;
            BigInteger start = sd.getStartAddress(vSwitch);
            BigInteger end = sd.getEndAddress(vSwitch);
            if (end.compareTo(startAddr) < 0 || start.compareTo(endAddr) > 0) continue;
            return sd;
        }
        return null;
    }

    public HashMap getInconsistentSubDirectAccessDevice() throws RemoteException {
        if (this.isRedundant()) {
            VSwitch firstVSwitch = this.getFirstVSwitch();
            Vector notRedundantVector = this.getNotRedundantSubDirectAccessDevices(firstVSwitch);
            VSwitch otherVSwitch = this.cluster.getOtherVSwitch(firstVSwitch);
            HashMap<SubDirectAccessDeviceImpl, SubDirectAccessDevice> inconsistentSDs = null;
            Enumeration e = notRedundantVector.elements();
            while (e.hasMoreElements()) {
                BigInteger endAddr;
                SubDirectAccessDeviceImpl notRedundantSD = (SubDirectAccessDeviceImpl)e.nextElement();
                BigInteger startAddr = notRedundantSD.getStartAddress(firstVSwitch);
                SubDirectAccessDevice inconsistent = this.getSubDirectAccessDevice(startAddr, endAddr = notRedundantSD.getEndAddress(firstVSwitch), otherVSwitch);
                if (inconsistent == null) continue;
                if (inconsistentSDs == null) {
                    inconsistentSDs = new HashMap<SubDirectAccessDeviceImpl, SubDirectAccessDevice>();
                }
                inconsistentSDs.put(notRedundantSD, inconsistent);
            }
            return inconsistentSDs;
        }
        return null;
    }

    public boolean hasIllegalSubDirectAccessDevice() throws RemoteException {
        return this.getParentVolume() != null && !this.getSubDirectAccessDevices().isEmpty();
    }

    protected boolean compareNoAffectOnVirtualizationWith(GeneralSCSIDeviceImpl device) {
        boolean result = super.compareNoAffectOnVirtualizationWith(device);
        if (result) {
            if (this.numberOfBlocks != null && ((DirectAccessDeviceImpl)device).numberOfBlocks == null || this.numberOfBlocks == null && ((DirectAccessDeviceImpl)device).numberOfBlocks != null) {
                return false;
            }
            if (this.blockSize.compareTo(((DirectAccessDeviceImpl)device).blockSize) == 0 && (this.numberOfBlocks == null && ((DirectAccessDeviceImpl)device).numberOfBlocks == null || this.numberOfBlocks.compareTo(((DirectAccessDeviceImpl)device).numberOfBlocks) == 0) || this.numberOfBlocks.intValue() == 0 || ((DirectAccessDeviceImpl)device).numberOfBlocks.intValue() == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean isIllegalDownHierarchy() {
        try {
            return this.getInconsistentSubDirectAccessDevice() != null || this.hasIllegalSubDirectAccessDevice();
        }
        catch (RemoteException e) {
            logger.error(e);
            return true;
        }
    }

    public boolean isIllegalUpHierarchy() {
        try {
            VolumeImpl parentVol = (VolumeImpl)this.getParentVolume();
            LUImpl parentLu = (LUImpl)this.getParentLU();
            boolean isOk = true;
            if (parentVol != null) {
                isOk = !parentVol.isIllegalUpHierarchy();
            } else if (parentLu != null) {
                isOk = ((LUImpl)this.getHeadLU()).isLegitimateForVolumeOperation();
            }
            if (isOk) {
                isOk = this.getInconsistentSubDirectAccessDevice() == null && !this.hasIllegalSubDirectAccessDevice();
            }
            return !isOk;
        }
        catch (RemoteException re) {
            logger.error(re);
            return false;
        }
    }
}

