/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.lu;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.lu.SCSILun;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrScsiLUNFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.SCSILunStateConstant;
import com.sanrad.nms.server.util.types.constants.SCSILunStatusConstant;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class SCSILunImpl
extends LogicObjectImpl
implements SCSILun {
    private static final ParameterCode[] parameterCodeList = new ParameterCode[]{ParameterCode.SCSI_LUN_LU_NUMBER, ParameterCode.SCSI_LUN_REVISION_ID, ParameterCode.SCSI_LUN_STATE, ParameterCode.SCSI_LUN_STATUS};
    private LUImpl lu;
    private CommKey[] scsiTargetKeys = null;

    public SCSILunImpl(ClusterImpl cluster, LUImpl lu) throws RemoteException {
        super(cluster, ClassID.SCSI_LUN, parameterCodeList);
        this.lu = lu;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public Integer getLUN() throws RemoteException {
        return this.getLUN(null);
    }

    public Integer getLUN(VSwitch vSwitch) throws RemoteException {
        SrScsiLUNFormat lun = (SrScsiLUNFormat)this.getSrValueOf(vSwitch, ParameterCode.SCSI_LUN_LU_NUMBER, vSwitch == null);
        return lun != null ? lun.toInt() : null;
    }

    public String getRevisionID() throws RemoteException {
        return this.getRevisionID(null);
    }

    public String getRevisionID(VSwitch vSwitch) throws RemoteException {
        SrString rev = (SrString)this.getSrValueOf(vSwitch, ParameterCode.SCSI_LUN_REVISION_ID, vSwitch == null);
        return rev != null ? rev.toString() : null;
    }

    public SCSILunStateConstant getState() throws RemoteException {
        return this.getState(null);
    }

    public SCSILunStateConstant getState(VSwitch vSwitch) throws RemoteException {
        SCSILunStateConstant state = (SCSILunStateConstant)this.getSrValueOf(vSwitch, ParameterCode.SCSI_LUN_STATE, vSwitch == null);
        return state;
    }

    public SCSILunStatusConstant getStatus() throws RemoteException {
        return this.getStatus(null);
    }

    public SCSILunStatusConstant getStatus(VSwitch vSwitch) throws RemoteException {
        SCSILunStatusConstant status = (SCSILunStatusConstant)this.getSrValueOf(vSwitch, ParameterCode.SCSI_LUN_STATUS, vSwitch == null);
        return status;
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        this.setSCSITargetCommKeyClassID((CommKeyClassId)parameterList.get(ParameterCode.SCSI_DEVICE_ID));
        HashMap changedValues = super.setParameterList(parameterList);
        if (this.cluster.isDiscoverCompleted()) {
            ElementEventImpl elementEvent = new ElementEventImpl(this.lu, this.lu);
            Object vSwitchObj = parameterList.get(ParameterCode.VSWITCH_ID);
            CommKeyClassId vswitchID = vSwitchObj instanceof CommKeyClassId ? (CommKeyClassId)vSwitchObj : ((CommKeyClassId[])vSwitchObj)[0];
            VSwitchImpl vSwitch = (VSwitchImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(vswitchID);
            if (vSwitch != null) {
                elementEvent.setVSwitchIp(vSwitch.getMgmIPAddr());
            }
            elementEvent.setParameterList(parameterList);
            EventServiceImpl.getInstance().fireElementChanged(elementEvent);
        }
        this.toStringValue = this.getLUN().toString();
        return changedValues;
    }

    private void setSCSITargetCommKeyClassID(CommKeyClassId scsiTarget) {
        this.scsiTargetKeys = this.scsiTargetKeys == null ? scsiTarget.getCommKeys() : CommKeyUtil.mergerCommKeyLists(this.scsiTargetKeys, scsiTarget.getCommKeys());
    }

    public CommKey[] removeFromVSwitch(VSwitch vSwitch) throws RemoteException {
        Vector<CommKey> commKeysVec = new Vector<CommKey>(Arrays.asList(this.scsiTargetKeys));
        CommKeyUtil.removeSpecificCommKeys(commKeysVec, vSwitch.getCommKeys());
        return super.removeFromVSwitch(vSwitch);
    }

    public CommKeyClassId getSCSITargetID() {
        return new CommKeyClassId(this.scsiTargetKeys, ClassID.SCSI_TARGET);
    }
}

