/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.lu;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.StorageSize;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Vector;

public class LUValidator
extends LogicObjectValidator {
    private static final StorageSize MIN_VOL_SIZE = StorageSize.MEGA;
    protected int luNumber;
    protected VolumeNode volume;
    protected TargetImpl target;
    protected ClusterImpl cluster;

    public LUValidator(ClusterImpl cluster, int luNumber, VolumeNode volume, Target target) throws RemoteException {
        this.cluster = cluster;
        this.luNumber = luNumber;
        this.volume = volume;
        this.target = (TargetImpl)target;
    }

    public boolean isValid() throws RemoteException {
        CopyOperationManagerImpl copyMgr;
        VolumeNode sourceVolume;
        VSwitch vSwitch;
        if (this.volume == null) {
            this.setErrorMsg("Volume for exposure not found");
            return false;
        }
        if (!this.cluster.isSingleVSwitchMode() && (vSwitch = ((VolumeNodeImpl)this.volume).isInvolvedInActiveCopyDownHirarchy()) != null) {
            this.setErrorMsg(this.volume.getClassId() + " " + this.volume + " is part of copy operation on " + ClassID.VSWITCH + " " + vSwitch + ". You cannot expose it until the operation is done/aborted");
            return false;
        }
        if (this.target.isExposedOnDifferentVSwitches()) {
            String[] msg = new String[]{this.target.getClassId().toString(), this.target.getAlias()};
            this.setErrorMsg(ErrorMessage.TARGET_EXPOSED_ON_DIFFERENT_VSWITCHES.getMessage(msg));
            return false;
        }
        Volume parentVolume = this.volume.getParentVolume();
        if (parentVolume != null) {
            this.setErrorMsg("You cannot expose " + this.volume.getClassId() + " " + this.volume + ".  It has a parent: " + parentVolume.getClassId() + " " + parentVolume);
            return false;
        }
        if (this.volume.getClassId().equals(ClassID.SNAPSHOT_VOLUME) && (sourceVolume = ((SnapshotVolume)this.volume).getSourceVolume()).isExposed()) {
            TargetImpl sourceVolTarget = (TargetImpl)sourceVolume.getParentLU().getParentTarget();
        }
        if ((copyMgr = (CopyOperationManagerImpl)this.cluster.getCopyOperManager()).isInvolvedInActiveCopyOper(this.volume.getCommKeyClassId())) {
            this.setErrorMsg("You cannot expose " + this.volume.getClassId() + " " + this.volume + ".  It's a part of a copy Operation");
            return false;
        }
        String exposedOnVSwitch = this.target.getExposedOnVSwitch();
        VSwitch[] vSwitches = this.volume.getConnectedVSwitchesList();
        boolean valid = false;
        for (int i = 0; i < vSwitches.length; ++i) {
            String name = vSwitches[i].getName();
            if (!name.equals(exposedOnVSwitch)) continue;
            valid = true;
        }
        if (!valid && !this.volume.getClassId().equals(ClassID.SNAPSHOT_VOLUME)) {
            StringBuffer logMsg = new StringBuffer("Cannot expose ");
            logMsg.append(this.volume.getClassId());
            logMsg.append(" ");
            logMsg.append(this.volume);
            logMsg.append(" on ");
            logMsg.append(ClassID.VSWITCH);
            logMsg.append(" ");
            logMsg.append(exposedOnVSwitch);
            logMsg.append(". The volume exists only on ");
            logMsg.append(ClassID.VSWITCH);
            logMsg.append("(es) ");
            for (int i = 0; i < vSwitches.length; ++i) {
                logMsg.append(vSwitches[i].getName());
                logMsg.append("; ");
            }
            logger.warning(logMsg.toString());
            this.setErrorMsg("You cannot expose " + this.volume.getClassId() + " " + this.volume + " on " + ClassID.VSWITCH + " " + exposedOnVSwitch + ".  The volume doesn't exist on this " + ClassID.VSWITCH);
            return false;
        }
        BigInteger accessibleSpace = this.volume.getAccessibleSpace();
        if (!this.volume.getClassId().equals(ClassID.TRANSPARENT_VOLUME) && accessibleSpace.compareTo(MIN_VOL_SIZE.getValue()) == -1 && accessibleSpace.compareTo(BigInteger.ZERO) != 0) {
            this.setErrorMsg("You cannot expose " + this.volume.getClassId() + " " + this.volume + ".  The volume size must be 1" + MIN_VOL_SIZE + " or greater");
            return false;
        }
        return true;
    }

    public CommKeyClassId[] getLegalVSwitchesForOperation(Vector vSwitchToSet) throws RemoteException, IllegalValueException {
        CommKeyClassId[] vSwitches = new CommKeyClassId[vSwitchToSet.size()];
        for (int i = 0; i < vSwitchToSet.size(); ++i) {
            vSwitches[i] = ((VSwitchImpl)vSwitchToSet.get(i)).getCommKeyClassId();
        }
        return this.getLegalVSwitchesForOperation(vSwitches);
    }

    public CommKeyClassId[] getLegalVSwitchesForOperation(CommKeyClassId[] vSwitchToSet) throws RemoteException, IllegalValueException {
        if (!this.isValid()) {
            throw new IllegalValueException("Operation is not Valid");
        }
        CommKeyClassId[] allChildrenExistOn = this.getVSwitchesAllElementsExistIn(this.volume, this.cluster);
        return this.getVSwitchesToSet(vSwitchToSet, allChildrenExistOn);
    }
}

