/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.lu;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUValidator;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;

public class LUSyncValidator
extends LUValidator {
    private Vector vSwitches;

    public LUSyncValidator(ClusterImpl cluster, int luNumber, VolumeNode volume, Target target, Vector vSwitchToSet) throws RemoteException {
        super(cluster, luNumber, volume, target);
        this.vSwitches = vSwitchToSet;
    }

    public boolean isValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        if (this.isLuNumberExist(this.target)) {
            String[] msgParts = new String[]{Integer.toString(this.luNumber), this.target.getAlias()};
            this.setErrorMsg(ErrorMessage.LUN_ALREADY_IN_USE.getMessage(msgParts));
            return false;
        }
        return true;
    }

    private boolean isLuNumberExist(TargetImpl tgt) {
        try {
            Iterator itr = this.vSwitches.iterator();
            while (itr.hasNext()) {
                if (!tgt.isLUNumberExist((VSwitch)itr.next(), this.luNumber)) continue;
                return true;
            }
            return false;
        }
        catch (RemoteException re) {
            logger.error(re);
            return false;
        }
    }
}

