/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.lu;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.lu.LUAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SynchronizeEvent;
import com.sanrad.nms.server.logic.SynchronizeListener;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.VirtualizationHierarchyObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.lu.LUSyncValidator;
import com.sanrad.nms.server.logic.lu.SCSILunImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeParentable;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.LUOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.SCSILunStateConstant;
import com.sanrad.nms.server.util.types.constants.SCSILunStatusConstant;
import com.sanrad.util.SrConstantsBundleKeys;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class LUImpl
extends SynchronizeableImpl
implements LU,
SynchronizeListener,
VolumeParentable,
VirtualizationHierarchyObject {
    public static final int MAX_LUN_VALUE = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.MAX_LUN_VALUE));
    private static List parameterCodeList;
    private Target parentTaregt = null;
    private VolumeNode volumeChild = null;
    private Integer lun = null;
    private SCSILunImpl scsiLun = null;

    public LUImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.LUN, parameterCodeList);
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        VolumeNode volume = this.getVolumeChild();
        Parameter childVolume = new Parameter(ParameterCode.LU_VOLUME_ID, new CommKeyClassId(volume.getCommKeys(), volume.getClassId()));
        ced.addParameter(childVolume);
        this.deleteElement(ced);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        BigInteger luNumber = (BigInteger)this.getSrValueOf(null, ParameterCode.LU_LUN_NUMBER, true).value();
        this.lun = new Integer(luNumber.intValue());
        this.toStringValue = this.getLUN().toString();
        boolean newElement = this.parentTaregt == null;
        VSwitch vSwitch = this.getVSwitch(parameterList);
        if (this.parentTaregt == null) {
            this.parentTaregt = this.getParentTarget(vSwitch);
            if (this.parentTaregt == null) {
                throw new IllegalValueException(ClassID.VSWITCH + " " + vSwitch + ".  Target of LU " + this.lun + " is null");
            }
        }
        VolumeNode oldVolume = null;
        if (parameterList.containsKey(ParameterCode.LU_VOLUME_ID)) {
            oldVolume = this.volumeChild;
            this.volumeChild = this.getVolumeChild(vSwitch);
        }
        if (this.volumeChild == null) {
            throw new IllegalValueException(ClassID.VSWITCH + " " + vSwitch + ".  Volume of LU " + this.lun + " on target " + this.parentTaregt + " is null");
        }
        this.toStringValue = this.parentTaregt.toString() + "/" + this.getLUN().toString();
        if (oldVolume != null && !this.volumeChild.equals(oldVolume)) {
            ((SynchronizeableImpl)((Object)oldVolume)).removeSynchronizeListener(this);
            if (oldVolume.getParentLU() != null && oldVolume.getParentLU().equals(this)) {
                ((StorageImpl)this.cluster.getStorage()).returnVolumeToForest((VolumeNodeImpl)oldVolume);
            } else {
                this.removePropagationStateDependentObjectAndListener((VolumeNodeImpl)oldVolume);
            }
            this.setVol((VolumeNodeImpl)this.volumeChild);
        }
        if (newElement) {
            ((SynchronizeableImpl)((Object)this.parentTaregt)).addSynchronizeListener(this);
            this.setVol((VolumeNodeImpl)this.volumeChild);
        }
        this.synchronizeSerialNumber();
        return changedValues;
    }

    public void synchronizeSerialNumber() throws RemoteException, IllegalValueException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        if (vSwitches.length > 1) {
            SrType luSerialNumberOnNotExposed;
            SrType luSerialNumberOnExposed;
            VSwitch exposedOnVSwitch = this.getExposedOnVSwitch();
            VSwitch notExposedOnVSwitch = this.getNotExposedOnVSwitch();
            CommKey exposedKey = CommKeyUtil.getSpecificCommKey(this.getCommKeyClassId(), exposedOnVSwitch.getCommKeyClassId().getMyFirstSnmpAgentIndex());
            CommKey notExposedKey = CommKeyUtil.getSpecificCommKey(this.getCommKeyClassId(), notExposedOnVSwitch.getCommKeyClassId().getMyFirstSnmpAgentIndex());
            if (exposedKey != null && notExposedKey != null && !(luSerialNumberOnExposed = this.getLUSerialNumber(exposedOnVSwitch)).equals(luSerialNumberOnNotExposed = this.getLUSerialNumber(notExposedOnVSwitch)) && this.isNullSerialNumberValue((SrString)luSerialNumberOnNotExposed)) {
                ConfigElementData element = new ConfigElementData(this.getCommKeyClassId());
                element.setValue(ParameterCode.LU_SERIAL_NUMBER, luSerialNumberOnExposed);
                element.setValue(ParameterCode.VSWITCH_ID, notExposedOnVSwitch.getCommKeyClassId());
                DataMgr.getInstance().changeElement(element);
            }
        }
    }

    private boolean isNullSerialNumberValue(SrString value) {
        if (value.toString().length() == 0) {
            return true;
        }
        if (this.isMonfoxHexaString(value.toString())) {
            String strval = value.toString();
            BigInteger bigint = new BigInteger(strval.substring(1, strval.length() - 2), 16);
            return bigint.compareTo(BigInteger.ZERO) == 0;
        }
        return false;
    }

    private boolean isMonfoxHexaString(String str) {
        if (str == null || str.length() < 5) {
            return false;
        }
        int len = str.length();
        if (str.charAt(0) == '\'' && str.charAt(len - 2) == '\'' && (str.charAt(len - 1) == 'H' || str.charAt(len - 1) == 'h') && (len - 1) % 2 == 0) {
            char c;
            String hexStr = str.substring(1, len - 2).toLowerCase();
            int i = hexStr.length();
            while (i-- > 0 && (Character.isDigit(c = hexStr.charAt(i)) || c >= 'a' && c <= 'f')) {
            }
            return i == -1;
        }
        return false;
    }

    private VSwitch getExposedOnVSwitch() throws RemoteException {
        Target parent = this.getParentTarget();
        String vSwitchName = parent.getExposedOnVSwitch();
        return ((ClusterImpl)this.getCluster()).getVSwitchByName(vSwitchName);
    }

    private VSwitch getNotExposedOnVSwitch() throws RemoteException {
        VSwitch exposedOnVSwitch = this.getExposedOnVSwitch();
        return ((ClusterImpl)this.getCluster()).getOtherVSwitch(exposedOnVSwitch);
    }

    public String getSerialNumber() throws RemoteException {
        VSwitch vs = this.getExposedOnVSwitch();
        if (vs == null) {
            vs = this.getFirstVSwitch();
        }
        return this.getSerialNumber(vs);
    }

    public String getSerialNumber(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(this.getExposedOnVSwitch(), ParameterCode.LU_SERIAL_NUMBER);
    }

    public SrType getLUSerialNumber() throws RemoteException {
        return this.getLUSerialNumber(this.getExposedOnVSwitch());
    }

    private SrType getLUSerialNumber(VSwitch vSwitch) throws RemoteException {
        SrType luSerialNumber = this.getSrValueOf(vSwitch, ParameterCode.LU_SERIAL_NUMBER, vSwitch == null);
        return luSerialNumber;
    }

    private void setVolumeExposed() throws RemoteException {
        if (this.volumeChild != null) {
            this.volumeChild.setExposed(true);
            this.volumeChild.setParentLU(this);
            this.volumeChild.setParent(null, 0);
        } else {
            Target parent = this.getParentTarget();
            String message = "Volume not found for " + ClassID.LUN + " " + this.getLUN() + " under " + parent.getClassId() + " " + parent.toString();
            logger.fatal("Snmp Configuration Error: " + message);
            ElementEventImpl elementEvent = new ElementEventImpl(this, this);
            elementEvent.setErrorMesaage(message);
            EventServiceImpl.getInstance().fireFatalConfigurationError(elementEvent);
        }
    }

    public Integer getLUN() throws RemoteException {
        return this.lun;
    }

    public Integer getLUN(VSwitch vSwitch) throws RemoteException {
        SrGauge lun = (SrGauge)this.getSrValueOf(vSwitch, ParameterCode.LU_LUN_NUMBER, vSwitch == null);
        if (lun != null) {
            return new Integer(((BigInteger)lun.value()).intValue());
        }
        return null;
    }

    public Target getParentTarget(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId targetCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.LU_PARENT, vSwitch == null);
        Target taregt = (Target)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(targetCommKeyClassId);
        return taregt;
    }

    public Target getParentTarget() throws RemoteException {
        return this.parentTaregt;
    }

    public VolumeNode getVolumeChild(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId volumeCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.LU_VOLUME_ID, vSwitch == null);
        VolumeNode volume = (VolumeNode)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(volumeCommKeyClassId);
        return volume;
    }

    public VolumeNode getVolumeChild() throws RemoteException {
        return this.volumeChild;
    }

    protected String canBeDeleted() throws RemoteException {
        VSwitch vSwitch = this.cluster.getVSwitchByName(this.getParentTarget().getExposedOnVSwitch());
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public BigInteger getAccessibleSpace() throws RemoteException {
        VolumeNode volume = this.getVolumeChild();
        return volume.getAccessibleSpace();
    }

    public int getTotalVolumeCount() throws RemoteException {
        int totalVolumeCount = 0;
        VolumeNode volume = this.getVolumeChild();
        if (volume instanceof Volume) {
            ++totalVolumeCount;
        }
        return totalVolumeCount += volume.getChildrenOfVirtualVolumeTypeCount();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LU) {
            try {
                if (((LU)obj).getLUN().equals(this.getLUN()) && ((LU)obj).getParentTarget().equals(this.getParentTarget())) {
                    VolumeNode volumeNode = ((LU)obj).getVolumeChild();
                    if (volumeNode != null && this.getVolumeChild() != null) {
                        return ((LU)obj).getVolumeChild().equals(this.getVolumeChild());
                    }
                    return volumeNode == null && this.getVolumeChild() == null;
                }
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
        return false;
    }

    private LUOperStatusConstant getState(VSwitch vSwitch) throws RemoteException {
        return (LUOperStatusConstant)this.getSrValueOf(vSwitch, ParameterCode.LU_OPER_STATUS, vSwitch == null);
    }

    private boolean isInState(VSwitch vSwitch, LUOperStatusConstant state) throws RemoteException {
        return state.equals(this.getState(vSwitch));
    }

    public boolean isWaitingForTarget(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, LUOperStatusConstant.LU_OPER_STATUS_WAITING_FOR_TARGET);
    }

    public boolean isInitializing(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, LUOperStatusConstant.LU_OPER_STATUS_INITIALIZING);
    }

    public boolean isActive(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, LUOperStatusConstant.LU_OPER_STATUS_ACTIVE);
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        this.addPropagationStateDependentObjectAndListener((LogicObjectImpl)((Object)this.getVolumeChild()));
        ((TargetImpl)this.getParentTarget()).addPropagationStateDependentObjectAndListener(this);
        VolumeNode volume = this.getVolumeChild();
        if (volume instanceof Volume) {
            ((VolumeImpl)volume).unRegisterToPropagatedStateListenerForAllLeafs(this.cluster);
        } else {
            this.cluster.removePropagationStateDependentObjectAndListener((LogicObjectImpl)((Object)volume));
        }
    }

    public void unregisterToPropagatedStateChange() throws RemoteException {
        ((TargetImpl)this.getParentTarget()).removePropagationStateDependentObjectAndListener(this);
    }

    public AlarmGenerator getAlarmGenerator() {
        return LUAlarmGenerator.getInstance();
    }

    public boolean isLU0() {
        return this.lun != null && this.lun == 0;
    }

    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        TargetImpl target = (TargetImpl)this.getParentTarget();
        if (target.isNeedToSynchronize()) {
            if (!target.isSynchronizePending()) {
                StringBuffer msg = new StringBuffer("LU ");
                msg.append(this.toString());
                msg.append(" cannot be synchronized. ");
                msg.append(target.getClassId());
                msg.append(" ");
                msg.append(target);
                msg.append("is not synchronized yet");
                throw new IllegalValueException(msg.toString());
            }
            String msg = "Target " + target.getAlias() + " is not synchronized.";
            return msg;
        }
        VolumeNodeImpl volume = (VolumeNodeImpl)this.getVolumeChild();
        if (volume.isNeedToSynchronize()) {
            if (!volume.isSynchronizePending()) {
                StringBuffer msg = new StringBuffer("LU ");
                msg.append(this.toString());
                msg.append(" cannot be synchronized. ");
                msg.append(volume.getClassId());
                msg.append(" ");
                msg.append(volume);
                msg.append("is not synchronized yet");
                throw new IllegalValueException(msg.toString());
            }
            String msg = "Volume " + volume.getAlias() + " is not synchronized.";
            return msg;
        }
        return null;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().debug("Start Sync of Lu " + this.toString());
        if (this.isSynchronizePending()) {
            logger.debug("Already synchronizing " + this.getClassId() + " " + this.toString());
            return 1;
        }
        logger.debug("Start to synchronize " + this.getClassId() + " " + this.toString());
        this.setSynchronizePending(true);
        int retVal = 0;
        try {
            retVal = this.getVolumeChild().synchronize();
            LogMgr.getServerLog().debug("Sync of Lu " + this.toString() + " Vol " + this.getVolumeChild().getAlias() + " Vol Sync status " + retVal);
            switch (retVal) {
                case 1: 
                case 2: {
                    return 2;
                }
                case 3: {
                    this.setSynchronizePending(false);
                    return 3;
                }
            }
            if (!this.isNeedToSynchronize()) {
                this.setSynchronizePending(false);
                return retVal;
            }
            retVal = this.synchronizeMe();
            LogMgr.getServerLog().debug("Sync of Lu " + this.toString() + " SyncMe status " + retVal);
            return retVal;
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            this.setSynchronizePending(false);
            throw ive;
        }
    }

    public int synchronizeMe() throws RemoteException, IllegalValueException {
        String msg = this.canBeSynchronized();
        if (msg != null) {
            return 2;
        }
        if (!this.isInSynchronizingMode()) {
            LogMgr.getServerLog().info("Sync Me for Lu " + this.toString());
            StorageImpl storage = (StorageImpl)this.cluster.getStorage();
            LUSyncValidator validator = new LUSyncValidator(this.cluster, this.getLUN(), this.getVolumeChild(), this.getParentTarget(), this.cluster.getOtherVSwitches(this.getVSwitches()));
            if (!validator.isValid()) {
                throw new IllegalValueException(validator.getErrorMsg());
            }
            storage.exposeVolume(this.getLUN(), this.getVolumeChild(), this.getParentTarget(), this.cluster.getOtherVSwitches(this.getVSwitches()), this.getCommKeyClassId(), this.getSerialNumber(this.getActiveVswitch()));
            LogMgr.getServerLog().info("After send SNMP in Sync Me for Lu " + this.toString());
            this.setSynchronizingMode(true);
        }
        return 2;
    }

    public void synchronizingCompleted(SynchronizeEvent event) {
        try {
            this.syncDataWasChanged();
        }
        catch (RemoteException re) {
            logger.warning(re);
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
        }
    }

    public void doneSynchronizing() throws RemoteException {
        super.doneSynchronizing();
    }

    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().info("syncDataWasChanged called  " + this.toString());
        if (!this.isSynchronizePending()) {
            return;
        }
        try {
            if (this.isNeedToSynchronize()) {
                this.synchronizeMe();
                return;
            }
        }
        catch (IllegalValueException ive) {
            logger.error(ive.getMessage());
            this.errorInSynchronizing();
            return;
        }
        this.doneSynchronizing();
    }

    public String getAlias() throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public void setVol(VolumeNodeImpl newVol) throws IllegalValueException, RemoteException {
        if (newVol.getParentLU() == null && newVol.getParentVolume() == null) {
            this.cluster.getVolumeMgr().removeVolumeFromForest(newVol);
        }
        this.volumeChild = newVol;
        newVol.addSynchronizeListener(this);
        this.addPropagationStateDependentObjectAndListener(newVol);
        this.setVolumeExposed();
    }

    public void removeVol(VolumeNodeImpl vol) throws RemoteException {
        vol.removeSynchronizeListener(this);
        vol.removePropagatedStateEventListener(this);
        if (this.volumeChild.equals(vol)) {
            this.volumeChild = null;
        }
    }

    public void childVolumeStateWasChanged() {
    }

    public void childCapacityWasChanged() {
    }

    public boolean isLegitimateForVolumeOperation() {
        return ((TargetImpl)this.parentTaregt).isLegitimateForVolumeOperation();
    }

    public SCSILunImpl getScsiLun() {
        return this.scsiLun;
    }

    public void setScsiLun(SCSILunImpl scsiLun) {
        this.scsiLun = scsiLun;
    }

    public String getDeviceRevisionID() throws RemoteException {
        return this.scsiLun != null ? this.scsiLun.getRevisionID() : null;
    }

    public String getDeviceRevisionID(VSwitch vSwitch) throws RemoteException {
        return this.scsiLun != null ? this.scsiLun.getRevisionID(vSwitch) : null;
    }

    public SCSILunStateConstant getDeviceState() throws RemoteException {
        return this.scsiLun != null ? this.scsiLun.getState() : null;
    }

    public SCSILunStateConstant getDeviceState(VSwitch vSwitch) throws RemoteException {
        return this.scsiLun != null ? this.scsiLun.getState(vSwitch) : null;
    }

    public SCSILunStatusConstant getDeviceStatus() throws RemoteException {
        return this.scsiLun != null ? this.scsiLun.getStatus() : null;
    }

    public SCSILunStatusConstant getDeviceStatus(VSwitch vSwitch) throws RemoteException {
        return this.scsiLun != null ? this.scsiLun.getStatus(vSwitch) : null;
    }

    public void readSCSILunElement() throws RemoteException {
        if (this.cluster.isDiscoverCompleted()) {
            VSwitch[] vSwitches = this.getConnectedVSwitches();
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwitches.length];
            CommKeyClassId targetID = this.getParentTarget().getCommKeyClassId();
            CommKey[] scsiKeys = null;
            int vsCount = vSwitches.length;
            for (int i = 0; i < vsCount; ++i) {
                CommKeyClassId vsKey;
                vSwitchesData[i] = vsKey = vSwitches[i].getCommKeyClassId();
                CommKeyClassId targetSpecific = CommKeyUtil.getSpecificCommKeyClassId(targetID, vsKey);
                scsiKeys = i == 0 ? this.cluster.getSCSIId(targetSpecific).getCommKeys() : CommKeyUtil.mergerCommKeyLists(scsiKeys, this.cluster.getSCSIId(targetSpecific).getCommKeys());
            }
            ConfigElementData element = new ConfigElementData(ClassID.SCSI_LUN);
            CommKeyClassId scsiDeviceID = new CommKeyClassId(scsiKeys, ClassID.SCSI_TARGET);
            element.setValue(ParameterCode.SCSI_DEVICE_ID, scsiDeviceID);
            element.setValue(ParameterCode.LU_LUN_NUMBER, this.getSrValueOf(ParameterCode.LU_LUN_NUMBER));
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchesData));
            this.cluster.createElement(element, "read SCSI LUN after LU creation", null);
        }
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap list = super.getClientParameterList();
        list.put(ClientParameterCode.LU_DEVICE_REVISION_ID, this.getDeviceRevisionID());
        list.put(ClientParameterCode.LU_DEVICE_STATE, this.getDeviceState());
        list.put(ClientParameterCode.LU_DEVICE_STATUS, this.getDeviceStatus());
        list.put(ClientParameterCode.LU_VOLUME_CHILD, this.volumeChild);
        return list;
    }

    public VSwitch getDominentVswitch() throws RemoteException {
        return super.getDominentVswitch();
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.LU_LUN_NUMBER);
        parameterCodes.addElement(ParameterCode.LU_PARENT);
        parameterCodes.addElement(ParameterCode.LU_VOLUME_ID);
        parameterCodes.addElement(ParameterCode.LU_OPER_STATUS);
        parameterCodes.addElement(ParameterCode.LU_SERIAL_NUMBER);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

