/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.lu;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.lu.LUValidator;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;

public class LUCreateValidator
extends LUValidator {
    public LUCreateValidator(ClusterImpl cluster, int luNumber, VolumeNodeImpl volume, Target target) throws RemoteException {
        super(cluster, luNumber, volume, target);
    }

    public boolean isValid() throws RemoteException {
        VolumeNode sourceVolume;
        if (!super.isValid()) {
            return false;
        }
        DRPairImpl pairThisVolumeIsBannedFromExposureBecauseOf = DRRootImpl.getInstance().getPairContainsISCSIDisk(this.volume);
        if (pairThisVolumeIsBannedFromExposureBecauseOf != null) {
            this.setErrorMsg("Volume " + this.volume + " cannot be exposed since it belongs to pair " + pairThisVolumeIsBannedFromExposureBecauseOf + " as primary remote or secondary local");
            return false;
        }
        if (((VolumeNodeImpl)this.volume).isDROfflineLocalCopy()) {
            this.setErrorMsg("Volume " + this.volume + " is used for DR offline local copy");
            return false;
        }
        boolean isSnapshotVolume = this.volume.getClassId().equals(ClassID.SNAPSHOT_VOLUME);
        if (this.luNumber > LUImpl.MAX_LUN_VALUE || this.luNumber < 0) {
            this.setErrorMsg("Target " + this.target.getAlias() + ": LUN value " + this.luNumber + " is wrong - value must be between 0 and " + LUImpl.MAX_LUN_VALUE);
            return false;
        }
        if (this.volume.isExposed()) {
            String target = this.volume.getParentLU().getParentTarget().getName();
            this.setErrorMsg("Cannot expose volume. " + this.volume.getAlias() + " is already exposed under target " + target);
            return false;
        }
        if (this.target.isLUNumberExist(this.luNumber)) {
            String[] msgParts = new String[]{Integer.toString(this.luNumber), this.target.getAlias()};
            this.setErrorMsg(ErrorMessage.LUN_ALREADY_IN_USE.getMessage(msgParts));
            return false;
        }
        if (isSnapshotVolume && (sourceVolume = ((SnapshotVolume)this.volume).getSourceVolume()).isExposed()) {
            Target sourceVolTarget = sourceVolume.getParentLU().getParentTarget();
            String vSwitchAlias = sourceVolTarget.getExposedOnVSwitch();
            if (!this.target.getExposedOnVSwitch().equalsIgnoreCase(vSwitchAlias)) {
                this.setErrorMsg(ClassID.SNAPSHOT_VOLUME + " " + this.volume + " cannot be exposed on a different " + ClassID.VSWITCH + " than its source volume");
                return false;
            }
        }
        return true;
    }
}

