/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.iscsi;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatistics;
import com.sanrad.nms.server.logic.statistics.StatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.nms.server.util.types.constants.SessionTypeConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ISCSISessionStatisticsImpl
extends StatisticsImpl
implements ISCSISessionStatistics {
    private static List s_parameterCodeList;
    private static HashMap s_parametersToCalculateMap;

    public ISCSISessionStatisticsImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.ISCSI_SESSION_STATISTICS, s_parameterCodeList, s_parametersToCalculateMap);
    }

    protected PollingGroupType getGroupType() {
        return PollingGroupType.ISCSI_SESSIONS_STATISTICS_GROUP_TYPE;
    }

    private ISCSISessionImpl getSessionShowImpl() throws RemoteException {
        CommKeyClassId sessionCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.ISCSI_SESSION_ID);
        if (sessionCommKeyClassId != null) {
            ISCSISessionImpl sessionImpl = (ISCSISessionImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(sessionCommKeyClassId);
            return sessionImpl;
        }
        return null;
    }

    public VSwitch getVSwitchStub() throws RemoteException {
        return this.getParentVSwitch();
    }

    public BigInteger getCmdPDUs() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_CMD_PDUS);
    }

    public BigInteger getRspPDUs() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_RSP_PDUS);
    }

    public BigInteger getTxBytes() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_TX_DATA_OCTETS);
    }

    public BigInteger getRxBytes() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_RX_DATA_OCTETS);
    }

    public BigInteger getDigestsErr() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_DIGEST_ERRORS);
    }

    public BigInteger getTimeoutErr() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_TIMEOUT_ERRORS);
    }

    public ISCSISession getSessionStub() throws RemoteException {
        return this.getSessionShowImpl();
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        StringBuffer sb = new StringBuffer("PolicyTableEntry");
        sb.append(this.getValueOf(ParameterCode.POLICY_PARAM_ID));
        this.toStringValue = sb.toString();
        return changedValues;
    }

    public String toString() {
        try {
            ISCSISessionImpl session = this.getSessionShowImpl();
            if (session != null) {
                StringBuffer sb = new StringBuffer(session.isInBound() ? SessionDirectionConstant.IN_BOUND.toString() : SessionDirectionConstant.OUT_BOUND.toString());
                sb.append(" ");
                sb.append(session.isDiscovery() ? SessionTypeConstant.DISCOVER.toString() : SessionTypeConstant.NORMAL.toString());
                sb.append(" ");
                sb.append(ClassID.ISCSI_SESSION_STATISTICS.toString());
                return sb.toString();
            }
        }
        catch (RemoteException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return ClassID.ISCSI_SESSION_STATISTICS.toString();
    }

    static {
        s_parametersToCalculateMap = new HashMap();
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_ID);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_CMD_PDUS);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_RSP_PDUS);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_TX_DATA_OCTETS);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_RX_DATA_OCTETS);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_DIGEST_ERRORS);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_TIMEOUT_ERRORS);
        s_parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
        s_parametersToCalculateMap.put(ParameterCode.ISCSI_SESSION_CMD_PDUS, ClientParameterCode.ISCSI_SESSION_STATISTICS_CMD_PDUS_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.ISCSI_SESSION_RSP_PDUS, ClientParameterCode.ISCSI_SESSION_STATISTICS_RSP_PDUS_PER_SEC);
    }
}

