/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.iscsi;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSIConnection;
import com.sanrad.nms.server.logic.iscsi.ISCSIConnectionImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrISCSISessionISID;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.constants.SessionConnectionStatusConstant;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.nms.server.util.types.constants.SessionTypeConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ISCSISessionImpl
extends TableRowImpl
implements ISCSISession {
    private static List m_parameterCodeList;
    private String m_initiatorName;
    private String m_targetName;
    private Vector m_connections = new Vector();
    private String m_identityAlias;
    private ISCSIRemoteInitiator m_sessionRemoteInitiator;
    private ISCSITarget m_sessionLocalTarget;
    private ISCSIInitiator m_sessionLocalInitiator;
    private ISCSIRemoteTarget m_sessionRemoteTarget;

    public ISCSISessionImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, m_parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.m_initiatorName = this.getInitiatorName();
        this.m_targetName = this.getTargetName();
        this.toStringValue = this.toString();
        return changedValues;
    }

    public String toString() {
        try {
            StringBuffer sb = new StringBuffer(this.isInBound() ? SessionDirectionConstant.IN_BOUND.toString() : SessionDirectionConstant.OUT_BOUND.toString());
            sb.append(" ");
            sb.append(this.isDiscovery() ? SessionTypeConstant.DISCOVER.toString() : SessionTypeConstant.NORMAL.toString());
            sb.append(" ");
            sb.append(ClassID.ISCSI_SESSION.toString());
            return sb.toString();
        }
        catch (RemoteException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return ClassID.ISCSI_SESSION.toString();
    }

    public void clear() throws RemoteException {
        if (this.m_connections != null) {
            this.m_connections.clear();
        }
        this.setInitiatorName(null);
        this.setTargetName(null);
        this.setIdentityAlias(null);
        this.setSessionRemoteInitiator(null);
        this.setSessionLocalTarget(null);
        this.setSessionLocalInitiator(null);
        this.setSessionRemoteTarget(null);
        super.clear();
    }

    public void setInitiatorName(String name) {
        this.m_initiatorName = name;
    }

    public void setTargetName(String name) {
        this.m_targetName = name;
    }

    public void setIdentityAlias(String identityAlias) {
        this.m_identityAlias = identityAlias;
    }

    public String getIdentityAlias() throws RemoteException {
        return this.m_identityAlias;
    }

    public void setSessionRemoteInitiator(ISCSIRemoteInitiator remoteInitiator) {
        this.m_sessionRemoteInitiator = remoteInitiator;
    }

    public void setSessionLocalTarget(ISCSITarget localTarget) {
        this.m_sessionLocalTarget = localTarget;
    }

    public void setSessionLocalInitiator(ISCSIInitiator localInitiator) {
        this.m_sessionLocalInitiator = localInitiator;
    }

    public void setSessionRemoteTarget(ISCSIRemoteTarget remoteTarget) {
        this.m_sessionRemoteTarget = remoteTarget;
    }

    public boolean isConnectionExist(HashMap parameterList) throws RemoteException {
        SrIpAddress connectionLocalIP = (SrIpAddress)parameterList.get(ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS);
        SrGauge connectionLocalPort = (SrGauge)parameterList.get(ParameterCode.ISCSI_CONNECTION_LOCAL_PORT);
        SrIpAddress connectionRemoteIP = (SrIpAddress)parameterList.get(ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS);
        SrGauge connectionRemotePort = (SrGauge)parameterList.get(ParameterCode.ISCSI_CONNECTION_REMOTE_PORT);
        Enumeration iter = this.m_connections.elements();
        while (iter.hasMoreElements()) {
            ISCSIConnection iscsiConnection = (ISCSIConnection)iter.nextElement();
            String localIP = iscsiConnection.getInitiatorIP();
            BigInteger localPort = iscsiConnection.getInitiatorPort();
            String remoteIP = iscsiConnection.getTargetIP();
            BigInteger remotePort = iscsiConnection.getTargetPort();
            if (!localIP.equals(connectionLocalIP.toDisplayString()) || !localPort.equals(connectionLocalPort.value()) || !remoteIP.equals(connectionRemoteIP.toDisplayString()) || !remotePort.equals(connectionRemotePort.value())) continue;
            return true;
        }
        return false;
    }

    public void addConnection(ISCSIConnection connection) throws RemoteException {
        this.m_connections.addElement(connection);
    }

    public void removeConnection(ISCSIConnection connection) throws RemoteException {
        this.m_connections.remove(connection);
    }

    public void removeAllConnections() {
        this.m_connections.clear();
    }

    public VSwitch getSessionVswitchParent() throws RemoteException {
        return this.getParentVSwitch();
    }

    public Vector getConnections() throws RemoteException {
        return this.m_connections;
    }

    public SessionDirectionConstant getDirection() throws RemoteException {
        return (SessionDirectionConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_DIRECTION);
    }

    public boolean isInBound() throws RemoteException {
        return SessionDirectionConstant.IN_BOUND.equals(this.getDirection());
    }

    public String getInitiatorAlias() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_INITIATOR_ALIAS);
    }

    public String getInitiatorName() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_INITIATOR_NAME);
    }

    public String getISID() throws RemoteException {
        SrISCSISessionISID val = (SrISCSISessionISID)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_ISID);
        return val.toString();
    }

    public String getTargetAlias() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_TARGET_ALIAS);
    }

    public String getTargetName() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_TARGET_NAME);
    }

    public Integer getTSIH() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_TSIH);
    }

    public SessionTypeConstant getType() throws RemoteException {
        return (SessionTypeConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_TYPE);
    }

    public boolean isDiscovery() throws RemoteException {
        return SessionTypeConstant.DISCOVER.equals(this.getType());
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public ISCSITarget getLocalTarget() throws RemoteException {
        return this.m_sessionLocalTarget;
    }

    public ISCSIRemoteInitiator getRemoteInitiator() throws RemoteException {
        return this.m_sessionRemoteInitiator;
    }

    public ISCSIInitiator getLocalInitiator() throws RemoteException {
        return this.m_sessionLocalInitiator;
    }

    public ISCSIRemoteTarget getRemoteTarget() throws RemoteException {
        return this.m_sessionRemoteTarget;
    }

    public SessionConnectionStatusConstant getConnectionStatus() throws RemoteException {
        return (SessionConnectionStatusConstant)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_CONNECTION_STATUS);
    }

    public String getConnectionFailureReason() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_SESSION_CONNECTION_FAILURE_REASON);
    }

    public boolean addToInitiatorAndTarget() throws RemoteException {
        if (this.isInBound()) {
            Vector remoteInitiators = ((VSwitchImpl)this.getParentVSwitch()).getRemoteInitiators();
            if (this.isDiscovery()) {
                return this.updateRemoteInitiatorWithDiscoverySession(remoteInitiators);
            }
            Vector targets = ((ClusterImpl)this.getCluster()).getTargetListMgr().getAll();
            return this.updateRemoteInitiatorAndLocalTargetWithNormalSession(remoteInitiators, targets);
        }
        if (this.isDiscovery()) {
            return this.updateLocalInitiatorWithDiscoverySession();
        }
        return this.updateLocalInitiatorAndRemoteTargetWithNormalSession();
    }

    public void removeFromAll() throws RemoteException {
        if (this.isInBound()) {
            if (this.m_sessionRemoteInitiator != null) {
                ((ISCSIRemoteInitiatorImpl)this.m_sessionRemoteInitiator).removeInitiatorSession(this);
            }
            if (!this.isDiscovery() && this.m_sessionLocalTarget != null) {
                ((ISCSITargetImpl)this.m_sessionLocalTarget).removeSession(this);
            }
        } else {
            if (this.m_sessionLocalInitiator != null) {
                ((ISCSIInitiatorImpl)this.m_sessionLocalInitiator).removeSession(this);
            }
            if (!this.isDiscovery() && this.m_sessionRemoteTarget != null) {
                ((ISCSIRemoteTargetImpl)this.m_sessionRemoteTarget).removeSession(this);
            }
        }
        for (int i = 0; i < this.m_connections.size(); ++i) {
            ISCSIConnection connection = (ISCSIConnection)this.m_connections.elementAt(i);
            ((ISCSIConnectionImpl)connection).setSessionParent(null);
        }
    }

    private boolean updateRemoteInitiatorAndLocalTargetWithNormalSession(Vector remoteInitiators, Vector targets) throws RemoteException {
        ISCSIRemoteInitiatorImpl remoteInitiator;
        boolean found = false;
        for (int index1 = 0; index1 < remoteInitiators.size() && (remoteInitiator = (ISCSIRemoteInitiatorImpl)remoteInitiators.elementAt(index1)).getInitiatorName() != null; ++index1) {
            if (!remoteInitiator.getInitiatorName().equals(this.m_initiatorName)) continue;
            for (int index2 = 0; index2 < targets.size(); ++index2) {
                ISCSITargetImpl target = (ISCSITargetImpl)targets.elementAt(index2);
                if (!target.getName().equals(this.m_targetName) || !target.initiatorKnownByTarget(remoteInitiator)) continue;
                remoteInitiator.addInitiatorSession(this);
                target.addSession(this);
                this.setSessionLocalTarget(target);
                this.setSessionRemoteInitiator(remoteInitiator);
                return true;
            }
        }
        logger.warning("Inbound session: remote initiator or local target element wasn't found.\nCould not set sessionRemoteInitiator and sessionLocalTarget.");
        return false;
    }

    private boolean updateLocalInitiatorAndRemoteTargetWithNormalSession() throws RemoteException {
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)((ClusterImpl)this.getCluster()).getRemoteTargetListMgr().getRemoteTargetByName(this.getTargetName());
        ISCSIInitiator[] localInitiators = ((VSwitchImpl)this.getParentVSwitch()).getISCSIInitiators();
        ISCSIInitiatorImpl initiator = (ISCSIInitiatorImpl)localInitiators[0];
        if (remoteTarget == null) {
            logger.error("Outbound session: remote target element wasn't found. Could not set sessionRemoteTarget.");
            return false;
        }
        if (initiator == null) {
            logger.error("Outbound session: local initiator element wasn't found. Could not set sessionLocalInitiator.");
            return false;
        }
        this.setSessionRemoteTarget(remoteTarget);
        remoteTarget.addSession(this);
        this.setSessionLocalInitiator(initiator);
        initiator.addSession(this);
        return true;
    }

    private boolean updateLocalInitiatorWithDiscoverySession() throws RemoteException {
        ISCSIInitiator[] localInitiators = ((VSwitchImpl)this.getParentVSwitch()).getISCSIInitiators();
        ISCSIInitiatorImpl initiator = (ISCSIInitiatorImpl)localInitiators[0];
        this.setSessionLocalInitiator(initiator);
        initiator.addSession(this);
        return true;
    }

    private boolean updateRemoteInitiatorWithDiscoverySession(Vector remoteInitiators) throws RemoteException {
        for (int index1 = 0; index1 < remoteInitiators.size(); ++index1) {
            ISCSIRemoteInitiatorImpl remoteInitiator = (ISCSIRemoteInitiatorImpl)remoteInitiators.elementAt(index1);
            if (!remoteInitiator.getInitiatorName().equals(this.m_initiatorName)) continue;
            remoteInitiator.addInitiatorSession(this);
            this.setSessionRemoteInitiator(remoteInitiator);
            return true;
        }
        return false;
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_DIRECTION);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_INITIATOR_ALIAS);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_INITIATOR_NAME);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_ISID);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_TARGET_ALIAS);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_TARGET_NAME);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_TSIH);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_TYPE);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_CONNECTION_STATUS);
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_CONNECTION_FAILURE_REASON);
        m_parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

