/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.iscsi;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSIInstance;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.SessionFailureTypeConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ISCSIInstanceImpl
extends TableRowImpl
implements ISCSIInstance {
    private static List m_parameterCodeList;

    public ISCSIInstanceImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, m_parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        StringBuffer sb = new StringBuffer(this.getInstanceVswitch().getName());
        sb.append(" ISCSI Instance");
        this.toStringValue = sb.toString();
        return changedValues;
    }

    public VSwitch getInstanceVswitch() throws RemoteException {
        return this.getParentVSwitch();
    }

    public Integer getMinVersionSupported() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_VERSION_MIN);
    }

    public Integer getMaxVersionSupported() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_VERSION_MAX);
    }

    public String getVendorId() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_VENDOR_ID);
    }

    public String getVendorVersion() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_VENDOR_VERSION);
    }

    public BigInteger getNumOfPortals() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_NUM_OF_PORTALS);
    }

    public BigInteger getNumOfNodes() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_NUM_OF_NODES);
    }

    public BigInteger getNumOfSessions() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSIONS);
    }

    public BigInteger getNumOfSessionFailures() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURE);
    }

    public SessionFailureTypeConstant getLastFailureType() throws RemoteException {
        return (SessionFailureTypeConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_TYPE);
    }

    public String getLastRemoteNodeName() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_REMOTE_NODE_NAME);
    }

    protected String canBeDeleted() throws RemoteException {
        throw new UnsupportedOperationException();
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.VSWITCH_ID);
        parameterCodes.addElement(ParameterCode.ISCSI_INSTANCE_VERSION_MIN);
        parameterCodes.addElement(ParameterCode.ISCSI_INSTANCE_VERSION_MAX);
        parameterCodes.addElement(ParameterCode.ISCSI_INSTANCE_VENDOR_ID);
        parameterCodes.addElement(ParameterCode.ISCSI_INSTANCE_VENDOR_VERSION);
        parameterCodes.addElement(ParameterCode.ISCSI_INSTANCE_NUM_OF_PORTALS);
        parameterCodes.addElement(ParameterCode.ISCSI_INSTANCE_NUM_OF_NODES);
        parameterCodes.addElement(ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSIONS);
        parameterCodes.addElement(ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURE);
        parameterCodes.addElement(ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_TYPE);
        parameterCodes.addElement(ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_REMOTE_NODE_NAME);
        m_parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

