/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.iscsi;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSIConnection;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionImpl;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.ConnectionStateConstant;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ISCSIConnectionImpl
extends TableRowImpl
implements ISCSIConnection {
    private static List m_parameterCodeList;
    private ISCSISessionImpl m_sessionParent;

    public ISCSIConnectionImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, m_parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.m_sessionParent = this.getConnectionSessionParent();
        return changedValues;
    }

    public void clear() throws RemoteException {
        this.setSessionParent(null);
        super.clear();
    }

    public ISCSISessionImpl getConnectionSessionParent() throws RemoteException {
        CommKeyClassId sessionCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.ISCSI_SESSION_ID);
        ISCSISessionImpl iscsiSessionImpl = (ISCSISessionImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(sessionCommKeyClassId);
        return iscsiSessionImpl;
    }

    public ISCSISession getSessionParent() throws RemoteException {
        return this.m_sessionParent;
    }

    public void setSessionParent(ISCSISession session) {
        this.m_sessionParent = (ISCSISessionImpl)session;
    }

    public Integer getCid() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_CONNECTION_CID);
    }

    public ConnectionStateConstant getState() throws RemoteException {
        return (ConnectionStateConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_CONNECTION_STATE);
    }

    public String getInitiatorIP() throws RemoteException {
        if (this.m_sessionParent == null) {
            this.m_sessionParent = this.getConnectionSessionParent();
        }
        if (this.m_sessionParent != null) {
            SessionDirectionConstant sessionDirection = this.m_sessionParent.getDirection();
            ParameterCode code = sessionDirection.equals(SessionDirectionConstant.IN_BOUND) ? ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS : ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS;
            String ip = this.getDisplayStringOf(this.getParentVSwitch(), code);
            return ip;
        }
        return null;
    }

    public BigInteger getInitiatorPort() throws RemoteException {
        SessionDirectionConstant sessionDirection = this.m_sessionParent.getDirection();
        ParameterCode code = sessionDirection.equals(SessionDirectionConstant.IN_BOUND) ? ParameterCode.ISCSI_CONNECTION_REMOTE_PORT : ParameterCode.ISCSI_CONNECTION_LOCAL_PORT;
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), code);
    }

    public String getTargetIP() throws RemoteException {
        SessionDirectionConstant sessionDirection = this.m_sessionParent.getDirection();
        ParameterCode code = sessionDirection.equals(SessionDirectionConstant.IN_BOUND) ? ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS : ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS;
        String ip = this.getDisplayStringOf(this.getParentVSwitch(), code);
        return ip;
    }

    public BigInteger getTargetPort() throws RemoteException {
        SessionDirectionConstant sessionDirection = this.m_sessionParent.getDirection();
        ParameterCode code = sessionDirection.equals(SessionDirectionConstant.IN_BOUND) ? ParameterCode.ISCSI_CONNECTION_LOCAL_PORT : ParameterCode.ISCSI_CONNECTION_REMOTE_PORT;
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), code);
    }

    public Integer getMaxReceivedPDULength() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_CONNECTION_MAX_RECEIVED_PDU_LENGTH);
    }

    public Integer getMaxTransmittedPDULength() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_CONNECTION_MAX_TRANSMIT_PDU_LENGTH);
    }

    public Integer getHeaderIntegrity() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_CONNECTION_HEADER_INTEGRITY);
    }

    public Integer getDataIntegrity() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_CONNECTION_DATA_INTEGRITY);
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public String toString() {
        return "TODO";
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.ISCSI_SESSION_ID);
        parameterCodes.addElement(ParameterCode.ISCSI_CONNECTION_CID);
        parameterCodes.addElement(ParameterCode.ISCSI_CONNECTION_STATE);
        parameterCodes.addElement(ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS);
        parameterCodes.addElement(ParameterCode.ISCSI_CONNECTION_LOCAL_PORT);
        parameterCodes.addElement(ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS);
        parameterCodes.addElement(ParameterCode.ISCSI_CONNECTION_REMOTE_PORT);
        parameterCodes.addElement(ParameterCode.ISCSI_CONNECTION_MAX_RECEIVED_PDU_LENGTH);
        parameterCodes.addElement(ParameterCode.ISCSI_CONNECTION_MAX_TRANSMIT_PDU_LENGTH);
        parameterCodes.addElement(ParameterCode.ISCSI_CONNECTION_HEADER_INTEGRITY);
        parameterCodes.addElement(ParameterCode.ISCSI_CONNECTION_DATA_INTEGRITY);
        m_parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

