/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.initiator;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiatorImpl;
import com.sanrad.nms.server.logic.initiator.SCSIInitiatorPort;
import com.sanrad.nms.server.logic.statistics.StatisticsImpl;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.SCSIPortRoleConstant;
import com.sanrad.nms.server.util.types.constants.SCSITransportType;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class SCSIInitiatorPortImpl
extends StatisticsImpl
implements SCSIInitiatorPort {
    private static List s_parameterCodeList;
    private static HashMap s_parametersToCalculateMap;

    public SCSIInitiatorPortImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.SCSI_INITIATOR_PORT, s_parameterCodeList, s_parametersToCalculateMap);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(ClassID.SCSI_INITIATOR_PORT.toString());
        try {
            ISCSIInitiatorImpl initiator = this.getInitiatorImpl();
            if (initiator != null) {
                sb.append(" ");
                sb.append(" - Initiator ");
                sb.append(initiator.getAlias());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sb.toString();
    }

    private ISCSIInitiatorImpl getInitiatorImpl() throws RemoteException {
        CommKeyClassId iscsiInitiatorCommKeyClassId;
        CommKeyClassId scsiInitiatorCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.ISCSI_INITIATOR_ID);
        if (scsiInitiatorCommKeyClassId != null && (iscsiInitiatorCommKeyClassId = ((ClusterImpl)this.getCluster()).getISCSIId(scsiInitiatorCommKeyClassId)) != null) {
            ISCSIInitiatorImpl initiatorCommKeyClassIdImpl = (ISCSIInitiatorImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(iscsiInitiatorCommKeyClassId);
            return initiatorCommKeyClassIdImpl;
        }
        return null;
    }

    protected PollingGroupType getGroupType() {
        return PollingGroupType.SCSI_INITIATOR_PORT_STATISTICS_GROUP_TYPE;
    }

    public SCSIPortRoleConstant getRole() throws RemoteException {
        SCSIPortRoleConstant role = (SCSIPortRoleConstant)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_PORT_ROLE);
        return role;
    }

    public SCSITransportType getTransportType() throws RemoteException {
        SCSITransportType transportType = (SCSITransportType)this.getSrValueOf(ParameterCode.SCSI_PORT_TRANSPORT_TYPE);
        return transportType;
    }

    public String getName() throws RemoteException {
        String name = (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_INITIATOR_PORT_NAME);
        return name;
    }

    public BigInteger getReadMB() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_INITIATOR_PORT_READ_MB);
    }

    public BigInteger getWrittenMB() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_INITIATOR_PORT_WRITTEN_MB);
    }

    public Integer getISID() throws RemoteException {
        Integer isid = (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_INITIATOR_PORT_ISID);
        return isid;
    }

    public BigInteger getOutCommands() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.SCSI_INITIATOR_PORT_OUT_COMMANDS);
    }

    public ISCSIInitiator getInitiator() throws RemoteException {
        return this.getInitiatorImpl();
    }

    static {
        s_parametersToCalculateMap = new HashMap();
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.ISCSI_INITIATOR_ID);
        parameterCodes.addElement(ParameterCode.SCSI_PORT_ROLE);
        parameterCodes.addElement(ParameterCode.SCSI_INITIATOR_PORT_NAME);
        parameterCodes.addElement(ParameterCode.SCSI_INITIATOR_PORT_ISID);
        parameterCodes.addElement(ParameterCode.SCSI_INITIATOR_PORT_OUT_COMMANDS);
        parameterCodes.addElement(ParameterCode.SCSI_INITIATOR_PORT_READ_MB);
        parameterCodes.addElement(ParameterCode.SCSI_INITIATOR_PORT_WRITTEN_MB);
        s_parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
        s_parametersToCalculateMap.put(ParameterCode.SCSI_INITIATOR_PORT_OUT_COMMANDS, ClientParameterCode.SCSI_TARGET_PORT_IN_COMMANDS_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.SCSI_INITIATOR_PORT_READ_MB, ClientParameterCode.SCSI_TARGET_PORT_READ_MB_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.SCSI_INITIATOR_PORT_WRITTEN_MB, ClientParameterCode.SCSI_TARGET_PORT_WRITTEN_MB_PER_SEC);
    }
}

