/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.initiator;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.initiator.Initiator;
import com.sanrad.nms.server.logic.scsi.SCSIDeviceImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.TargetAccessModeConstant;
import java.rmi.RemoteException;
import java.util.HashMap;

public class InitiatorImpl
extends SCSIDeviceImpl
implements Initiator {
    private VSwitch m_vswitch;

    protected InitiatorImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId);
        this.addParameterCode(ParameterCode.VSWITCH_ID);
        this.addParameterCode(ParameterCode.SCSI_INITIATOR_TARGET_ACCESS_MODE);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
        VSwitch vSwitch = (VSwitch)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
        this.setParentVSwitch(vSwitch);
        return changedValues;
    }

    public VSwitch getParentVSwitch() throws RemoteException {
        return this.m_vswitch;
    }

    public void setParentVSwitch(VSwitch vswitch) throws RemoteException {
        this.m_vswitch = vswitch;
    }

    public TargetAccessModeConstant getTargetAccessMode() throws RemoteException {
        return this.getTargetAccessMode(null);
    }

    public TargetAccessModeConstant getTargetAccessMode(VSwitch vSwitch) throws RemoteException {
        TargetAccessModeConstant accessMode = (TargetAccessModeConstant)this.getValueOf(ParameterCode.SCSI_INITIATOR_TARGET_ACCESS_MODE);
        return accessMode;
    }

    public String getAlias() throws RemoteException {
        return this.getAlias(null);
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        String alias = (String)this.getValueOf(vSwitch, ParameterCode.ISCSI_INITIATOR_ALIAS, vSwitch == null);
        return alias;
    }

    public String getName() throws RemoteException {
        return this.getName(null);
    }

    public String getName(VSwitch vSwitch) throws RemoteException {
        String name = (String)this.getValueOf(vSwitch, ParameterCode.ISCSI_INITIATOR_NAME, vSwitch == null);
        return name;
    }
}

