/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.initiator;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorStatistics;
import com.sanrad.nms.server.logic.statistics.StatisticsImpl;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ISCSIRemoteInitiatorStatisticsImpl
extends StatisticsImpl
implements ISCSIRemoteInitiatorStatistics {
    private static List s_parameterCodeList;
    private static HashMap s_parametersToCalculateMap;

    public ISCSIRemoteInitiatorStatisticsImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.ISCSI_REMOTE_INITIATOR_STATISTICS, s_parameterCodeList, s_parametersToCalculateMap);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.getInitiatorAlias();
        return changedValues;
    }

    protected PollingGroupType getGroupType() {
        return PollingGroupType.ISCSI_REMOTE_INITIATOR_STATISTICS_GROUP_TYPE;
    }

    private ISCSIRemoteInitiatorImpl getRemoteInitiatorImpl() throws RemoteException {
        CommKeyClassId initiatorCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.ISCSI_REMOTE_INITIATOR_ID);
        if (initiatorCommKeyClassId != null) {
            ISCSIRemoteInitiatorImpl initiatorImpl = (ISCSIRemoteInitiatorImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(initiatorCommKeyClassId);
            return initiatorImpl;
        }
        return null;
    }

    public String getInitiatorAlias() throws RemoteException {
        ISCSIRemoteInitiatorImpl initiatorImpl = this.getRemoteInitiatorImpl();
        if (initiatorImpl != null) {
            return initiatorImpl.getInitiatorAlias();
        }
        return null;
    }

    public String getInitiatorName() throws RemoteException {
        ISCSIRemoteInitiatorImpl initiatorImpl = this.getRemoteInitiatorImpl();
        if (initiatorImpl != null) {
            return initiatorImpl.getInitiatorName();
        }
        return null;
    }

    public ISCSITarget getTarget() throws RemoteException {
        CommKeyClassId scsiTargetCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.SCSI_TARGET_ID);
        ISCSITarget target = null;
        if (scsiTargetCommKeyClassId != null) {
            CommKeyClassId iscsiTargetCommKeyClassId = this.cluster.getISCSIId(scsiTargetCommKeyClassId);
            if (iscsiTargetCommKeyClassId != null) {
                target = (ISCSITarget)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(iscsiTargetCommKeyClassId);
            } else {
                logger.debug(">>>>>>ISCSIRemoteInitiatorStatisticsImpl: getTarget(), iscsiTargetCommKeyClassId == null");
            }
        }
        return target;
    }

    public VSwitch getVSwitch() throws RemoteException {
        return this.getParentVSwitch();
    }

    public BigInteger getAttachedTimes() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_REMOTE_INITIATOR_ATTACHED_TIMES);
    }

    public BigInteger getOutCommands() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_REMOTE_OUT_COMMANDS);
    }

    public BigInteger getReadMB() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_REMOTE_READ_MB);
    }

    public BigInteger getWrittenMB() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_REMOTE_WRITTEN_MB);
    }

    static {
        s_parametersToCalculateMap = new HashMap();
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.ISCSI_REMOTE_INITIATOR_ATTACHED_TIMES);
        parameterCodes.addElement(ParameterCode.ISCSI_REMOTE_OUT_COMMANDS);
        parameterCodes.addElement(ParameterCode.ISCSI_REMOTE_READ_MB);
        parameterCodes.addElement(ParameterCode.ISCSI_REMOTE_WRITTEN_MB);
        parameterCodes.addElement(ParameterCode.SCSI_TARGET_ID);
        parameterCodes.addElement(ParameterCode.ISCSI_REMOTE_INITIATOR_ID);
        s_parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
        s_parametersToCalculateMap.put(ParameterCode.ISCSI_REMOTE_OUT_COMMANDS, ClientParameterCode.ISCSI_REMOTE_INITIATOR_OUT_CMDS_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.ISCSI_REMOTE_WRITTEN_MB, ClientParameterCode.ISCSI_REMOTE_INITIATOR_WRITTEN_MB_PER_SEC);
        s_parametersToCalculateMap.put(ParameterCode.ISCSI_REMOTE_READ_MB, ClientParameterCode.ISCSI_REMOTE_INITIATOR_READ_MB_PER_SEC);
    }
}

